# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PreferencesArgs', 'Preferences']

@pulumi.input_type
class PreferencesArgs:
    def __init__(__self__, *,
                 connection_recording_preferences: Optional[pulumi.Input['ConnectionRecordingPreferencesPropertiesArgs']] = None):
        """
        The set of arguments for constructing a Preferences resource.
        :param pulumi.Input['ConnectionRecordingPreferencesPropertiesArgs'] connection_recording_preferences: The set of preferences used for recording RDP connections in the requesting AWS account and AWS Region. This includes details such as which S3 bucket recordings are stored in.
        """
        if connection_recording_preferences is not None:
            pulumi.set(__self__, "connection_recording_preferences", connection_recording_preferences)

    @property
    @pulumi.getter(name="connectionRecordingPreferences")
    def connection_recording_preferences(self) -> Optional[pulumi.Input['ConnectionRecordingPreferencesPropertiesArgs']]:
        """
        The set of preferences used for recording RDP connections in the requesting AWS account and AWS Region. This includes details such as which S3 bucket recordings are stored in.
        """
        return pulumi.get(self, "connection_recording_preferences")

    @connection_recording_preferences.setter
    def connection_recording_preferences(self, value: Optional[pulumi.Input['ConnectionRecordingPreferencesPropertiesArgs']]):
        pulumi.set(self, "connection_recording_preferences", value)


@pulumi.type_token("aws-native:ssmguiconnect:Preferences")
class Preferences(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_recording_preferences: Optional[pulumi.Input[Union['ConnectionRecordingPreferencesPropertiesArgs', 'ConnectionRecordingPreferencesPropertiesArgsDict']]] = None,
                 __props__=None):
        """
        Definition of AWS::SSMGuiConnect::Preferences Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ConnectionRecordingPreferencesPropertiesArgs', 'ConnectionRecordingPreferencesPropertiesArgsDict']] connection_recording_preferences: The set of preferences used for recording RDP connections in the requesting AWS account and AWS Region. This includes details such as which S3 bucket recordings are stored in.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[PreferencesArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::SSMGuiConnect::Preferences Resource Type

        :param str resource_name: The name of the resource.
        :param PreferencesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PreferencesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_recording_preferences: Optional[pulumi.Input[Union['ConnectionRecordingPreferencesPropertiesArgs', 'ConnectionRecordingPreferencesPropertiesArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PreferencesArgs.__new__(PreferencesArgs)

            __props__.__dict__["connection_recording_preferences"] = connection_recording_preferences
            __props__.__dict__["account_id"] = None
        super(Preferences, __self__).__init__(
            'aws-native:ssmguiconnect:Preferences',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Preferences':
        """
        Get an existing Preferences resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = PreferencesArgs.__new__(PreferencesArgs)

        __props__.__dict__["account_id"] = None
        __props__.__dict__["connection_recording_preferences"] = None
        return Preferences(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[builtins.str]:
        """
        The AWS Account Id that the preference is associated with, used as the unique identifier for this resource.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="connectionRecordingPreferences")
    def connection_recording_preferences(self) -> pulumi.Output[Optional['outputs.ConnectionRecordingPreferencesProperties']]:
        """
        The set of preferences used for recording RDP connections in the requesting AWS account and AWS Region. This includes details such as which S3 bucket recordings are stored in.
        """
        return pulumi.get(self, "connection_recording_preferences")

