# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ConnectionRecordingPreferencesProperties',
    'PreferencesRecordingDestinations',
    'PreferencesS3Bucket',
]

@pulumi.output_type
class ConnectionRecordingPreferencesProperties(dict):
    """
    The set of preferences used for recording RDP connections in the requesting AWS account and AWS Region. This includes details such as which S3 bucket recordings are stored in.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyArn":
            suggest = "kms_key_arn"
        elif key == "recordingDestinations":
            suggest = "recording_destinations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionRecordingPreferencesProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionRecordingPreferencesProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionRecordingPreferencesProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_arn: builtins.str,
                 recording_destinations: 'outputs.PreferencesRecordingDestinations'):
        """
        The set of preferences used for recording RDP connections in the requesting AWS account and AWS Region. This includes details such as which S3 bucket recordings are stored in.
        :param builtins.str kms_key_arn: The ARN of a AWS KMS key that is used to encrypt data while it is being processed by the service. This key must exist in the same AWS Region as the node you start an RDP connection to.
        :param 'PreferencesRecordingDestinations' recording_destinations: Determines where recordings of RDP connections are stored.
        """
        pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        pulumi.set(__self__, "recording_destinations", recording_destinations)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> builtins.str:
        """
        The ARN of a AWS KMS key that is used to encrypt data while it is being processed by the service. This key must exist in the same AWS Region as the node you start an RDP connection to.
        """
        return pulumi.get(self, "kms_key_arn")

    @property
    @pulumi.getter(name="recordingDestinations")
    def recording_destinations(self) -> 'outputs.PreferencesRecordingDestinations':
        """
        Determines where recordings of RDP connections are stored.
        """
        return pulumi.get(self, "recording_destinations")


@pulumi.output_type
class PreferencesRecordingDestinations(dict):
    """
    Determines where recordings of RDP connections are stored.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Buckets":
            suggest = "s3_buckets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PreferencesRecordingDestinations. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PreferencesRecordingDestinations.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PreferencesRecordingDestinations.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_buckets: Sequence['outputs.PreferencesS3Bucket']):
        """
        Determines where recordings of RDP connections are stored.
        :param Sequence['PreferencesS3Bucket'] s3_buckets: The S3 bucket where RDP connection recordings are stored.
        """
        pulumi.set(__self__, "s3_buckets", s3_buckets)

    @property
    @pulumi.getter(name="s3Buckets")
    def s3_buckets(self) -> Sequence['outputs.PreferencesS3Bucket']:
        """
        The S3 bucket where RDP connection recordings are stored.
        """
        return pulumi.get(self, "s3_buckets")


@pulumi.output_type
class PreferencesS3Bucket(dict):
    """
    The S3 bucket where RDP connection recordings are stored.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "bucketOwner":
            suggest = "bucket_owner"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PreferencesS3Bucket. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PreferencesS3Bucket.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PreferencesS3Bucket.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: builtins.str,
                 bucket_owner: builtins.str):
        """
        The S3 bucket where RDP connection recordings are stored.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "bucket_owner", bucket_owner)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> builtins.str:
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="bucketOwner")
    def bucket_owner(self) -> builtins.str:
        return pulumi.get(self, "bucket_owner")


