# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetPreferencesResult',
    'AwaitableGetPreferencesResult',
    'get_preferences',
    'get_preferences_output',
]

@pulumi.output_type
class GetPreferencesResult:
    def __init__(__self__, account_id=None, connection_recording_preferences=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if connection_recording_preferences and not isinstance(connection_recording_preferences, dict):
            raise TypeError("Expected argument 'connection_recording_preferences' to be a dict")
        pulumi.set(__self__, "connection_recording_preferences", connection_recording_preferences)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[builtins.str]:
        """
        The AWS Account Id that the preference is associated with, used as the unique identifier for this resource.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="connectionRecordingPreferences")
    def connection_recording_preferences(self) -> Optional['outputs.ConnectionRecordingPreferencesProperties']:
        """
        The set of preferences used for recording RDP connections in the requesting AWS account and AWS Region. This includes details such as which S3 bucket recordings are stored in.
        """
        return pulumi.get(self, "connection_recording_preferences")


class AwaitableGetPreferencesResult(GetPreferencesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPreferencesResult(
            account_id=self.account_id,
            connection_recording_preferences=self.connection_recording_preferences)


def get_preferences(account_id: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPreferencesResult:
    """
    Definition of AWS::SSMGuiConnect::Preferences Resource Type


    :param builtins.str account_id: The AWS Account Id that the preference is associated with, used as the unique identifier for this resource.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ssmguiconnect:getPreferences', __args__, opts=opts, typ=GetPreferencesResult).value

    return AwaitableGetPreferencesResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        connection_recording_preferences=pulumi.get(__ret__, 'connection_recording_preferences'))
def get_preferences_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPreferencesResult]:
    """
    Definition of AWS::SSMGuiConnect::Preferences Resource Type


    :param builtins.str account_id: The AWS Account Id that the preference is associated with, used as the unique identifier for this resource.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ssmguiconnect:getPreferences', __args__, opts=opts, typ=GetPreferencesResult)
    return __ret__.apply(lambda __response__: GetPreferencesResult(
        account_id=pulumi.get(__response__, 'account_id'),
        connection_recording_preferences=pulumi.get(__response__, 'connection_recording_preferences')))
