# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ConnectionRecordingPreferencesPropertiesArgs',
    'ConnectionRecordingPreferencesPropertiesArgsDict',
    'PreferencesRecordingDestinationsArgs',
    'PreferencesRecordingDestinationsArgsDict',
    'PreferencesS3BucketArgs',
    'PreferencesS3BucketArgsDict',
]

MYPY = False

if not MYPY:
    class ConnectionRecordingPreferencesPropertiesArgsDict(TypedDict):
        """
        The set of preferences used for recording RDP connections in the requesting AWS account and AWS Region. This includes details such as which S3 bucket recordings are stored in.
        """
        kms_key_arn: pulumi.Input[builtins.str]
        """
        The ARN of a AWS KMS key that is used to encrypt data while it is being processed by the service. This key must exist in the same AWS Region as the node you start an RDP connection to.
        """
        recording_destinations: pulumi.Input['PreferencesRecordingDestinationsArgsDict']
        """
        Determines where recordings of RDP connections are stored.
        """
elif False:
    ConnectionRecordingPreferencesPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionRecordingPreferencesPropertiesArgs:
    def __init__(__self__, *,
                 kms_key_arn: pulumi.Input[builtins.str],
                 recording_destinations: pulumi.Input['PreferencesRecordingDestinationsArgs']):
        """
        The set of preferences used for recording RDP connections in the requesting AWS account and AWS Region. This includes details such as which S3 bucket recordings are stored in.
        :param pulumi.Input[builtins.str] kms_key_arn: The ARN of a AWS KMS key that is used to encrypt data while it is being processed by the service. This key must exist in the same AWS Region as the node you start an RDP connection to.
        :param pulumi.Input['PreferencesRecordingDestinationsArgs'] recording_destinations: Determines where recordings of RDP connections are stored.
        """
        pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        pulumi.set(__self__, "recording_destinations", recording_destinations)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> pulumi.Input[builtins.str]:
        """
        The ARN of a AWS KMS key that is used to encrypt data while it is being processed by the service. This key must exist in the same AWS Region as the node you start an RDP connection to.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "kms_key_arn", value)

    @property
    @pulumi.getter(name="recordingDestinations")
    def recording_destinations(self) -> pulumi.Input['PreferencesRecordingDestinationsArgs']:
        """
        Determines where recordings of RDP connections are stored.
        """
        return pulumi.get(self, "recording_destinations")

    @recording_destinations.setter
    def recording_destinations(self, value: pulumi.Input['PreferencesRecordingDestinationsArgs']):
        pulumi.set(self, "recording_destinations", value)


if not MYPY:
    class PreferencesRecordingDestinationsArgsDict(TypedDict):
        """
        Determines where recordings of RDP connections are stored.
        """
        s3_buckets: pulumi.Input[Sequence[pulumi.Input['PreferencesS3BucketArgsDict']]]
        """
        The S3 bucket where RDP connection recordings are stored.
        """
elif False:
    PreferencesRecordingDestinationsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PreferencesRecordingDestinationsArgs:
    def __init__(__self__, *,
                 s3_buckets: pulumi.Input[Sequence[pulumi.Input['PreferencesS3BucketArgs']]]):
        """
        Determines where recordings of RDP connections are stored.
        :param pulumi.Input[Sequence[pulumi.Input['PreferencesS3BucketArgs']]] s3_buckets: The S3 bucket where RDP connection recordings are stored.
        """
        pulumi.set(__self__, "s3_buckets", s3_buckets)

    @property
    @pulumi.getter(name="s3Buckets")
    def s3_buckets(self) -> pulumi.Input[Sequence[pulumi.Input['PreferencesS3BucketArgs']]]:
        """
        The S3 bucket where RDP connection recordings are stored.
        """
        return pulumi.get(self, "s3_buckets")

    @s3_buckets.setter
    def s3_buckets(self, value: pulumi.Input[Sequence[pulumi.Input['PreferencesS3BucketArgs']]]):
        pulumi.set(self, "s3_buckets", value)


if not MYPY:
    class PreferencesS3BucketArgsDict(TypedDict):
        """
        The S3 bucket where RDP connection recordings are stored.
        """
        bucket_name: pulumi.Input[builtins.str]
        bucket_owner: pulumi.Input[builtins.str]
elif False:
    PreferencesS3BucketArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PreferencesS3BucketArgs:
    def __init__(__self__, *,
                 bucket_name: pulumi.Input[builtins.str],
                 bucket_owner: pulumi.Input[builtins.str]):
        """
        The S3 bucket where RDP connection recordings are stored.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "bucket_owner", bucket_owner)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter(name="bucketOwner")
    def bucket_owner(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "bucket_owner")

    @bucket_owner.setter
    def bucket_owner(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket_owner", value)


