# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetPlanResult',
    'AwaitableGetPlanResult',
    'get_plan',
    'get_plan_output',
]

@pulumi.output_type
class GetPlanResult:
    def __init__(__self__, arn=None, stages=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if stages and not isinstance(stages, list):
            raise TypeError("Expected argument 'stages' to be a list")
        pulumi.set(__self__, "stages", stages)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the contact.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def stages(self) -> Optional[Sequence['outputs.PlanStage']]:
        """
        The stages that an escalation plan or engagement plan engages contacts and contact methods in.
        """
        return pulumi.get(self, "stages")


class AwaitableGetPlanResult(GetPlanResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPlanResult(
            arn=self.arn,
            stages=self.stages)


def get_plan(arn: Optional[builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPlanResult:
    """
    Engagement Plan for a SSM Incident Manager Contact.


    :param builtins.str arn: The Amazon Resource Name (ARN) of the contact.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ssmcontacts:getPlan', __args__, opts=opts, typ=GetPlanResult).value

    return AwaitableGetPlanResult(
        arn=pulumi.get(__ret__, 'arn'),
        stages=pulumi.get(__ret__, 'stages'))
def get_plan_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPlanResult]:
    """
    Engagement Plan for a SSM Incident Manager Contact.


    :param builtins.str arn: The Amazon Resource Name (ARN) of the contact.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ssmcontacts:getPlan', __args__, opts=opts, typ=GetPlanResult)
    return __ret__.apply(lambda __response__: GetPlanResult(
        arn=pulumi.get(__response__, 'arn'),
        stages=pulumi.get(__response__, 'stages')))
