# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetContactChannelResult',
    'AwaitableGetContactChannelResult',
    'get_contact_channel',
    'get_contact_channel_output',
]

@pulumi.output_type
class GetContactChannelResult:
    def __init__(__self__, arn=None, channel_address=None, channel_name=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if channel_address and not isinstance(channel_address, str):
            raise TypeError("Expected argument 'channel_address' to be a str")
        pulumi.set(__self__, "channel_address", channel_address)
        if channel_name and not isinstance(channel_name, str):
            raise TypeError("Expected argument 'channel_name' to be a str")
        pulumi.set(__self__, "channel_name", channel_name)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the engagement to a contact channel.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="channelAddress")
    def channel_address(self) -> Optional[builtins.str]:
        """
        The details that SSM Incident Manager uses when trying to engage the contact channel.
        """
        return pulumi.get(self, "channel_address")

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> Optional[builtins.str]:
        """
        The device name. String of 6 to 50 alphabetical, numeric, dash, and underscore characters.
        """
        return pulumi.get(self, "channel_name")


class AwaitableGetContactChannelResult(GetContactChannelResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetContactChannelResult(
            arn=self.arn,
            channel_address=self.channel_address,
            channel_name=self.channel_name)


def get_contact_channel(arn: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetContactChannelResult:
    """
    Resource Type definition for AWS::SSMContacts::ContactChannel


    :param builtins.str arn: The Amazon Resource Name (ARN) of the engagement to a contact channel.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ssmcontacts:getContactChannel', __args__, opts=opts, typ=GetContactChannelResult).value

    return AwaitableGetContactChannelResult(
        arn=pulumi.get(__ret__, 'arn'),
        channel_address=pulumi.get(__ret__, 'channel_address'),
        channel_name=pulumi.get(__ret__, 'channel_name'))
def get_contact_channel_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetContactChannelResult]:
    """
    Resource Type definition for AWS::SSMContacts::ContactChannel


    :param builtins.str arn: The Amazon Resource Name (ARN) of the engagement to a contact channel.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ssmcontacts:getContactChannel', __args__, opts=opts, typ=GetContactChannelResult)
    return __ret__.apply(lambda __response__: GetContactChannelResult(
        arn=pulumi.get(__response__, 'arn'),
        channel_address=pulumi.get(__response__, 'channel_address'),
        channel_name=pulumi.get(__response__, 'channel_name')))
