# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['PatchBaselineArgs', 'PatchBaseline']

@pulumi.input_type
class PatchBaselineArgs:
    def __init__(__self__, *,
                 approval_rules: Optional[pulumi.Input['PatchBaselineRuleGroupArgs']] = None,
                 approved_patches: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 approved_patches_compliance_level: Optional[pulumi.Input['PatchBaselineApprovedPatchesComplianceLevel']] = None,
                 approved_patches_enable_non_security: Optional[pulumi.Input[builtins.bool]] = None,
                 default_baseline: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 global_filters: Optional[pulumi.Input['PatchBaselinePatchFilterGroupArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 operating_system: Optional[pulumi.Input['PatchBaselineOperatingSystem']] = None,
                 patch_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 rejected_patches: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 rejected_patches_action: Optional[pulumi.Input['PatchBaselineRejectedPatchesAction']] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input['PatchBaselinePatchSourceArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a PatchBaseline resource.
        :param pulumi.Input['PatchBaselineRuleGroupArgs'] approval_rules: A set of rules used to include patches in the baseline.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] approved_patches: A list of explicitly approved patches for the baseline.
        :param pulumi.Input['PatchBaselineApprovedPatchesComplianceLevel'] approved_patches_compliance_level: Defines the compliance level for approved patches. This means that if an approved patch is reported as missing, this is the severity of the compliance violation. The default value is UNSPECIFIED.
        :param pulumi.Input[builtins.bool] approved_patches_enable_non_security: Indicates whether the list of approved patches includes non-security updates that should be applied to the instances. The default value is 'false'. Applies to Linux instances only.
        :param pulumi.Input[builtins.bool] default_baseline: Set the baseline as default baseline. Only registering to default patch baseline is allowed.
        :param pulumi.Input[builtins.str] description: The description of the patch baseline.
        :param pulumi.Input['PatchBaselinePatchFilterGroupArgs'] global_filters: A set of global filters used to include patches in the baseline.
        :param pulumi.Input[builtins.str] name: The name of the patch baseline.
        :param pulumi.Input['PatchBaselineOperatingSystem'] operating_system: Defines the operating system the patch baseline applies to. The Default value is WINDOWS.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] patch_groups: PatchGroups is used to associate instances with a specific patch baseline
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] rejected_patches: A list of explicitly rejected patches for the baseline.
        :param pulumi.Input['PatchBaselineRejectedPatchesAction'] rejected_patches_action: The action for Patch Manager to take on patches included in the RejectedPackages list.
        :param pulumi.Input[Sequence[pulumi.Input['PatchBaselinePatchSourceArgs']]] sources: Information about the patches to use to update the instances, including target operating systems and source repository. Applies to Linux instances only.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways.
        """
        if approval_rules is not None:
            pulumi.set(__self__, "approval_rules", approval_rules)
        if approved_patches is not None:
            pulumi.set(__self__, "approved_patches", approved_patches)
        if approved_patches_compliance_level is not None:
            pulumi.set(__self__, "approved_patches_compliance_level", approved_patches_compliance_level)
        if approved_patches_enable_non_security is not None:
            pulumi.set(__self__, "approved_patches_enable_non_security", approved_patches_enable_non_security)
        if default_baseline is not None:
            pulumi.set(__self__, "default_baseline", default_baseline)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if global_filters is not None:
            pulumi.set(__self__, "global_filters", global_filters)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if operating_system is not None:
            pulumi.set(__self__, "operating_system", operating_system)
        if patch_groups is not None:
            pulumi.set(__self__, "patch_groups", patch_groups)
        if rejected_patches is not None:
            pulumi.set(__self__, "rejected_patches", rejected_patches)
        if rejected_patches_action is not None:
            pulumi.set(__self__, "rejected_patches_action", rejected_patches_action)
        if sources is not None:
            pulumi.set(__self__, "sources", sources)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="approvalRules")
    def approval_rules(self) -> Optional[pulumi.Input['PatchBaselineRuleGroupArgs']]:
        """
        A set of rules used to include patches in the baseline.
        """
        return pulumi.get(self, "approval_rules")

    @approval_rules.setter
    def approval_rules(self, value: Optional[pulumi.Input['PatchBaselineRuleGroupArgs']]):
        pulumi.set(self, "approval_rules", value)

    @property
    @pulumi.getter(name="approvedPatches")
    def approved_patches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of explicitly approved patches for the baseline.
        """
        return pulumi.get(self, "approved_patches")

    @approved_patches.setter
    def approved_patches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "approved_patches", value)

    @property
    @pulumi.getter(name="approvedPatchesComplianceLevel")
    def approved_patches_compliance_level(self) -> Optional[pulumi.Input['PatchBaselineApprovedPatchesComplianceLevel']]:
        """
        Defines the compliance level for approved patches. This means that if an approved patch is reported as missing, this is the severity of the compliance violation. The default value is UNSPECIFIED.
        """
        return pulumi.get(self, "approved_patches_compliance_level")

    @approved_patches_compliance_level.setter
    def approved_patches_compliance_level(self, value: Optional[pulumi.Input['PatchBaselineApprovedPatchesComplianceLevel']]):
        pulumi.set(self, "approved_patches_compliance_level", value)

    @property
    @pulumi.getter(name="approvedPatchesEnableNonSecurity")
    def approved_patches_enable_non_security(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether the list of approved patches includes non-security updates that should be applied to the instances. The default value is 'false'. Applies to Linux instances only.
        """
        return pulumi.get(self, "approved_patches_enable_non_security")

    @approved_patches_enable_non_security.setter
    def approved_patches_enable_non_security(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "approved_patches_enable_non_security", value)

    @property
    @pulumi.getter(name="defaultBaseline")
    def default_baseline(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set the baseline as default baseline. Only registering to default patch baseline is allowed.
        """
        return pulumi.get(self, "default_baseline")

    @default_baseline.setter
    def default_baseline(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "default_baseline", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the patch baseline.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="globalFilters")
    def global_filters(self) -> Optional[pulumi.Input['PatchBaselinePatchFilterGroupArgs']]:
        """
        A set of global filters used to include patches in the baseline.
        """
        return pulumi.get(self, "global_filters")

    @global_filters.setter
    def global_filters(self, value: Optional[pulumi.Input['PatchBaselinePatchFilterGroupArgs']]):
        pulumi.set(self, "global_filters", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the patch baseline.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> Optional[pulumi.Input['PatchBaselineOperatingSystem']]:
        """
        Defines the operating system the patch baseline applies to. The Default value is WINDOWS.
        """
        return pulumi.get(self, "operating_system")

    @operating_system.setter
    def operating_system(self, value: Optional[pulumi.Input['PatchBaselineOperatingSystem']]):
        pulumi.set(self, "operating_system", value)

    @property
    @pulumi.getter(name="patchGroups")
    def patch_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        PatchGroups is used to associate instances with a specific patch baseline
        """
        return pulumi.get(self, "patch_groups")

    @patch_groups.setter
    def patch_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "patch_groups", value)

    @property
    @pulumi.getter(name="rejectedPatches")
    def rejected_patches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of explicitly rejected patches for the baseline.
        """
        return pulumi.get(self, "rejected_patches")

    @rejected_patches.setter
    def rejected_patches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "rejected_patches", value)

    @property
    @pulumi.getter(name="rejectedPatchesAction")
    def rejected_patches_action(self) -> Optional[pulumi.Input['PatchBaselineRejectedPatchesAction']]:
        """
        The action for Patch Manager to take on patches included in the RejectedPackages list.
        """
        return pulumi.get(self, "rejected_patches_action")

    @rejected_patches_action.setter
    def rejected_patches_action(self, value: Optional[pulumi.Input['PatchBaselineRejectedPatchesAction']]):
        pulumi.set(self, "rejected_patches_action", value)

    @property
    @pulumi.getter
    def sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PatchBaselinePatchSourceArgs']]]]:
        """
        Information about the patches to use to update the instances, including target operating systems and source repository. Applies to Linux instances only.
        """
        return pulumi.get(self, "sources")

    @sources.setter
    def sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PatchBaselinePatchSourceArgs']]]]):
        pulumi.set(self, "sources", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:ssm:PatchBaseline")
class PatchBaseline(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 approval_rules: Optional[pulumi.Input[Union['PatchBaselineRuleGroupArgs', 'PatchBaselineRuleGroupArgsDict']]] = None,
                 approved_patches: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 approved_patches_compliance_level: Optional[pulumi.Input['PatchBaselineApprovedPatchesComplianceLevel']] = None,
                 approved_patches_enable_non_security: Optional[pulumi.Input[builtins.bool]] = None,
                 default_baseline: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 global_filters: Optional[pulumi.Input[Union['PatchBaselinePatchFilterGroupArgs', 'PatchBaselinePatchFilterGroupArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 operating_system: Optional[pulumi.Input['PatchBaselineOperatingSystem']] = None,
                 patch_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 rejected_patches: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 rejected_patches_action: Optional[pulumi.Input['PatchBaselineRejectedPatchesAction']] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PatchBaselinePatchSourceArgs', 'PatchBaselinePatchSourceArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::SSM::PatchBaseline

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_patch_baseline = aws_native.ssm.PatchBaseline("myPatchBaseline",
            name="myPatchBaseline",
            description="Baseline containing all updates approved for Windows instances",
            operating_system=aws_native.ssm.PatchBaselineOperatingSystem.WINDOWS,
            patch_groups=["myPatchGroup"],
            approval_rules={
                "patch_rules": [
                    {
                        "patch_filter_group": {
                            "patch_filters": [
                                {
                                    "values": [
                                        "Critical",
                                        "Important",
                                        "Moderate",
                                    ],
                                    "key": aws_native.ssm.PatchBaselinePatchFilterKey.MSRC_SEVERITY,
                                },
                                {
                                    "values": [
                                        "SecurityUpdates",
                                        "CriticalUpdates",
                                    ],
                                    "key": aws_native.ssm.PatchBaselinePatchFilterKey.CLASSIFICATION,
                                },
                                {
                                    "values": ["WindowsServer2019"],
                                    "key": aws_native.ssm.PatchBaselinePatchFilterKey.PRODUCT,
                                },
                            ],
                        },
                        "approve_after_days": 7,
                        "compliance_level": aws_native.ssm.PatchBaselineRuleComplianceLevel.CRITICAL,
                    },
                    {
                        "patch_filter_group": {
                            "patch_filters": [
                                {
                                    "values": [
                                        "Critical",
                                        "Important",
                                        "Moderate",
                                    ],
                                    "key": aws_native.ssm.PatchBaselinePatchFilterKey.MSRC_SEVERITY,
                                },
                                {
                                    "values": ["*"],
                                    "key": aws_native.ssm.PatchBaselinePatchFilterKey.CLASSIFICATION,
                                },
                                {
                                    "values": ["APPLICATION"],
                                    "key": aws_native.ssm.PatchBaselinePatchFilterKey.PATCH_SET,
                                },
                                {
                                    "values": ["Active Directory Rights Management Services Client 2.0"],
                                    "key": aws_native.ssm.PatchBaselinePatchFilterKey.PRODUCT,
                                },
                                {
                                    "values": ["Active Directory"],
                                    "key": aws_native.ssm.PatchBaselinePatchFilterKey.PRODUCT_FAMILY,
                                },
                            ],
                        },
                        "approve_after_days": 7,
                        "compliance_level": aws_native.ssm.PatchBaselineRuleComplianceLevel.CRITICAL,
                    },
                ],
            })

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_patch_baseline = aws_native.ssm.PatchBaseline("myPatchBaseline",
            name="myPatchBaseline",
            description="Baseline containing all updates approved for Windows instances",
            operating_system=aws_native.ssm.PatchBaselineOperatingSystem.WINDOWS,
            patch_groups=["myPatchGroup"],
            approval_rules={
                "patch_rules": [
                    {
                        "patch_filter_group": {
                            "patch_filters": [
                                {
                                    "values": [
                                        "Critical",
                                        "Important",
                                        "Moderate",
                                    ],
                                    "key": aws_native.ssm.PatchBaselinePatchFilterKey.MSRC_SEVERITY,
                                },
                                {
                                    "values": [
                                        "SecurityUpdates",
                                        "CriticalUpdates",
                                    ],
                                    "key": aws_native.ssm.PatchBaselinePatchFilterKey.CLASSIFICATION,
                                },
                                {
                                    "values": ["WindowsServer2019"],
                                    "key": aws_native.ssm.PatchBaselinePatchFilterKey.PRODUCT,
                                },
                            ],
                        },
                        "approve_after_days": 7,
                        "compliance_level": aws_native.ssm.PatchBaselineRuleComplianceLevel.CRITICAL,
                    },
                    {
                        "patch_filter_group": {
                            "patch_filters": [
                                {
                                    "values": [
                                        "Critical",
                                        "Important",
                                        "Moderate",
                                    ],
                                    "key": aws_native.ssm.PatchBaselinePatchFilterKey.MSRC_SEVERITY,
                                },
                                {
                                    "values": ["*"],
                                    "key": aws_native.ssm.PatchBaselinePatchFilterKey.CLASSIFICATION,
                                },
                                {
                                    "values": ["APPLICATION"],
                                    "key": aws_native.ssm.PatchBaselinePatchFilterKey.PATCH_SET,
                                },
                                {
                                    "values": ["Active Directory Rights Management Services Client 2.0"],
                                    "key": aws_native.ssm.PatchBaselinePatchFilterKey.PRODUCT,
                                },
                                {
                                    "values": ["Active Directory"],
                                    "key": aws_native.ssm.PatchBaselinePatchFilterKey.PRODUCT_FAMILY,
                                },
                            ],
                        },
                        "approve_after_days": 7,
                        "compliance_level": aws_native.ssm.PatchBaselineRuleComplianceLevel.CRITICAL,
                    },
                ],
            })

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['PatchBaselineRuleGroupArgs', 'PatchBaselineRuleGroupArgsDict']] approval_rules: A set of rules used to include patches in the baseline.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] approved_patches: A list of explicitly approved patches for the baseline.
        :param pulumi.Input['PatchBaselineApprovedPatchesComplianceLevel'] approved_patches_compliance_level: Defines the compliance level for approved patches. This means that if an approved patch is reported as missing, this is the severity of the compliance violation. The default value is UNSPECIFIED.
        :param pulumi.Input[builtins.bool] approved_patches_enable_non_security: Indicates whether the list of approved patches includes non-security updates that should be applied to the instances. The default value is 'false'. Applies to Linux instances only.
        :param pulumi.Input[builtins.bool] default_baseline: Set the baseline as default baseline. Only registering to default patch baseline is allowed.
        :param pulumi.Input[builtins.str] description: The description of the patch baseline.
        :param pulumi.Input[Union['PatchBaselinePatchFilterGroupArgs', 'PatchBaselinePatchFilterGroupArgsDict']] global_filters: A set of global filters used to include patches in the baseline.
        :param pulumi.Input[builtins.str] name: The name of the patch baseline.
        :param pulumi.Input['PatchBaselineOperatingSystem'] operating_system: Defines the operating system the patch baseline applies to. The Default value is WINDOWS.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] patch_groups: PatchGroups is used to associate instances with a specific patch baseline
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] rejected_patches: A list of explicitly rejected patches for the baseline.
        :param pulumi.Input['PatchBaselineRejectedPatchesAction'] rejected_patches_action: The action for Patch Manager to take on patches included in the RejectedPackages list.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PatchBaselinePatchSourceArgs', 'PatchBaselinePatchSourceArgsDict']]]] sources: Information about the patches to use to update the instances, including target operating systems and source repository. Applies to Linux instances only.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[PatchBaselineArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::SSM::PatchBaseline

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_patch_baseline = aws_native.ssm.PatchBaseline("myPatchBaseline",
            name="myPatchBaseline",
            description="Baseline containing all updates approved for Windows instances",
            operating_system=aws_native.ssm.PatchBaselineOperatingSystem.WINDOWS,
            patch_groups=["myPatchGroup"],
            approval_rules={
                "patch_rules": [
                    {
                        "patch_filter_group": {
                            "patch_filters": [
                                {
                                    "values": [
                                        "Critical",
                                        "Important",
                                        "Moderate",
                                    ],
                                    "key": aws_native.ssm.PatchBaselinePatchFilterKey.MSRC_SEVERITY,
                                },
                                {
                                    "values": [
                                        "SecurityUpdates",
                                        "CriticalUpdates",
                                    ],
                                    "key": aws_native.ssm.PatchBaselinePatchFilterKey.CLASSIFICATION,
                                },
                                {
                                    "values": ["WindowsServer2019"],
                                    "key": aws_native.ssm.PatchBaselinePatchFilterKey.PRODUCT,
                                },
                            ],
                        },
                        "approve_after_days": 7,
                        "compliance_level": aws_native.ssm.PatchBaselineRuleComplianceLevel.CRITICAL,
                    },
                    {
                        "patch_filter_group": {
                            "patch_filters": [
                                {
                                    "values": [
                                        "Critical",
                                        "Important",
                                        "Moderate",
                                    ],
                                    "key": aws_native.ssm.PatchBaselinePatchFilterKey.MSRC_SEVERITY,
                                },
                                {
                                    "values": ["*"],
                                    "key": aws_native.ssm.PatchBaselinePatchFilterKey.CLASSIFICATION,
                                },
                                {
                                    "values": ["APPLICATION"],
                                    "key": aws_native.ssm.PatchBaselinePatchFilterKey.PATCH_SET,
                                },
                                {
                                    "values": ["Active Directory Rights Management Services Client 2.0"],
                                    "key": aws_native.ssm.PatchBaselinePatchFilterKey.PRODUCT,
                                },
                                {
                                    "values": ["Active Directory"],
                                    "key": aws_native.ssm.PatchBaselinePatchFilterKey.PRODUCT_FAMILY,
                                },
                            ],
                        },
                        "approve_after_days": 7,
                        "compliance_level": aws_native.ssm.PatchBaselineRuleComplianceLevel.CRITICAL,
                    },
                ],
            })

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_patch_baseline = aws_native.ssm.PatchBaseline("myPatchBaseline",
            name="myPatchBaseline",
            description="Baseline containing all updates approved for Windows instances",
            operating_system=aws_native.ssm.PatchBaselineOperatingSystem.WINDOWS,
            patch_groups=["myPatchGroup"],
            approval_rules={
                "patch_rules": [
                    {
                        "patch_filter_group": {
                            "patch_filters": [
                                {
                                    "values": [
                                        "Critical",
                                        "Important",
                                        "Moderate",
                                    ],
                                    "key": aws_native.ssm.PatchBaselinePatchFilterKey.MSRC_SEVERITY,
                                },
                                {
                                    "values": [
                                        "SecurityUpdates",
                                        "CriticalUpdates",
                                    ],
                                    "key": aws_native.ssm.PatchBaselinePatchFilterKey.CLASSIFICATION,
                                },
                                {
                                    "values": ["WindowsServer2019"],
                                    "key": aws_native.ssm.PatchBaselinePatchFilterKey.PRODUCT,
                                },
                            ],
                        },
                        "approve_after_days": 7,
                        "compliance_level": aws_native.ssm.PatchBaselineRuleComplianceLevel.CRITICAL,
                    },
                    {
                        "patch_filter_group": {
                            "patch_filters": [
                                {
                                    "values": [
                                        "Critical",
                                        "Important",
                                        "Moderate",
                                    ],
                                    "key": aws_native.ssm.PatchBaselinePatchFilterKey.MSRC_SEVERITY,
                                },
                                {
                                    "values": ["*"],
                                    "key": aws_native.ssm.PatchBaselinePatchFilterKey.CLASSIFICATION,
                                },
                                {
                                    "values": ["APPLICATION"],
                                    "key": aws_native.ssm.PatchBaselinePatchFilterKey.PATCH_SET,
                                },
                                {
                                    "values": ["Active Directory Rights Management Services Client 2.0"],
                                    "key": aws_native.ssm.PatchBaselinePatchFilterKey.PRODUCT,
                                },
                                {
                                    "values": ["Active Directory"],
                                    "key": aws_native.ssm.PatchBaselinePatchFilterKey.PRODUCT_FAMILY,
                                },
                            ],
                        },
                        "approve_after_days": 7,
                        "compliance_level": aws_native.ssm.PatchBaselineRuleComplianceLevel.CRITICAL,
                    },
                ],
            })

        ```

        :param str resource_name: The name of the resource.
        :param PatchBaselineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PatchBaselineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 approval_rules: Optional[pulumi.Input[Union['PatchBaselineRuleGroupArgs', 'PatchBaselineRuleGroupArgsDict']]] = None,
                 approved_patches: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 approved_patches_compliance_level: Optional[pulumi.Input['PatchBaselineApprovedPatchesComplianceLevel']] = None,
                 approved_patches_enable_non_security: Optional[pulumi.Input[builtins.bool]] = None,
                 default_baseline: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 global_filters: Optional[pulumi.Input[Union['PatchBaselinePatchFilterGroupArgs', 'PatchBaselinePatchFilterGroupArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 operating_system: Optional[pulumi.Input['PatchBaselineOperatingSystem']] = None,
                 patch_groups: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 rejected_patches: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 rejected_patches_action: Optional[pulumi.Input['PatchBaselineRejectedPatchesAction']] = None,
                 sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PatchBaselinePatchSourceArgs', 'PatchBaselinePatchSourceArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PatchBaselineArgs.__new__(PatchBaselineArgs)

            __props__.__dict__["approval_rules"] = approval_rules
            __props__.__dict__["approved_patches"] = approved_patches
            __props__.__dict__["approved_patches_compliance_level"] = approved_patches_compliance_level
            __props__.__dict__["approved_patches_enable_non_security"] = approved_patches_enable_non_security
            __props__.__dict__["default_baseline"] = default_baseline
            __props__.__dict__["description"] = description
            __props__.__dict__["global_filters"] = global_filters
            __props__.__dict__["name"] = name
            __props__.__dict__["operating_system"] = operating_system
            __props__.__dict__["patch_groups"] = patch_groups
            __props__.__dict__["rejected_patches"] = rejected_patches
            __props__.__dict__["rejected_patches_action"] = rejected_patches_action
            __props__.__dict__["sources"] = sources
            __props__.__dict__["tags"] = tags
            __props__.__dict__["aws_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["operatingSystem"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(PatchBaseline, __self__).__init__(
            'aws-native:ssm:PatchBaseline',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'PatchBaseline':
        """
        Get an existing PatchBaseline resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = PatchBaselineArgs.__new__(PatchBaselineArgs)

        __props__.__dict__["approval_rules"] = None
        __props__.__dict__["approved_patches"] = None
        __props__.__dict__["approved_patches_compliance_level"] = None
        __props__.__dict__["approved_patches_enable_non_security"] = None
        __props__.__dict__["aws_id"] = None
        __props__.__dict__["default_baseline"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["global_filters"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["operating_system"] = None
        __props__.__dict__["patch_groups"] = None
        __props__.__dict__["rejected_patches"] = None
        __props__.__dict__["rejected_patches_action"] = None
        __props__.__dict__["sources"] = None
        __props__.__dict__["tags"] = None
        return PatchBaseline(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="approvalRules")
    def approval_rules(self) -> pulumi.Output[Optional['outputs.PatchBaselineRuleGroup']]:
        """
        A set of rules used to include patches in the baseline.
        """
        return pulumi.get(self, "approval_rules")

    @property
    @pulumi.getter(name="approvedPatches")
    def approved_patches(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of explicitly approved patches for the baseline.
        """
        return pulumi.get(self, "approved_patches")

    @property
    @pulumi.getter(name="approvedPatchesComplianceLevel")
    def approved_patches_compliance_level(self) -> pulumi.Output[Optional['PatchBaselineApprovedPatchesComplianceLevel']]:
        """
        Defines the compliance level for approved patches. This means that if an approved patch is reported as missing, this is the severity of the compliance violation. The default value is UNSPECIFIED.
        """
        return pulumi.get(self, "approved_patches_compliance_level")

    @property
    @pulumi.getter(name="approvedPatchesEnableNonSecurity")
    def approved_patches_enable_non_security(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Indicates whether the list of approved patches includes non-security updates that should be applied to the instances. The default value is 'false'. Applies to Linux instances only.
        """
        return pulumi.get(self, "approved_patches_enable_non_security")

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the patch baseline.
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="defaultBaseline")
    def default_baseline(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Set the baseline as default baseline. Only registering to default patch baseline is allowed.
        """
        return pulumi.get(self, "default_baseline")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the patch baseline.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="globalFilters")
    def global_filters(self) -> pulumi.Output[Optional['outputs.PatchBaselinePatchFilterGroup']]:
        """
        A set of global filters used to include patches in the baseline.
        """
        return pulumi.get(self, "global_filters")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the patch baseline.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> pulumi.Output[Optional['PatchBaselineOperatingSystem']]:
        """
        Defines the operating system the patch baseline applies to. The Default value is WINDOWS.
        """
        return pulumi.get(self, "operating_system")

    @property
    @pulumi.getter(name="patchGroups")
    def patch_groups(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        PatchGroups is used to associate instances with a specific patch baseline
        """
        return pulumi.get(self, "patch_groups")

    @property
    @pulumi.getter(name="rejectedPatches")
    def rejected_patches(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of explicitly rejected patches for the baseline.
        """
        return pulumi.get(self, "rejected_patches")

    @property
    @pulumi.getter(name="rejectedPatchesAction")
    def rejected_patches_action(self) -> pulumi.Output[Optional['PatchBaselineRejectedPatchesAction']]:
        """
        The action for Patch Manager to take on patches included in the RejectedPackages list.
        """
        return pulumi.get(self, "rejected_patches_action")

    @property
    @pulumi.getter
    def sources(self) -> pulumi.Output[Optional[Sequence['outputs.PatchBaselinePatchSource']]]:
        """
        Information about the patches to use to update the instances, including target operating systems and source repository. Applies to Linux instances only.
        """
        return pulumi.get(self, "sources")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways.
        """
        return pulumi.get(self, "tags")

