# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AssociationInstanceAssociationOutputLocation',
    'AssociationS3OutputLocation',
    'AssociationTarget',
    'DocumentAttachmentsSource',
    'DocumentRequires',
    'PatchBaselinePatchFilter',
    'PatchBaselinePatchFilterGroup',
    'PatchBaselinePatchSource',
    'PatchBaselineRule',
    'PatchBaselineRuleGroup',
    'ResourceDataSyncAwsOrganizationsSource',
    'ResourceDataSyncS3Destination',
    'ResourceDataSyncSyncSource',
]

@pulumi.output_type
class AssociationInstanceAssociationOutputLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Location":
            suggest = "s3_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssociationInstanceAssociationOutputLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssociationInstanceAssociationOutputLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssociationInstanceAssociationOutputLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_location: Optional['outputs.AssociationS3OutputLocation'] = None):
        """
        :param 'AssociationS3OutputLocation' s3_location: `S3OutputLocation` is a property of the [InstanceAssociationOutputLocation](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-instanceassociationoutputlocation.html) property that specifies an Amazon S3 bucket where you want to store the results of this request.
        """
        if s3_location is not None:
            pulumi.set(__self__, "s3_location", s3_location)

    @property
    @pulumi.getter(name="s3Location")
    def s3_location(self) -> Optional['outputs.AssociationS3OutputLocation']:
        """
        `S3OutputLocation` is a property of the [InstanceAssociationOutputLocation](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-instanceassociationoutputlocation.html) property that specifies an Amazon S3 bucket where you want to store the results of this request.
        """
        return pulumi.get(self, "s3_location")


@pulumi.output_type
class AssociationS3OutputLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "outputS3BucketName":
            suggest = "output_s3_bucket_name"
        elif key == "outputS3KeyPrefix":
            suggest = "output_s3_key_prefix"
        elif key == "outputS3Region":
            suggest = "output_s3_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AssociationS3OutputLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AssociationS3OutputLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AssociationS3OutputLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 output_s3_bucket_name: Optional[builtins.str] = None,
                 output_s3_key_prefix: Optional[builtins.str] = None,
                 output_s3_region: Optional[builtins.str] = None):
        """
        :param builtins.str output_s3_bucket_name: The name of the S3 bucket.
        :param builtins.str output_s3_key_prefix: The S3 bucket subfolder.
        :param builtins.str output_s3_region: The AWS Region of the S3 bucket.
        """
        if output_s3_bucket_name is not None:
            pulumi.set(__self__, "output_s3_bucket_name", output_s3_bucket_name)
        if output_s3_key_prefix is not None:
            pulumi.set(__self__, "output_s3_key_prefix", output_s3_key_prefix)
        if output_s3_region is not None:
            pulumi.set(__self__, "output_s3_region", output_s3_region)

    @property
    @pulumi.getter(name="outputS3BucketName")
    def output_s3_bucket_name(self) -> Optional[builtins.str]:
        """
        The name of the S3 bucket.
        """
        return pulumi.get(self, "output_s3_bucket_name")

    @property
    @pulumi.getter(name="outputS3KeyPrefix")
    def output_s3_key_prefix(self) -> Optional[builtins.str]:
        """
        The S3 bucket subfolder.
        """
        return pulumi.get(self, "output_s3_key_prefix")

    @property
    @pulumi.getter(name="outputS3Region")
    def output_s3_region(self) -> Optional[builtins.str]:
        """
        The AWS Region of the S3 bucket.
        """
        return pulumi.get(self, "output_s3_region")


@pulumi.output_type
class AssociationTarget(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 values: Sequence[builtins.str]):
        """
        :param builtins.str key: User-defined criteria for sending commands that target managed nodes that meet the criteria.
        :param Sequence[builtins.str] values: User-defined criteria that maps to `Key` . For example, if you specified `tag:ServerRole` , you could specify `value:WebServer` to run a command on instances that include EC2 tags of `ServerRole,WebServer` .
               
               Depending on the type of target, the maximum number of values for a key might be lower than the global maximum of 50.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        User-defined criteria for sending commands that target managed nodes that meet the criteria.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        """
        User-defined criteria that maps to `Key` . For example, if you specified `tag:ServerRole` , you could specify `value:WebServer` to run a command on instances that include EC2 tags of `ServerRole,WebServer` .

        Depending on the type of target, the maximum number of values for a key might be lower than the global maximum of 50.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class DocumentAttachmentsSource(dict):
    def __init__(__self__, *,
                 key: Optional['DocumentAttachmentsSourceKey'] = None,
                 name: Optional[builtins.str] = None,
                 values: Optional[Sequence[builtins.str]] = None):
        """
        :param 'DocumentAttachmentsSourceKey' key: The key of a key-value pair that identifies the location of an attachment to a document.
        :param builtins.str name: The name of the document attachment file.
        :param Sequence[builtins.str] values: The value of a key-value pair that identifies the location of an attachment to a document. The format for Value depends on the type of key you specify.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> Optional['DocumentAttachmentsSourceKey']:
        """
        The key of a key-value pair that identifies the location of an attachment to a document.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the document attachment file.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[builtins.str]]:
        """
        The value of a key-value pair that identifies the location of an attachment to a document. The format for Value depends on the type of key you specify.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class DocumentRequires(dict):
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 version: Optional[builtins.str] = None):
        """
        :param builtins.str name: The name of the required SSM document. The name can be an Amazon Resource Name (ARN).
        :param builtins.str version: The document version required by the current document.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the required SSM document. The name can be an Amazon Resource Name (ARN).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        The document version required by the current document.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class PatchBaselinePatchFilter(dict):
    """
    Defines which patches should be included in a patch baseline.
    """
    def __init__(__self__, *,
                 key: Optional['PatchBaselinePatchFilterKey'] = None,
                 values: Optional[Sequence[builtins.str]] = None):
        """
        Defines which patches should be included in a patch baseline.
        :param 'PatchBaselinePatchFilterKey' key: The key for the filter.
               
               For information about valid keys, see [PatchFilter](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html) in the *AWS Systems Manager API Reference* .
        :param Sequence[builtins.str] values: The value for the filter key.
               
               For information about valid values for each key based on operating system type, see [PatchFilter](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html) in the *AWS Systems Manager API Reference* .
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> Optional['PatchBaselinePatchFilterKey']:
        """
        The key for the filter.

        For information about valid keys, see [PatchFilter](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html) in the *AWS Systems Manager API Reference* .
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[builtins.str]]:
        """
        The value for the filter key.

        For information about valid values for each key based on operating system type, see [PatchFilter](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html) in the *AWS Systems Manager API Reference* .
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class PatchBaselinePatchFilterGroup(dict):
    """
    The patch filter group that defines the criteria for the rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "patchFilters":
            suggest = "patch_filters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PatchBaselinePatchFilterGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PatchBaselinePatchFilterGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PatchBaselinePatchFilterGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 patch_filters: Optional[Sequence['outputs.PatchBaselinePatchFilter']] = None):
        """
        The patch filter group that defines the criteria for the rule.
        :param Sequence['PatchBaselinePatchFilter'] patch_filters: The set of patch filters that make up the group.
        """
        if patch_filters is not None:
            pulumi.set(__self__, "patch_filters", patch_filters)

    @property
    @pulumi.getter(name="patchFilters")
    def patch_filters(self) -> Optional[Sequence['outputs.PatchBaselinePatchFilter']]:
        """
        The set of patch filters that make up the group.
        """
        return pulumi.get(self, "patch_filters")


@pulumi.output_type
class PatchBaselinePatchSource(dict):
    """
    Information about the patches to use to update the instances, including target operating systems and source repository. Applies to Linux instances only.
    """
    def __init__(__self__, *,
                 configuration: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 products: Optional[Sequence[builtins.str]] = None):
        """
        Information about the patches to use to update the instances, including target operating systems and source repository. Applies to Linux instances only.
        :param builtins.str configuration: The value of the yum repo configuration. For example:
               
               `[main]`
               
               `name=MyCustomRepository`
               
               `baseurl=https://my-custom-repository`
               
               `enabled=1`
               
               > For information about other options available for your yum repository configuration, see [dnf.conf(5)](https://docs.aws.amazon.com/https://man7.org/linux/man-pages/man5/dnf.conf.5.html) .
        :param builtins.str name: The name specified to identify the patch source.
        :param Sequence[builtins.str] products: The specific operating system versions a patch repository applies to, such as "Ubuntu16.04", "RedhatEnterpriseLinux7.2" or "Suse12.7". For lists of supported product values, see [PatchFilter](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html) in the *AWS Systems Manager API Reference* .
        """
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if products is not None:
            pulumi.set(__self__, "products", products)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[builtins.str]:
        """
        The value of the yum repo configuration. For example:

        `[main]`

        `name=MyCustomRepository`

        `baseurl=https://my-custom-repository`

        `enabled=1`

        > For information about other options available for your yum repository configuration, see [dnf.conf(5)](https://docs.aws.amazon.com/https://man7.org/linux/man-pages/man5/dnf.conf.5.html) .
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name specified to identify the patch source.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def products(self) -> Optional[Sequence[builtins.str]]:
        """
        The specific operating system versions a patch repository applies to, such as "Ubuntu16.04", "RedhatEnterpriseLinux7.2" or "Suse12.7". For lists of supported product values, see [PatchFilter](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html) in the *AWS Systems Manager API Reference* .
        """
        return pulumi.get(self, "products")


@pulumi.output_type
class PatchBaselineRule(dict):
    """
    Defines an approval rule for a patch baseline.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "approveAfterDays":
            suggest = "approve_after_days"
        elif key == "approveUntilDate":
            suggest = "approve_until_date"
        elif key == "complianceLevel":
            suggest = "compliance_level"
        elif key == "enableNonSecurity":
            suggest = "enable_non_security"
        elif key == "patchFilterGroup":
            suggest = "patch_filter_group"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PatchBaselineRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PatchBaselineRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PatchBaselineRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 approve_after_days: Optional[builtins.int] = None,
                 approve_until_date: Optional[builtins.str] = None,
                 compliance_level: Optional['PatchBaselineRuleComplianceLevel'] = None,
                 enable_non_security: Optional[builtins.bool] = None,
                 patch_filter_group: Optional['outputs.PatchBaselinePatchFilterGroup'] = None):
        """
        Defines an approval rule for a patch baseline.
        :param builtins.int approve_after_days: The number of days after the release date of each patch matched by the rule that the patch is marked as approved in the patch baseline. For example, a value of `7` means that patches are approved seven days after they are released.
               
               This parameter is marked as `Required: No` , but your request must include a value for either `ApproveAfterDays` or `ApproveUntilDate` .
               
               Not supported for Debian Server or Ubuntu Server.
               
               > Use caution when setting this value for Windows Server patch baselines. Because patch updates that are replaced by later updates are removed, setting too broad a value for this parameter can result in crucial patches not being installed. For more information, see the *Windows Server* tab in the topic [How security patches are selected](https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-selecting-patches.html) in the *AWS Systems Manager User Guide* .
        :param builtins.str approve_until_date: The cutoff date for auto approval of released patches. Any patches released on or before this date are installed automatically.
               
               Enter dates in the format `YYYY-MM-DD` . For example, `2024-12-31` .
               
               This parameter is marked as `Required: No` , but your request must include a value for either `ApproveUntilDate` or `ApproveAfterDays` .
               
               Not supported for Debian Server or Ubuntu Server.
               
               > Use caution when setting this value for Windows Server patch baselines. Because patch updates that are replaced by later updates are removed, setting too broad a value for this parameter can result in crucial patches not being installed. For more information, see the *Windows Server* tab in the topic [How security patches are selected](https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-selecting-patches.html) in the *AWS Systems Manager User Guide* .
        :param 'PatchBaselineRuleComplianceLevel' compliance_level: A compliance severity level for all approved patches in a patch baseline. Valid compliance severity levels include the following: `UNSPECIFIED` , `CRITICAL` , `HIGH` , `MEDIUM` , `LOW` , and `INFORMATIONAL` .
        :param builtins.bool enable_non_security: For managed nodes identified by the approval rule filters, enables a patch baseline to apply non-security updates available in the specified repository. The default value is `false` . Applies to Linux managed nodes only.
        :param 'PatchBaselinePatchFilterGroup' patch_filter_group: The patch filter group that defines the criteria for the rule.
        """
        if approve_after_days is not None:
            pulumi.set(__self__, "approve_after_days", approve_after_days)
        if approve_until_date is not None:
            pulumi.set(__self__, "approve_until_date", approve_until_date)
        if compliance_level is not None:
            pulumi.set(__self__, "compliance_level", compliance_level)
        if enable_non_security is not None:
            pulumi.set(__self__, "enable_non_security", enable_non_security)
        if patch_filter_group is not None:
            pulumi.set(__self__, "patch_filter_group", patch_filter_group)

    @property
    @pulumi.getter(name="approveAfterDays")
    def approve_after_days(self) -> Optional[builtins.int]:
        """
        The number of days after the release date of each patch matched by the rule that the patch is marked as approved in the patch baseline. For example, a value of `7` means that patches are approved seven days after they are released.

        This parameter is marked as `Required: No` , but your request must include a value for either `ApproveAfterDays` or `ApproveUntilDate` .

        Not supported for Debian Server or Ubuntu Server.

        > Use caution when setting this value for Windows Server patch baselines. Because patch updates that are replaced by later updates are removed, setting too broad a value for this parameter can result in crucial patches not being installed. For more information, see the *Windows Server* tab in the topic [How security patches are selected](https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-selecting-patches.html) in the *AWS Systems Manager User Guide* .
        """
        return pulumi.get(self, "approve_after_days")

    @property
    @pulumi.getter(name="approveUntilDate")
    def approve_until_date(self) -> Optional[builtins.str]:
        """
        The cutoff date for auto approval of released patches. Any patches released on or before this date are installed automatically.

        Enter dates in the format `YYYY-MM-DD` . For example, `2024-12-31` .

        This parameter is marked as `Required: No` , but your request must include a value for either `ApproveUntilDate` or `ApproveAfterDays` .

        Not supported for Debian Server or Ubuntu Server.

        > Use caution when setting this value for Windows Server patch baselines. Because patch updates that are replaced by later updates are removed, setting too broad a value for this parameter can result in crucial patches not being installed. For more information, see the *Windows Server* tab in the topic [How security patches are selected](https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-selecting-patches.html) in the *AWS Systems Manager User Guide* .
        """
        return pulumi.get(self, "approve_until_date")

    @property
    @pulumi.getter(name="complianceLevel")
    def compliance_level(self) -> Optional['PatchBaselineRuleComplianceLevel']:
        """
        A compliance severity level for all approved patches in a patch baseline. Valid compliance severity levels include the following: `UNSPECIFIED` , `CRITICAL` , `HIGH` , `MEDIUM` , `LOW` , and `INFORMATIONAL` .
        """
        return pulumi.get(self, "compliance_level")

    @property
    @pulumi.getter(name="enableNonSecurity")
    def enable_non_security(self) -> Optional[builtins.bool]:
        """
        For managed nodes identified by the approval rule filters, enables a patch baseline to apply non-security updates available in the specified repository. The default value is `false` . Applies to Linux managed nodes only.
        """
        return pulumi.get(self, "enable_non_security")

    @property
    @pulumi.getter(name="patchFilterGroup")
    def patch_filter_group(self) -> Optional['outputs.PatchBaselinePatchFilterGroup']:
        """
        The patch filter group that defines the criteria for the rule.
        """
        return pulumi.get(self, "patch_filter_group")


@pulumi.output_type
class PatchBaselineRuleGroup(dict):
    """
    A set of rules defining the approval rules for a patch baseline.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "patchRules":
            suggest = "patch_rules"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PatchBaselineRuleGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PatchBaselineRuleGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PatchBaselineRuleGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 patch_rules: Optional[Sequence['outputs.PatchBaselineRule']] = None):
        """
        A set of rules defining the approval rules for a patch baseline.
        :param Sequence['PatchBaselineRule'] patch_rules: The rules that make up the rule group.
        """
        if patch_rules is not None:
            pulumi.set(__self__, "patch_rules", patch_rules)

    @property
    @pulumi.getter(name="patchRules")
    def patch_rules(self) -> Optional[Sequence['outputs.PatchBaselineRule']]:
        """
        The rules that make up the rule group.
        """
        return pulumi.get(self, "patch_rules")


@pulumi.output_type
class ResourceDataSyncAwsOrganizationsSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "organizationSourceType":
            suggest = "organization_source_type"
        elif key == "organizationalUnits":
            suggest = "organizational_units"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceDataSyncAwsOrganizationsSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceDataSyncAwsOrganizationsSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceDataSyncAwsOrganizationsSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 organization_source_type: builtins.str,
                 organizational_units: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str organization_source_type: If an AWS organization is present, this is either `OrganizationalUnits` or `EntireOrganization` . For `OrganizationalUnits` , the data is aggregated from a set of organization units. For `EntireOrganization` , the data is aggregated from the entire AWS organization.
        :param Sequence[builtins.str] organizational_units: The AWS Organizations organization units included in the sync.
        """
        pulumi.set(__self__, "organization_source_type", organization_source_type)
        if organizational_units is not None:
            pulumi.set(__self__, "organizational_units", organizational_units)

    @property
    @pulumi.getter(name="organizationSourceType")
    def organization_source_type(self) -> builtins.str:
        """
        If an AWS organization is present, this is either `OrganizationalUnits` or `EntireOrganization` . For `OrganizationalUnits` , the data is aggregated from a set of organization units. For `EntireOrganization` , the data is aggregated from the entire AWS organization.
        """
        return pulumi.get(self, "organization_source_type")

    @property
    @pulumi.getter(name="organizationalUnits")
    def organizational_units(self) -> Optional[Sequence[builtins.str]]:
        """
        The AWS Organizations organization units included in the sync.
        """
        return pulumi.get(self, "organizational_units")


@pulumi.output_type
class ResourceDataSyncS3Destination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "bucketRegion":
            suggest = "bucket_region"
        elif key == "syncFormat":
            suggest = "sync_format"
        elif key == "bucketPrefix":
            suggest = "bucket_prefix"
        elif key == "kmsKeyArn":
            suggest = "kms_key_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceDataSyncS3Destination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceDataSyncS3Destination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceDataSyncS3Destination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: builtins.str,
                 bucket_region: builtins.str,
                 sync_format: builtins.str,
                 bucket_prefix: Optional[builtins.str] = None,
                 kms_key_arn: Optional[builtins.str] = None):
        """
        :param builtins.str bucket_name: The name of the S3 bucket where the aggregated data is stored.
        :param builtins.str bucket_region: The AWS Region with the S3 bucket targeted by the resource data sync.
        :param builtins.str sync_format: A supported sync format. The following format is currently supported: JsonSerDe
        :param builtins.str bucket_prefix: An Amazon S3 prefix for the bucket.
        :param builtins.str kms_key_arn: The ARN of an encryption key for a destination in Amazon S3. Must belong to the same Region as the destination S3 bucket.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "bucket_region", bucket_region)
        pulumi.set(__self__, "sync_format", sync_format)
        if bucket_prefix is not None:
            pulumi.set(__self__, "bucket_prefix", bucket_prefix)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> builtins.str:
        """
        The name of the S3 bucket where the aggregated data is stored.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="bucketRegion")
    def bucket_region(self) -> builtins.str:
        """
        The AWS Region with the S3 bucket targeted by the resource data sync.
        """
        return pulumi.get(self, "bucket_region")

    @property
    @pulumi.getter(name="syncFormat")
    def sync_format(self) -> builtins.str:
        """
        A supported sync format. The following format is currently supported: JsonSerDe
        """
        return pulumi.get(self, "sync_format")

    @property
    @pulumi.getter(name="bucketPrefix")
    def bucket_prefix(self) -> Optional[builtins.str]:
        """
        An Amazon S3 prefix for the bucket.
        """
        return pulumi.get(self, "bucket_prefix")

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[builtins.str]:
        """
        The ARN of an encryption key for a destination in Amazon S3. Must belong to the same Region as the destination S3 bucket.
        """
        return pulumi.get(self, "kms_key_arn")


@pulumi.output_type
class ResourceDataSyncSyncSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceRegions":
            suggest = "source_regions"
        elif key == "sourceType":
            suggest = "source_type"
        elif key == "awsOrganizationsSource":
            suggest = "aws_organizations_source"
        elif key == "includeFutureRegions":
            suggest = "include_future_regions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceDataSyncSyncSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceDataSyncSyncSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceDataSyncSyncSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_regions: Sequence[builtins.str],
                 source_type: builtins.str,
                 aws_organizations_source: Optional['outputs.ResourceDataSyncAwsOrganizationsSource'] = None,
                 include_future_regions: Optional[builtins.bool] = None):
        """
        :param Sequence[builtins.str] source_regions: The `SyncSource` AWS Regions included in the resource data sync.
        :param builtins.str source_type: The type of data source for the resource data sync. `SourceType` is either `AwsOrganizations` (if an organization is present in AWS Organizations ) or `SingleAccountMultiRegions` .
        :param 'ResourceDataSyncAwsOrganizationsSource' aws_organizations_source: Information about the AwsOrganizationsSource resource data sync source. A sync source of this type can synchronize data from AWS Organizations .
        :param builtins.bool include_future_regions: Whether to automatically synchronize and aggregate data from new AWS Regions when those Regions come online.
        """
        pulumi.set(__self__, "source_regions", source_regions)
        pulumi.set(__self__, "source_type", source_type)
        if aws_organizations_source is not None:
            pulumi.set(__self__, "aws_organizations_source", aws_organizations_source)
        if include_future_regions is not None:
            pulumi.set(__self__, "include_future_regions", include_future_regions)

    @property
    @pulumi.getter(name="sourceRegions")
    def source_regions(self) -> Sequence[builtins.str]:
        """
        The `SyncSource` AWS Regions included in the resource data sync.
        """
        return pulumi.get(self, "source_regions")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> builtins.str:
        """
        The type of data source for the resource data sync. `SourceType` is either `AwsOrganizations` (if an organization is present in AWS Organizations ) or `SingleAccountMultiRegions` .
        """
        return pulumi.get(self, "source_type")

    @property
    @pulumi.getter(name="awsOrganizationsSource")
    def aws_organizations_source(self) -> Optional['outputs.ResourceDataSyncAwsOrganizationsSource']:
        """
        Information about the AwsOrganizationsSource resource data sync source. A sync source of this type can synchronize data from AWS Organizations .
        """
        return pulumi.get(self, "aws_organizations_source")

    @property
    @pulumi.getter(name="includeFutureRegions")
    def include_future_regions(self) -> Optional[builtins.bool]:
        """
        Whether to automatically synchronize and aggregate data from new AWS Regions when those Regions come online.
        """
        return pulumi.get(self, "include_future_regions")


