# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetResourcePolicyResult',
    'AwaitableGetResourcePolicyResult',
    'get_resource_policy',
    'get_resource_policy_output',
]

@pulumi.output_type
class GetResourcePolicyResult:
    def __init__(__self__, policy=None, policy_hash=None, policy_id=None):
        if policy and not isinstance(policy, dict):
            raise TypeError("Expected argument 'policy' to be a dict")
        pulumi.set(__self__, "policy", policy)
        if policy_hash and not isinstance(policy_hash, str):
            raise TypeError("Expected argument 'policy_hash' to be a str")
        pulumi.set(__self__, "policy_hash", policy_hash)
        if policy_id and not isinstance(policy_id, str):
            raise TypeError("Expected argument 'policy_id' to be a str")
        pulumi.set(__self__, "policy_id", policy_id)

    @property
    @pulumi.getter
    def policy(self) -> Optional[Any]:
        """
        Actual policy statement.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SSM::ResourcePolicy` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="policyHash")
    def policy_hash(self) -> Optional[builtins.str]:
        """
        A snapshot identifier for the policy over time.
        """
        return pulumi.get(self, "policy_hash")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[builtins.str]:
        """
        An unique identifier within the policies of a resource. 
        """
        return pulumi.get(self, "policy_id")


class AwaitableGetResourcePolicyResult(GetResourcePolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResourcePolicyResult(
            policy=self.policy,
            policy_hash=self.policy_hash,
            policy_id=self.policy_id)


def get_resource_policy(policy_id: Optional[builtins.str] = None,
                        resource_arn: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResourcePolicyResult:
    """
    Resource Type definition for AWS::SSM::ResourcePolicy


    :param builtins.str policy_id: An unique identifier within the policies of a resource. 
    :param builtins.str resource_arn: Arn of OpsItemGroup etc.
    """
    __args__ = dict()
    __args__['policyId'] = policy_id
    __args__['resourceArn'] = resource_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ssm:getResourcePolicy', __args__, opts=opts, typ=GetResourcePolicyResult).value

    return AwaitableGetResourcePolicyResult(
        policy=pulumi.get(__ret__, 'policy'),
        policy_hash=pulumi.get(__ret__, 'policy_hash'),
        policy_id=pulumi.get(__ret__, 'policy_id'))
def get_resource_policy_output(policy_id: Optional[pulumi.Input[builtins.str]] = None,
                               resource_arn: Optional[pulumi.Input[builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResourcePolicyResult]:
    """
    Resource Type definition for AWS::SSM::ResourcePolicy


    :param builtins.str policy_id: An unique identifier within the policies of a resource. 
    :param builtins.str resource_arn: Arn of OpsItemGroup etc.
    """
    __args__ = dict()
    __args__['policyId'] = policy_id
    __args__['resourceArn'] = resource_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ssm:getResourcePolicy', __args__, opts=opts, typ=GetResourcePolicyResult)
    return __ret__.apply(lambda __response__: GetResourcePolicyResult(
        policy=pulumi.get(__response__, 'policy'),
        policy_hash=pulumi.get(__response__, 'policy_hash'),
        policy_id=pulumi.get(__response__, 'policy_id')))
