# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['AssociationArgs', 'Association']

@pulumi.input_type
class AssociationArgs:
    def __init__(__self__, *,
                 apply_only_at_cron_interval: Optional[pulumi.Input[builtins.bool]] = None,
                 association_name: Optional[pulumi.Input[builtins.str]] = None,
                 automation_target_parameter_name: Optional[pulumi.Input[builtins.str]] = None,
                 calendar_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 compliance_severity: Optional[pulumi.Input['AssociationComplianceSeverity']] = None,
                 document_version: Optional[pulumi.Input[builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 max_concurrency: Optional[pulumi.Input[builtins.str]] = None,
                 max_errors: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 output_location: Optional[pulumi.Input['AssociationInstanceAssociationOutputLocationArgs']] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]] = None,
                 schedule_expression: Optional[pulumi.Input[builtins.str]] = None,
                 schedule_offset: Optional[pulumi.Input[builtins.int]] = None,
                 sync_compliance: Optional[pulumi.Input['AssociationSyncCompliance']] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input['AssociationTargetArgs']]]] = None,
                 wait_for_success_timeout_seconds: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a Association resource.
        :param pulumi.Input[builtins.bool] apply_only_at_cron_interval: By default, when you create a new association, the system runs it immediately after it is created and then according to the schedule you specified. Specify this option if you don't want an association to run immediately after you create it. This parameter is not supported for rate expressions.
        :param pulumi.Input[builtins.str] association_name: The name of the association.
        :param pulumi.Input[builtins.str] automation_target_parameter_name: Choose the parameter that will define how your automation will branch out. This target is required for associations that use an Automation runbook and target resources by using rate controls. Automation is a tool in AWS Systems Manager .
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] calendar_names: The names or Amazon Resource Names (ARNs) of the Change Calendar type documents your associations are gated under. The associations only run when that Change Calendar is open. For more information, see [AWS Systems Manager Change Calendar](https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar) in the *AWS Systems Manager User Guide* .
        :param pulumi.Input['AssociationComplianceSeverity'] compliance_severity: The severity level that is assigned to the association.
        :param pulumi.Input[builtins.str] document_version: The version of the SSM document to associate with the target.
        :param pulumi.Input[builtins.str] instance_id: The ID of the instance that the SSM document is associated with.
        :param pulumi.Input[builtins.str] max_concurrency: The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%. The default value is 100%, which means all targets run the association at the same time.
               
               If a new managed node starts and attempts to run an association while Systems Manager is running `MaxConcurrency` associations, the association is allowed to run. During the next association interval, the new managed node will process its association within the limit specified for `MaxConcurrency` .
        :param pulumi.Input[builtins.str] max_errors: The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify either an absolute number of errors, for example 10, or a percentage of the target set, for example 10%. If you specify 3, for example, the system stops sending requests when the fourth error is received. If you specify 0, then the system stops sending requests after the first error is returned. If you run an association on 50 managed nodes and set `MaxError` to 10%, then the system stops sending the request when the sixth error is received.
               
               Executions that are already running an association when `MaxErrors` is reached are allowed to complete, but some of these executions may fail as well. If you need to ensure that there won't be more than max-errors failed executions, set `MaxConcurrency` to 1 so that executions proceed one at a time.
        :param pulumi.Input[builtins.str] name: The name of the SSM document.
        :param pulumi.Input['AssociationInstanceAssociationOutputLocationArgs'] output_location: An Amazon Simple Storage Service (Amazon S3) bucket where you want to store the output details of the request.
        :param pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]] parameters: Parameter values that the SSM document uses at runtime.
        :param pulumi.Input[builtins.str] schedule_expression: A Cron or Rate expression that specifies when the association is applied to the target.
        :param pulumi.Input[builtins.int] schedule_offset: Number of days to wait after the scheduled day to run an association.
        :param pulumi.Input['AssociationSyncCompliance'] sync_compliance: The mode for generating association compliance. You can specify `AUTO` or `MANUAL` . In `AUTO` mode, the system uses the status of the association execution to determine the compliance status. If the association execution runs successfully, then the association is `COMPLIANT` . If the association execution doesn't run successfully, the association is `NON-COMPLIANT` .
               
               In `MANUAL` mode, you must specify the `AssociationId` as a parameter for the `PutComplianceItems` API action. In this case, compliance data is not managed by State Manager. It is managed by your direct call to the `PutComplianceItems` API action.
               
               By default, all associations use `AUTO` mode.
        :param pulumi.Input[Sequence[pulumi.Input['AssociationTargetArgs']]] targets: The targets that the SSM document sends commands to.
        :param pulumi.Input[builtins.int] wait_for_success_timeout_seconds: The number of seconds the service should wait for the association status to show "Success" before proceeding with the stack execution. If the association status doesn't show "Success" after the specified number of seconds, then stack creation fails.
               
               > When you specify a value for the `WaitForSuccessTimeoutSeconds` , [drift detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html) for your AWS CloudFormation stack’s configuration might yield inaccurate results. If drift detection is important in your scenario, we recommend that you don’t include `WaitForSuccessTimeoutSeconds` in your template.
        """
        if apply_only_at_cron_interval is not None:
            pulumi.set(__self__, "apply_only_at_cron_interval", apply_only_at_cron_interval)
        if association_name is not None:
            pulumi.set(__self__, "association_name", association_name)
        if automation_target_parameter_name is not None:
            pulumi.set(__self__, "automation_target_parameter_name", automation_target_parameter_name)
        if calendar_names is not None:
            pulumi.set(__self__, "calendar_names", calendar_names)
        if compliance_severity is not None:
            pulumi.set(__self__, "compliance_severity", compliance_severity)
        if document_version is not None:
            pulumi.set(__self__, "document_version", document_version)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if max_concurrency is not None:
            pulumi.set(__self__, "max_concurrency", max_concurrency)
        if max_errors is not None:
            pulumi.set(__self__, "max_errors", max_errors)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if output_location is not None:
            pulumi.set(__self__, "output_location", output_location)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if schedule_expression is not None:
            pulumi.set(__self__, "schedule_expression", schedule_expression)
        if schedule_offset is not None:
            pulumi.set(__self__, "schedule_offset", schedule_offset)
        if sync_compliance is not None:
            pulumi.set(__self__, "sync_compliance", sync_compliance)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)
        if wait_for_success_timeout_seconds is not None:
            pulumi.set(__self__, "wait_for_success_timeout_seconds", wait_for_success_timeout_seconds)

    @property
    @pulumi.getter(name="applyOnlyAtCronInterval")
    def apply_only_at_cron_interval(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        By default, when you create a new association, the system runs it immediately after it is created and then according to the schedule you specified. Specify this option if you don't want an association to run immediately after you create it. This parameter is not supported for rate expressions.
        """
        return pulumi.get(self, "apply_only_at_cron_interval")

    @apply_only_at_cron_interval.setter
    def apply_only_at_cron_interval(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "apply_only_at_cron_interval", value)

    @property
    @pulumi.getter(name="associationName")
    def association_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the association.
        """
        return pulumi.get(self, "association_name")

    @association_name.setter
    def association_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "association_name", value)

    @property
    @pulumi.getter(name="automationTargetParameterName")
    def automation_target_parameter_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Choose the parameter that will define how your automation will branch out. This target is required for associations that use an Automation runbook and target resources by using rate controls. Automation is a tool in AWS Systems Manager .
        """
        return pulumi.get(self, "automation_target_parameter_name")

    @automation_target_parameter_name.setter
    def automation_target_parameter_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "automation_target_parameter_name", value)

    @property
    @pulumi.getter(name="calendarNames")
    def calendar_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The names or Amazon Resource Names (ARNs) of the Change Calendar type documents your associations are gated under. The associations only run when that Change Calendar is open. For more information, see [AWS Systems Manager Change Calendar](https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar) in the *AWS Systems Manager User Guide* .
        """
        return pulumi.get(self, "calendar_names")

    @calendar_names.setter
    def calendar_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "calendar_names", value)

    @property
    @pulumi.getter(name="complianceSeverity")
    def compliance_severity(self) -> Optional[pulumi.Input['AssociationComplianceSeverity']]:
        """
        The severity level that is assigned to the association.
        """
        return pulumi.get(self, "compliance_severity")

    @compliance_severity.setter
    def compliance_severity(self, value: Optional[pulumi.Input['AssociationComplianceSeverity']]):
        pulumi.set(self, "compliance_severity", value)

    @property
    @pulumi.getter(name="documentVersion")
    def document_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The version of the SSM document to associate with the target.
        """
        return pulumi.get(self, "document_version")

    @document_version.setter
    def document_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "document_version", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the instance that the SSM document is associated with.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="maxConcurrency")
    def max_concurrency(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%. The default value is 100%, which means all targets run the association at the same time.

        If a new managed node starts and attempts to run an association while Systems Manager is running `MaxConcurrency` associations, the association is allowed to run. During the next association interval, the new managed node will process its association within the limit specified for `MaxConcurrency` .
        """
        return pulumi.get(self, "max_concurrency")

    @max_concurrency.setter
    def max_concurrency(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "max_concurrency", value)

    @property
    @pulumi.getter(name="maxErrors")
    def max_errors(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify either an absolute number of errors, for example 10, or a percentage of the target set, for example 10%. If you specify 3, for example, the system stops sending requests when the fourth error is received. If you specify 0, then the system stops sending requests after the first error is returned. If you run an association on 50 managed nodes and set `MaxError` to 10%, then the system stops sending the request when the sixth error is received.

        Executions that are already running an association when `MaxErrors` is reached are allowed to complete, but some of these executions may fail as well. If you need to ensure that there won't be more than max-errors failed executions, set `MaxConcurrency` to 1 so that executions proceed one at a time.
        """
        return pulumi.get(self, "max_errors")

    @max_errors.setter
    def max_errors(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "max_errors", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the SSM document.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="outputLocation")
    def output_location(self) -> Optional[pulumi.Input['AssociationInstanceAssociationOutputLocationArgs']]:
        """
        An Amazon Simple Storage Service (Amazon S3) bucket where you want to store the output details of the request.
        """
        return pulumi.get(self, "output_location")

    @output_location.setter
    def output_location(self, value: Optional[pulumi.Input['AssociationInstanceAssociationOutputLocationArgs']]):
        pulumi.set(self, "output_location", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]]:
        """
        Parameter values that the SSM document uses at runtime.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A Cron or Rate expression that specifies when the association is applied to the target.
        """
        return pulumi.get(self, "schedule_expression")

    @schedule_expression.setter
    def schedule_expression(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "schedule_expression", value)

    @property
    @pulumi.getter(name="scheduleOffset")
    def schedule_offset(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of days to wait after the scheduled day to run an association.
        """
        return pulumi.get(self, "schedule_offset")

    @schedule_offset.setter
    def schedule_offset(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "schedule_offset", value)

    @property
    @pulumi.getter(name="syncCompliance")
    def sync_compliance(self) -> Optional[pulumi.Input['AssociationSyncCompliance']]:
        """
        The mode for generating association compliance. You can specify `AUTO` or `MANUAL` . In `AUTO` mode, the system uses the status of the association execution to determine the compliance status. If the association execution runs successfully, then the association is `COMPLIANT` . If the association execution doesn't run successfully, the association is `NON-COMPLIANT` .

        In `MANUAL` mode, you must specify the `AssociationId` as a parameter for the `PutComplianceItems` API action. In this case, compliance data is not managed by State Manager. It is managed by your direct call to the `PutComplianceItems` API action.

        By default, all associations use `AUTO` mode.
        """
        return pulumi.get(self, "sync_compliance")

    @sync_compliance.setter
    def sync_compliance(self, value: Optional[pulumi.Input['AssociationSyncCompliance']]):
        pulumi.set(self, "sync_compliance", value)

    @property
    @pulumi.getter
    def targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AssociationTargetArgs']]]]:
        """
        The targets that the SSM document sends commands to.
        """
        return pulumi.get(self, "targets")

    @targets.setter
    def targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AssociationTargetArgs']]]]):
        pulumi.set(self, "targets", value)

    @property
    @pulumi.getter(name="waitForSuccessTimeoutSeconds")
    def wait_for_success_timeout_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of seconds the service should wait for the association status to show "Success" before proceeding with the stack execution. If the association status doesn't show "Success" after the specified number of seconds, then stack creation fails.

        > When you specify a value for the `WaitForSuccessTimeoutSeconds` , [drift detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html) for your AWS CloudFormation stack’s configuration might yield inaccurate results. If drift detection is important in your scenario, we recommend that you don’t include `WaitForSuccessTimeoutSeconds` in your template.
        """
        return pulumi.get(self, "wait_for_success_timeout_seconds")

    @wait_for_success_timeout_seconds.setter
    def wait_for_success_timeout_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "wait_for_success_timeout_seconds", value)


@pulumi.type_token("aws-native:ssm:Association")
class Association(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apply_only_at_cron_interval: Optional[pulumi.Input[builtins.bool]] = None,
                 association_name: Optional[pulumi.Input[builtins.str]] = None,
                 automation_target_parameter_name: Optional[pulumi.Input[builtins.str]] = None,
                 calendar_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 compliance_severity: Optional[pulumi.Input['AssociationComplianceSeverity']] = None,
                 document_version: Optional[pulumi.Input[builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 max_concurrency: Optional[pulumi.Input[builtins.str]] = None,
                 max_errors: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 output_location: Optional[pulumi.Input[Union['AssociationInstanceAssociationOutputLocationArgs', 'AssociationInstanceAssociationOutputLocationArgsDict']]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]] = None,
                 schedule_expression: Optional[pulumi.Input[builtins.str]] = None,
                 schedule_offset: Optional[pulumi.Input[builtins.int]] = None,
                 sync_compliance: Optional[pulumi.Input['AssociationSyncCompliance']] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AssociationTargetArgs', 'AssociationTargetArgsDict']]]]] = None,
                 wait_for_success_timeout_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        The AWS::SSM::Association resource associates an SSM document in AWS Systems Manager with EC2 instances that contain a configuration agent to process the document.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        specific_instance_id_association = aws_native.ssm.Association("specificInstanceIdAssociation",
            name="AWS-RunShellScript",
            targets=[{
                "key": "InstanceIds",
                "values": ["i-1234567890abcdef0"],
            }],
            parameters={
                "commands": ["ls"],
                "workingDirectory": ["/"],
            })

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        specific_instance_id_association = aws_native.ssm.Association("specificInstanceIdAssociation",
            name="AWS-RunShellScript",
            targets=[{
                "key": "InstanceIds",
                "values": ["i-1234567890abcdef0"],
            }],
            parameters={
                "commands": ["ls"],
                "workingDirectory": ["/"],
            })

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        all_instance_ids_association = aws_native.ssm.Association("allInstanceIdsAssociation",
            association_name="UpdateSSMAgent",
            name="AWS-UpdateSSMAgent",
            schedule_expression="cron(0 2 ? * SUN *)",
            targets=[{
                "key": "InstanceIds",
                "values": ["*"],
            }])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        all_instance_ids_association = aws_native.ssm.Association("allInstanceIdsAssociation",
            association_name="UpdateSSMAgent",
            name="AWS-UpdateSSMAgent",
            schedule_expression="cron(0 2 ? * SUN *)",
            targets=[{
                "key": "InstanceIds",
                "values": ["*"],
            }])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        tagged_instances_association = aws_native.ssm.Association("taggedInstancesAssociation",
            association_name="UpdateSSMAgent",
            name="AWS-UpdateSSMAgent",
            schedule_expression="rate(7 days)",
            targets=[{
                "key": "tag:Environment",
                "values": ["Production"],
            }])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        tagged_instances_association = aws_native.ssm.Association("taggedInstancesAssociation",
            association_name="UpdateSSMAgent",
            name="AWS-UpdateSSMAgent",
            schedule_expression="rate(7 days)",
            targets=[{
                "key": "tag:Environment",
                "values": ["Production"],
            }])

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] apply_only_at_cron_interval: By default, when you create a new association, the system runs it immediately after it is created and then according to the schedule you specified. Specify this option if you don't want an association to run immediately after you create it. This parameter is not supported for rate expressions.
        :param pulumi.Input[builtins.str] association_name: The name of the association.
        :param pulumi.Input[builtins.str] automation_target_parameter_name: Choose the parameter that will define how your automation will branch out. This target is required for associations that use an Automation runbook and target resources by using rate controls. Automation is a tool in AWS Systems Manager .
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] calendar_names: The names or Amazon Resource Names (ARNs) of the Change Calendar type documents your associations are gated under. The associations only run when that Change Calendar is open. For more information, see [AWS Systems Manager Change Calendar](https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar) in the *AWS Systems Manager User Guide* .
        :param pulumi.Input['AssociationComplianceSeverity'] compliance_severity: The severity level that is assigned to the association.
        :param pulumi.Input[builtins.str] document_version: The version of the SSM document to associate with the target.
        :param pulumi.Input[builtins.str] instance_id: The ID of the instance that the SSM document is associated with.
        :param pulumi.Input[builtins.str] max_concurrency: The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%. The default value is 100%, which means all targets run the association at the same time.
               
               If a new managed node starts and attempts to run an association while Systems Manager is running `MaxConcurrency` associations, the association is allowed to run. During the next association interval, the new managed node will process its association within the limit specified for `MaxConcurrency` .
        :param pulumi.Input[builtins.str] max_errors: The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify either an absolute number of errors, for example 10, or a percentage of the target set, for example 10%. If you specify 3, for example, the system stops sending requests when the fourth error is received. If you specify 0, then the system stops sending requests after the first error is returned. If you run an association on 50 managed nodes and set `MaxError` to 10%, then the system stops sending the request when the sixth error is received.
               
               Executions that are already running an association when `MaxErrors` is reached are allowed to complete, but some of these executions may fail as well. If you need to ensure that there won't be more than max-errors failed executions, set `MaxConcurrency` to 1 so that executions proceed one at a time.
        :param pulumi.Input[builtins.str] name: The name of the SSM document.
        :param pulumi.Input[Union['AssociationInstanceAssociationOutputLocationArgs', 'AssociationInstanceAssociationOutputLocationArgsDict']] output_location: An Amazon Simple Storage Service (Amazon S3) bucket where you want to store the output details of the request.
        :param pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]] parameters: Parameter values that the SSM document uses at runtime.
        :param pulumi.Input[builtins.str] schedule_expression: A Cron or Rate expression that specifies when the association is applied to the target.
        :param pulumi.Input[builtins.int] schedule_offset: Number of days to wait after the scheduled day to run an association.
        :param pulumi.Input['AssociationSyncCompliance'] sync_compliance: The mode for generating association compliance. You can specify `AUTO` or `MANUAL` . In `AUTO` mode, the system uses the status of the association execution to determine the compliance status. If the association execution runs successfully, then the association is `COMPLIANT` . If the association execution doesn't run successfully, the association is `NON-COMPLIANT` .
               
               In `MANUAL` mode, you must specify the `AssociationId` as a parameter for the `PutComplianceItems` API action. In this case, compliance data is not managed by State Manager. It is managed by your direct call to the `PutComplianceItems` API action.
               
               By default, all associations use `AUTO` mode.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AssociationTargetArgs', 'AssociationTargetArgsDict']]]] targets: The targets that the SSM document sends commands to.
        :param pulumi.Input[builtins.int] wait_for_success_timeout_seconds: The number of seconds the service should wait for the association status to show "Success" before proceeding with the stack execution. If the association status doesn't show "Success" after the specified number of seconds, then stack creation fails.
               
               > When you specify a value for the `WaitForSuccessTimeoutSeconds` , [drift detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html) for your AWS CloudFormation stack’s configuration might yield inaccurate results. If drift detection is important in your scenario, we recommend that you don’t include `WaitForSuccessTimeoutSeconds` in your template.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AssociationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The AWS::SSM::Association resource associates an SSM document in AWS Systems Manager with EC2 instances that contain a configuration agent to process the document.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        specific_instance_id_association = aws_native.ssm.Association("specificInstanceIdAssociation",
            name="AWS-RunShellScript",
            targets=[{
                "key": "InstanceIds",
                "values": ["i-1234567890abcdef0"],
            }],
            parameters={
                "commands": ["ls"],
                "workingDirectory": ["/"],
            })

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        specific_instance_id_association = aws_native.ssm.Association("specificInstanceIdAssociation",
            name="AWS-RunShellScript",
            targets=[{
                "key": "InstanceIds",
                "values": ["i-1234567890abcdef0"],
            }],
            parameters={
                "commands": ["ls"],
                "workingDirectory": ["/"],
            })

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        all_instance_ids_association = aws_native.ssm.Association("allInstanceIdsAssociation",
            association_name="UpdateSSMAgent",
            name="AWS-UpdateSSMAgent",
            schedule_expression="cron(0 2 ? * SUN *)",
            targets=[{
                "key": "InstanceIds",
                "values": ["*"],
            }])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        all_instance_ids_association = aws_native.ssm.Association("allInstanceIdsAssociation",
            association_name="UpdateSSMAgent",
            name="AWS-UpdateSSMAgent",
            schedule_expression="cron(0 2 ? * SUN *)",
            targets=[{
                "key": "InstanceIds",
                "values": ["*"],
            }])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        tagged_instances_association = aws_native.ssm.Association("taggedInstancesAssociation",
            association_name="UpdateSSMAgent",
            name="AWS-UpdateSSMAgent",
            schedule_expression="rate(7 days)",
            targets=[{
                "key": "tag:Environment",
                "values": ["Production"],
            }])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        tagged_instances_association = aws_native.ssm.Association("taggedInstancesAssociation",
            association_name="UpdateSSMAgent",
            name="AWS-UpdateSSMAgent",
            schedule_expression="rate(7 days)",
            targets=[{
                "key": "tag:Environment",
                "values": ["Production"],
            }])

        ```

        :param str resource_name: The name of the resource.
        :param AssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apply_only_at_cron_interval: Optional[pulumi.Input[builtins.bool]] = None,
                 association_name: Optional[pulumi.Input[builtins.str]] = None,
                 automation_target_parameter_name: Optional[pulumi.Input[builtins.str]] = None,
                 calendar_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 compliance_severity: Optional[pulumi.Input['AssociationComplianceSeverity']] = None,
                 document_version: Optional[pulumi.Input[builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 max_concurrency: Optional[pulumi.Input[builtins.str]] = None,
                 max_errors: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 output_location: Optional[pulumi.Input[Union['AssociationInstanceAssociationOutputLocationArgs', 'AssociationInstanceAssociationOutputLocationArgsDict']]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]]] = None,
                 schedule_expression: Optional[pulumi.Input[builtins.str]] = None,
                 schedule_offset: Optional[pulumi.Input[builtins.int]] = None,
                 sync_compliance: Optional[pulumi.Input['AssociationSyncCompliance']] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AssociationTargetArgs', 'AssociationTargetArgsDict']]]]] = None,
                 wait_for_success_timeout_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AssociationArgs.__new__(AssociationArgs)

            __props__.__dict__["apply_only_at_cron_interval"] = apply_only_at_cron_interval
            __props__.__dict__["association_name"] = association_name
            __props__.__dict__["automation_target_parameter_name"] = automation_target_parameter_name
            __props__.__dict__["calendar_names"] = calendar_names
            __props__.__dict__["compliance_severity"] = compliance_severity
            __props__.__dict__["document_version"] = document_version
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["max_concurrency"] = max_concurrency
            __props__.__dict__["max_errors"] = max_errors
            __props__.__dict__["name"] = name
            __props__.__dict__["output_location"] = output_location
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["schedule_expression"] = schedule_expression
            __props__.__dict__["schedule_offset"] = schedule_offset
            __props__.__dict__["sync_compliance"] = sync_compliance
            __props__.__dict__["targets"] = targets
            __props__.__dict__["wait_for_success_timeout_seconds"] = wait_for_success_timeout_seconds
            __props__.__dict__["association_id"] = None
        super(Association, __self__).__init__(
            'aws-native:ssm:Association',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Association':
        """
        Get an existing Association resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = AssociationArgs.__new__(AssociationArgs)

        __props__.__dict__["apply_only_at_cron_interval"] = None
        __props__.__dict__["association_id"] = None
        __props__.__dict__["association_name"] = None
        __props__.__dict__["automation_target_parameter_name"] = None
        __props__.__dict__["calendar_names"] = None
        __props__.__dict__["compliance_severity"] = None
        __props__.__dict__["document_version"] = None
        __props__.__dict__["instance_id"] = None
        __props__.__dict__["max_concurrency"] = None
        __props__.__dict__["max_errors"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["output_location"] = None
        __props__.__dict__["parameters"] = None
        __props__.__dict__["schedule_expression"] = None
        __props__.__dict__["schedule_offset"] = None
        __props__.__dict__["sync_compliance"] = None
        __props__.__dict__["targets"] = None
        __props__.__dict__["wait_for_success_timeout_seconds"] = None
        return Association(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applyOnlyAtCronInterval")
    def apply_only_at_cron_interval(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        By default, when you create a new association, the system runs it immediately after it is created and then according to the schedule you specified. Specify this option if you don't want an association to run immediately after you create it. This parameter is not supported for rate expressions.
        """
        return pulumi.get(self, "apply_only_at_cron_interval")

    @property
    @pulumi.getter(name="associationId")
    def association_id(self) -> pulumi.Output[builtins.str]:
        """
        Unique identifier of the association.
        """
        return pulumi.get(self, "association_id")

    @property
    @pulumi.getter(name="associationName")
    def association_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the association.
        """
        return pulumi.get(self, "association_name")

    @property
    @pulumi.getter(name="automationTargetParameterName")
    def automation_target_parameter_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Choose the parameter that will define how your automation will branch out. This target is required for associations that use an Automation runbook and target resources by using rate controls. Automation is a tool in AWS Systems Manager .
        """
        return pulumi.get(self, "automation_target_parameter_name")

    @property
    @pulumi.getter(name="calendarNames")
    def calendar_names(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        The names or Amazon Resource Names (ARNs) of the Change Calendar type documents your associations are gated under. The associations only run when that Change Calendar is open. For more information, see [AWS Systems Manager Change Calendar](https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar) in the *AWS Systems Manager User Guide* .
        """
        return pulumi.get(self, "calendar_names")

    @property
    @pulumi.getter(name="complianceSeverity")
    def compliance_severity(self) -> pulumi.Output[Optional['AssociationComplianceSeverity']]:
        """
        The severity level that is assigned to the association.
        """
        return pulumi.get(self, "compliance_severity")

    @property
    @pulumi.getter(name="documentVersion")
    def document_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The version of the SSM document to associate with the target.
        """
        return pulumi.get(self, "document_version")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the instance that the SSM document is associated with.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="maxConcurrency")
    def max_concurrency(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The maximum number of targets allowed to run the association at the same time. You can specify a number, for example 10, or a percentage of the target set, for example 10%. The default value is 100%, which means all targets run the association at the same time.

        If a new managed node starts and attempts to run an association while Systems Manager is running `MaxConcurrency` associations, the association is allowed to run. During the next association interval, the new managed node will process its association within the limit specified for `MaxConcurrency` .
        """
        return pulumi.get(self, "max_concurrency")

    @property
    @pulumi.getter(name="maxErrors")
    def max_errors(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The number of errors that are allowed before the system stops sending requests to run the association on additional targets. You can specify either an absolute number of errors, for example 10, or a percentage of the target set, for example 10%. If you specify 3, for example, the system stops sending requests when the fourth error is received. If you specify 0, then the system stops sending requests after the first error is returned. If you run an association on 50 managed nodes and set `MaxError` to 10%, then the system stops sending the request when the sixth error is received.

        Executions that are already running an association when `MaxErrors` is reached are allowed to complete, but some of these executions may fail as well. If you need to ensure that there won't be more than max-errors failed executions, set `MaxConcurrency` to 1 so that executions proceed one at a time.
        """
        return pulumi.get(self, "max_errors")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the SSM document.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outputLocation")
    def output_location(self) -> pulumi.Output[Optional['outputs.AssociationInstanceAssociationOutputLocation']]:
        """
        An Amazon Simple Storage Service (Amazon S3) bucket where you want to store the output details of the request.
        """
        return pulumi.get(self, "output_location")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Mapping[str, Sequence[builtins.str]]]]:
        """
        Parameter values that the SSM document uses at runtime.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A Cron or Rate expression that specifies when the association is applied to the target.
        """
        return pulumi.get(self, "schedule_expression")

    @property
    @pulumi.getter(name="scheduleOffset")
    def schedule_offset(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Number of days to wait after the scheduled day to run an association.
        """
        return pulumi.get(self, "schedule_offset")

    @property
    @pulumi.getter(name="syncCompliance")
    def sync_compliance(self) -> pulumi.Output[Optional['AssociationSyncCompliance']]:
        """
        The mode for generating association compliance. You can specify `AUTO` or `MANUAL` . In `AUTO` mode, the system uses the status of the association execution to determine the compliance status. If the association execution runs successfully, then the association is `COMPLIANT` . If the association execution doesn't run successfully, the association is `NON-COMPLIANT` .

        In `MANUAL` mode, you must specify the `AssociationId` as a parameter for the `PutComplianceItems` API action. In this case, compliance data is not managed by State Manager. It is managed by your direct call to the `PutComplianceItems` API action.

        By default, all associations use `AUTO` mode.
        """
        return pulumi.get(self, "sync_compliance")

    @property
    @pulumi.getter
    def targets(self) -> pulumi.Output[Optional[Sequence['outputs.AssociationTarget']]]:
        """
        The targets that the SSM document sends commands to.
        """
        return pulumi.get(self, "targets")

    @property
    @pulumi.getter(name="waitForSuccessTimeoutSeconds")
    def wait_for_success_timeout_seconds(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The number of seconds the service should wait for the association status to show "Success" before proceeding with the stack execution. If the association status doesn't show "Success" after the specified number of seconds, then stack creation fails.

        > When you specify a value for the `WaitForSuccessTimeoutSeconds` , [drift detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html) for your AWS CloudFormation stack’s configuration might yield inaccurate results. If drift detection is important in your scenario, we recommend that you don’t include `WaitForSuccessTimeoutSeconds` in your template.
        """
        return pulumi.get(self, "wait_for_success_timeout_seconds")

