# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'AssociationInstanceAssociationOutputLocationArgs',
    'AssociationInstanceAssociationOutputLocationArgsDict',
    'AssociationS3OutputLocationArgs',
    'AssociationS3OutputLocationArgsDict',
    'AssociationTargetArgs',
    'AssociationTargetArgsDict',
    'DocumentAttachmentsSourceArgs',
    'DocumentAttachmentsSourceArgsDict',
    'DocumentRequiresArgs',
    'DocumentRequiresArgsDict',
    'PatchBaselinePatchFilterGroupArgs',
    'PatchBaselinePatchFilterGroupArgsDict',
    'PatchBaselinePatchFilterArgs',
    'PatchBaselinePatchFilterArgsDict',
    'PatchBaselinePatchSourceArgs',
    'PatchBaselinePatchSourceArgsDict',
    'PatchBaselineRuleGroupArgs',
    'PatchBaselineRuleGroupArgsDict',
    'PatchBaselineRuleArgs',
    'PatchBaselineRuleArgsDict',
    'ResourceDataSyncAwsOrganizationsSourceArgs',
    'ResourceDataSyncAwsOrganizationsSourceArgsDict',
    'ResourceDataSyncS3DestinationArgs',
    'ResourceDataSyncS3DestinationArgsDict',
    'ResourceDataSyncSyncSourceArgs',
    'ResourceDataSyncSyncSourceArgsDict',
]

MYPY = False

if not MYPY:
    class AssociationInstanceAssociationOutputLocationArgsDict(TypedDict):
        s3_location: NotRequired[pulumi.Input['AssociationS3OutputLocationArgsDict']]
        """
        `S3OutputLocation` is a property of the [InstanceAssociationOutputLocation](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-instanceassociationoutputlocation.html) property that specifies an Amazon S3 bucket where you want to store the results of this request.
        """
elif False:
    AssociationInstanceAssociationOutputLocationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AssociationInstanceAssociationOutputLocationArgs:
    def __init__(__self__, *,
                 s3_location: Optional[pulumi.Input['AssociationS3OutputLocationArgs']] = None):
        """
        :param pulumi.Input['AssociationS3OutputLocationArgs'] s3_location: `S3OutputLocation` is a property of the [InstanceAssociationOutputLocation](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-instanceassociationoutputlocation.html) property that specifies an Amazon S3 bucket where you want to store the results of this request.
        """
        if s3_location is not None:
            pulumi.set(__self__, "s3_location", s3_location)

    @property
    @pulumi.getter(name="s3Location")
    def s3_location(self) -> Optional[pulumi.Input['AssociationS3OutputLocationArgs']]:
        """
        `S3OutputLocation` is a property of the [InstanceAssociationOutputLocation](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ssm-association-instanceassociationoutputlocation.html) property that specifies an Amazon S3 bucket where you want to store the results of this request.
        """
        return pulumi.get(self, "s3_location")

    @s3_location.setter
    def s3_location(self, value: Optional[pulumi.Input['AssociationS3OutputLocationArgs']]):
        pulumi.set(self, "s3_location", value)


if not MYPY:
    class AssociationS3OutputLocationArgsDict(TypedDict):
        output_s3_bucket_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the S3 bucket.
        """
        output_s3_key_prefix: NotRequired[pulumi.Input[builtins.str]]
        """
        The S3 bucket subfolder.
        """
        output_s3_region: NotRequired[pulumi.Input[builtins.str]]
        """
        The AWS Region of the S3 bucket.
        """
elif False:
    AssociationS3OutputLocationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AssociationS3OutputLocationArgs:
    def __init__(__self__, *,
                 output_s3_bucket_name: Optional[pulumi.Input[builtins.str]] = None,
                 output_s3_key_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 output_s3_region: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] output_s3_bucket_name: The name of the S3 bucket.
        :param pulumi.Input[builtins.str] output_s3_key_prefix: The S3 bucket subfolder.
        :param pulumi.Input[builtins.str] output_s3_region: The AWS Region of the S3 bucket.
        """
        if output_s3_bucket_name is not None:
            pulumi.set(__self__, "output_s3_bucket_name", output_s3_bucket_name)
        if output_s3_key_prefix is not None:
            pulumi.set(__self__, "output_s3_key_prefix", output_s3_key_prefix)
        if output_s3_region is not None:
            pulumi.set(__self__, "output_s3_region", output_s3_region)

    @property
    @pulumi.getter(name="outputS3BucketName")
    def output_s3_bucket_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the S3 bucket.
        """
        return pulumi.get(self, "output_s3_bucket_name")

    @output_s3_bucket_name.setter
    def output_s3_bucket_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "output_s3_bucket_name", value)

    @property
    @pulumi.getter(name="outputS3KeyPrefix")
    def output_s3_key_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The S3 bucket subfolder.
        """
        return pulumi.get(self, "output_s3_key_prefix")

    @output_s3_key_prefix.setter
    def output_s3_key_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "output_s3_key_prefix", value)

    @property
    @pulumi.getter(name="outputS3Region")
    def output_s3_region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS Region of the S3 bucket.
        """
        return pulumi.get(self, "output_s3_region")

    @output_s3_region.setter
    def output_s3_region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "output_s3_region", value)


if not MYPY:
    class AssociationTargetArgsDict(TypedDict):
        key: pulumi.Input[builtins.str]
        """
        User-defined criteria for sending commands that target managed nodes that meet the criteria.
        """
        values: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        User-defined criteria that maps to `Key` . For example, if you specified `tag:ServerRole` , you could specify `value:WebServer` to run a command on instances that include EC2 tags of `ServerRole,WebServer` .

        Depending on the type of target, the maximum number of values for a key might be lower than the global maximum of 50.
        """
elif False:
    AssociationTargetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AssociationTargetArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[builtins.str],
                 values: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        """
        :param pulumi.Input[builtins.str] key: User-defined criteria for sending commands that target managed nodes that meet the criteria.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] values: User-defined criteria that maps to `Key` . For example, if you specified `tag:ServerRole` , you could specify `value:WebServer` to run a command on instances that include EC2 tags of `ServerRole,WebServer` .
               
               Depending on the type of target, the maximum number of values for a key might be lower than the global maximum of 50.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[builtins.str]:
        """
        User-defined criteria for sending commands that target managed nodes that meet the criteria.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def values(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        User-defined criteria that maps to `Key` . For example, if you specified `tag:ServerRole` , you could specify `value:WebServer` to run a command on instances that include EC2 tags of `ServerRole,WebServer` .

        Depending on the type of target, the maximum number of values for a key might be lower than the global maximum of 50.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "values", value)


if not MYPY:
    class DocumentAttachmentsSourceArgsDict(TypedDict):
        key: NotRequired[pulumi.Input['DocumentAttachmentsSourceKey']]
        """
        The key of a key-value pair that identifies the location of an attachment to a document.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the document attachment file.
        """
        values: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The value of a key-value pair that identifies the location of an attachment to a document. The format for Value depends on the type of key you specify.
        """
elif False:
    DocumentAttachmentsSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DocumentAttachmentsSourceArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input['DocumentAttachmentsSourceKey']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input['DocumentAttachmentsSourceKey'] key: The key of a key-value pair that identifies the location of an attachment to a document.
        :param pulumi.Input[builtins.str] name: The name of the document attachment file.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] values: The value of a key-value pair that identifies the location of an attachment to a document. The format for Value depends on the type of key you specify.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input['DocumentAttachmentsSourceKey']]:
        """
        The key of a key-value pair that identifies the location of an attachment to a document.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input['DocumentAttachmentsSourceKey']]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the document attachment file.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The value of a key-value pair that identifies the location of an attachment to a document. The format for Value depends on the type of key you specify.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "values", value)


if not MYPY:
    class DocumentRequiresArgsDict(TypedDict):
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the required SSM document. The name can be an Amazon Resource Name (ARN).
        """
        version: NotRequired[pulumi.Input[builtins.str]]
        """
        The document version required by the current document.
        """
elif False:
    DocumentRequiresArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DocumentRequiresArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] name: The name of the required SSM document. The name can be an Amazon Resource Name (ARN).
        :param pulumi.Input[builtins.str] version: The document version required by the current document.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the required SSM document. The name can be an Amazon Resource Name (ARN).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The document version required by the current document.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


if not MYPY:
    class PatchBaselinePatchFilterGroupArgsDict(TypedDict):
        """
        The patch filter group that defines the criteria for the rule.
        """
        patch_filters: NotRequired[pulumi.Input[Sequence[pulumi.Input['PatchBaselinePatchFilterArgsDict']]]]
        """
        The set of patch filters that make up the group.
        """
elif False:
    PatchBaselinePatchFilterGroupArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PatchBaselinePatchFilterGroupArgs:
    def __init__(__self__, *,
                 patch_filters: Optional[pulumi.Input[Sequence[pulumi.Input['PatchBaselinePatchFilterArgs']]]] = None):
        """
        The patch filter group that defines the criteria for the rule.
        :param pulumi.Input[Sequence[pulumi.Input['PatchBaselinePatchFilterArgs']]] patch_filters: The set of patch filters that make up the group.
        """
        if patch_filters is not None:
            pulumi.set(__self__, "patch_filters", patch_filters)

    @property
    @pulumi.getter(name="patchFilters")
    def patch_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PatchBaselinePatchFilterArgs']]]]:
        """
        The set of patch filters that make up the group.
        """
        return pulumi.get(self, "patch_filters")

    @patch_filters.setter
    def patch_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PatchBaselinePatchFilterArgs']]]]):
        pulumi.set(self, "patch_filters", value)


if not MYPY:
    class PatchBaselinePatchFilterArgsDict(TypedDict):
        """
        Defines which patches should be included in a patch baseline.
        """
        key: NotRequired[pulumi.Input['PatchBaselinePatchFilterKey']]
        """
        The key for the filter.

        For information about valid keys, see [PatchFilter](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html) in the *AWS Systems Manager API Reference* .
        """
        values: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The value for the filter key.

        For information about valid values for each key based on operating system type, see [PatchFilter](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html) in the *AWS Systems Manager API Reference* .
        """
elif False:
    PatchBaselinePatchFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PatchBaselinePatchFilterArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input['PatchBaselinePatchFilterKey']] = None,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Defines which patches should be included in a patch baseline.
        :param pulumi.Input['PatchBaselinePatchFilterKey'] key: The key for the filter.
               
               For information about valid keys, see [PatchFilter](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html) in the *AWS Systems Manager API Reference* .
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] values: The value for the filter key.
               
               For information about valid values for each key based on operating system type, see [PatchFilter](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html) in the *AWS Systems Manager API Reference* .
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input['PatchBaselinePatchFilterKey']]:
        """
        The key for the filter.

        For information about valid keys, see [PatchFilter](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html) in the *AWS Systems Manager API Reference* .
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input['PatchBaselinePatchFilterKey']]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The value for the filter key.

        For information about valid values for each key based on operating system type, see [PatchFilter](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html) in the *AWS Systems Manager API Reference* .
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "values", value)


if not MYPY:
    class PatchBaselinePatchSourceArgsDict(TypedDict):
        """
        Information about the patches to use to update the instances, including target operating systems and source repository. Applies to Linux instances only.
        """
        configuration: NotRequired[pulumi.Input[builtins.str]]
        """
        The value of the yum repo configuration. For example:

        `[main]`

        `name=MyCustomRepository`

        `baseurl=https://my-custom-repository`

        `enabled=1`

        > For information about other options available for your yum repository configuration, see [dnf.conf(5)](https://docs.aws.amazon.com/https://man7.org/linux/man-pages/man5/dnf.conf.5.html) .
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name specified to identify the patch source.
        """
        products: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The specific operating system versions a patch repository applies to, such as "Ubuntu16.04", "RedhatEnterpriseLinux7.2" or "Suse12.7". For lists of supported product values, see [PatchFilter](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html) in the *AWS Systems Manager API Reference* .
        """
elif False:
    PatchBaselinePatchSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PatchBaselinePatchSourceArgs:
    def __init__(__self__, *,
                 configuration: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 products: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Information about the patches to use to update the instances, including target operating systems and source repository. Applies to Linux instances only.
        :param pulumi.Input[builtins.str] configuration: The value of the yum repo configuration. For example:
               
               `[main]`
               
               `name=MyCustomRepository`
               
               `baseurl=https://my-custom-repository`
               
               `enabled=1`
               
               > For information about other options available for your yum repository configuration, see [dnf.conf(5)](https://docs.aws.amazon.com/https://man7.org/linux/man-pages/man5/dnf.conf.5.html) .
        :param pulumi.Input[builtins.str] name: The name specified to identify the patch source.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] products: The specific operating system versions a patch repository applies to, such as "Ubuntu16.04", "RedhatEnterpriseLinux7.2" or "Suse12.7". For lists of supported product values, see [PatchFilter](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html) in the *AWS Systems Manager API Reference* .
        """
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if products is not None:
            pulumi.set(__self__, "products", products)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The value of the yum repo configuration. For example:

        `[main]`

        `name=MyCustomRepository`

        `baseurl=https://my-custom-repository`

        `enabled=1`

        > For information about other options available for your yum repository configuration, see [dnf.conf(5)](https://docs.aws.amazon.com/https://man7.org/linux/man-pages/man5/dnf.conf.5.html) .
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name specified to identify the patch source.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def products(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The specific operating system versions a patch repository applies to, such as "Ubuntu16.04", "RedhatEnterpriseLinux7.2" or "Suse12.7". For lists of supported product values, see [PatchFilter](https://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html) in the *AWS Systems Manager API Reference* .
        """
        return pulumi.get(self, "products")

    @products.setter
    def products(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "products", value)


if not MYPY:
    class PatchBaselineRuleGroupArgsDict(TypedDict):
        """
        A set of rules defining the approval rules for a patch baseline.
        """
        patch_rules: NotRequired[pulumi.Input[Sequence[pulumi.Input['PatchBaselineRuleArgsDict']]]]
        """
        The rules that make up the rule group.
        """
elif False:
    PatchBaselineRuleGroupArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PatchBaselineRuleGroupArgs:
    def __init__(__self__, *,
                 patch_rules: Optional[pulumi.Input[Sequence[pulumi.Input['PatchBaselineRuleArgs']]]] = None):
        """
        A set of rules defining the approval rules for a patch baseline.
        :param pulumi.Input[Sequence[pulumi.Input['PatchBaselineRuleArgs']]] patch_rules: The rules that make up the rule group.
        """
        if patch_rules is not None:
            pulumi.set(__self__, "patch_rules", patch_rules)

    @property
    @pulumi.getter(name="patchRules")
    def patch_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PatchBaselineRuleArgs']]]]:
        """
        The rules that make up the rule group.
        """
        return pulumi.get(self, "patch_rules")

    @patch_rules.setter
    def patch_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PatchBaselineRuleArgs']]]]):
        pulumi.set(self, "patch_rules", value)


if not MYPY:
    class PatchBaselineRuleArgsDict(TypedDict):
        """
        Defines an approval rule for a patch baseline.
        """
        approve_after_days: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of days after the release date of each patch matched by the rule that the patch is marked as approved in the patch baseline. For example, a value of `7` means that patches are approved seven days after they are released.

        This parameter is marked as `Required: No` , but your request must include a value for either `ApproveAfterDays` or `ApproveUntilDate` .

        Not supported for Debian Server or Ubuntu Server.

        > Use caution when setting this value for Windows Server patch baselines. Because patch updates that are replaced by later updates are removed, setting too broad a value for this parameter can result in crucial patches not being installed. For more information, see the *Windows Server* tab in the topic [How security patches are selected](https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-selecting-patches.html) in the *AWS Systems Manager User Guide* .
        """
        approve_until_date: NotRequired[pulumi.Input[builtins.str]]
        """
        The cutoff date for auto approval of released patches. Any patches released on or before this date are installed automatically.

        Enter dates in the format `YYYY-MM-DD` . For example, `2024-12-31` .

        This parameter is marked as `Required: No` , but your request must include a value for either `ApproveUntilDate` or `ApproveAfterDays` .

        Not supported for Debian Server or Ubuntu Server.

        > Use caution when setting this value for Windows Server patch baselines. Because patch updates that are replaced by later updates are removed, setting too broad a value for this parameter can result in crucial patches not being installed. For more information, see the *Windows Server* tab in the topic [How security patches are selected](https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-selecting-patches.html) in the *AWS Systems Manager User Guide* .
        """
        compliance_level: NotRequired[pulumi.Input['PatchBaselineRuleComplianceLevel']]
        """
        A compliance severity level for all approved patches in a patch baseline. Valid compliance severity levels include the following: `UNSPECIFIED` , `CRITICAL` , `HIGH` , `MEDIUM` , `LOW` , and `INFORMATIONAL` .
        """
        enable_non_security: NotRequired[pulumi.Input[builtins.bool]]
        """
        For managed nodes identified by the approval rule filters, enables a patch baseline to apply non-security updates available in the specified repository. The default value is `false` . Applies to Linux managed nodes only.
        """
        patch_filter_group: NotRequired[pulumi.Input['PatchBaselinePatchFilterGroupArgsDict']]
        """
        The patch filter group that defines the criteria for the rule.
        """
elif False:
    PatchBaselineRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PatchBaselineRuleArgs:
    def __init__(__self__, *,
                 approve_after_days: Optional[pulumi.Input[builtins.int]] = None,
                 approve_until_date: Optional[pulumi.Input[builtins.str]] = None,
                 compliance_level: Optional[pulumi.Input['PatchBaselineRuleComplianceLevel']] = None,
                 enable_non_security: Optional[pulumi.Input[builtins.bool]] = None,
                 patch_filter_group: Optional[pulumi.Input['PatchBaselinePatchFilterGroupArgs']] = None):
        """
        Defines an approval rule for a patch baseline.
        :param pulumi.Input[builtins.int] approve_after_days: The number of days after the release date of each patch matched by the rule that the patch is marked as approved in the patch baseline. For example, a value of `7` means that patches are approved seven days after they are released.
               
               This parameter is marked as `Required: No` , but your request must include a value for either `ApproveAfterDays` or `ApproveUntilDate` .
               
               Not supported for Debian Server or Ubuntu Server.
               
               > Use caution when setting this value for Windows Server patch baselines. Because patch updates that are replaced by later updates are removed, setting too broad a value for this parameter can result in crucial patches not being installed. For more information, see the *Windows Server* tab in the topic [How security patches are selected](https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-selecting-patches.html) in the *AWS Systems Manager User Guide* .
        :param pulumi.Input[builtins.str] approve_until_date: The cutoff date for auto approval of released patches. Any patches released on or before this date are installed automatically.
               
               Enter dates in the format `YYYY-MM-DD` . For example, `2024-12-31` .
               
               This parameter is marked as `Required: No` , but your request must include a value for either `ApproveUntilDate` or `ApproveAfterDays` .
               
               Not supported for Debian Server or Ubuntu Server.
               
               > Use caution when setting this value for Windows Server patch baselines. Because patch updates that are replaced by later updates are removed, setting too broad a value for this parameter can result in crucial patches not being installed. For more information, see the *Windows Server* tab in the topic [How security patches are selected](https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-selecting-patches.html) in the *AWS Systems Manager User Guide* .
        :param pulumi.Input['PatchBaselineRuleComplianceLevel'] compliance_level: A compliance severity level for all approved patches in a patch baseline. Valid compliance severity levels include the following: `UNSPECIFIED` , `CRITICAL` , `HIGH` , `MEDIUM` , `LOW` , and `INFORMATIONAL` .
        :param pulumi.Input[builtins.bool] enable_non_security: For managed nodes identified by the approval rule filters, enables a patch baseline to apply non-security updates available in the specified repository. The default value is `false` . Applies to Linux managed nodes only.
        :param pulumi.Input['PatchBaselinePatchFilterGroupArgs'] patch_filter_group: The patch filter group that defines the criteria for the rule.
        """
        if approve_after_days is not None:
            pulumi.set(__self__, "approve_after_days", approve_after_days)
        if approve_until_date is not None:
            pulumi.set(__self__, "approve_until_date", approve_until_date)
        if compliance_level is not None:
            pulumi.set(__self__, "compliance_level", compliance_level)
        if enable_non_security is not None:
            pulumi.set(__self__, "enable_non_security", enable_non_security)
        if patch_filter_group is not None:
            pulumi.set(__self__, "patch_filter_group", patch_filter_group)

    @property
    @pulumi.getter(name="approveAfterDays")
    def approve_after_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of days after the release date of each patch matched by the rule that the patch is marked as approved in the patch baseline. For example, a value of `7` means that patches are approved seven days after they are released.

        This parameter is marked as `Required: No` , but your request must include a value for either `ApproveAfterDays` or `ApproveUntilDate` .

        Not supported for Debian Server or Ubuntu Server.

        > Use caution when setting this value for Windows Server patch baselines. Because patch updates that are replaced by later updates are removed, setting too broad a value for this parameter can result in crucial patches not being installed. For more information, see the *Windows Server* tab in the topic [How security patches are selected](https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-selecting-patches.html) in the *AWS Systems Manager User Guide* .
        """
        return pulumi.get(self, "approve_after_days")

    @approve_after_days.setter
    def approve_after_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "approve_after_days", value)

    @property
    @pulumi.getter(name="approveUntilDate")
    def approve_until_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The cutoff date for auto approval of released patches. Any patches released on or before this date are installed automatically.

        Enter dates in the format `YYYY-MM-DD` . For example, `2024-12-31` .

        This parameter is marked as `Required: No` , but your request must include a value for either `ApproveUntilDate` or `ApproveAfterDays` .

        Not supported for Debian Server or Ubuntu Server.

        > Use caution when setting this value for Windows Server patch baselines. Because patch updates that are replaced by later updates are removed, setting too broad a value for this parameter can result in crucial patches not being installed. For more information, see the *Windows Server* tab in the topic [How security patches are selected](https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-selecting-patches.html) in the *AWS Systems Manager User Guide* .
        """
        return pulumi.get(self, "approve_until_date")

    @approve_until_date.setter
    def approve_until_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "approve_until_date", value)

    @property
    @pulumi.getter(name="complianceLevel")
    def compliance_level(self) -> Optional[pulumi.Input['PatchBaselineRuleComplianceLevel']]:
        """
        A compliance severity level for all approved patches in a patch baseline. Valid compliance severity levels include the following: `UNSPECIFIED` , `CRITICAL` , `HIGH` , `MEDIUM` , `LOW` , and `INFORMATIONAL` .
        """
        return pulumi.get(self, "compliance_level")

    @compliance_level.setter
    def compliance_level(self, value: Optional[pulumi.Input['PatchBaselineRuleComplianceLevel']]):
        pulumi.set(self, "compliance_level", value)

    @property
    @pulumi.getter(name="enableNonSecurity")
    def enable_non_security(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        For managed nodes identified by the approval rule filters, enables a patch baseline to apply non-security updates available in the specified repository. The default value is `false` . Applies to Linux managed nodes only.
        """
        return pulumi.get(self, "enable_non_security")

    @enable_non_security.setter
    def enable_non_security(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_non_security", value)

    @property
    @pulumi.getter(name="patchFilterGroup")
    def patch_filter_group(self) -> Optional[pulumi.Input['PatchBaselinePatchFilterGroupArgs']]:
        """
        The patch filter group that defines the criteria for the rule.
        """
        return pulumi.get(self, "patch_filter_group")

    @patch_filter_group.setter
    def patch_filter_group(self, value: Optional[pulumi.Input['PatchBaselinePatchFilterGroupArgs']]):
        pulumi.set(self, "patch_filter_group", value)


if not MYPY:
    class ResourceDataSyncAwsOrganizationsSourceArgsDict(TypedDict):
        organization_source_type: pulumi.Input[builtins.str]
        """
        If an AWS organization is present, this is either `OrganizationalUnits` or `EntireOrganization` . For `OrganizationalUnits` , the data is aggregated from a set of organization units. For `EntireOrganization` , the data is aggregated from the entire AWS organization.
        """
        organizational_units: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The AWS Organizations organization units included in the sync.
        """
elif False:
    ResourceDataSyncAwsOrganizationsSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceDataSyncAwsOrganizationsSourceArgs:
    def __init__(__self__, *,
                 organization_source_type: pulumi.Input[builtins.str],
                 organizational_units: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] organization_source_type: If an AWS organization is present, this is either `OrganizationalUnits` or `EntireOrganization` . For `OrganizationalUnits` , the data is aggregated from a set of organization units. For `EntireOrganization` , the data is aggregated from the entire AWS organization.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] organizational_units: The AWS Organizations organization units included in the sync.
        """
        pulumi.set(__self__, "organization_source_type", organization_source_type)
        if organizational_units is not None:
            pulumi.set(__self__, "organizational_units", organizational_units)

    @property
    @pulumi.getter(name="organizationSourceType")
    def organization_source_type(self) -> pulumi.Input[builtins.str]:
        """
        If an AWS organization is present, this is either `OrganizationalUnits` or `EntireOrganization` . For `OrganizationalUnits` , the data is aggregated from a set of organization units. For `EntireOrganization` , the data is aggregated from the entire AWS organization.
        """
        return pulumi.get(self, "organization_source_type")

    @organization_source_type.setter
    def organization_source_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "organization_source_type", value)

    @property
    @pulumi.getter(name="organizationalUnits")
    def organizational_units(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The AWS Organizations organization units included in the sync.
        """
        return pulumi.get(self, "organizational_units")

    @organizational_units.setter
    def organizational_units(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "organizational_units", value)


if not MYPY:
    class ResourceDataSyncS3DestinationArgsDict(TypedDict):
        bucket_name: pulumi.Input[builtins.str]
        """
        The name of the S3 bucket where the aggregated data is stored.
        """
        bucket_region: pulumi.Input[builtins.str]
        """
        The AWS Region with the S3 bucket targeted by the resource data sync.
        """
        sync_format: pulumi.Input[builtins.str]
        """
        A supported sync format. The following format is currently supported: JsonSerDe
        """
        bucket_prefix: NotRequired[pulumi.Input[builtins.str]]
        """
        An Amazon S3 prefix for the bucket.
        """
        kms_key_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The ARN of an encryption key for a destination in Amazon S3. Must belong to the same Region as the destination S3 bucket.
        """
elif False:
    ResourceDataSyncS3DestinationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceDataSyncS3DestinationArgs:
    def __init__(__self__, *,
                 bucket_name: pulumi.Input[builtins.str],
                 bucket_region: pulumi.Input[builtins.str],
                 sync_format: pulumi.Input[builtins.str],
                 bucket_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] bucket_name: The name of the S3 bucket where the aggregated data is stored.
        :param pulumi.Input[builtins.str] bucket_region: The AWS Region with the S3 bucket targeted by the resource data sync.
        :param pulumi.Input[builtins.str] sync_format: A supported sync format. The following format is currently supported: JsonSerDe
        :param pulumi.Input[builtins.str] bucket_prefix: An Amazon S3 prefix for the bucket.
        :param pulumi.Input[builtins.str] kms_key_arn: The ARN of an encryption key for a destination in Amazon S3. Must belong to the same Region as the destination S3 bucket.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "bucket_region", bucket_region)
        pulumi.set(__self__, "sync_format", sync_format)
        if bucket_prefix is not None:
            pulumi.set(__self__, "bucket_prefix", bucket_prefix)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the S3 bucket where the aggregated data is stored.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter(name="bucketRegion")
    def bucket_region(self) -> pulumi.Input[builtins.str]:
        """
        The AWS Region with the S3 bucket targeted by the resource data sync.
        """
        return pulumi.get(self, "bucket_region")

    @bucket_region.setter
    def bucket_region(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket_region", value)

    @property
    @pulumi.getter(name="syncFormat")
    def sync_format(self) -> pulumi.Input[builtins.str]:
        """
        A supported sync format. The following format is currently supported: JsonSerDe
        """
        return pulumi.get(self, "sync_format")

    @sync_format.setter
    def sync_format(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "sync_format", value)

    @property
    @pulumi.getter(name="bucketPrefix")
    def bucket_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An Amazon S3 prefix for the bucket.
        """
        return pulumi.get(self, "bucket_prefix")

    @bucket_prefix.setter
    def bucket_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bucket_prefix", value)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of an encryption key for a destination in Amazon S3. Must belong to the same Region as the destination S3 bucket.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_arn", value)


if not MYPY:
    class ResourceDataSyncSyncSourceArgsDict(TypedDict):
        source_regions: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]
        """
        The `SyncSource` AWS Regions included in the resource data sync.
        """
        source_type: pulumi.Input[builtins.str]
        """
        The type of data source for the resource data sync. `SourceType` is either `AwsOrganizations` (if an organization is present in AWS Organizations ) or `SingleAccountMultiRegions` .
        """
        aws_organizations_source: NotRequired[pulumi.Input['ResourceDataSyncAwsOrganizationsSourceArgsDict']]
        """
        Information about the AwsOrganizationsSource resource data sync source. A sync source of this type can synchronize data from AWS Organizations .
        """
        include_future_regions: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether to automatically synchronize and aggregate data from new AWS Regions when those Regions come online.
        """
elif False:
    ResourceDataSyncSyncSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ResourceDataSyncSyncSourceArgs:
    def __init__(__self__, *,
                 source_regions: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 source_type: pulumi.Input[builtins.str],
                 aws_organizations_source: Optional[pulumi.Input['ResourceDataSyncAwsOrganizationsSourceArgs']] = None,
                 include_future_regions: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] source_regions: The `SyncSource` AWS Regions included in the resource data sync.
        :param pulumi.Input[builtins.str] source_type: The type of data source for the resource data sync. `SourceType` is either `AwsOrganizations` (if an organization is present in AWS Organizations ) or `SingleAccountMultiRegions` .
        :param pulumi.Input['ResourceDataSyncAwsOrganizationsSourceArgs'] aws_organizations_source: Information about the AwsOrganizationsSource resource data sync source. A sync source of this type can synchronize data from AWS Organizations .
        :param pulumi.Input[builtins.bool] include_future_regions: Whether to automatically synchronize and aggregate data from new AWS Regions when those Regions come online.
        """
        pulumi.set(__self__, "source_regions", source_regions)
        pulumi.set(__self__, "source_type", source_type)
        if aws_organizations_source is not None:
            pulumi.set(__self__, "aws_organizations_source", aws_organizations_source)
        if include_future_regions is not None:
            pulumi.set(__self__, "include_future_regions", include_future_regions)

    @property
    @pulumi.getter(name="sourceRegions")
    def source_regions(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        The `SyncSource` AWS Regions included in the resource data sync.
        """
        return pulumi.get(self, "source_regions")

    @source_regions.setter
    def source_regions(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "source_regions", value)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of data source for the resource data sync. `SourceType` is either `AwsOrganizations` (if an organization is present in AWS Organizations ) or `SingleAccountMultiRegions` .
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source_type", value)

    @property
    @pulumi.getter(name="awsOrganizationsSource")
    def aws_organizations_source(self) -> Optional[pulumi.Input['ResourceDataSyncAwsOrganizationsSourceArgs']]:
        """
        Information about the AwsOrganizationsSource resource data sync source. A sync source of this type can synchronize data from AWS Organizations .
        """
        return pulumi.get(self, "aws_organizations_source")

    @aws_organizations_source.setter
    def aws_organizations_source(self, value: Optional[pulumi.Input['ResourceDataSyncAwsOrganizationsSourceArgs']]):
        pulumi.set(self, "aws_organizations_source", value)

    @property
    @pulumi.getter(name="includeFutureRegions")
    def include_future_regions(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to automatically synchronize and aggregate data from new AWS Regions when those Regions come online.
        """
        return pulumi.get(self, "include_future_regions")

    @include_future_regions.setter
    def include_future_regions(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "include_future_regions", value)


