# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetQueueResult',
    'AwaitableGetQueueResult',
    'get_queue',
    'get_queue_output',
]

@pulumi.output_type
class GetQueueResult:
    def __init__(__self__, arn=None, content_based_deduplication=None, deduplication_scope=None, delay_seconds=None, fifo_throughput_limit=None, kms_data_key_reuse_period_seconds=None, kms_master_key_id=None, maximum_message_size=None, message_retention_period=None, queue_url=None, receive_message_wait_time_seconds=None, redrive_allow_policy=None, redrive_policy=None, sqs_managed_sse_enabled=None, tags=None, visibility_timeout=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if content_based_deduplication and not isinstance(content_based_deduplication, bool):
            raise TypeError("Expected argument 'content_based_deduplication' to be a bool")
        pulumi.set(__self__, "content_based_deduplication", content_based_deduplication)
        if deduplication_scope and not isinstance(deduplication_scope, str):
            raise TypeError("Expected argument 'deduplication_scope' to be a str")
        pulumi.set(__self__, "deduplication_scope", deduplication_scope)
        if delay_seconds and not isinstance(delay_seconds, int):
            raise TypeError("Expected argument 'delay_seconds' to be a int")
        pulumi.set(__self__, "delay_seconds", delay_seconds)
        if fifo_throughput_limit and not isinstance(fifo_throughput_limit, str):
            raise TypeError("Expected argument 'fifo_throughput_limit' to be a str")
        pulumi.set(__self__, "fifo_throughput_limit", fifo_throughput_limit)
        if kms_data_key_reuse_period_seconds and not isinstance(kms_data_key_reuse_period_seconds, int):
            raise TypeError("Expected argument 'kms_data_key_reuse_period_seconds' to be a int")
        pulumi.set(__self__, "kms_data_key_reuse_period_seconds", kms_data_key_reuse_period_seconds)
        if kms_master_key_id and not isinstance(kms_master_key_id, str):
            raise TypeError("Expected argument 'kms_master_key_id' to be a str")
        pulumi.set(__self__, "kms_master_key_id", kms_master_key_id)
        if maximum_message_size and not isinstance(maximum_message_size, int):
            raise TypeError("Expected argument 'maximum_message_size' to be a int")
        pulumi.set(__self__, "maximum_message_size", maximum_message_size)
        if message_retention_period and not isinstance(message_retention_period, int):
            raise TypeError("Expected argument 'message_retention_period' to be a int")
        pulumi.set(__self__, "message_retention_period", message_retention_period)
        if queue_url and not isinstance(queue_url, str):
            raise TypeError("Expected argument 'queue_url' to be a str")
        pulumi.set(__self__, "queue_url", queue_url)
        if receive_message_wait_time_seconds and not isinstance(receive_message_wait_time_seconds, int):
            raise TypeError("Expected argument 'receive_message_wait_time_seconds' to be a int")
        pulumi.set(__self__, "receive_message_wait_time_seconds", receive_message_wait_time_seconds)
        if redrive_allow_policy and not isinstance(redrive_allow_policy, dict):
            raise TypeError("Expected argument 'redrive_allow_policy' to be a dict")
        pulumi.set(__self__, "redrive_allow_policy", redrive_allow_policy)
        if redrive_policy and not isinstance(redrive_policy, dict):
            raise TypeError("Expected argument 'redrive_policy' to be a dict")
        pulumi.set(__self__, "redrive_policy", redrive_policy)
        if sqs_managed_sse_enabled and not isinstance(sqs_managed_sse_enabled, bool):
            raise TypeError("Expected argument 'sqs_managed_sse_enabled' to be a bool")
        pulumi.set(__self__, "sqs_managed_sse_enabled", sqs_managed_sse_enabled)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if visibility_timeout and not isinstance(visibility_timeout, int):
            raise TypeError("Expected argument 'visibility_timeout' to be a int")
        pulumi.set(__self__, "visibility_timeout", visibility_timeout)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        Returns the Amazon Resource Name (ARN) of the queue. For example: `arn:aws:sqs:us-east-2:123456789012:mystack-myqueue-15PG5C2FC1CW8` .
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="contentBasedDeduplication")
    def content_based_deduplication(self) -> Optional[builtins.bool]:
        """
        For first-in-first-out (FIFO) queues, specifies whether to enable content-based deduplication. During the deduplication interval, SQS treats messages that are sent with identical content as duplicates and delivers only one copy of the message. For more information, see the ``ContentBasedDeduplication`` attribute for the ``CreateQueue`` action in the *API Reference*.
        """
        return pulumi.get(self, "content_based_deduplication")

    @property
    @pulumi.getter(name="deduplicationScope")
    def deduplication_scope(self) -> Optional[builtins.str]:
        """
        For high throughput for FIFO queues, specifies whether message deduplication occurs at the message group or queue level. Valid values are ``messageGroup`` and ``queue``.
         To enable high throughput for a FIFO queue, set this attribute to ``messageGroup`` *and* set the ``FifoThroughputLimit`` attribute to ``perMessageGroupId``. If you set these attributes to anything other than these values, normal throughput is in effect and deduplication occurs as specified. For more information, see [High throughput for FIFO queues](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/high-throughput-fifo.html) and [Quotas related to messages](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-messages.html) in the *Developer Guide*.
        """
        return pulumi.get(self, "deduplication_scope")

    @property
    @pulumi.getter(name="delaySeconds")
    def delay_seconds(self) -> Optional[builtins.int]:
        """
        The time in seconds for which the delivery of all messages in the queue is delayed. You can specify an integer value of ``0`` to ``900`` (15 minutes). The default value is ``0``.
        """
        return pulumi.get(self, "delay_seconds")

    @property
    @pulumi.getter(name="fifoThroughputLimit")
    def fifo_throughput_limit(self) -> Optional[builtins.str]:
        """
        For high throughput for FIFO queues, specifies whether the FIFO queue throughput quota applies to the entire queue or per message group. Valid values are ``perQueue`` and ``perMessageGroupId``.
         To enable high throughput for a FIFO queue, set this attribute to ``perMessageGroupId`` *and* set the ``DeduplicationScope`` attribute to ``messageGroup``. If you set these attributes to anything other than these values, normal throughput is in effect and deduplication occurs as specified. For more information, see [High throughput for FIFO queues](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/high-throughput-fifo.html) and [Quotas related to messages](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/quotas-messages.html) in the *Developer Guide*.
        """
        return pulumi.get(self, "fifo_throughput_limit")

    @property
    @pulumi.getter(name="kmsDataKeyReusePeriodSeconds")
    def kms_data_key_reuse_period_seconds(self) -> Optional[builtins.int]:
        """
        The length of time in seconds for which SQS can reuse a data key to encrypt or decrypt messages before calling KMS again. The value must be an integer between 60 (1 minute) and 86,400 (24 hours). The default is 300 (5 minutes).
          A shorter time period provides better security, but results in more calls to KMS, which might incur charges after Free Tier. For more information, see [Encryption at rest](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-how-does-the-data-key-reuse-period-work) in the *Developer Guide*.
        """
        return pulumi.get(self, "kms_data_key_reuse_period_seconds")

    @property
    @pulumi.getter(name="kmsMasterKeyId")
    def kms_master_key_id(self) -> Optional[builtins.str]:
        """
        The ID of an AWS Key Management Service (KMS) for SQS, or a custom KMS. To use the AWS managed KMS for SQS, specify a (default) alias ARN, alias name (for example ``alias/aws/sqs``), key ARN, or key ID. For more information, see the following:
          +   [Encryption at rest](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html) in the *Developer Guide* 
          +   [CreateQueue](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_CreateQueue.html) in the *API Reference* 
          +   [Request Parameters](https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters) in the *Key Management Service API Reference* 
          +   The Key Management Service (KMS) section of the [Security best practices for Key Management Service](https://docs.aws.amazon.com/kms/latest/developerguide/best-practices.html) in the *Key Management Service Developer Guide*
        """
        return pulumi.get(self, "kms_master_key_id")

    @property
    @pulumi.getter(name="maximumMessageSize")
    def maximum_message_size(self) -> Optional[builtins.int]:
        """
        The limit of how many bytes that a message can contain before SQS rejects it. You can specify an integer value from ``1,024`` bytes (1 KiB) to ``262,144`` bytes (256 KiB). The default value is ``262,144`` (256 KiB).
        """
        return pulumi.get(self, "maximum_message_size")

    @property
    @pulumi.getter(name="messageRetentionPeriod")
    def message_retention_period(self) -> Optional[builtins.int]:
        """
        The number of seconds that SQS retains a message. You can specify an integer value from ``60`` seconds (1 minute) to ``1,209,600`` seconds (14 days). The default value is ``345,600`` seconds (4 days).
        """
        return pulumi.get(self, "message_retention_period")

    @property
    @pulumi.getter(name="queueUrl")
    def queue_url(self) -> Optional[builtins.str]:
        """
        Returns the URLs of the queues from the policy.
        """
        return pulumi.get(self, "queue_url")

    @property
    @pulumi.getter(name="receiveMessageWaitTimeSeconds")
    def receive_message_wait_time_seconds(self) -> Optional[builtins.int]:
        """
        Specifies the duration, in seconds, that the ReceiveMessage action call waits until a message is in the queue in order to include it in the response, rather than returning an empty response if a message isn't yet available. You can specify an integer from 1 to 20. Short polling is used as the default or when you specify 0 for this property. For more information, see [Consuming messages using long polling](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-short-and-long-polling.html#sqs-long-polling) in the *Developer Guide*.
        """
        return pulumi.get(self, "receive_message_wait_time_seconds")

    @property
    @pulumi.getter(name="redriveAllowPolicy")
    def redrive_allow_policy(self) -> Optional[Any]:
        """
        The string that includes the parameters for the permissions for the dead-letter queue redrive permission and which source queues can specify dead-letter queues as a JSON object. The parameters are as follows:
          +   ``redrivePermission``: The permission type that defines which source queues can specify the current queue as the dead-letter queue. Valid values are:
          +   ``allowAll``: (Default) Any source queues in this AWS account in the same Region can specify this queue as the dead-letter queue.
          +   ``denyAll``: No source queues can specify this queue as the dead-letter queue.
          +   ``byQueue``: Only queues specified by the ``sourceQueueArns`` parameter can specify this queue as the dead-letter queue.
          
          +   ``sourceQueueArns``: The Amazon Resource Names (ARN)s of the source queues that can specify this queue as the dead-letter queue and redrive messages. You can specify this parameter only when the ``redrivePermission`` parameter is set to ``byQueue``. You can specify up to 10 source queue ARNs. To allow more than 10 source queues to specify dead-letter queues, set the ``redrivePermission`` parameter to ``allowAll``.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SQS::Queue` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "redrive_allow_policy")

    @property
    @pulumi.getter(name="redrivePolicy")
    def redrive_policy(self) -> Optional[Any]:
        """
        The string that includes the parameters for the dead-letter queue functionality of the source queue as a JSON object. The parameters are as follows:
          +   ``deadLetterTargetArn``: The Amazon Resource Name (ARN) of the dead-letter queue to which SQS moves messages after the value of ``maxReceiveCount`` is exceeded.
          +   ``maxReceiveCount``: The number of times a message is received by a consumer of the source queue before being moved to the dead-letter queue. When the ``ReceiveCount`` for a message exceeds the ``maxReceiveCount`` for a queue, SQS moves the message to the dead-letter-queue.
          
          The dead-letter queue of a FIFO queue must also be a FIFO queue. Similarly, the dead-letter queue of a standard queue must also be a standard queue.
           *JSON* 
          ``{ "deadLetterTargetArn" : String, "maxReceiveCount" : Integer }`` 
          *YAML* 
          ``deadLetterTargetArn : String`` 
          ``maxReceiveCount : Integer``

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SQS::Queue` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "redrive_policy")

    @property
    @pulumi.getter(name="sqsManagedSseEnabled")
    def sqs_managed_sse_enabled(self) -> Optional[builtins.bool]:
        """
        Enables server-side queue encryption using SQS owned encryption keys. Only one server-side encryption option is supported per queue (for example, [SSE-KMS](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sse-existing-queue.html) or [SSE-SQS](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-configure-sqs-sse-queue.html)). When ``SqsManagedSseEnabled`` is not defined, ``SSE-SQS`` encryption is enabled by default.
        """
        return pulumi.get(self, "sqs_managed_sse_enabled")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The tags that you attach to this queue. For more information, see [Resource tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) in the *User Guide*.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="visibilityTimeout")
    def visibility_timeout(self) -> Optional[builtins.int]:
        """
        The length of time during which a message will be unavailable after a message is delivered from the queue. This blocks other components from receiving the same message and gives the initial component time to process and delete the message from the queue.
         Values must be from 0 to 43,200 seconds (12 hours). If you don't specify a value, AWS CloudFormation uses the default value of 30 seconds.
         For more information about SQS queue visibility timeouts, see [Visibility timeout](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html) in the *Developer Guide*.
        """
        return pulumi.get(self, "visibility_timeout")


class AwaitableGetQueueResult(GetQueueResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetQueueResult(
            arn=self.arn,
            content_based_deduplication=self.content_based_deduplication,
            deduplication_scope=self.deduplication_scope,
            delay_seconds=self.delay_seconds,
            fifo_throughput_limit=self.fifo_throughput_limit,
            kms_data_key_reuse_period_seconds=self.kms_data_key_reuse_period_seconds,
            kms_master_key_id=self.kms_master_key_id,
            maximum_message_size=self.maximum_message_size,
            message_retention_period=self.message_retention_period,
            queue_url=self.queue_url,
            receive_message_wait_time_seconds=self.receive_message_wait_time_seconds,
            redrive_allow_policy=self.redrive_allow_policy,
            redrive_policy=self.redrive_policy,
            sqs_managed_sse_enabled=self.sqs_managed_sse_enabled,
            tags=self.tags,
            visibility_timeout=self.visibility_timeout)


def get_queue(queue_url: Optional[builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetQueueResult:
    """
    The ``AWS::SQS::Queue`` resource creates an SQS standard or FIFO queue.
     Keep the following caveats in mind:
      +  If you don't specify the ``FifoQueue`` property, SQS creates a standard queue.
           You can't change the queue type after you create it and you can't convert an existing standard queue into a FIFO queue. You must either create a new FIFO queue for your application or delete your existing standard queue and recreate it as a FIFO queue. For more information, see [Moving from a standard queue to a FIFO queue](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-moving.html) in the *Developer Guide*.
       +  If you don't provide a value for a property, the queue is created with the default value for the property.
      +  If you delete a queue, you must wait at least 60 seconds before creating a queue with the same name.
      +  To successfully create a new queue, you must provide a queue name that adheres to the [limits related to queues](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/limits-queues.html) and is unique within the scope of your queues.

     For more information about creating FIFO (first-in-first-out) queues, see [Creating an queue ()](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/create-queue-cloudformation.html) in the *Developer Guide*.


    :param builtins.str queue_url: Returns the URLs of the queues from the policy.
    """
    __args__ = dict()
    __args__['queueUrl'] = queue_url
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:sqs:getQueue', __args__, opts=opts, typ=GetQueueResult).value

    return AwaitableGetQueueResult(
        arn=pulumi.get(__ret__, 'arn'),
        content_based_deduplication=pulumi.get(__ret__, 'content_based_deduplication'),
        deduplication_scope=pulumi.get(__ret__, 'deduplication_scope'),
        delay_seconds=pulumi.get(__ret__, 'delay_seconds'),
        fifo_throughput_limit=pulumi.get(__ret__, 'fifo_throughput_limit'),
        kms_data_key_reuse_period_seconds=pulumi.get(__ret__, 'kms_data_key_reuse_period_seconds'),
        kms_master_key_id=pulumi.get(__ret__, 'kms_master_key_id'),
        maximum_message_size=pulumi.get(__ret__, 'maximum_message_size'),
        message_retention_period=pulumi.get(__ret__, 'message_retention_period'),
        queue_url=pulumi.get(__ret__, 'queue_url'),
        receive_message_wait_time_seconds=pulumi.get(__ret__, 'receive_message_wait_time_seconds'),
        redrive_allow_policy=pulumi.get(__ret__, 'redrive_allow_policy'),
        redrive_policy=pulumi.get(__ret__, 'redrive_policy'),
        sqs_managed_sse_enabled=pulumi.get(__ret__, 'sqs_managed_sse_enabled'),
        tags=pulumi.get(__ret__, 'tags'),
        visibility_timeout=pulumi.get(__ret__, 'visibility_timeout'))
def get_queue_output(queue_url: Optional[pulumi.Input[builtins.str]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetQueueResult]:
    """
    The ``AWS::SQS::Queue`` resource creates an SQS standard or FIFO queue.
     Keep the following caveats in mind:
      +  If you don't specify the ``FifoQueue`` property, SQS creates a standard queue.
           You can't change the queue type after you create it and you can't convert an existing standard queue into a FIFO queue. You must either create a new FIFO queue for your application or delete your existing standard queue and recreate it as a FIFO queue. For more information, see [Moving from a standard queue to a FIFO queue](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues-moving.html) in the *Developer Guide*.
       +  If you don't provide a value for a property, the queue is created with the default value for the property.
      +  If you delete a queue, you must wait at least 60 seconds before creating a queue with the same name.
      +  To successfully create a new queue, you must provide a queue name that adheres to the [limits related to queues](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/limits-queues.html) and is unique within the scope of your queues.

     For more information about creating FIFO (first-in-first-out) queues, see [Creating an queue ()](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/create-queue-cloudformation.html) in the *Developer Guide*.


    :param builtins.str queue_url: Returns the URLs of the queues from the policy.
    """
    __args__ = dict()
    __args__['queueUrl'] = queue_url
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:sqs:getQueue', __args__, opts=opts, typ=GetQueueResult)
    return __ret__.apply(lambda __response__: GetQueueResult(
        arn=pulumi.get(__response__, 'arn'),
        content_based_deduplication=pulumi.get(__response__, 'content_based_deduplication'),
        deduplication_scope=pulumi.get(__response__, 'deduplication_scope'),
        delay_seconds=pulumi.get(__response__, 'delay_seconds'),
        fifo_throughput_limit=pulumi.get(__response__, 'fifo_throughput_limit'),
        kms_data_key_reuse_period_seconds=pulumi.get(__response__, 'kms_data_key_reuse_period_seconds'),
        kms_master_key_id=pulumi.get(__response__, 'kms_master_key_id'),
        maximum_message_size=pulumi.get(__response__, 'maximum_message_size'),
        message_retention_period=pulumi.get(__response__, 'message_retention_period'),
        queue_url=pulumi.get(__response__, 'queue_url'),
        receive_message_wait_time_seconds=pulumi.get(__response__, 'receive_message_wait_time_seconds'),
        redrive_allow_policy=pulumi.get(__response__, 'redrive_allow_policy'),
        redrive_policy=pulumi.get(__response__, 'redrive_policy'),
        sqs_managed_sse_enabled=pulumi.get(__response__, 'sqs_managed_sse_enabled'),
        tags=pulumi.get(__response__, 'tags'),
        visibility_timeout=pulumi.get(__response__, 'visibility_timeout')))
