# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['TopicInlinePolicyArgs', 'TopicInlinePolicy']

@pulumi.input_type
class TopicInlinePolicyArgs:
    def __init__(__self__, *,
                 policy_document: Any,
                 topic_arn: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a TopicInlinePolicy resource.
        :param Any policy_document: A policy document that contains permissions to add to the specified SNS topics.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SNS::TopicInlinePolicy` for more information about the expected schema for this property.
        :param pulumi.Input[builtins.str] topic_arn: The Amazon Resource Name (ARN) of the topic to which you want to add the policy.
        """
        pulumi.set(__self__, "policy_document", policy_document)
        pulumi.set(__self__, "topic_arn", topic_arn)

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> Any:
        """
        A policy document that contains permissions to add to the specified SNS topics.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SNS::TopicInlinePolicy` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "policy_document")

    @policy_document.setter
    def policy_document(self, value: Any):
        pulumi.set(self, "policy_document", value)

    @property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the topic to which you want to add the policy.
        """
        return pulumi.get(self, "topic_arn")

    @topic_arn.setter
    def topic_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "topic_arn", value)


@pulumi.type_token("aws-native:sns:TopicInlinePolicy")
class TopicInlinePolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 policy_document: Optional[Any] = None,
                 topic_arn: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Schema for AWS::SNS::TopicInlinePolicy

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param Any policy_document: A policy document that contains permissions to add to the specified SNS topics.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SNS::TopicInlinePolicy` for more information about the expected schema for this property.
        :param pulumi.Input[builtins.str] topic_arn: The Amazon Resource Name (ARN) of the topic to which you want to add the policy.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TopicInlinePolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Schema for AWS::SNS::TopicInlinePolicy

        :param str resource_name: The name of the resource.
        :param TopicInlinePolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TopicInlinePolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 policy_document: Optional[Any] = None,
                 topic_arn: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TopicInlinePolicyArgs.__new__(TopicInlinePolicyArgs)

            if policy_document is None and not opts.urn:
                raise TypeError("Missing required property 'policy_document'")
            __props__.__dict__["policy_document"] = policy_document
            if topic_arn is None and not opts.urn:
                raise TypeError("Missing required property 'topic_arn'")
            __props__.__dict__["topic_arn"] = topic_arn
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["topicArn"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(TopicInlinePolicy, __self__).__init__(
            'aws-native:sns:TopicInlinePolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'TopicInlinePolicy':
        """
        Get an existing TopicInlinePolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = TopicInlinePolicyArgs.__new__(TopicInlinePolicyArgs)

        __props__.__dict__["policy_document"] = None
        __props__.__dict__["topic_arn"] = None
        return TopicInlinePolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> pulumi.Output[Any]:
        """
        A policy document that contains permissions to add to the specified SNS topics.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SNS::TopicInlinePolicy` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "policy_document")

    @property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the topic to which you want to add the policy.
        """
        return pulumi.get(self, "topic_arn")

