# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SubscriptionArgs', 'Subscription']

@pulumi.input_type
class SubscriptionArgs:
    def __init__(__self__, *,
                 protocol: pulumi.Input[builtins.str],
                 topic_arn: pulumi.Input[builtins.str],
                 delivery_policy: Optional[Any] = None,
                 endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 filter_policy: Optional[Any] = None,
                 filter_policy_scope: Optional[pulumi.Input[builtins.str]] = None,
                 raw_message_delivery: Optional[pulumi.Input[builtins.bool]] = None,
                 redrive_policy: Optional[Any] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 replay_policy: Optional[Any] = None,
                 subscription_role_arn: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Subscription resource.
        :param pulumi.Input[builtins.str] protocol: The subscription's protocol.
        :param pulumi.Input[builtins.str] topic_arn: The ARN of the topic to subscribe to.
        :param Any delivery_policy: The delivery policy JSON assigned to the subscription. Enables the subscriber to define the message delivery retry strategy in the case of an HTTP/S endpoint subscribed to the topic.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SNS::Subscription` for more information about the expected schema for this property.
        :param pulumi.Input[builtins.str] endpoint: The subscription's endpoint. The endpoint value depends on the protocol that you specify. 
        :param Any filter_policy: The filter policy JSON assigned to the subscription. Enables the subscriber to filter out unwanted messages.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SNS::Subscription` for more information about the expected schema for this property.
        :param pulumi.Input[builtins.str] filter_policy_scope: This attribute lets you choose the filtering scope by using one of the following string value types: MessageAttributes (default) and MessageBody.
        :param pulumi.Input[builtins.bool] raw_message_delivery: When set to true, enables raw message delivery. Raw messages don't contain any JSON formatting and can be sent to Amazon SQS and HTTP/S endpoints.
        :param Any redrive_policy: When specified, sends undeliverable messages to the specified Amazon SQS dead-letter queue. Messages that can't be delivered due to client errors are held in the dead-letter queue for further analysis or reprocessing.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SNS::Subscription` for more information about the expected schema for this property.
        :param pulumi.Input[builtins.str] region: For cross-region subscriptions, the region in which the topic resides.If no region is specified, AWS CloudFormation uses the region of the caller as the default.
        :param Any replay_policy: Specifies whether Amazon SNS resends the notification to the subscription when a message's attribute changes.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SNS::Subscription` for more information about the expected schema for this property.
        :param pulumi.Input[builtins.str] subscription_role_arn: This property applies only to Amazon Data Firehose delivery stream subscriptions.
        """
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "topic_arn", topic_arn)
        if delivery_policy is not None:
            pulumi.set(__self__, "delivery_policy", delivery_policy)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if filter_policy is not None:
            pulumi.set(__self__, "filter_policy", filter_policy)
        if filter_policy_scope is not None:
            pulumi.set(__self__, "filter_policy_scope", filter_policy_scope)
        if raw_message_delivery is not None:
            pulumi.set(__self__, "raw_message_delivery", raw_message_delivery)
        if redrive_policy is not None:
            pulumi.set(__self__, "redrive_policy", redrive_policy)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replay_policy is not None:
            pulumi.set(__self__, "replay_policy", replay_policy)
        if subscription_role_arn is not None:
            pulumi.set(__self__, "subscription_role_arn", subscription_role_arn)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[builtins.str]:
        """
        The subscription's protocol.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> pulumi.Input[builtins.str]:
        """
        The ARN of the topic to subscribe to.
        """
        return pulumi.get(self, "topic_arn")

    @topic_arn.setter
    def topic_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "topic_arn", value)

    @property
    @pulumi.getter(name="deliveryPolicy")
    def delivery_policy(self) -> Optional[Any]:
        """
        The delivery policy JSON assigned to the subscription. Enables the subscriber to define the message delivery retry strategy in the case of an HTTP/S endpoint subscribed to the topic.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SNS::Subscription` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "delivery_policy")

    @delivery_policy.setter
    def delivery_policy(self, value: Optional[Any]):
        pulumi.set(self, "delivery_policy", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The subscription's endpoint. The endpoint value depends on the protocol that you specify. 
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="filterPolicy")
    def filter_policy(self) -> Optional[Any]:
        """
        The filter policy JSON assigned to the subscription. Enables the subscriber to filter out unwanted messages.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SNS::Subscription` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "filter_policy")

    @filter_policy.setter
    def filter_policy(self, value: Optional[Any]):
        pulumi.set(self, "filter_policy", value)

    @property
    @pulumi.getter(name="filterPolicyScope")
    def filter_policy_scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This attribute lets you choose the filtering scope by using one of the following string value types: MessageAttributes (default) and MessageBody.
        """
        return pulumi.get(self, "filter_policy_scope")

    @filter_policy_scope.setter
    def filter_policy_scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "filter_policy_scope", value)

    @property
    @pulumi.getter(name="rawMessageDelivery")
    def raw_message_delivery(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When set to true, enables raw message delivery. Raw messages don't contain any JSON formatting and can be sent to Amazon SQS and HTTP/S endpoints.
        """
        return pulumi.get(self, "raw_message_delivery")

    @raw_message_delivery.setter
    def raw_message_delivery(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "raw_message_delivery", value)

    @property
    @pulumi.getter(name="redrivePolicy")
    def redrive_policy(self) -> Optional[Any]:
        """
        When specified, sends undeliverable messages to the specified Amazon SQS dead-letter queue. Messages that can't be delivered due to client errors are held in the dead-letter queue for further analysis or reprocessing.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SNS::Subscription` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "redrive_policy")

    @redrive_policy.setter
    def redrive_policy(self, value: Optional[Any]):
        pulumi.set(self, "redrive_policy", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        For cross-region subscriptions, the region in which the topic resides.If no region is specified, AWS CloudFormation uses the region of the caller as the default.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="replayPolicy")
    def replay_policy(self) -> Optional[Any]:
        """
        Specifies whether Amazon SNS resends the notification to the subscription when a message's attribute changes.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SNS::Subscription` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "replay_policy")

    @replay_policy.setter
    def replay_policy(self, value: Optional[Any]):
        pulumi.set(self, "replay_policy", value)

    @property
    @pulumi.getter(name="subscriptionRoleArn")
    def subscription_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This property applies only to Amazon Data Firehose delivery stream subscriptions.
        """
        return pulumi.get(self, "subscription_role_arn")

    @subscription_role_arn.setter
    def subscription_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subscription_role_arn", value)


@pulumi.type_token("aws-native:sns:Subscription")
class Subscription(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delivery_policy: Optional[Any] = None,
                 endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 filter_policy: Optional[Any] = None,
                 filter_policy_scope: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 raw_message_delivery: Optional[pulumi.Input[builtins.bool]] = None,
                 redrive_policy: Optional[Any] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 replay_policy: Optional[Any] = None,
                 subscription_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 topic_arn: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::SNS::Subscription

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param Any delivery_policy: The delivery policy JSON assigned to the subscription. Enables the subscriber to define the message delivery retry strategy in the case of an HTTP/S endpoint subscribed to the topic.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SNS::Subscription` for more information about the expected schema for this property.
        :param pulumi.Input[builtins.str] endpoint: The subscription's endpoint. The endpoint value depends on the protocol that you specify. 
        :param Any filter_policy: The filter policy JSON assigned to the subscription. Enables the subscriber to filter out unwanted messages.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SNS::Subscription` for more information about the expected schema for this property.
        :param pulumi.Input[builtins.str] filter_policy_scope: This attribute lets you choose the filtering scope by using one of the following string value types: MessageAttributes (default) and MessageBody.
        :param pulumi.Input[builtins.str] protocol: The subscription's protocol.
        :param pulumi.Input[builtins.bool] raw_message_delivery: When set to true, enables raw message delivery. Raw messages don't contain any JSON formatting and can be sent to Amazon SQS and HTTP/S endpoints.
        :param Any redrive_policy: When specified, sends undeliverable messages to the specified Amazon SQS dead-letter queue. Messages that can't be delivered due to client errors are held in the dead-letter queue for further analysis or reprocessing.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SNS::Subscription` for more information about the expected schema for this property.
        :param pulumi.Input[builtins.str] region: For cross-region subscriptions, the region in which the topic resides.If no region is specified, AWS CloudFormation uses the region of the caller as the default.
        :param Any replay_policy: Specifies whether Amazon SNS resends the notification to the subscription when a message's attribute changes.
               
               Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SNS::Subscription` for more information about the expected schema for this property.
        :param pulumi.Input[builtins.str] subscription_role_arn: This property applies only to Amazon Data Firehose delivery stream subscriptions.
        :param pulumi.Input[builtins.str] topic_arn: The ARN of the topic to subscribe to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SubscriptionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::SNS::Subscription

        :param str resource_name: The name of the resource.
        :param SubscriptionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SubscriptionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 delivery_policy: Optional[Any] = None,
                 endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 filter_policy: Optional[Any] = None,
                 filter_policy_scope: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 raw_message_delivery: Optional[pulumi.Input[builtins.bool]] = None,
                 redrive_policy: Optional[Any] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 replay_policy: Optional[Any] = None,
                 subscription_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 topic_arn: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SubscriptionArgs.__new__(SubscriptionArgs)

            __props__.__dict__["delivery_policy"] = delivery_policy
            __props__.__dict__["endpoint"] = endpoint
            __props__.__dict__["filter_policy"] = filter_policy
            __props__.__dict__["filter_policy_scope"] = filter_policy_scope
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["raw_message_delivery"] = raw_message_delivery
            __props__.__dict__["redrive_policy"] = redrive_policy
            __props__.__dict__["region"] = region
            __props__.__dict__["replay_policy"] = replay_policy
            __props__.__dict__["subscription_role_arn"] = subscription_role_arn
            if topic_arn is None and not opts.urn:
                raise TypeError("Missing required property 'topic_arn'")
            __props__.__dict__["topic_arn"] = topic_arn
            __props__.__dict__["arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["endpoint", "protocol", "topicArn"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Subscription, __self__).__init__(
            'aws-native:sns:Subscription',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Subscription':
        """
        Get an existing Subscription resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SubscriptionArgs.__new__(SubscriptionArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["delivery_policy"] = None
        __props__.__dict__["endpoint"] = None
        __props__.__dict__["filter_policy"] = None
        __props__.__dict__["filter_policy_scope"] = None
        __props__.__dict__["protocol"] = None
        __props__.__dict__["raw_message_delivery"] = None
        __props__.__dict__["redrive_policy"] = None
        __props__.__dict__["region"] = None
        __props__.__dict__["replay_policy"] = None
        __props__.__dict__["subscription_role_arn"] = None
        __props__.__dict__["topic_arn"] = None
        return Subscription(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        Arn of the subscription
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="deliveryPolicy")
    def delivery_policy(self) -> pulumi.Output[Optional[Any]]:
        """
        The delivery policy JSON assigned to the subscription. Enables the subscriber to define the message delivery retry strategy in the case of an HTTP/S endpoint subscribed to the topic.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SNS::Subscription` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "delivery_policy")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The subscription's endpoint. The endpoint value depends on the protocol that you specify. 
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="filterPolicy")
    def filter_policy(self) -> pulumi.Output[Optional[Any]]:
        """
        The filter policy JSON assigned to the subscription. Enables the subscriber to filter out unwanted messages.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SNS::Subscription` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "filter_policy")

    @property
    @pulumi.getter(name="filterPolicyScope")
    def filter_policy_scope(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        This attribute lets you choose the filtering scope by using one of the following string value types: MessageAttributes (default) and MessageBody.
        """
        return pulumi.get(self, "filter_policy_scope")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[builtins.str]:
        """
        The subscription's protocol.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="rawMessageDelivery")
    def raw_message_delivery(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        When set to true, enables raw message delivery. Raw messages don't contain any JSON formatting and can be sent to Amazon SQS and HTTP/S endpoints.
        """
        return pulumi.get(self, "raw_message_delivery")

    @property
    @pulumi.getter(name="redrivePolicy")
    def redrive_policy(self) -> pulumi.Output[Optional[Any]]:
        """
        When specified, sends undeliverable messages to the specified Amazon SQS dead-letter queue. Messages that can't be delivered due to client errors are held in the dead-letter queue for further analysis or reprocessing.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SNS::Subscription` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "redrive_policy")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        For cross-region subscriptions, the region in which the topic resides.If no region is specified, AWS CloudFormation uses the region of the caller as the default.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="replayPolicy")
    def replay_policy(self) -> pulumi.Output[Optional[Any]]:
        """
        Specifies whether Amazon SNS resends the notification to the subscription when a message's attribute changes.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SNS::Subscription` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "replay_policy")

    @property
    @pulumi.getter(name="subscriptionRoleArn")
    def subscription_role_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        This property applies only to Amazon Data Firehose delivery stream subscriptions.
        """
        return pulumi.get(self, "subscription_role_arn")

    @property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the topic to subscribe to.
        """
        return pulumi.get(self, "topic_arn")

