# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSubscriptionResult',
    'AwaitableGetSubscriptionResult',
    'get_subscription',
    'get_subscription_output',
]

@pulumi.output_type
class GetSubscriptionResult:
    def __init__(__self__, arn=None, delivery_policy=None, filter_policy=None, filter_policy_scope=None, raw_message_delivery=None, redrive_policy=None, replay_policy=None, subscription_role_arn=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if delivery_policy and not isinstance(delivery_policy, dict):
            raise TypeError("Expected argument 'delivery_policy' to be a dict")
        pulumi.set(__self__, "delivery_policy", delivery_policy)
        if filter_policy and not isinstance(filter_policy, dict):
            raise TypeError("Expected argument 'filter_policy' to be a dict")
        pulumi.set(__self__, "filter_policy", filter_policy)
        if filter_policy_scope and not isinstance(filter_policy_scope, str):
            raise TypeError("Expected argument 'filter_policy_scope' to be a str")
        pulumi.set(__self__, "filter_policy_scope", filter_policy_scope)
        if raw_message_delivery and not isinstance(raw_message_delivery, bool):
            raise TypeError("Expected argument 'raw_message_delivery' to be a bool")
        pulumi.set(__self__, "raw_message_delivery", raw_message_delivery)
        if redrive_policy and not isinstance(redrive_policy, dict):
            raise TypeError("Expected argument 'redrive_policy' to be a dict")
        pulumi.set(__self__, "redrive_policy", redrive_policy)
        if replay_policy and not isinstance(replay_policy, dict):
            raise TypeError("Expected argument 'replay_policy' to be a dict")
        pulumi.set(__self__, "replay_policy", replay_policy)
        if subscription_role_arn and not isinstance(subscription_role_arn, str):
            raise TypeError("Expected argument 'subscription_role_arn' to be a str")
        pulumi.set(__self__, "subscription_role_arn", subscription_role_arn)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        Arn of the subscription
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="deliveryPolicy")
    def delivery_policy(self) -> Optional[Any]:
        """
        The delivery policy JSON assigned to the subscription. Enables the subscriber to define the message delivery retry strategy in the case of an HTTP/S endpoint subscribed to the topic.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SNS::Subscription` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "delivery_policy")

    @property
    @pulumi.getter(name="filterPolicy")
    def filter_policy(self) -> Optional[Any]:
        """
        The filter policy JSON assigned to the subscription. Enables the subscriber to filter out unwanted messages.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SNS::Subscription` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "filter_policy")

    @property
    @pulumi.getter(name="filterPolicyScope")
    def filter_policy_scope(self) -> Optional[builtins.str]:
        """
        This attribute lets you choose the filtering scope by using one of the following string value types: MessageAttributes (default) and MessageBody.
        """
        return pulumi.get(self, "filter_policy_scope")

    @property
    @pulumi.getter(name="rawMessageDelivery")
    def raw_message_delivery(self) -> Optional[builtins.bool]:
        """
        When set to true, enables raw message delivery. Raw messages don't contain any JSON formatting and can be sent to Amazon SQS and HTTP/S endpoints.
        """
        return pulumi.get(self, "raw_message_delivery")

    @property
    @pulumi.getter(name="redrivePolicy")
    def redrive_policy(self) -> Optional[Any]:
        """
        When specified, sends undeliverable messages to the specified Amazon SQS dead-letter queue. Messages that can't be delivered due to client errors are held in the dead-letter queue for further analysis or reprocessing.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SNS::Subscription` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "redrive_policy")

    @property
    @pulumi.getter(name="replayPolicy")
    def replay_policy(self) -> Optional[Any]:
        """
        Specifies whether Amazon SNS resends the notification to the subscription when a message's attribute changes.

        Search the [CloudFormation User Guide](https://docs.aws.amazon.com/cloudformation/) for `AWS::SNS::Subscription` for more information about the expected schema for this property.
        """
        return pulumi.get(self, "replay_policy")

    @property
    @pulumi.getter(name="subscriptionRoleArn")
    def subscription_role_arn(self) -> Optional[builtins.str]:
        """
        This property applies only to Amazon Data Firehose delivery stream subscriptions.
        """
        return pulumi.get(self, "subscription_role_arn")


class AwaitableGetSubscriptionResult(GetSubscriptionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSubscriptionResult(
            arn=self.arn,
            delivery_policy=self.delivery_policy,
            filter_policy=self.filter_policy,
            filter_policy_scope=self.filter_policy_scope,
            raw_message_delivery=self.raw_message_delivery,
            redrive_policy=self.redrive_policy,
            replay_policy=self.replay_policy,
            subscription_role_arn=self.subscription_role_arn)


def get_subscription(arn: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSubscriptionResult:
    """
    Resource Type definition for AWS::SNS::Subscription


    :param builtins.str arn: Arn of the subscription
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:sns:getSubscription', __args__, opts=opts, typ=GetSubscriptionResult).value

    return AwaitableGetSubscriptionResult(
        arn=pulumi.get(__ret__, 'arn'),
        delivery_policy=pulumi.get(__ret__, 'delivery_policy'),
        filter_policy=pulumi.get(__ret__, 'filter_policy'),
        filter_policy_scope=pulumi.get(__ret__, 'filter_policy_scope'),
        raw_message_delivery=pulumi.get(__ret__, 'raw_message_delivery'),
        redrive_policy=pulumi.get(__ret__, 'redrive_policy'),
        replay_policy=pulumi.get(__ret__, 'replay_policy'),
        subscription_role_arn=pulumi.get(__ret__, 'subscription_role_arn'))
def get_subscription_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSubscriptionResult]:
    """
    Resource Type definition for AWS::SNS::Subscription


    :param builtins.str arn: Arn of the subscription
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:sns:getSubscription', __args__, opts=opts, typ=GetSubscriptionResult)
    return __ret__.apply(lambda __response__: GetSubscriptionResult(
        arn=pulumi.get(__response__, 'arn'),
        delivery_policy=pulumi.get(__response__, 'delivery_policy'),
        filter_policy=pulumi.get(__response__, 'filter_policy'),
        filter_policy_scope=pulumi.get(__response__, 'filter_policy_scope'),
        raw_message_delivery=pulumi.get(__response__, 'raw_message_delivery'),
        redrive_policy=pulumi.get(__response__, 'redrive_policy'),
        replay_policy=pulumi.get(__response__, 'replay_policy'),
        subscription_role_arn=pulumi.get(__response__, 'subscription_role_arn')))
