# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'TopicLoggingConfigArgs',
    'TopicLoggingConfigArgsDict',
    'TopicSubscriptionArgs',
    'TopicSubscriptionArgsDict',
]

MYPY = False

if not MYPY:
    class TopicLoggingConfigArgsDict(TypedDict):
        """
        The ``LoggingConfig`` property type specifies the ``Delivery`` status logging configuration for an [AWS::SNS::Topic](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html).
        """
        protocol: pulumi.Input['TopicLoggingConfigProtocol']
        """
        Indicates one of the supported protocols for the Amazon SNS topic.
          At least one of the other three ``LoggingConfig`` properties is recommend along with ``Protocol``.
        """
        failure_feedback_role_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The IAM role ARN to be used when logging failed message deliveries in Amazon CloudWatch.
        """
        success_feedback_role_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The IAM role ARN to be used when logging successful message deliveries in Amazon CloudWatch.
        """
        success_feedback_sample_rate: NotRequired[pulumi.Input[builtins.str]]
        """
        The percentage of successful message deliveries to be logged in Amazon CloudWatch. Valid percentage values range from 0 to 100.
        """
elif False:
    TopicLoggingConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TopicLoggingConfigArgs:
    def __init__(__self__, *,
                 protocol: pulumi.Input['TopicLoggingConfigProtocol'],
                 failure_feedback_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 success_feedback_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 success_feedback_sample_rate: Optional[pulumi.Input[builtins.str]] = None):
        """
        The ``LoggingConfig`` property type specifies the ``Delivery`` status logging configuration for an [AWS::SNS::Topic](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-topic.html).
        :param pulumi.Input['TopicLoggingConfigProtocol'] protocol: Indicates one of the supported protocols for the Amazon SNS topic.
                 At least one of the other three ``LoggingConfig`` properties is recommend along with ``Protocol``.
        :param pulumi.Input[builtins.str] failure_feedback_role_arn: The IAM role ARN to be used when logging failed message deliveries in Amazon CloudWatch.
        :param pulumi.Input[builtins.str] success_feedback_role_arn: The IAM role ARN to be used when logging successful message deliveries in Amazon CloudWatch.
        :param pulumi.Input[builtins.str] success_feedback_sample_rate: The percentage of successful message deliveries to be logged in Amazon CloudWatch. Valid percentage values range from 0 to 100.
        """
        pulumi.set(__self__, "protocol", protocol)
        if failure_feedback_role_arn is not None:
            pulumi.set(__self__, "failure_feedback_role_arn", failure_feedback_role_arn)
        if success_feedback_role_arn is not None:
            pulumi.set(__self__, "success_feedback_role_arn", success_feedback_role_arn)
        if success_feedback_sample_rate is not None:
            pulumi.set(__self__, "success_feedback_sample_rate", success_feedback_sample_rate)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input['TopicLoggingConfigProtocol']:
        """
        Indicates one of the supported protocols for the Amazon SNS topic.
          At least one of the other three ``LoggingConfig`` properties is recommend along with ``Protocol``.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input['TopicLoggingConfigProtocol']):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="failureFeedbackRoleArn")
    def failure_feedback_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IAM role ARN to be used when logging failed message deliveries in Amazon CloudWatch.
        """
        return pulumi.get(self, "failure_feedback_role_arn")

    @failure_feedback_role_arn.setter
    def failure_feedback_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "failure_feedback_role_arn", value)

    @property
    @pulumi.getter(name="successFeedbackRoleArn")
    def success_feedback_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IAM role ARN to be used when logging successful message deliveries in Amazon CloudWatch.
        """
        return pulumi.get(self, "success_feedback_role_arn")

    @success_feedback_role_arn.setter
    def success_feedback_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "success_feedback_role_arn", value)

    @property
    @pulumi.getter(name="successFeedbackSampleRate")
    def success_feedback_sample_rate(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The percentage of successful message deliveries to be logged in Amazon CloudWatch. Valid percentage values range from 0 to 100.
        """
        return pulumi.get(self, "success_feedback_sample_rate")

    @success_feedback_sample_rate.setter
    def success_feedback_sample_rate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "success_feedback_sample_rate", value)


if not MYPY:
    class TopicSubscriptionArgsDict(TypedDict):
        """
        ``Subscription`` is an embedded property that describes the subscription endpoints of an SNS topic.
          For full control over subscription behavior (for example, delivery policy, filtering, raw message delivery, and cross-region subscriptions), use the [AWS::SNS::Subscription](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html) resource.
        """
        endpoint: pulumi.Input[builtins.str]
        """
        The endpoint that receives notifications from the SNS topic. The endpoint value depends on the protocol that you specify. For more information, see the ``Endpoint`` parameter of the ``Subscribe`` action in the *API Reference*.
        """
        protocol: pulumi.Input[builtins.str]
        """
        The subscription's protocol. For more information, see the ``Protocol`` parameter of the ``Subscribe`` action in the *API Reference*.
        """
elif False:
    TopicSubscriptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TopicSubscriptionArgs:
    def __init__(__self__, *,
                 endpoint: pulumi.Input[builtins.str],
                 protocol: pulumi.Input[builtins.str]):
        """
        ``Subscription`` is an embedded property that describes the subscription endpoints of an SNS topic.
          For full control over subscription behavior (for example, delivery policy, filtering, raw message delivery, and cross-region subscriptions), use the [AWS::SNS::Subscription](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sns-subscription.html) resource.
        :param pulumi.Input[builtins.str] endpoint: The endpoint that receives notifications from the SNS topic. The endpoint value depends on the protocol that you specify. For more information, see the ``Endpoint`` parameter of the ``Subscribe`` action in the *API Reference*.
        :param pulumi.Input[builtins.str] protocol: The subscription's protocol. For more information, see the ``Protocol`` parameter of the ``Subscribe`` action in the *API Reference*.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Input[builtins.str]:
        """
        The endpoint that receives notifications from the SNS topic. The endpoint value depends on the protocol that you specify. For more information, see the ``Endpoint`` parameter of the ``Subscribe`` action in the *API Reference*.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[builtins.str]:
        """
        The subscription's protocol. For more information, see the ``Protocol`` parameter of the ``Subscribe`` action in the *API Reference*.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "protocol", value)


