# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDrtAccessResult',
    'AwaitableGetDrtAccessResult',
    'get_drt_access',
    'get_drt_access_output',
]

@pulumi.output_type
class GetDrtAccessResult:
    def __init__(__self__, account_id=None, log_bucket_list=None, role_arn=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if log_bucket_list and not isinstance(log_bucket_list, list):
            raise TypeError("Expected argument 'log_bucket_list' to be a list")
        pulumi.set(__self__, "log_bucket_list", log_bucket_list)
        if role_arn and not isinstance(role_arn, str):
            raise TypeError("Expected argument 'role_arn' to be a str")
        pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[builtins.str]:
        """
        The ID of the account that submitted the template.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="logBucketList")
    def log_bucket_list(self) -> Optional[Sequence[builtins.str]]:
        """
        Authorizes the Shield Response Team (SRT) to access the specified Amazon S3 bucket containing log data such as Application Load Balancer access logs, CloudFront logs, or logs from third party sources. You can associate up to 10 Amazon S3 buckets with your subscription.
        """
        return pulumi.get(self, "log_bucket_list")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[builtins.str]:
        """
        Authorizes the Shield Response Team (SRT) using the specified role, to access your AWS account to assist with DDoS attack mitigation during potential attacks. This enables the SRT to inspect your AWS WAF configuration and create or update AWS WAF rules and web ACLs.
        """
        return pulumi.get(self, "role_arn")


class AwaitableGetDrtAccessResult(GetDrtAccessResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDrtAccessResult(
            account_id=self.account_id,
            log_bucket_list=self.log_bucket_list,
            role_arn=self.role_arn)


def get_drt_access(account_id: Optional[builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDrtAccessResult:
    """
    Config the role and list of Amazon S3 log buckets used by the Shield Response Team (SRT) to access your AWS account while assisting with attack mitigation.


    :param builtins.str account_id: The ID of the account that submitted the template.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:shield:getDrtAccess', __args__, opts=opts, typ=GetDrtAccessResult).value

    return AwaitableGetDrtAccessResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        log_bucket_list=pulumi.get(__ret__, 'log_bucket_list'),
        role_arn=pulumi.get(__ret__, 'role_arn'))
def get_drt_access_output(account_id: Optional[pulumi.Input[builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDrtAccessResult]:
    """
    Config the role and list of Amazon S3 log buckets used by the Shield Response Team (SRT) to access your AWS account while assisting with attack mitigation.


    :param builtins.str account_id: The ID of the account that submitted the template.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:shield:getDrtAccess', __args__, opts=opts, typ=GetDrtAccessResult)
    return __ret__.apply(lambda __response__: GetDrtAccessResult(
        account_id=pulumi.get(__response__, 'account_id'),
        log_bucket_list=pulumi.get(__response__, 'log_bucket_list'),
        role_arn=pulumi.get(__response__, 'role_arn')))
