# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['MailManagerTrafficPolicyArgs', 'MailManagerTrafficPolicy']

@pulumi.input_type
class MailManagerTrafficPolicyArgs:
    def __init__(__self__, *,
                 default_action: pulumi.Input['MailManagerTrafficPolicyAcceptAction'],
                 policy_statements: pulumi.Input[Sequence[pulumi.Input['MailManagerTrafficPolicyPolicyStatementArgs']]],
                 max_message_size_bytes: Optional[pulumi.Input[builtins.float]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 traffic_policy_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a MailManagerTrafficPolicy resource.
        :param pulumi.Input['MailManagerTrafficPolicyAcceptAction'] default_action: Default action instructs the traﬃc policy to either Allow or Deny (block) messages that fall outside of (or not addressed by) the conditions of your policy statements
        :param pulumi.Input[Sequence[pulumi.Input['MailManagerTrafficPolicyPolicyStatementArgs']]] policy_statements: Conditional statements for filtering email traffic.
        :param pulumi.Input[builtins.float] max_message_size_bytes: The maximum message size in bytes of email which is allowed in by this traffic policy—anything larger will be blocked.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The tags used to organize, track, or control access for the resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
        :param pulumi.Input[builtins.str] traffic_policy_name: The name of the policy.
               
               The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.
        """
        pulumi.set(__self__, "default_action", default_action)
        pulumi.set(__self__, "policy_statements", policy_statements)
        if max_message_size_bytes is not None:
            pulumi.set(__self__, "max_message_size_bytes", max_message_size_bytes)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if traffic_policy_name is not None:
            pulumi.set(__self__, "traffic_policy_name", traffic_policy_name)

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> pulumi.Input['MailManagerTrafficPolicyAcceptAction']:
        """
        Default action instructs the traﬃc policy to either Allow or Deny (block) messages that fall outside of (or not addressed by) the conditions of your policy statements
        """
        return pulumi.get(self, "default_action")

    @default_action.setter
    def default_action(self, value: pulumi.Input['MailManagerTrafficPolicyAcceptAction']):
        pulumi.set(self, "default_action", value)

    @property
    @pulumi.getter(name="policyStatements")
    def policy_statements(self) -> pulumi.Input[Sequence[pulumi.Input['MailManagerTrafficPolicyPolicyStatementArgs']]]:
        """
        Conditional statements for filtering email traffic.
        """
        return pulumi.get(self, "policy_statements")

    @policy_statements.setter
    def policy_statements(self, value: pulumi.Input[Sequence[pulumi.Input['MailManagerTrafficPolicyPolicyStatementArgs']]]):
        pulumi.set(self, "policy_statements", value)

    @property
    @pulumi.getter(name="maxMessageSizeBytes")
    def max_message_size_bytes(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The maximum message size in bytes of email which is allowed in by this traffic policy—anything larger will be blocked.
        """
        return pulumi.get(self, "max_message_size_bytes")

    @max_message_size_bytes.setter
    def max_message_size_bytes(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "max_message_size_bytes", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tags used to organize, track, or control access for the resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="trafficPolicyName")
    def traffic_policy_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the policy.

        The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.
        """
        return pulumi.get(self, "traffic_policy_name")

    @traffic_policy_name.setter
    def traffic_policy_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "traffic_policy_name", value)


@pulumi.type_token("aws-native:ses:MailManagerTrafficPolicy")
class MailManagerTrafficPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_action: Optional[pulumi.Input['MailManagerTrafficPolicyAcceptAction']] = None,
                 max_message_size_bytes: Optional[pulumi.Input[builtins.float]] = None,
                 policy_statements: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MailManagerTrafficPolicyPolicyStatementArgs', 'MailManagerTrafficPolicyPolicyStatementArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 traffic_policy_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Definition of AWS::SES::MailManagerTrafficPolicy Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input['MailManagerTrafficPolicyAcceptAction'] default_action: Default action instructs the traﬃc policy to either Allow or Deny (block) messages that fall outside of (or not addressed by) the conditions of your policy statements
        :param pulumi.Input[builtins.float] max_message_size_bytes: The maximum message size in bytes of email which is allowed in by this traffic policy—anything larger will be blocked.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MailManagerTrafficPolicyPolicyStatementArgs', 'MailManagerTrafficPolicyPolicyStatementArgsDict']]]] policy_statements: Conditional statements for filtering email traffic.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The tags used to organize, track, or control access for the resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
        :param pulumi.Input[builtins.str] traffic_policy_name: The name of the policy.
               
               The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MailManagerTrafficPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::SES::MailManagerTrafficPolicy Resource Type

        :param str resource_name: The name of the resource.
        :param MailManagerTrafficPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MailManagerTrafficPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_action: Optional[pulumi.Input['MailManagerTrafficPolicyAcceptAction']] = None,
                 max_message_size_bytes: Optional[pulumi.Input[builtins.float]] = None,
                 policy_statements: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MailManagerTrafficPolicyPolicyStatementArgs', 'MailManagerTrafficPolicyPolicyStatementArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 traffic_policy_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MailManagerTrafficPolicyArgs.__new__(MailManagerTrafficPolicyArgs)

            if default_action is None and not opts.urn:
                raise TypeError("Missing required property 'default_action'")
            __props__.__dict__["default_action"] = default_action
            __props__.__dict__["max_message_size_bytes"] = max_message_size_bytes
            if policy_statements is None and not opts.urn:
                raise TypeError("Missing required property 'policy_statements'")
            __props__.__dict__["policy_statements"] = policy_statements
            __props__.__dict__["tags"] = tags
            __props__.__dict__["traffic_policy_name"] = traffic_policy_name
            __props__.__dict__["traffic_policy_arn"] = None
            __props__.__dict__["traffic_policy_id"] = None
        super(MailManagerTrafficPolicy, __self__).__init__(
            'aws-native:ses:MailManagerTrafficPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'MailManagerTrafficPolicy':
        """
        Get an existing MailManagerTrafficPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = MailManagerTrafficPolicyArgs.__new__(MailManagerTrafficPolicyArgs)

        __props__.__dict__["default_action"] = None
        __props__.__dict__["max_message_size_bytes"] = None
        __props__.__dict__["policy_statements"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["traffic_policy_arn"] = None
        __props__.__dict__["traffic_policy_id"] = None
        __props__.__dict__["traffic_policy_name"] = None
        return MailManagerTrafficPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> pulumi.Output['MailManagerTrafficPolicyAcceptAction']:
        """
        Default action instructs the traﬃc policy to either Allow or Deny (block) messages that fall outside of (or not addressed by) the conditions of your policy statements
        """
        return pulumi.get(self, "default_action")

    @property
    @pulumi.getter(name="maxMessageSizeBytes")
    def max_message_size_bytes(self) -> pulumi.Output[Optional[builtins.float]]:
        """
        The maximum message size in bytes of email which is allowed in by this traffic policy—anything larger will be blocked.
        """
        return pulumi.get(self, "max_message_size_bytes")

    @property
    @pulumi.getter(name="policyStatements")
    def policy_statements(self) -> pulumi.Output[Sequence['outputs.MailManagerTrafficPolicyPolicyStatement']]:
        """
        Conditional statements for filtering email traffic.
        """
        return pulumi.get(self, "policy_statements")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tags used to organize, track, or control access for the resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="trafficPolicyArn")
    def traffic_policy_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the traffic policy resource.
        """
        return pulumi.get(self, "traffic_policy_arn")

    @property
    @pulumi.getter(name="trafficPolicyId")
    def traffic_policy_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the traffic policy resource.
        """
        return pulumi.get(self, "traffic_policy_id")

    @property
    @pulumi.getter(name="trafficPolicyName")
    def traffic_policy_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the policy.

        The policy name cannot exceed 64 characters and can only include alphanumeric characters, dashes, and underscores.
        """
        return pulumi.get(self, "traffic_policy_name")

