# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['MailManagerIngressPointArgs', 'MailManagerIngressPoint']

@pulumi.input_type
class MailManagerIngressPointArgs:
    def __init__(__self__, *,
                 rule_set_id: pulumi.Input[builtins.str],
                 traffic_policy_id: pulumi.Input[builtins.str],
                 type: pulumi.Input['MailManagerIngressPointIngressPointType'],
                 ingress_point_configuration: Optional[pulumi.Input[Union['MailManagerIngressPointIngressPointConfiguration0PropertiesArgs', 'MailManagerIngressPointIngressPointConfiguration1PropertiesArgs']]] = None,
                 ingress_point_name: Optional[pulumi.Input[builtins.str]] = None,
                 network_configuration: Optional[pulumi.Input[Union['MailManagerIngressPointNetworkConfiguration0PropertiesArgs', 'MailManagerIngressPointNetworkConfiguration1PropertiesArgs']]] = None,
                 status_to_update: Optional[pulumi.Input['MailManagerIngressPointIngressPointStatusToUpdate']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a MailManagerIngressPoint resource.
        :param pulumi.Input[builtins.str] rule_set_id: The identifier of an existing rule set that you attach to an ingress endpoint resource.
        :param pulumi.Input[builtins.str] traffic_policy_id: The identifier of an existing traffic policy that you attach to an ingress endpoint resource.
        :param pulumi.Input['MailManagerIngressPointIngressPointType'] type: The type of the ingress endpoint to create.
        :param pulumi.Input[Union['MailManagerIngressPointIngressPointConfiguration0PropertiesArgs', 'MailManagerIngressPointIngressPointConfiguration1PropertiesArgs']] ingress_point_configuration: The configuration of the ingress endpoint resource.
        :param pulumi.Input[builtins.str] ingress_point_name: A user friendly name for an ingress endpoint resource.
        :param pulumi.Input[Union['MailManagerIngressPointNetworkConfiguration0PropertiesArgs', 'MailManagerIngressPointNetworkConfiguration1PropertiesArgs']] network_configuration: The network type (IPv4-only, Dual-Stack, PrivateLink) of the ingress endpoint resource.
        :param pulumi.Input['MailManagerIngressPointIngressPointStatusToUpdate'] status_to_update: The update status of an ingress endpoint.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The tags used to organize, track, or control access for the resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
        """
        pulumi.set(__self__, "rule_set_id", rule_set_id)
        pulumi.set(__self__, "traffic_policy_id", traffic_policy_id)
        pulumi.set(__self__, "type", type)
        if ingress_point_configuration is not None:
            pulumi.set(__self__, "ingress_point_configuration", ingress_point_configuration)
        if ingress_point_name is not None:
            pulumi.set(__self__, "ingress_point_name", ingress_point_name)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if status_to_update is not None:
            pulumi.set(__self__, "status_to_update", status_to_update)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="ruleSetId")
    def rule_set_id(self) -> pulumi.Input[builtins.str]:
        """
        The identifier of an existing rule set that you attach to an ingress endpoint resource.
        """
        return pulumi.get(self, "rule_set_id")

    @rule_set_id.setter
    def rule_set_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "rule_set_id", value)

    @property
    @pulumi.getter(name="trafficPolicyId")
    def traffic_policy_id(self) -> pulumi.Input[builtins.str]:
        """
        The identifier of an existing traffic policy that you attach to an ingress endpoint resource.
        """
        return pulumi.get(self, "traffic_policy_id")

    @traffic_policy_id.setter
    def traffic_policy_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "traffic_policy_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['MailManagerIngressPointIngressPointType']:
        """
        The type of the ingress endpoint to create.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['MailManagerIngressPointIngressPointType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="ingressPointConfiguration")
    def ingress_point_configuration(self) -> Optional[pulumi.Input[Union['MailManagerIngressPointIngressPointConfiguration0PropertiesArgs', 'MailManagerIngressPointIngressPointConfiguration1PropertiesArgs']]]:
        """
        The configuration of the ingress endpoint resource.
        """
        return pulumi.get(self, "ingress_point_configuration")

    @ingress_point_configuration.setter
    def ingress_point_configuration(self, value: Optional[pulumi.Input[Union['MailManagerIngressPointIngressPointConfiguration0PropertiesArgs', 'MailManagerIngressPointIngressPointConfiguration1PropertiesArgs']]]):
        pulumi.set(self, "ingress_point_configuration", value)

    @property
    @pulumi.getter(name="ingressPointName")
    def ingress_point_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A user friendly name for an ingress endpoint resource.
        """
        return pulumi.get(self, "ingress_point_name")

    @ingress_point_name.setter
    def ingress_point_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ingress_point_name", value)

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional[pulumi.Input[Union['MailManagerIngressPointNetworkConfiguration0PropertiesArgs', 'MailManagerIngressPointNetworkConfiguration1PropertiesArgs']]]:
        """
        The network type (IPv4-only, Dual-Stack, PrivateLink) of the ingress endpoint resource.
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: Optional[pulumi.Input[Union['MailManagerIngressPointNetworkConfiguration0PropertiesArgs', 'MailManagerIngressPointNetworkConfiguration1PropertiesArgs']]]):
        pulumi.set(self, "network_configuration", value)

    @property
    @pulumi.getter(name="statusToUpdate")
    def status_to_update(self) -> Optional[pulumi.Input['MailManagerIngressPointIngressPointStatusToUpdate']]:
        """
        The update status of an ingress endpoint.
        """
        return pulumi.get(self, "status_to_update")

    @status_to_update.setter
    def status_to_update(self, value: Optional[pulumi.Input['MailManagerIngressPointIngressPointStatusToUpdate']]):
        pulumi.set(self, "status_to_update", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tags used to organize, track, or control access for the resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:ses:MailManagerIngressPoint")
class MailManagerIngressPoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ingress_point_configuration: Optional[pulumi.Input[Union[Union['MailManagerIngressPointIngressPointConfiguration0PropertiesArgs', 'MailManagerIngressPointIngressPointConfiguration0PropertiesArgsDict'], Union['MailManagerIngressPointIngressPointConfiguration1PropertiesArgs', 'MailManagerIngressPointIngressPointConfiguration1PropertiesArgsDict']]]] = None,
                 ingress_point_name: Optional[pulumi.Input[builtins.str]] = None,
                 network_configuration: Optional[pulumi.Input[Union[Union['MailManagerIngressPointNetworkConfiguration0PropertiesArgs', 'MailManagerIngressPointNetworkConfiguration0PropertiesArgsDict'], Union['MailManagerIngressPointNetworkConfiguration1PropertiesArgs', 'MailManagerIngressPointNetworkConfiguration1PropertiesArgsDict']]]] = None,
                 rule_set_id: Optional[pulumi.Input[builtins.str]] = None,
                 status_to_update: Optional[pulumi.Input['MailManagerIngressPointIngressPointStatusToUpdate']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 traffic_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input['MailManagerIngressPointIngressPointType']] = None,
                 __props__=None):
        """
        Definition of AWS::SES::MailManagerIngressPoint Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union[Union['MailManagerIngressPointIngressPointConfiguration0PropertiesArgs', 'MailManagerIngressPointIngressPointConfiguration0PropertiesArgsDict'], Union['MailManagerIngressPointIngressPointConfiguration1PropertiesArgs', 'MailManagerIngressPointIngressPointConfiguration1PropertiesArgsDict']]] ingress_point_configuration: The configuration of the ingress endpoint resource.
        :param pulumi.Input[builtins.str] ingress_point_name: A user friendly name for an ingress endpoint resource.
        :param pulumi.Input[Union[Union['MailManagerIngressPointNetworkConfiguration0PropertiesArgs', 'MailManagerIngressPointNetworkConfiguration0PropertiesArgsDict'], Union['MailManagerIngressPointNetworkConfiguration1PropertiesArgs', 'MailManagerIngressPointNetworkConfiguration1PropertiesArgsDict']]] network_configuration: The network type (IPv4-only, Dual-Stack, PrivateLink) of the ingress endpoint resource.
        :param pulumi.Input[builtins.str] rule_set_id: The identifier of an existing rule set that you attach to an ingress endpoint resource.
        :param pulumi.Input['MailManagerIngressPointIngressPointStatusToUpdate'] status_to_update: The update status of an ingress endpoint.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The tags used to organize, track, or control access for the resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
        :param pulumi.Input[builtins.str] traffic_policy_id: The identifier of an existing traffic policy that you attach to an ingress endpoint resource.
        :param pulumi.Input['MailManagerIngressPointIngressPointType'] type: The type of the ingress endpoint to create.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MailManagerIngressPointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::SES::MailManagerIngressPoint Resource Type

        :param str resource_name: The name of the resource.
        :param MailManagerIngressPointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MailManagerIngressPointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ingress_point_configuration: Optional[pulumi.Input[Union[Union['MailManagerIngressPointIngressPointConfiguration0PropertiesArgs', 'MailManagerIngressPointIngressPointConfiguration0PropertiesArgsDict'], Union['MailManagerIngressPointIngressPointConfiguration1PropertiesArgs', 'MailManagerIngressPointIngressPointConfiguration1PropertiesArgsDict']]]] = None,
                 ingress_point_name: Optional[pulumi.Input[builtins.str]] = None,
                 network_configuration: Optional[pulumi.Input[Union[Union['MailManagerIngressPointNetworkConfiguration0PropertiesArgs', 'MailManagerIngressPointNetworkConfiguration0PropertiesArgsDict'], Union['MailManagerIngressPointNetworkConfiguration1PropertiesArgs', 'MailManagerIngressPointNetworkConfiguration1PropertiesArgsDict']]]] = None,
                 rule_set_id: Optional[pulumi.Input[builtins.str]] = None,
                 status_to_update: Optional[pulumi.Input['MailManagerIngressPointIngressPointStatusToUpdate']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 traffic_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input['MailManagerIngressPointIngressPointType']] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MailManagerIngressPointArgs.__new__(MailManagerIngressPointArgs)

            __props__.__dict__["ingress_point_configuration"] = ingress_point_configuration
            __props__.__dict__["ingress_point_name"] = ingress_point_name
            __props__.__dict__["network_configuration"] = network_configuration
            if rule_set_id is None and not opts.urn:
                raise TypeError("Missing required property 'rule_set_id'")
            __props__.__dict__["rule_set_id"] = rule_set_id
            __props__.__dict__["status_to_update"] = status_to_update
            __props__.__dict__["tags"] = tags
            if traffic_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'traffic_policy_id'")
            __props__.__dict__["traffic_policy_id"] = traffic_policy_id
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["a_record"] = None
            __props__.__dict__["ingress_point_arn"] = None
            __props__.__dict__["ingress_point_id"] = None
            __props__.__dict__["status"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["networkConfiguration", "type"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(MailManagerIngressPoint, __self__).__init__(
            'aws-native:ses:MailManagerIngressPoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'MailManagerIngressPoint':
        """
        Get an existing MailManagerIngressPoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = MailManagerIngressPointArgs.__new__(MailManagerIngressPointArgs)

        __props__.__dict__["a_record"] = None
        __props__.__dict__["ingress_point_arn"] = None
        __props__.__dict__["ingress_point_configuration"] = None
        __props__.__dict__["ingress_point_id"] = None
        __props__.__dict__["ingress_point_name"] = None
        __props__.__dict__["network_configuration"] = None
        __props__.__dict__["rule_set_id"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["status_to_update"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["traffic_policy_id"] = None
        __props__.__dict__["type"] = None
        return MailManagerIngressPoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="aRecord")
    def a_record(self) -> pulumi.Output[builtins.str]:
        """
        The DNS A Record that identifies your ingress endpoint. Configure your DNS Mail Exchange (MX) record with this value to route emails to Mail Manager.
        """
        return pulumi.get(self, "a_record")

    @property
    @pulumi.getter(name="ingressPointArn")
    def ingress_point_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the ingress endpoint resource.
        """
        return pulumi.get(self, "ingress_point_arn")

    @property
    @pulumi.getter(name="ingressPointConfiguration")
    def ingress_point_configuration(self) -> pulumi.Output[Optional[Any]]:
        """
        The configuration of the ingress endpoint resource.
        """
        return pulumi.get(self, "ingress_point_configuration")

    @property
    @pulumi.getter(name="ingressPointId")
    def ingress_point_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the ingress endpoint resource.
        """
        return pulumi.get(self, "ingress_point_id")

    @property
    @pulumi.getter(name="ingressPointName")
    def ingress_point_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A user friendly name for an ingress endpoint resource.
        """
        return pulumi.get(self, "ingress_point_name")

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> pulumi.Output[Optional[Any]]:
        """
        The network type (IPv4-only, Dual-Stack, PrivateLink) of the ingress endpoint resource.
        """
        return pulumi.get(self, "network_configuration")

    @property
    @pulumi.getter(name="ruleSetId")
    def rule_set_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of an existing rule set that you attach to an ingress endpoint resource.
        """
        return pulumi.get(self, "rule_set_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['MailManagerIngressPointIngressPointStatus']:
        """
        The status of the ingress endpoint resource.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusToUpdate")
    def status_to_update(self) -> pulumi.Output[Optional['MailManagerIngressPointIngressPointStatusToUpdate']]:
        """
        The update status of an ingress endpoint.
        """
        return pulumi.get(self, "status_to_update")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tags used to organize, track, or control access for the resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="trafficPolicyId")
    def traffic_policy_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of an existing traffic policy that you attach to an ingress endpoint resource.
        """
        return pulumi.get(self, "traffic_policy_id")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output['MailManagerIngressPointIngressPointType']:
        """
        The type of the ingress endpoint to create.
        """
        return pulumi.get(self, "type")

