# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetVdmAttributesResult',
    'AwaitableGetVdmAttributesResult',
    'get_vdm_attributes',
    'get_vdm_attributes_output',
]

@pulumi.output_type
class GetVdmAttributesResult:
    def __init__(__self__, dashboard_attributes=None, guardian_attributes=None, vdm_attributes_resource_id=None):
        if dashboard_attributes and not isinstance(dashboard_attributes, dict):
            raise TypeError("Expected argument 'dashboard_attributes' to be a dict")
        pulumi.set(__self__, "dashboard_attributes", dashboard_attributes)
        if guardian_attributes and not isinstance(guardian_attributes, dict):
            raise TypeError("Expected argument 'guardian_attributes' to be a dict")
        pulumi.set(__self__, "guardian_attributes", guardian_attributes)
        if vdm_attributes_resource_id and not isinstance(vdm_attributes_resource_id, str):
            raise TypeError("Expected argument 'vdm_attributes_resource_id' to be a str")
        pulumi.set(__self__, "vdm_attributes_resource_id", vdm_attributes_resource_id)

    @property
    @pulumi.getter(name="dashboardAttributes")
    def dashboard_attributes(self) -> Optional['outputs.VdmAttributesDashboardAttributes']:
        """
        Specifies additional settings for your VDM configuration as applicable to the Dashboard.
        """
        return pulumi.get(self, "dashboard_attributes")

    @property
    @pulumi.getter(name="guardianAttributes")
    def guardian_attributes(self) -> Optional['outputs.VdmAttributesGuardianAttributes']:
        """
        Specifies additional settings for your VDM configuration as applicable to the Guardian.
        """
        return pulumi.get(self, "guardian_attributes")

    @property
    @pulumi.getter(name="vdmAttributesResourceId")
    def vdm_attributes_resource_id(self) -> Optional[builtins.str]:
        """
        Unique identifier for this resource
        """
        return pulumi.get(self, "vdm_attributes_resource_id")


class AwaitableGetVdmAttributesResult(GetVdmAttributesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVdmAttributesResult(
            dashboard_attributes=self.dashboard_attributes,
            guardian_attributes=self.guardian_attributes,
            vdm_attributes_resource_id=self.vdm_attributes_resource_id)


def get_vdm_attributes(vdm_attributes_resource_id: Optional[builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVdmAttributesResult:
    """
    Resource Type definition for AWS::SES::VdmAttributes


    :param builtins.str vdm_attributes_resource_id: Unique identifier for this resource
    """
    __args__ = dict()
    __args__['vdmAttributesResourceId'] = vdm_attributes_resource_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ses:getVdmAttributes', __args__, opts=opts, typ=GetVdmAttributesResult).value

    return AwaitableGetVdmAttributesResult(
        dashboard_attributes=pulumi.get(__ret__, 'dashboard_attributes'),
        guardian_attributes=pulumi.get(__ret__, 'guardian_attributes'),
        vdm_attributes_resource_id=pulumi.get(__ret__, 'vdm_attributes_resource_id'))
def get_vdm_attributes_output(vdm_attributes_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVdmAttributesResult]:
    """
    Resource Type definition for AWS::SES::VdmAttributes


    :param builtins.str vdm_attributes_resource_id: Unique identifier for this resource
    """
    __args__ = dict()
    __args__['vdmAttributesResourceId'] = vdm_attributes_resource_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ses:getVdmAttributes', __args__, opts=opts, typ=GetVdmAttributesResult)
    return __ret__.apply(lambda __response__: GetVdmAttributesResult(
        dashboard_attributes=pulumi.get(__response__, 'dashboard_attributes'),
        guardian_attributes=pulumi.get(__response__, 'guardian_attributes'),
        vdm_attributes_resource_id=pulumi.get(__response__, 'vdm_attributes_resource_id')))
