# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetMailManagerRuleSetResult',
    'AwaitableGetMailManagerRuleSetResult',
    'get_mail_manager_rule_set',
    'get_mail_manager_rule_set_output',
]

@pulumi.output_type
class GetMailManagerRuleSetResult:
    def __init__(__self__, rule_set_arn=None, rule_set_id=None, rule_set_name=None, rules=None, tags=None):
        if rule_set_arn and not isinstance(rule_set_arn, str):
            raise TypeError("Expected argument 'rule_set_arn' to be a str")
        pulumi.set(__self__, "rule_set_arn", rule_set_arn)
        if rule_set_id and not isinstance(rule_set_id, str):
            raise TypeError("Expected argument 'rule_set_id' to be a str")
        pulumi.set(__self__, "rule_set_id", rule_set_id)
        if rule_set_name and not isinstance(rule_set_name, str):
            raise TypeError("Expected argument 'rule_set_name' to be a str")
        pulumi.set(__self__, "rule_set_name", rule_set_name)
        if rules and not isinstance(rules, list):
            raise TypeError("Expected argument 'rules' to be a list")
        pulumi.set(__self__, "rules", rules)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="ruleSetArn")
    def rule_set_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the rule set resource.
        """
        return pulumi.get(self, "rule_set_arn")

    @property
    @pulumi.getter(name="ruleSetId")
    def rule_set_id(self) -> Optional[builtins.str]:
        """
        The identifier of the rule set.
        """
        return pulumi.get(self, "rule_set_id")

    @property
    @pulumi.getter(name="ruleSetName")
    def rule_set_name(self) -> Optional[builtins.str]:
        """
        A user-friendly name for the rule set.
        """
        return pulumi.get(self, "rule_set_name")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.MailManagerRuleSetRule']]:
        """
        Conditional rules that are evaluated for determining actions on email.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The tags used to organize, track, or control access for the resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
        """
        return pulumi.get(self, "tags")


class AwaitableGetMailManagerRuleSetResult(GetMailManagerRuleSetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMailManagerRuleSetResult(
            rule_set_arn=self.rule_set_arn,
            rule_set_id=self.rule_set_id,
            rule_set_name=self.rule_set_name,
            rules=self.rules,
            tags=self.tags)


def get_mail_manager_rule_set(rule_set_id: Optional[builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMailManagerRuleSetResult:
    """
    Definition of AWS::SES::MailManagerRuleSet Resource Type


    :param builtins.str rule_set_id: The identifier of the rule set.
    """
    __args__ = dict()
    __args__['ruleSetId'] = rule_set_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ses:getMailManagerRuleSet', __args__, opts=opts, typ=GetMailManagerRuleSetResult).value

    return AwaitableGetMailManagerRuleSetResult(
        rule_set_arn=pulumi.get(__ret__, 'rule_set_arn'),
        rule_set_id=pulumi.get(__ret__, 'rule_set_id'),
        rule_set_name=pulumi.get(__ret__, 'rule_set_name'),
        rules=pulumi.get(__ret__, 'rules'),
        tags=pulumi.get(__ret__, 'tags'))
def get_mail_manager_rule_set_output(rule_set_id: Optional[pulumi.Input[builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMailManagerRuleSetResult]:
    """
    Definition of AWS::SES::MailManagerRuleSet Resource Type


    :param builtins.str rule_set_id: The identifier of the rule set.
    """
    __args__ = dict()
    __args__['ruleSetId'] = rule_set_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ses:getMailManagerRuleSet', __args__, opts=opts, typ=GetMailManagerRuleSetResult)
    return __ret__.apply(lambda __response__: GetMailManagerRuleSetResult(
        rule_set_arn=pulumi.get(__response__, 'rule_set_arn'),
        rule_set_id=pulumi.get(__response__, 'rule_set_id'),
        rule_set_name=pulumi.get(__response__, 'rule_set_name'),
        rules=pulumi.get(__response__, 'rules'),
        tags=pulumi.get(__response__, 'tags')))
