# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetMailManagerIngressPointResult',
    'AwaitableGetMailManagerIngressPointResult',
    'get_mail_manager_ingress_point',
    'get_mail_manager_ingress_point_output',
]

@pulumi.output_type
class GetMailManagerIngressPointResult:
    def __init__(__self__, a_record=None, ingress_point_arn=None, ingress_point_id=None, ingress_point_name=None, rule_set_id=None, status=None, status_to_update=None, tags=None, traffic_policy_id=None):
        if a_record and not isinstance(a_record, str):
            raise TypeError("Expected argument 'a_record' to be a str")
        pulumi.set(__self__, "a_record", a_record)
        if ingress_point_arn and not isinstance(ingress_point_arn, str):
            raise TypeError("Expected argument 'ingress_point_arn' to be a str")
        pulumi.set(__self__, "ingress_point_arn", ingress_point_arn)
        if ingress_point_id and not isinstance(ingress_point_id, str):
            raise TypeError("Expected argument 'ingress_point_id' to be a str")
        pulumi.set(__self__, "ingress_point_id", ingress_point_id)
        if ingress_point_name and not isinstance(ingress_point_name, str):
            raise TypeError("Expected argument 'ingress_point_name' to be a str")
        pulumi.set(__self__, "ingress_point_name", ingress_point_name)
        if rule_set_id and not isinstance(rule_set_id, str):
            raise TypeError("Expected argument 'rule_set_id' to be a str")
        pulumi.set(__self__, "rule_set_id", rule_set_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if status_to_update and not isinstance(status_to_update, str):
            raise TypeError("Expected argument 'status_to_update' to be a str")
        pulumi.set(__self__, "status_to_update", status_to_update)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if traffic_policy_id and not isinstance(traffic_policy_id, str):
            raise TypeError("Expected argument 'traffic_policy_id' to be a str")
        pulumi.set(__self__, "traffic_policy_id", traffic_policy_id)

    @property
    @pulumi.getter(name="aRecord")
    def a_record(self) -> Optional[builtins.str]:
        """
        The DNS A Record that identifies your ingress endpoint. Configure your DNS Mail Exchange (MX) record with this value to route emails to Mail Manager.
        """
        return pulumi.get(self, "a_record")

    @property
    @pulumi.getter(name="ingressPointArn")
    def ingress_point_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the ingress endpoint resource.
        """
        return pulumi.get(self, "ingress_point_arn")

    @property
    @pulumi.getter(name="ingressPointId")
    def ingress_point_id(self) -> Optional[builtins.str]:
        """
        The identifier of the ingress endpoint resource.
        """
        return pulumi.get(self, "ingress_point_id")

    @property
    @pulumi.getter(name="ingressPointName")
    def ingress_point_name(self) -> Optional[builtins.str]:
        """
        A user friendly name for an ingress endpoint resource.
        """
        return pulumi.get(self, "ingress_point_name")

    @property
    @pulumi.getter(name="ruleSetId")
    def rule_set_id(self) -> Optional[builtins.str]:
        """
        The identifier of an existing rule set that you attach to an ingress endpoint resource.
        """
        return pulumi.get(self, "rule_set_id")

    @property
    @pulumi.getter
    def status(self) -> Optional['MailManagerIngressPointIngressPointStatus']:
        """
        The status of the ingress endpoint resource.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusToUpdate")
    def status_to_update(self) -> Optional['MailManagerIngressPointIngressPointStatusToUpdate']:
        """
        The update status of an ingress endpoint.
        """
        return pulumi.get(self, "status_to_update")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The tags used to organize, track, or control access for the resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="trafficPolicyId")
    def traffic_policy_id(self) -> Optional[builtins.str]:
        """
        The identifier of an existing traffic policy that you attach to an ingress endpoint resource.
        """
        return pulumi.get(self, "traffic_policy_id")


class AwaitableGetMailManagerIngressPointResult(GetMailManagerIngressPointResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMailManagerIngressPointResult(
            a_record=self.a_record,
            ingress_point_arn=self.ingress_point_arn,
            ingress_point_id=self.ingress_point_id,
            ingress_point_name=self.ingress_point_name,
            rule_set_id=self.rule_set_id,
            status=self.status,
            status_to_update=self.status_to_update,
            tags=self.tags,
            traffic_policy_id=self.traffic_policy_id)


def get_mail_manager_ingress_point(ingress_point_id: Optional[builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMailManagerIngressPointResult:
    """
    Definition of AWS::SES::MailManagerIngressPoint Resource Type


    :param builtins.str ingress_point_id: The identifier of the ingress endpoint resource.
    """
    __args__ = dict()
    __args__['ingressPointId'] = ingress_point_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ses:getMailManagerIngressPoint', __args__, opts=opts, typ=GetMailManagerIngressPointResult).value

    return AwaitableGetMailManagerIngressPointResult(
        a_record=pulumi.get(__ret__, 'a_record'),
        ingress_point_arn=pulumi.get(__ret__, 'ingress_point_arn'),
        ingress_point_id=pulumi.get(__ret__, 'ingress_point_id'),
        ingress_point_name=pulumi.get(__ret__, 'ingress_point_name'),
        rule_set_id=pulumi.get(__ret__, 'rule_set_id'),
        status=pulumi.get(__ret__, 'status'),
        status_to_update=pulumi.get(__ret__, 'status_to_update'),
        tags=pulumi.get(__ret__, 'tags'),
        traffic_policy_id=pulumi.get(__ret__, 'traffic_policy_id'))
def get_mail_manager_ingress_point_output(ingress_point_id: Optional[pulumi.Input[builtins.str]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMailManagerIngressPointResult]:
    """
    Definition of AWS::SES::MailManagerIngressPoint Resource Type


    :param builtins.str ingress_point_id: The identifier of the ingress endpoint resource.
    """
    __args__ = dict()
    __args__['ingressPointId'] = ingress_point_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ses:getMailManagerIngressPoint', __args__, opts=opts, typ=GetMailManagerIngressPointResult)
    return __ret__.apply(lambda __response__: GetMailManagerIngressPointResult(
        a_record=pulumi.get(__response__, 'a_record'),
        ingress_point_arn=pulumi.get(__response__, 'ingress_point_arn'),
        ingress_point_id=pulumi.get(__response__, 'ingress_point_id'),
        ingress_point_name=pulumi.get(__response__, 'ingress_point_name'),
        rule_set_id=pulumi.get(__response__, 'rule_set_id'),
        status=pulumi.get(__response__, 'status'),
        status_to_update=pulumi.get(__response__, 'status_to_update'),
        tags=pulumi.get(__response__, 'tags'),
        traffic_policy_id=pulumi.get(__response__, 'traffic_policy_id')))
