# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDedicatedIpPoolResult',
    'AwaitableGetDedicatedIpPoolResult',
    'get_dedicated_ip_pool',
    'get_dedicated_ip_pool_output',
]

@pulumi.output_type
class GetDedicatedIpPoolResult:
    def __init__(__self__, scaling_mode=None):
        if scaling_mode and not isinstance(scaling_mode, str):
            raise TypeError("Expected argument 'scaling_mode' to be a str")
        pulumi.set(__self__, "scaling_mode", scaling_mode)

    @property
    @pulumi.getter(name="scalingMode")
    def scaling_mode(self) -> Optional[builtins.str]:
        """
        Specifies whether the dedicated IP pool is managed or not. The default value is STANDARD.
        """
        return pulumi.get(self, "scaling_mode")


class AwaitableGetDedicatedIpPoolResult(GetDedicatedIpPoolResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDedicatedIpPoolResult(
            scaling_mode=self.scaling_mode)


def get_dedicated_ip_pool(pool_name: Optional[builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDedicatedIpPoolResult:
    """
    Resource Type definition for AWS::SES::DedicatedIpPool


    :param builtins.str pool_name: The name of the dedicated IP pool.
    """
    __args__ = dict()
    __args__['poolName'] = pool_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ses:getDedicatedIpPool', __args__, opts=opts, typ=GetDedicatedIpPoolResult).value

    return AwaitableGetDedicatedIpPoolResult(
        scaling_mode=pulumi.get(__ret__, 'scaling_mode'))
def get_dedicated_ip_pool_output(pool_name: Optional[pulumi.Input[builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDedicatedIpPoolResult]:
    """
    Resource Type definition for AWS::SES::DedicatedIpPool


    :param builtins.str pool_name: The name of the dedicated IP pool.
    """
    __args__ = dict()
    __args__['poolName'] = pool_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ses:getDedicatedIpPool', __args__, opts=opts, typ=GetDedicatedIpPoolResult)
    return __ret__.apply(lambda __response__: GetDedicatedIpPoolResult(
        scaling_mode=pulumi.get(__response__, 'scaling_mode')))
