# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ServiceActionAssociationArgs', 'ServiceActionAssociation']

@pulumi.input_type
class ServiceActionAssociationArgs:
    def __init__(__self__, *,
                 product_id: pulumi.Input[builtins.str],
                 provisioning_artifact_id: pulumi.Input[builtins.str],
                 service_action_id: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a ServiceActionAssociation resource.
        :param pulumi.Input[builtins.str] product_id: The product identifier. For example, `prod-abcdzk7xy33qa` .
        :param pulumi.Input[builtins.str] provisioning_artifact_id: The identifier of the provisioning artifact. For example, `pa-4abcdjnxjj6ne` .
        :param pulumi.Input[builtins.str] service_action_id: The self-service action identifier. For example, `act-fs7abcd89wxyz` .
        """
        pulumi.set(__self__, "product_id", product_id)
        pulumi.set(__self__, "provisioning_artifact_id", provisioning_artifact_id)
        pulumi.set(__self__, "service_action_id", service_action_id)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Input[builtins.str]:
        """
        The product identifier. For example, `prod-abcdzk7xy33qa` .
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "product_id", value)

    @property
    @pulumi.getter(name="provisioningArtifactId")
    def provisioning_artifact_id(self) -> pulumi.Input[builtins.str]:
        """
        The identifier of the provisioning artifact. For example, `pa-4abcdjnxjj6ne` .
        """
        return pulumi.get(self, "provisioning_artifact_id")

    @provisioning_artifact_id.setter
    def provisioning_artifact_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "provisioning_artifact_id", value)

    @property
    @pulumi.getter(name="serviceActionId")
    def service_action_id(self) -> pulumi.Input[builtins.str]:
        """
        The self-service action identifier. For example, `act-fs7abcd89wxyz` .
        """
        return pulumi.get(self, "service_action_id")

    @service_action_id.setter
    def service_action_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_action_id", value)


@pulumi.type_token("aws-native:servicecatalog:ServiceActionAssociation")
class ServiceActionAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 product_id: Optional[pulumi.Input[builtins.str]] = None,
                 provisioning_artifact_id: Optional[pulumi.Input[builtins.str]] = None,
                 service_action_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource Schema for AWS::ServiceCatalog::ServiceActionAssociation

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] product_id: The product identifier. For example, `prod-abcdzk7xy33qa` .
        :param pulumi.Input[builtins.str] provisioning_artifact_id: The identifier of the provisioning artifact. For example, `pa-4abcdjnxjj6ne` .
        :param pulumi.Input[builtins.str] service_action_id: The self-service action identifier. For example, `act-fs7abcd89wxyz` .
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceActionAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Schema for AWS::ServiceCatalog::ServiceActionAssociation

        :param str resource_name: The name of the resource.
        :param ServiceActionAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceActionAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 product_id: Optional[pulumi.Input[builtins.str]] = None,
                 provisioning_artifact_id: Optional[pulumi.Input[builtins.str]] = None,
                 service_action_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceActionAssociationArgs.__new__(ServiceActionAssociationArgs)

            if product_id is None and not opts.urn:
                raise TypeError("Missing required property 'product_id'")
            __props__.__dict__["product_id"] = product_id
            if provisioning_artifact_id is None and not opts.urn:
                raise TypeError("Missing required property 'provisioning_artifact_id'")
            __props__.__dict__["provisioning_artifact_id"] = provisioning_artifact_id
            if service_action_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_action_id'")
            __props__.__dict__["service_action_id"] = service_action_id
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["productId", "provisioningArtifactId", "serviceActionId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(ServiceActionAssociation, __self__).__init__(
            'aws-native:servicecatalog:ServiceActionAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ServiceActionAssociation':
        """
        Get an existing ServiceActionAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ServiceActionAssociationArgs.__new__(ServiceActionAssociationArgs)

        __props__.__dict__["product_id"] = None
        __props__.__dict__["provisioning_artifact_id"] = None
        __props__.__dict__["service_action_id"] = None
        return ServiceActionAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Output[builtins.str]:
        """
        The product identifier. For example, `prod-abcdzk7xy33qa` .
        """
        return pulumi.get(self, "product_id")

    @property
    @pulumi.getter(name="provisioningArtifactId")
    def provisioning_artifact_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the provisioning artifact. For example, `pa-4abcdjnxjj6ne` .
        """
        return pulumi.get(self, "provisioning_artifact_id")

    @property
    @pulumi.getter(name="serviceActionId")
    def service_action_id(self) -> pulumi.Output[builtins.str]:
        """
        The self-service action identifier. For example, `act-fs7abcd89wxyz` .
        """
        return pulumi.get(self, "service_action_id")

