# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'CloudFormationProvisionedProductProvisioningParameter',
    'CloudFormationProvisionedProductProvisioningPreferences',
    'ServiceActionDefinitionParameter',
]

@pulumi.output_type
class CloudFormationProvisionedProductProvisioningParameter(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str key: The parameter key.
        :param builtins.str value: The parameter value.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The parameter key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The parameter value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class CloudFormationProvisionedProductProvisioningPreferences(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stackSetAccounts":
            suggest = "stack_set_accounts"
        elif key == "stackSetFailureToleranceCount":
            suggest = "stack_set_failure_tolerance_count"
        elif key == "stackSetFailureTolerancePercentage":
            suggest = "stack_set_failure_tolerance_percentage"
        elif key == "stackSetMaxConcurrencyCount":
            suggest = "stack_set_max_concurrency_count"
        elif key == "stackSetMaxConcurrencyPercentage":
            suggest = "stack_set_max_concurrency_percentage"
        elif key == "stackSetOperationType":
            suggest = "stack_set_operation_type"
        elif key == "stackSetRegions":
            suggest = "stack_set_regions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudFormationProvisionedProductProvisioningPreferences. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudFormationProvisionedProductProvisioningPreferences.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudFormationProvisionedProductProvisioningPreferences.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 stack_set_accounts: Optional[Sequence[builtins.str]] = None,
                 stack_set_failure_tolerance_count: Optional[builtins.int] = None,
                 stack_set_failure_tolerance_percentage: Optional[builtins.int] = None,
                 stack_set_max_concurrency_count: Optional[builtins.int] = None,
                 stack_set_max_concurrency_percentage: Optional[builtins.int] = None,
                 stack_set_operation_type: Optional['CloudFormationProvisionedProductProvisioningPreferencesStackSetOperationType'] = None,
                 stack_set_regions: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] stack_set_accounts: One or more AWS accounts where the provisioned product will be available.
               
               Applicable only to a `CFN_STACKSET` provisioned product type.
               
               The specified accounts should be within the list of accounts from the `STACKSET` constraint. To get the list of accounts in the `STACKSET` constraint, use the `DescribeProvisioningParameters` operation.
               
               If no values are specified, the default value is all acounts from the `STACKSET` constraint.
        :param builtins.int stack_set_failure_tolerance_count: The number of accounts, per Region, for which this operation can fail before AWS Service Catalog stops the operation in that Region. If the operation is stopped in a Region, AWS Service Catalog doesn't attempt the operation in any subsequent Regions.
               
               Applicable only to a `CFN_STACKSET` provisioned product type.
               
               Conditional: You must specify either `StackSetFailureToleranceCount` or `StackSetFailureTolerancePercentage` , but not both.
               
               The default value is `0` if no value is specified.
        :param builtins.int stack_set_failure_tolerance_percentage: The percentage of accounts, per Region, for which this stack operation can fail before AWS Service Catalog stops the operation in that Region. If the operation is stopped in a Region, AWS Service Catalog doesn't attempt the operation in any subsequent Regions.
               
               When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to the next whole number.
               
               Applicable only to a `CFN_STACKSET` provisioned product type.
               
               Conditional: You must specify either `StackSetFailureToleranceCount` or `StackSetFailureTolerancePercentage` , but not both.
        :param builtins.int stack_set_max_concurrency_count: The maximum number of accounts in which to perform this operation at one time. This is dependent on the value of `StackSetFailureToleranceCount` . `StackSetMaxConcurrentCount` is at most one more than the `StackSetFailureToleranceCount` .
               
               Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.
               
               Applicable only to a `CFN_STACKSET` provisioned product type.
               
               Conditional: You must specify either `StackSetMaxConcurrentCount` or `StackSetMaxConcurrentPercentage` , but not both.
        :param builtins.int stack_set_max_concurrency_percentage: The maximum percentage of accounts in which to perform this operation at one time.
               
               When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to the next whole number. This is true except in cases where rounding down would result is zero. In this case, AWS Service Catalog sets the number as `1` instead.
               
               Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.
               
               Applicable only to a `CFN_STACKSET` provisioned product type.
               
               Conditional: You must specify either `StackSetMaxConcurrentCount` or `StackSetMaxConcurrentPercentage` , but not both.
        :param 'CloudFormationProvisionedProductProvisioningPreferencesStackSetOperationType' stack_set_operation_type: Determines what action AWS Service Catalog performs to a stack set or a stack instance represented by the provisioned product. The default value is `UPDATE` if nothing is specified.
               
               Applicable only to a `CFN_STACKSET` provisioned product type.
               
               - **CREATE** - Creates a new stack instance in the stack set represented by the provisioned product. In this case, only new stack instances are created based on accounts and Regions; if new ProductId or ProvisioningArtifactID are passed, they will be ignored.
               - **UPDATE** - Updates the stack set represented by the provisioned product and also its stack instances.
               - **DELETE** - Deletes a stack instance in the stack set represented by the provisioned product.
        :param Sequence[builtins.str] stack_set_regions: One or more AWS Regions where the provisioned product will be available.
               
               Applicable only to a `CFN_STACKSET` provisioned product type.
               
               The specified Regions should be within the list of Regions from the `STACKSET` constraint. To get the list of Regions in the `STACKSET` constraint, use the `DescribeProvisioningParameters` operation.
               
               If no values are specified, the default value is all Regions from the `STACKSET` constraint.
        """
        if stack_set_accounts is not None:
            pulumi.set(__self__, "stack_set_accounts", stack_set_accounts)
        if stack_set_failure_tolerance_count is not None:
            pulumi.set(__self__, "stack_set_failure_tolerance_count", stack_set_failure_tolerance_count)
        if stack_set_failure_tolerance_percentage is not None:
            pulumi.set(__self__, "stack_set_failure_tolerance_percentage", stack_set_failure_tolerance_percentage)
        if stack_set_max_concurrency_count is not None:
            pulumi.set(__self__, "stack_set_max_concurrency_count", stack_set_max_concurrency_count)
        if stack_set_max_concurrency_percentage is not None:
            pulumi.set(__self__, "stack_set_max_concurrency_percentage", stack_set_max_concurrency_percentage)
        if stack_set_operation_type is not None:
            pulumi.set(__self__, "stack_set_operation_type", stack_set_operation_type)
        if stack_set_regions is not None:
            pulumi.set(__self__, "stack_set_regions", stack_set_regions)

    @property
    @pulumi.getter(name="stackSetAccounts")
    def stack_set_accounts(self) -> Optional[Sequence[builtins.str]]:
        """
        One or more AWS accounts where the provisioned product will be available.

        Applicable only to a `CFN_STACKSET` provisioned product type.

        The specified accounts should be within the list of accounts from the `STACKSET` constraint. To get the list of accounts in the `STACKSET` constraint, use the `DescribeProvisioningParameters` operation.

        If no values are specified, the default value is all acounts from the `STACKSET` constraint.
        """
        return pulumi.get(self, "stack_set_accounts")

    @property
    @pulumi.getter(name="stackSetFailureToleranceCount")
    def stack_set_failure_tolerance_count(self) -> Optional[builtins.int]:
        """
        The number of accounts, per Region, for which this operation can fail before AWS Service Catalog stops the operation in that Region. If the operation is stopped in a Region, AWS Service Catalog doesn't attempt the operation in any subsequent Regions.

        Applicable only to a `CFN_STACKSET` provisioned product type.

        Conditional: You must specify either `StackSetFailureToleranceCount` or `StackSetFailureTolerancePercentage` , but not both.

        The default value is `0` if no value is specified.
        """
        return pulumi.get(self, "stack_set_failure_tolerance_count")

    @property
    @pulumi.getter(name="stackSetFailureTolerancePercentage")
    def stack_set_failure_tolerance_percentage(self) -> Optional[builtins.int]:
        """
        The percentage of accounts, per Region, for which this stack operation can fail before AWS Service Catalog stops the operation in that Region. If the operation is stopped in a Region, AWS Service Catalog doesn't attempt the operation in any subsequent Regions.

        When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to the next whole number.

        Applicable only to a `CFN_STACKSET` provisioned product type.

        Conditional: You must specify either `StackSetFailureToleranceCount` or `StackSetFailureTolerancePercentage` , but not both.
        """
        return pulumi.get(self, "stack_set_failure_tolerance_percentage")

    @property
    @pulumi.getter(name="stackSetMaxConcurrencyCount")
    def stack_set_max_concurrency_count(self) -> Optional[builtins.int]:
        """
        The maximum number of accounts in which to perform this operation at one time. This is dependent on the value of `StackSetFailureToleranceCount` . `StackSetMaxConcurrentCount` is at most one more than the `StackSetFailureToleranceCount` .

        Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.

        Applicable only to a `CFN_STACKSET` provisioned product type.

        Conditional: You must specify either `StackSetMaxConcurrentCount` or `StackSetMaxConcurrentPercentage` , but not both.
        """
        return pulumi.get(self, "stack_set_max_concurrency_count")

    @property
    @pulumi.getter(name="stackSetMaxConcurrencyPercentage")
    def stack_set_max_concurrency_percentage(self) -> Optional[builtins.int]:
        """
        The maximum percentage of accounts in which to perform this operation at one time.

        When calculating the number of accounts based on the specified percentage, AWS Service Catalog rounds down to the next whole number. This is true except in cases where rounding down would result is zero. In this case, AWS Service Catalog sets the number as `1` instead.

        Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.

        Applicable only to a `CFN_STACKSET` provisioned product type.

        Conditional: You must specify either `StackSetMaxConcurrentCount` or `StackSetMaxConcurrentPercentage` , but not both.
        """
        return pulumi.get(self, "stack_set_max_concurrency_percentage")

    @property
    @pulumi.getter(name="stackSetOperationType")
    def stack_set_operation_type(self) -> Optional['CloudFormationProvisionedProductProvisioningPreferencesStackSetOperationType']:
        """
        Determines what action AWS Service Catalog performs to a stack set or a stack instance represented by the provisioned product. The default value is `UPDATE` if nothing is specified.

        Applicable only to a `CFN_STACKSET` provisioned product type.

        - **CREATE** - Creates a new stack instance in the stack set represented by the provisioned product. In this case, only new stack instances are created based on accounts and Regions; if new ProductId or ProvisioningArtifactID are passed, they will be ignored.
        - **UPDATE** - Updates the stack set represented by the provisioned product and also its stack instances.
        - **DELETE** - Deletes a stack instance in the stack set represented by the provisioned product.
        """
        return pulumi.get(self, "stack_set_operation_type")

    @property
    @pulumi.getter(name="stackSetRegions")
    def stack_set_regions(self) -> Optional[Sequence[builtins.str]]:
        """
        One or more AWS Regions where the provisioned product will be available.

        Applicable only to a `CFN_STACKSET` provisioned product type.

        The specified Regions should be within the list of Regions from the `STACKSET` constraint. To get the list of Regions in the `STACKSET` constraint, use the `DescribeProvisioningParameters` operation.

        If no values are specified, the default value is all Regions from the `STACKSET` constraint.
        """
        return pulumi.get(self, "stack_set_regions")


@pulumi.output_type
class ServiceActionDefinitionParameter(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str key: The parameter key.
        :param builtins.str value: The value of the parameter.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The parameter key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the parameter.
        """
        return pulumi.get(self, "value")


