# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetCloudFormationProvisionedProductResult',
    'AwaitableGetCloudFormationProvisionedProductResult',
    'get_cloud_formation_provisioned_product',
    'get_cloud_formation_provisioned_product_output',
]

@pulumi.output_type
class GetCloudFormationProvisionedProductResult:
    def __init__(__self__, accept_language=None, cloudformation_stack_arn=None, outputs=None, path_id=None, path_name=None, product_id=None, product_name=None, provisioned_product_id=None, provisioning_artifact_id=None, provisioning_artifact_name=None, provisioning_parameters=None, provisioning_preferences=None, record_id=None, tags=None):
        if accept_language and not isinstance(accept_language, str):
            raise TypeError("Expected argument 'accept_language' to be a str")
        pulumi.set(__self__, "accept_language", accept_language)
        if cloudformation_stack_arn and not isinstance(cloudformation_stack_arn, str):
            raise TypeError("Expected argument 'cloudformation_stack_arn' to be a str")
        pulumi.set(__self__, "cloudformation_stack_arn", cloudformation_stack_arn)
        if outputs and not isinstance(outputs, dict):
            raise TypeError("Expected argument 'outputs' to be a dict")
        pulumi.set(__self__, "outputs", outputs)
        if path_id and not isinstance(path_id, str):
            raise TypeError("Expected argument 'path_id' to be a str")
        pulumi.set(__self__, "path_id", path_id)
        if path_name and not isinstance(path_name, str):
            raise TypeError("Expected argument 'path_name' to be a str")
        pulumi.set(__self__, "path_name", path_name)
        if product_id and not isinstance(product_id, str):
            raise TypeError("Expected argument 'product_id' to be a str")
        pulumi.set(__self__, "product_id", product_id)
        if product_name and not isinstance(product_name, str):
            raise TypeError("Expected argument 'product_name' to be a str")
        pulumi.set(__self__, "product_name", product_name)
        if provisioned_product_id and not isinstance(provisioned_product_id, str):
            raise TypeError("Expected argument 'provisioned_product_id' to be a str")
        pulumi.set(__self__, "provisioned_product_id", provisioned_product_id)
        if provisioning_artifact_id and not isinstance(provisioning_artifact_id, str):
            raise TypeError("Expected argument 'provisioning_artifact_id' to be a str")
        pulumi.set(__self__, "provisioning_artifact_id", provisioning_artifact_id)
        if provisioning_artifact_name and not isinstance(provisioning_artifact_name, str):
            raise TypeError("Expected argument 'provisioning_artifact_name' to be a str")
        pulumi.set(__self__, "provisioning_artifact_name", provisioning_artifact_name)
        if provisioning_parameters and not isinstance(provisioning_parameters, list):
            raise TypeError("Expected argument 'provisioning_parameters' to be a list")
        pulumi.set(__self__, "provisioning_parameters", provisioning_parameters)
        if provisioning_preferences and not isinstance(provisioning_preferences, dict):
            raise TypeError("Expected argument 'provisioning_preferences' to be a dict")
        pulumi.set(__self__, "provisioning_preferences", provisioning_preferences)
        if record_id and not isinstance(record_id, str):
            raise TypeError("Expected argument 'record_id' to be a str")
        pulumi.set(__self__, "record_id", record_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="acceptLanguage")
    def accept_language(self) -> Optional['CloudFormationProvisionedProductAcceptLanguage']:
        """
        The language code.

        - `jp` - Japanese
        - `zh` - Chinese
        """
        return pulumi.get(self, "accept_language")

    @property
    @pulumi.getter(name="cloudformationStackArn")
    def cloudformation_stack_arn(self) -> Optional[builtins.str]:
        return pulumi.get(self, "cloudformation_stack_arn")

    @property
    @pulumi.getter
    def outputs(self) -> Optional[Mapping[str, builtins.str]]:
        """
        List of key-value pair outputs.
        """
        return pulumi.get(self, "outputs")

    @property
    @pulumi.getter(name="pathId")
    def path_id(self) -> Optional[builtins.str]:
        """
        The path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use [ListLaunchPaths](https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListLaunchPaths.html) .

        > You must provide the name or ID, but not both.
        """
        return pulumi.get(self, "path_id")

    @property
    @pulumi.getter(name="pathName")
    def path_name(self) -> Optional[builtins.str]:
        """
        The name of the path. This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use [ListLaunchPaths](https://docs.aws.amazon.com/servicecatalog/latest/dg/API_ListLaunchPaths.html) .

        > You must provide the name or ID, but not both.
        """
        return pulumi.get(self, "path_name")

    @property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[builtins.str]:
        """
        The product identifier.

        > You must specify either the ID or the name of the product, but not both.
        """
        return pulumi.get(self, "product_id")

    @property
    @pulumi.getter(name="productName")
    def product_name(self) -> Optional[builtins.str]:
        """
        The name of the Service Catalog product.

        Each time a stack is created or updated, if `ProductName` is provided it will successfully resolve to `ProductId` as long as only one product exists in the account or Region with that `ProductName` .

        > You must specify either the name or the ID of the product, but not both.
        """
        return pulumi.get(self, "product_name")

    @property
    @pulumi.getter(name="provisionedProductId")
    def provisioned_product_id(self) -> Optional[builtins.str]:
        """
        The ID of the provisioned product.
        """
        return pulumi.get(self, "provisioned_product_id")

    @property
    @pulumi.getter(name="provisioningArtifactId")
    def provisioning_artifact_id(self) -> Optional[builtins.str]:
        """
        The identifier of the provisioning artifact (also known as a version).

        > You must specify either the ID or the name of the provisioning artifact, but not both.
        """
        return pulumi.get(self, "provisioning_artifact_id")

    @property
    @pulumi.getter(name="provisioningArtifactName")
    def provisioning_artifact_name(self) -> Optional[builtins.str]:
        """
        The name of the provisioning artifact (also known as a version) for the product. This name must be unique for the product.

        > You must specify either the name or the ID of the provisioning artifact, but not both. You must also specify either the name or the ID of the product, but not both.
        """
        return pulumi.get(self, "provisioning_artifact_name")

    @property
    @pulumi.getter(name="provisioningParameters")
    def provisioning_parameters(self) -> Optional[Sequence['outputs.CloudFormationProvisionedProductProvisioningParameter']]:
        """
        Parameters specified by the administrator that are required for provisioning the product.
        """
        return pulumi.get(self, "provisioning_parameters")

    @property
    @pulumi.getter(name="provisioningPreferences")
    def provisioning_preferences(self) -> Optional['outputs.CloudFormationProvisionedProductProvisioningPreferences']:
        """
        StackSet preferences that are required for provisioning the product or updating a provisioned product.
        """
        return pulumi.get(self, "provisioning_preferences")

    @property
    @pulumi.getter(name="recordId")
    def record_id(self) -> Optional[builtins.str]:
        """
        The ID of the record, such as `rec-rjeatvy434trk` .
        """
        return pulumi.get(self, "record_id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        One or more tags.

        > Requires the provisioned product to have an [ResourceUpdateConstraint](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-servicecatalog-resourceupdateconstraint.html) resource with `TagUpdatesOnProvisionedProduct` set to `ALLOWED` to allow tag updates. If `RESOURCE_UPDATE` constraint is not present, tags updates are ignored.
        """
        return pulumi.get(self, "tags")


class AwaitableGetCloudFormationProvisionedProductResult(GetCloudFormationProvisionedProductResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCloudFormationProvisionedProductResult(
            accept_language=self.accept_language,
            cloudformation_stack_arn=self.cloudformation_stack_arn,
            outputs=self.outputs,
            path_id=self.path_id,
            path_name=self.path_name,
            product_id=self.product_id,
            product_name=self.product_name,
            provisioned_product_id=self.provisioned_product_id,
            provisioning_artifact_id=self.provisioning_artifact_id,
            provisioning_artifact_name=self.provisioning_artifact_name,
            provisioning_parameters=self.provisioning_parameters,
            provisioning_preferences=self.provisioning_preferences,
            record_id=self.record_id,
            tags=self.tags)


def get_cloud_formation_provisioned_product(provisioned_product_id: Optional[builtins.str] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCloudFormationProvisionedProductResult:
    """
    Resource Schema for AWS::ServiceCatalog::CloudFormationProvisionedProduct


    :param builtins.str provisioned_product_id: The ID of the provisioned product.
    """
    __args__ = dict()
    __args__['provisionedProductId'] = provisioned_product_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:servicecatalog:getCloudFormationProvisionedProduct', __args__, opts=opts, typ=GetCloudFormationProvisionedProductResult).value

    return AwaitableGetCloudFormationProvisionedProductResult(
        accept_language=pulumi.get(__ret__, 'accept_language'),
        cloudformation_stack_arn=pulumi.get(__ret__, 'cloudformation_stack_arn'),
        outputs=pulumi.get(__ret__, 'outputs'),
        path_id=pulumi.get(__ret__, 'path_id'),
        path_name=pulumi.get(__ret__, 'path_name'),
        product_id=pulumi.get(__ret__, 'product_id'),
        product_name=pulumi.get(__ret__, 'product_name'),
        provisioned_product_id=pulumi.get(__ret__, 'provisioned_product_id'),
        provisioning_artifact_id=pulumi.get(__ret__, 'provisioning_artifact_id'),
        provisioning_artifact_name=pulumi.get(__ret__, 'provisioning_artifact_name'),
        provisioning_parameters=pulumi.get(__ret__, 'provisioning_parameters'),
        provisioning_preferences=pulumi.get(__ret__, 'provisioning_preferences'),
        record_id=pulumi.get(__ret__, 'record_id'),
        tags=pulumi.get(__ret__, 'tags'))
def get_cloud_formation_provisioned_product_output(provisioned_product_id: Optional[pulumi.Input[builtins.str]] = None,
                                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCloudFormationProvisionedProductResult]:
    """
    Resource Schema for AWS::ServiceCatalog::CloudFormationProvisionedProduct


    :param builtins.str provisioned_product_id: The ID of the provisioned product.
    """
    __args__ = dict()
    __args__['provisionedProductId'] = provisioned_product_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:servicecatalog:getCloudFormationProvisionedProduct', __args__, opts=opts, typ=GetCloudFormationProvisionedProductResult)
    return __ret__.apply(lambda __response__: GetCloudFormationProvisionedProductResult(
        accept_language=pulumi.get(__response__, 'accept_language'),
        cloudformation_stack_arn=pulumi.get(__response__, 'cloudformation_stack_arn'),
        outputs=pulumi.get(__response__, 'outputs'),
        path_id=pulumi.get(__response__, 'path_id'),
        path_name=pulumi.get(__response__, 'path_name'),
        product_id=pulumi.get(__response__, 'product_id'),
        product_name=pulumi.get(__response__, 'product_name'),
        provisioned_product_id=pulumi.get(__response__, 'provisioned_product_id'),
        provisioning_artifact_id=pulumi.get(__response__, 'provisioning_artifact_id'),
        provisioning_artifact_name=pulumi.get(__response__, 'provisioning_artifact_name'),
        provisioning_parameters=pulumi.get(__response__, 'provisioning_parameters'),
        provisioning_preferences=pulumi.get(__response__, 'provisioning_preferences'),
        record_id=pulumi.get(__response__, 'record_id'),
        tags=pulumi.get(__response__, 'tags')))
