# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAwsLogSourceResult',
    'AwaitableGetAwsLogSourceResult',
    'get_aws_log_source',
    'get_aws_log_source_output',
]

@pulumi.output_type
class GetAwsLogSourceResult:
    def __init__(__self__, accounts=None):
        if accounts and not isinstance(accounts, list):
            raise TypeError("Expected argument 'accounts' to be a list")
        pulumi.set(__self__, "accounts", accounts)

    @property
    @pulumi.getter
    def accounts(self) -> Optional[Sequence[builtins.str]]:
        """
        AWS account where you want to collect logs from.
        """
        return pulumi.get(self, "accounts")


class AwaitableGetAwsLogSourceResult(GetAwsLogSourceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAwsLogSourceResult(
            accounts=self.accounts)


def get_aws_log_source(source_name: Optional[builtins.str] = None,
                       source_version: Optional[builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAwsLogSourceResult:
    """
    Resource Type definition for AWS::SecurityLake::AwsLogSource


    :param builtins.str source_name: The name for a AWS source. This must be a Regionally unique value.
    :param builtins.str source_version: The version for a AWS source. This must be a Regionally unique value.
    """
    __args__ = dict()
    __args__['sourceName'] = source_name
    __args__['sourceVersion'] = source_version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:securitylake:getAwsLogSource', __args__, opts=opts, typ=GetAwsLogSourceResult).value

    return AwaitableGetAwsLogSourceResult(
        accounts=pulumi.get(__ret__, 'accounts'))
def get_aws_log_source_output(source_name: Optional[pulumi.Input[builtins.str]] = None,
                              source_version: Optional[pulumi.Input[builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAwsLogSourceResult]:
    """
    Resource Type definition for AWS::SecurityLake::AwsLogSource


    :param builtins.str source_name: The name for a AWS source. This must be a Regionally unique value.
    :param builtins.str source_version: The version for a AWS source. This must be a Regionally unique value.
    """
    __args__ = dict()
    __args__['sourceName'] = source_name
    __args__['sourceVersion'] = source_version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:securitylake:getAwsLogSource', __args__, opts=opts, typ=GetAwsLogSourceResult)
    return __ret__.apply(lambda __response__: GetAwsLogSourceResult(
        accounts=pulumi.get(__response__, 'accounts')))
