# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._inputs import *

__all__ = ['DataLakeArgs', 'DataLake']

@pulumi.input_type
class DataLakeArgs:
    def __init__(__self__, *,
                 encryption_configuration: Optional[pulumi.Input['DataLakeEncryptionConfigurationArgs']] = None,
                 lifecycle_configuration: Optional[pulumi.Input['DataLakeLifecycleConfigurationArgs']] = None,
                 meta_store_manager_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 replication_configuration: Optional[pulumi.Input['DataLakeReplicationConfigurationArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a DataLake resource.
        :param pulumi.Input['DataLakeEncryptionConfigurationArgs'] encryption_configuration: Provides encryption details of the Amazon Security Lake object.
        :param pulumi.Input['DataLakeLifecycleConfigurationArgs'] lifecycle_configuration: You can customize Security Lake to store data in your preferred AWS Regions for your preferred amount of time. Lifecycle management can help you comply with different compliance requirements. For more details, see [Lifecycle management](https://docs.aws.amazon.com//security-lake/latest/userguide/lifecycle-management.html) in the Amazon Security Lake User Guide.
        :param pulumi.Input[builtins.str] meta_store_manager_role_arn: The Amazon Resource Name (ARN) used to index AWS Glue table partitions that are generated by the ingestion and normalization of AWS log sources and custom sources.
        :param pulumi.Input['DataLakeReplicationConfigurationArgs'] replication_configuration: Provides replication details of Amazon Security Lake object.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of objects, one for each tag to associate with the data lake configuration. For each tag, you must specify both a tag key and a tag value. A tag value cannot be null, but it can be an empty string.
        """
        if encryption_configuration is not None:
            pulumi.set(__self__, "encryption_configuration", encryption_configuration)
        if lifecycle_configuration is not None:
            pulumi.set(__self__, "lifecycle_configuration", lifecycle_configuration)
        if meta_store_manager_role_arn is not None:
            pulumi.set(__self__, "meta_store_manager_role_arn", meta_store_manager_role_arn)
        if replication_configuration is not None:
            pulumi.set(__self__, "replication_configuration", replication_configuration)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> Optional[pulumi.Input['DataLakeEncryptionConfigurationArgs']]:
        """
        Provides encryption details of the Amazon Security Lake object.
        """
        return pulumi.get(self, "encryption_configuration")

    @encryption_configuration.setter
    def encryption_configuration(self, value: Optional[pulumi.Input['DataLakeEncryptionConfigurationArgs']]):
        pulumi.set(self, "encryption_configuration", value)

    @property
    @pulumi.getter(name="lifecycleConfiguration")
    def lifecycle_configuration(self) -> Optional[pulumi.Input['DataLakeLifecycleConfigurationArgs']]:
        """
        You can customize Security Lake to store data in your preferred AWS Regions for your preferred amount of time. Lifecycle management can help you comply with different compliance requirements. For more details, see [Lifecycle management](https://docs.aws.amazon.com//security-lake/latest/userguide/lifecycle-management.html) in the Amazon Security Lake User Guide.
        """
        return pulumi.get(self, "lifecycle_configuration")

    @lifecycle_configuration.setter
    def lifecycle_configuration(self, value: Optional[pulumi.Input['DataLakeLifecycleConfigurationArgs']]):
        pulumi.set(self, "lifecycle_configuration", value)

    @property
    @pulumi.getter(name="metaStoreManagerRoleArn")
    def meta_store_manager_role_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) used to index AWS Glue table partitions that are generated by the ingestion and normalization of AWS log sources and custom sources.
        """
        return pulumi.get(self, "meta_store_manager_role_arn")

    @meta_store_manager_role_arn.setter
    def meta_store_manager_role_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "meta_store_manager_role_arn", value)

    @property
    @pulumi.getter(name="replicationConfiguration")
    def replication_configuration(self) -> Optional[pulumi.Input['DataLakeReplicationConfigurationArgs']]:
        """
        Provides replication details of Amazon Security Lake object.
        """
        return pulumi.get(self, "replication_configuration")

    @replication_configuration.setter
    def replication_configuration(self, value: Optional[pulumi.Input['DataLakeReplicationConfigurationArgs']]):
        pulumi.set(self, "replication_configuration", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of objects, one for each tag to associate with the data lake configuration. For each tag, you must specify both a tag key and a tag value. A tag value cannot be null, but it can be an empty string.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:securitylake:DataLake")
class DataLake(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 encryption_configuration: Optional[pulumi.Input[Union['DataLakeEncryptionConfigurationArgs', 'DataLakeEncryptionConfigurationArgsDict']]] = None,
                 lifecycle_configuration: Optional[pulumi.Input[Union['DataLakeLifecycleConfigurationArgs', 'DataLakeLifecycleConfigurationArgsDict']]] = None,
                 meta_store_manager_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 replication_configuration: Optional[pulumi.Input[Union['DataLakeReplicationConfigurationArgs', 'DataLakeReplicationConfigurationArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::SecurityLake::DataLake

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DataLakeEncryptionConfigurationArgs', 'DataLakeEncryptionConfigurationArgsDict']] encryption_configuration: Provides encryption details of the Amazon Security Lake object.
        :param pulumi.Input[Union['DataLakeLifecycleConfigurationArgs', 'DataLakeLifecycleConfigurationArgsDict']] lifecycle_configuration: You can customize Security Lake to store data in your preferred AWS Regions for your preferred amount of time. Lifecycle management can help you comply with different compliance requirements. For more details, see [Lifecycle management](https://docs.aws.amazon.com//security-lake/latest/userguide/lifecycle-management.html) in the Amazon Security Lake User Guide.
        :param pulumi.Input[builtins.str] meta_store_manager_role_arn: The Amazon Resource Name (ARN) used to index AWS Glue table partitions that are generated by the ingestion and normalization of AWS log sources and custom sources.
        :param pulumi.Input[Union['DataLakeReplicationConfigurationArgs', 'DataLakeReplicationConfigurationArgsDict']] replication_configuration: Provides replication details of Amazon Security Lake object.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of objects, one for each tag to associate with the data lake configuration. For each tag, you must specify both a tag key and a tag value. A tag value cannot be null, but it can be an empty string.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[DataLakeArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::SecurityLake::DataLake

        :param str resource_name: The name of the resource.
        :param DataLakeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataLakeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 encryption_configuration: Optional[pulumi.Input[Union['DataLakeEncryptionConfigurationArgs', 'DataLakeEncryptionConfigurationArgsDict']]] = None,
                 lifecycle_configuration: Optional[pulumi.Input[Union['DataLakeLifecycleConfigurationArgs', 'DataLakeLifecycleConfigurationArgsDict']]] = None,
                 meta_store_manager_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 replication_configuration: Optional[pulumi.Input[Union['DataLakeReplicationConfigurationArgs', 'DataLakeReplicationConfigurationArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataLakeArgs.__new__(DataLakeArgs)

            __props__.__dict__["encryption_configuration"] = encryption_configuration
            __props__.__dict__["lifecycle_configuration"] = lifecycle_configuration
            __props__.__dict__["meta_store_manager_role_arn"] = meta_store_manager_role_arn
            __props__.__dict__["replication_configuration"] = replication_configuration
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["s3_bucket_arn"] = None
        super(DataLake, __self__).__init__(
            'aws-native:securitylake:DataLake',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DataLake':
        """
        Get an existing DataLake resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DataLakeArgs.__new__(DataLakeArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["encryption_configuration"] = None
        __props__.__dict__["lifecycle_configuration"] = None
        __props__.__dict__["meta_store_manager_role_arn"] = None
        __props__.__dict__["replication_configuration"] = None
        __props__.__dict__["s3_bucket_arn"] = None
        __props__.__dict__["tags"] = None
        return DataLake(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) created by you to provide to the subscriber.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> pulumi.Output[Optional['outputs.DataLakeEncryptionConfiguration']]:
        """
        Provides encryption details of the Amazon Security Lake object.
        """
        return pulumi.get(self, "encryption_configuration")

    @property
    @pulumi.getter(name="lifecycleConfiguration")
    def lifecycle_configuration(self) -> pulumi.Output[Optional['outputs.DataLakeLifecycleConfiguration']]:
        """
        You can customize Security Lake to store data in your preferred AWS Regions for your preferred amount of time. Lifecycle management can help you comply with different compliance requirements. For more details, see [Lifecycle management](https://docs.aws.amazon.com//security-lake/latest/userguide/lifecycle-management.html) in the Amazon Security Lake User Guide.
        """
        return pulumi.get(self, "lifecycle_configuration")

    @property
    @pulumi.getter(name="metaStoreManagerRoleArn")
    def meta_store_manager_role_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon Resource Name (ARN) used to index AWS Glue table partitions that are generated by the ingestion and normalization of AWS log sources and custom sources.
        """
        return pulumi.get(self, "meta_store_manager_role_arn")

    @property
    @pulumi.getter(name="replicationConfiguration")
    def replication_configuration(self) -> pulumi.Output[Optional['outputs.DataLakeReplicationConfiguration']]:
        """
        Provides replication details of Amazon Security Lake object.
        """
        return pulumi.get(self, "replication_configuration")

    @property
    @pulumi.getter(name="s3BucketArn")
    def s3_bucket_arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN for the Amazon Security Lake Amazon S3 bucket.
        """
        return pulumi.get(self, "s3_bucket_arn")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of objects, one for each tag to associate with the data lake configuration. For each tag, you must specify both a tag key and a tag value. A tag value cannot be null, but it can be an empty string.
        """
        return pulumi.get(self, "tags")

