# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['InsightArgs', 'Insight']

@pulumi.input_type
class InsightArgs:
    def __init__(__self__, *,
                 filters: pulumi.Input['InsightAwsSecurityFindingFiltersArgs'],
                 group_by_attribute: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Insight resource.
        :param pulumi.Input['InsightAwsSecurityFindingFiltersArgs'] filters: One or more attributes used to filter the findings included in the insight
        :param pulumi.Input[builtins.str] group_by_attribute: The grouping attribute for the insight's findings
        :param pulumi.Input[builtins.str] name: The name of a Security Hub insight
        """
        pulumi.set(__self__, "filters", filters)
        pulumi.set(__self__, "group_by_attribute", group_by_attribute)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def filters(self) -> pulumi.Input['InsightAwsSecurityFindingFiltersArgs']:
        """
        One or more attributes used to filter the findings included in the insight
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: pulumi.Input['InsightAwsSecurityFindingFiltersArgs']):
        pulumi.set(self, "filters", value)

    @property
    @pulumi.getter(name="groupByAttribute")
    def group_by_attribute(self) -> pulumi.Input[builtins.str]:
        """
        The grouping attribute for the insight's findings
        """
        return pulumi.get(self, "group_by_attribute")

    @group_by_attribute.setter
    def group_by_attribute(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "group_by_attribute", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of a Security Hub insight
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("aws-native:securityhub:Insight")
class Insight(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 filters: Optional[pulumi.Input[Union['InsightAwsSecurityFindingFiltersArgs', 'InsightAwsSecurityFindingFiltersArgsDict']]] = None,
                 group_by_attribute: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        The AWS::SecurityHub::Insight resource represents the AWS Security Hub Insight in your account. An AWS Security Hub insight is a collection of related findings.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['InsightAwsSecurityFindingFiltersArgs', 'InsightAwsSecurityFindingFiltersArgsDict']] filters: One or more attributes used to filter the findings included in the insight
        :param pulumi.Input[builtins.str] group_by_attribute: The grouping attribute for the insight's findings
        :param pulumi.Input[builtins.str] name: The name of a Security Hub insight
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InsightArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The AWS::SecurityHub::Insight resource represents the AWS Security Hub Insight in your account. An AWS Security Hub insight is a collection of related findings.

        :param str resource_name: The name of the resource.
        :param InsightArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InsightArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 filters: Optional[pulumi.Input[Union['InsightAwsSecurityFindingFiltersArgs', 'InsightAwsSecurityFindingFiltersArgsDict']]] = None,
                 group_by_attribute: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InsightArgs.__new__(InsightArgs)

            if filters is None and not opts.urn:
                raise TypeError("Missing required property 'filters'")
            __props__.__dict__["filters"] = filters
            if group_by_attribute is None and not opts.urn:
                raise TypeError("Missing required property 'group_by_attribute'")
            __props__.__dict__["group_by_attribute"] = group_by_attribute
            __props__.__dict__["name"] = name
            __props__.__dict__["insight_arn"] = None
        super(Insight, __self__).__init__(
            'aws-native:securityhub:Insight',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Insight':
        """
        Get an existing Insight resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = InsightArgs.__new__(InsightArgs)

        __props__.__dict__["filters"] = None
        __props__.__dict__["group_by_attribute"] = None
        __props__.__dict__["insight_arn"] = None
        __props__.__dict__["name"] = None
        return Insight(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def filters(self) -> pulumi.Output['outputs.InsightAwsSecurityFindingFilters']:
        """
        One or more attributes used to filter the findings included in the insight
        """
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="groupByAttribute")
    def group_by_attribute(self) -> pulumi.Output[builtins.str]:
        """
        The grouping attribute for the insight's findings
        """
        return pulumi.get(self, "group_by_attribute")

    @property
    @pulumi.getter(name="insightArn")
    def insight_arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of a Security Hub insight
        """
        return pulumi.get(self, "insight_arn")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of a Security Hub insight
        """
        return pulumi.get(self, "name")

