# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetProductSubscriptionResult',
    'AwaitableGetProductSubscriptionResult',
    'get_product_subscription',
    'get_product_subscription_output',
]

@pulumi.output_type
class GetProductSubscriptionResult:
    def __init__(__self__, product_subscription_arn=None):
        if product_subscription_arn and not isinstance(product_subscription_arn, str):
            raise TypeError("Expected argument 'product_subscription_arn' to be a str")
        pulumi.set(__self__, "product_subscription_arn", product_subscription_arn)

    @property
    @pulumi.getter(name="productSubscriptionArn")
    def product_subscription_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the product subscription for the account
        """
        return pulumi.get(self, "product_subscription_arn")


class AwaitableGetProductSubscriptionResult(GetProductSubscriptionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProductSubscriptionResult(
            product_subscription_arn=self.product_subscription_arn)


def get_product_subscription(product_subscription_arn: Optional[builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProductSubscriptionResult:
    """
    The AWS::SecurityHub::ProductSubscription resource represents a subscription to a service that is allowed to generate findings for your Security Hub account. One product subscription resource is created for each product enabled.


    :param builtins.str product_subscription_arn: The ARN of the product subscription for the account
    """
    __args__ = dict()
    __args__['productSubscriptionArn'] = product_subscription_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:securityhub:getProductSubscription', __args__, opts=opts, typ=GetProductSubscriptionResult).value

    return AwaitableGetProductSubscriptionResult(
        product_subscription_arn=pulumi.get(__ret__, 'product_subscription_arn'))
def get_product_subscription_output(product_subscription_arn: Optional[pulumi.Input[builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProductSubscriptionResult]:
    """
    The AWS::SecurityHub::ProductSubscription resource represents a subscription to a service that is allowed to generate findings for your Security Hub account. One product subscription resource is created for each product enabled.


    :param builtins.str product_subscription_arn: The ARN of the product subscription for the account
    """
    __args__ = dict()
    __args__['productSubscriptionArn'] = product_subscription_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:securityhub:getProductSubscription', __args__, opts=opts, typ=GetProductSubscriptionResult)
    return __ret__.apply(lambda __response__: GetProductSubscriptionResult(
        product_subscription_arn=pulumi.get(__response__, 'product_subscription_arn')))
