# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetInsightResult',
    'AwaitableGetInsightResult',
    'get_insight',
    'get_insight_output',
]

@pulumi.output_type
class GetInsightResult:
    def __init__(__self__, filters=None, group_by_attribute=None, insight_arn=None, name=None):
        if filters and not isinstance(filters, dict):
            raise TypeError("Expected argument 'filters' to be a dict")
        pulumi.set(__self__, "filters", filters)
        if group_by_attribute and not isinstance(group_by_attribute, str):
            raise TypeError("Expected argument 'group_by_attribute' to be a str")
        pulumi.set(__self__, "group_by_attribute", group_by_attribute)
        if insight_arn and not isinstance(insight_arn, str):
            raise TypeError("Expected argument 'insight_arn' to be a str")
        pulumi.set(__self__, "insight_arn", insight_arn)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def filters(self) -> Optional['outputs.InsightAwsSecurityFindingFilters']:
        """
        One or more attributes used to filter the findings included in the insight
        """
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="groupByAttribute")
    def group_by_attribute(self) -> Optional[builtins.str]:
        """
        The grouping attribute for the insight's findings
        """
        return pulumi.get(self, "group_by_attribute")

    @property
    @pulumi.getter(name="insightArn")
    def insight_arn(self) -> Optional[builtins.str]:
        """
        The ARN of a Security Hub insight
        """
        return pulumi.get(self, "insight_arn")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of a Security Hub insight
        """
        return pulumi.get(self, "name")


class AwaitableGetInsightResult(GetInsightResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInsightResult(
            filters=self.filters,
            group_by_attribute=self.group_by_attribute,
            insight_arn=self.insight_arn,
            name=self.name)


def get_insight(insight_arn: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInsightResult:
    """
    The AWS::SecurityHub::Insight resource represents the AWS Security Hub Insight in your account. An AWS Security Hub insight is a collection of related findings.


    :param builtins.str insight_arn: The ARN of a Security Hub insight
    """
    __args__ = dict()
    __args__['insightArn'] = insight_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:securityhub:getInsight', __args__, opts=opts, typ=GetInsightResult).value

    return AwaitableGetInsightResult(
        filters=pulumi.get(__ret__, 'filters'),
        group_by_attribute=pulumi.get(__ret__, 'group_by_attribute'),
        insight_arn=pulumi.get(__ret__, 'insight_arn'),
        name=pulumi.get(__ret__, 'name'))
def get_insight_output(insight_arn: Optional[pulumi.Input[builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInsightResult]:
    """
    The AWS::SecurityHub::Insight resource represents the AWS Security Hub Insight in your account. An AWS Security Hub insight is a collection of related findings.


    :param builtins.str insight_arn: The ARN of a Security Hub insight
    """
    __args__ = dict()
    __args__['insightArn'] = insight_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:securityhub:getInsight', __args__, opts=opts, typ=GetInsightResult)
    return __ret__.apply(lambda __response__: GetInsightResult(
        filters=pulumi.get(__response__, 'filters'),
        group_by_attribute=pulumi.get(__response__, 'group_by_attribute'),
        insight_arn=pulumi.get(__response__, 'insight_arn'),
        name=pulumi.get(__response__, 'name')))
