# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['AutomationRuleArgs', 'AutomationRule']

@pulumi.input_type
class AutomationRuleArgs:
    def __init__(__self__, *,
                 actions: pulumi.Input[Sequence[pulumi.Input['AutomationRulesActionArgs']]],
                 criteria: pulumi.Input['AutomationRulesFindingFiltersArgs'],
                 description: pulumi.Input[builtins.str],
                 rule_order: pulumi.Input[builtins.int],
                 is_terminal: Optional[pulumi.Input[builtins.bool]] = None,
                 rule_name: Optional[pulumi.Input[builtins.str]] = None,
                 rule_status: Optional[pulumi.Input['AutomationRuleRuleStatus']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a AutomationRule resource.
        :param pulumi.Input[Sequence[pulumi.Input['AutomationRulesActionArgs']]] actions: One or more actions to update finding fields if a finding matches the conditions specified in ``Criteria``.
        :param pulumi.Input['AutomationRulesFindingFiltersArgs'] criteria: A set of [Security Finding Format (ASFF)](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html) finding field attributes and corresponding expected values that ASH uses to filter findings. If a rule is enabled and a finding matches the criteria specified in this parameter, ASH applies the rule action to the finding.
        :param pulumi.Input[builtins.str] description: A description of the rule.
        :param pulumi.Input[builtins.int] rule_order: An integer ranging from 1 to 1000 that represents the order in which the rule action is applied to findings. Security Hub applies rules with lower values for this parameter first.
        :param pulumi.Input[builtins.bool] is_terminal: Specifies whether a rule is the last to be applied with respect to a finding that matches the rule criteria. This is useful when a finding matches the criteria for multiple rules, and each rule has different actions. If a rule is terminal, Security Hub applies the rule action to a finding that matches the rule criteria and doesn't evaluate other rules for the finding. By default, a rule isn't terminal.
        :param pulumi.Input[builtins.str] rule_name: The name of the rule.
        :param pulumi.Input['AutomationRuleRuleStatus'] rule_status: Whether the rule is active after it is created. If this parameter is equal to ``ENABLED``, ASH applies the rule to findings and finding updates after the rule is created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: User-defined tags associated with an automation rule.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "criteria", criteria)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "rule_order", rule_order)
        if is_terminal is not None:
            pulumi.set(__self__, "is_terminal", is_terminal)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if rule_status is not None:
            pulumi.set(__self__, "rule_status", rule_status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def actions(self) -> pulumi.Input[Sequence[pulumi.Input['AutomationRulesActionArgs']]]:
        """
        One or more actions to update finding fields if a finding matches the conditions specified in ``Criteria``.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: pulumi.Input[Sequence[pulumi.Input['AutomationRulesActionArgs']]]):
        pulumi.set(self, "actions", value)

    @property
    @pulumi.getter
    def criteria(self) -> pulumi.Input['AutomationRulesFindingFiltersArgs']:
        """
        A set of [Security Finding Format (ASFF)](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html) finding field attributes and corresponding expected values that ASH uses to filter findings. If a rule is enabled and a finding matches the criteria specified in this parameter, ASH applies the rule action to the finding.
        """
        return pulumi.get(self, "criteria")

    @criteria.setter
    def criteria(self, value: pulumi.Input['AutomationRulesFindingFiltersArgs']):
        pulumi.set(self, "criteria", value)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[builtins.str]:
        """
        A description of the rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="ruleOrder")
    def rule_order(self) -> pulumi.Input[builtins.int]:
        """
        An integer ranging from 1 to 1000 that represents the order in which the rule action is applied to findings. Security Hub applies rules with lower values for this parameter first.
        """
        return pulumi.get(self, "rule_order")

    @rule_order.setter
    def rule_order(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "rule_order", value)

    @property
    @pulumi.getter(name="isTerminal")
    def is_terminal(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether a rule is the last to be applied with respect to a finding that matches the rule criteria. This is useful when a finding matches the criteria for multiple rules, and each rule has different actions. If a rule is terminal, Security Hub applies the rule action to a finding that matches the rule criteria and doesn't evaluate other rules for the finding. By default, a rule isn't terminal.
        """
        return pulumi.get(self, "is_terminal")

    @is_terminal.setter
    def is_terminal(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_terminal", value)

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the rule.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @property
    @pulumi.getter(name="ruleStatus")
    def rule_status(self) -> Optional[pulumi.Input['AutomationRuleRuleStatus']]:
        """
        Whether the rule is active after it is created. If this parameter is equal to ``ENABLED``, ASH applies the rule to findings and finding updates after the rule is created.
        """
        return pulumi.get(self, "rule_status")

    @rule_status.setter
    def rule_status(self, value: Optional[pulumi.Input['AutomationRuleRuleStatus']]):
        pulumi.set(self, "rule_status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        User-defined tags associated with an automation rule.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:securityhub:AutomationRule")
class AutomationRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutomationRulesActionArgs', 'AutomationRulesActionArgsDict']]]]] = None,
                 criteria: Optional[pulumi.Input[Union['AutomationRulesFindingFiltersArgs', 'AutomationRulesFindingFiltersArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 is_terminal: Optional[pulumi.Input[builtins.bool]] = None,
                 rule_name: Optional[pulumi.Input[builtins.str]] = None,
                 rule_order: Optional[pulumi.Input[builtins.int]] = None,
                 rule_status: Optional[pulumi.Input['AutomationRuleRuleStatus']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        The ``AWS::SecurityHub::AutomationRule`` resource specifies an automation rule based on input parameters. For more information, see [Automation rules](https://docs.aws.amazon.com/securityhub/latest/userguide/automation-rules.html) in the *User Guide*.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        rule_with_criteria_actions_tags = aws_native.securityhub.AutomationRule("ruleWithCriteriaActionsTags",
            rule_name="Example rule name",
            rule_order=5,
            description="Example rule description.",
            is_terminal=False,
            rule_status=aws_native.securityhub.AutomationRuleRuleStatus.ENABLED,
            criteria={
                "product_name": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "GuardDuty",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.PREFIX,
                        "value": "SecurityHub",
                    },
                ],
                "company_name": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "AWS",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.PREFIX,
                        "value": "Private",
                    },
                ],
                "product_arn": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "arn:aws:securityhub:us-west-2:123456789012:product/123456789012/default",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.PREFIX,
                        "value": "arn:aws:securityhub:us-west-2:123456789012:product/aws",
                    },
                ],
                "aws_account_id": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "123456789012",
                }],
                "id": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "example-finding-id",
                }],
                "generator_id": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "example-generator-id",
                }],
                "type": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "type-1",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "type-2",
                    },
                ],
                "description": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "description1",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "description2",
                    },
                ],
                "source_url": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.PREFIX,
                        "value": "https",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.PREFIX,
                        "value": "ftp",
                    },
                ],
                "title": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "title-1",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.PREFIX,
                        "value": "title-2",
                    },
                ],
                "severity_label": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "LOW",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "HIGH",
                    },
                ],
                "resource_type": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "AwsEc2Instance",
                }],
                "resource_partition": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "aws",
                }],
                "resource_id": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.PREFIX,
                    "value": "i-1234567890",
                }],
                "resource_region": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.PREFIX,
                    "value": "us-west",
                }],
                "compliance_status": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "FAILED",
                }],
                "compliance_security_control_id": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "EC2.3",
                }],
                "compliance_associated_standards_id": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "ruleset/cis-aws-foundations-benchmark/v/1.2.0",
                }],
                "verification_state": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "BENIGN_POSITIVE",
                }],
                "record_state": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "ACTIVE",
                }],
                "related_findings_product_arn": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "arn:aws:securityhub:eu-central-1::product/aws/securityhub",
                }],
                "related_findings_id": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "example-finding-id-2",
                }],
                "note_text": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "example-note-text",
                }],
                "note_updated_at": [{
                    "date_range": {
                        "unit": aws_native.securityhub.AutomationRuleDateRangeUnit.DAYS,
                        "value": 5,
                    },
                }],
                "note_updated_by": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.PREFIX,
                    "value": "sechub",
                }],
                "workflow_status": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "NEW",
                }],
                "first_observed_at": [{
                    "date_range": {
                        "unit": aws_native.securityhub.AutomationRuleDateRangeUnit.DAYS,
                        "value": 5,
                    },
                }],
                "last_observed_at": [{
                    "date_range": {
                        "unit": aws_native.securityhub.AutomationRuleDateRangeUnit.DAYS,
                        "value": 5,
                    },
                }],
                "created_at": [{
                    "date_range": {
                        "unit": aws_native.securityhub.AutomationRuleDateRangeUnit.DAYS,
                        "value": 5,
                    },
                }],
                "updated_at": [{
                    "start": "2023-04-25T17:05:54.832Z",
                    "end": "2023-05-25T17:05:54.832Z",
                }],
                "resource_tags": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleMapFilterComparison.NOT_EQUALS,
                        "key": "department",
                        "value": "security",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleMapFilterComparison.NOT_EQUALS,
                        "key": "department",
                        "value": "operations",
                    },
                ],
                "user_defined_fields": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleMapFilterComparison.EQUALS,
                        "key": "key1",
                        "value": "security",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleMapFilterComparison.EQUALS,
                        "key": "key2",
                        "value": "operations",
                    },
                ],
                "resource_details_other": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleMapFilterComparison.NOT_EQUALS,
                        "key": "area",
                        "value": "na",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleMapFilterComparison.NOT_EQUALS,
                        "key": "department",
                        "value": "sales",
                    },
                ],
                "confidence": [{
                    "gte": 50,
                    "lte": 95,
                }],
                "criticality": [{
                    "gte": 50,
                    "lte": 95,
                }],
            },
            actions=[{
                "type": aws_native.securityhub.AutomationRulesActionType.FINDING_FIELDS_UPDATE,
                "finding_fields_update": {
                    "severity": {
                        "product": 50,
                        "label": aws_native.securityhub.AutomationRuleSeverityUpdateLabel.MEDIUM,
                        "normalized": 60,
                    },
                    "types": [
                        "Software and Configuration Checks/Industry and Regulatory Standards/AWS-Foundational-Security-Best-Practices",
                        "Industry Compliance",
                    ],
                    "confidence": 98,
                    "criticality": 95,
                    "user_defined_fields": {
                        "key1": "value1",
                        "key2": "value2",
                    },
                    "related_findings": [
                        {
                            "product_arn": "arn:aws:securityhub:us-west-2:123456789012:product/123456789012/default",
                            "id": "sample-finding-id-1",
                        },
                        {
                            "product_arn": "arn:aws:securityhub:us-west-2:123456789012:product/123456789012/default",
                            "id": "sample-finding-id-2",
                        },
                    ],
                    "note": {
                        "text": "sample-note-text",
                        "updated_by": "sechub",
                    },
                    "verification_state": aws_native.securityhub.AutomationRulesFindingFieldsUpdateVerificationState.TRUE_POSITIVE,
                    "workflow": {
                        "status": aws_native.securityhub.AutomationRuleWorkflowUpdateStatus.NOTIFIED,
                    },
                },
            }],
            tags={
                "sampleTag": "sampleValue",
                "organizationUnit": "pnw",
            })

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        rule_with_criteria_actions_tags = aws_native.securityhub.AutomationRule("ruleWithCriteriaActionsTags",
            rule_name="Example rule name",
            rule_order=5,
            description="Example rule description.",
            is_terminal=False,
            rule_status=aws_native.securityhub.AutomationRuleRuleStatus.ENABLED,
            criteria={
                "product_name": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "GuardDuty",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.PREFIX,
                        "value": "SecurityHub",
                    },
                ],
                "company_name": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "AWS",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.PREFIX,
                        "value": "Private",
                    },
                ],
                "product_arn": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "arn:aws:securityhub:us-west-2:123456789012:product/123456789012/default",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.PREFIX,
                        "value": "arn:aws:securityhub:us-west-2:123456789012:product/aws",
                    },
                ],
                "aws_account_id": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "123456789012",
                }],
                "id": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "example-finding-id",
                }],
                "generator_id": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "example-generator-id",
                }],
                "type": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "type-1",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "type-2",
                    },
                ],
                "description": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "description1",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "description2",
                    },
                ],
                "source_url": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.PREFIX,
                        "value": "https",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.PREFIX,
                        "value": "ftp",
                    },
                ],
                "title": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "title-1",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.PREFIX,
                        "value": "title-2",
                    },
                ],
                "severity_label": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "LOW",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "HIGH",
                    },
                ],
                "resource_type": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "AwsEc2Instance",
                }],
                "resource_partition": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "aws",
                }],
                "resource_id": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.PREFIX,
                    "value": "i-1234567890",
                }],
                "resource_region": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.PREFIX,
                    "value": "us-west",
                }],
                "compliance_status": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "FAILED",
                }],
                "compliance_security_control_id": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "EC2.3",
                }],
                "compliance_associated_standards_id": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "ruleset/cis-aws-foundations-benchmark/v/1.2.0",
                }],
                "verification_state": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "BENIGN_POSITIVE",
                }],
                "record_state": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "ACTIVE",
                }],
                "related_findings_product_arn": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "arn:aws:securityhub:eu-central-1::product/aws/securityhub",
                }],
                "related_findings_id": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "example-finding-id-2",
                }],
                "note_text": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "example-note-text",
                }],
                "note_updated_at": [{
                    "date_range": {
                        "unit": aws_native.securityhub.AutomationRuleDateRangeUnit.DAYS,
                        "value": 5,
                    },
                }],
                "note_updated_by": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.PREFIX,
                    "value": "sechub",
                }],
                "workflow_status": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "NEW",
                }],
                "first_observed_at": [{
                    "date_range": {
                        "unit": aws_native.securityhub.AutomationRuleDateRangeUnit.DAYS,
                        "value": 5,
                    },
                }],
                "last_observed_at": [{
                    "date_range": {
                        "unit": aws_native.securityhub.AutomationRuleDateRangeUnit.DAYS,
                        "value": 5,
                    },
                }],
                "created_at": [{
                    "date_range": {
                        "unit": aws_native.securityhub.AutomationRuleDateRangeUnit.DAYS,
                        "value": 5,
                    },
                }],
                "updated_at": [{
                    "start": "2023-04-25T17:05:54.832Z",
                    "end": "2023-05-25T17:05:54.832Z",
                }],
                "resource_tags": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleMapFilterComparison.NOT_EQUALS,
                        "key": "department",
                        "value": "security",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleMapFilterComparison.NOT_EQUALS,
                        "key": "department",
                        "value": "operations",
                    },
                ],
                "user_defined_fields": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleMapFilterComparison.EQUALS,
                        "key": "key1",
                        "value": "security",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleMapFilterComparison.EQUALS,
                        "key": "key2",
                        "value": "operations",
                    },
                ],
                "resource_details_other": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleMapFilterComparison.NOT_EQUALS,
                        "key": "area",
                        "value": "na",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleMapFilterComparison.NOT_EQUALS,
                        "key": "department",
                        "value": "sales",
                    },
                ],
                "confidence": [{
                    "gte": 50,
                    "lte": 95,
                }],
                "criticality": [{
                    "gte": 50,
                    "lte": 95,
                }],
            },
            actions=[{
                "type": aws_native.securityhub.AutomationRulesActionType.FINDING_FIELDS_UPDATE,
                "finding_fields_update": {
                    "severity": {
                        "product": 50,
                        "label": aws_native.securityhub.AutomationRuleSeverityUpdateLabel.MEDIUM,
                        "normalized": 60,
                    },
                    "types": [
                        "Software and Configuration Checks/Industry and Regulatory Standards/AWS-Foundational-Security-Best-Practices",
                        "Industry Compliance",
                    ],
                    "confidence": 98,
                    "criticality": 95,
                    "user_defined_fields": {
                        "key1": "value1",
                        "key2": "value2",
                    },
                    "related_findings": [
                        {
                            "product_arn": "arn:aws:securityhub:us-west-2:123456789012:product/123456789012/default",
                            "id": "sample-finding-id-1",
                        },
                        {
                            "product_arn": "arn:aws:securityhub:us-west-2:123456789012:product/123456789012/default",
                            "id": "sample-finding-id-2",
                        },
                    ],
                    "note": {
                        "text": "sample-note-text",
                        "updated_by": "sechub",
                    },
                    "verification_state": aws_native.securityhub.AutomationRulesFindingFieldsUpdateVerificationState.TRUE_POSITIVE,
                    "workflow": {
                        "status": aws_native.securityhub.AutomationRuleWorkflowUpdateStatus.NOTIFIED,
                    },
                },
            }],
            tags={
                "sampleTag": "sampleValue",
                "organizationUnit": "pnw",
            })

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutomationRulesActionArgs', 'AutomationRulesActionArgsDict']]]] actions: One or more actions to update finding fields if a finding matches the conditions specified in ``Criteria``.
        :param pulumi.Input[Union['AutomationRulesFindingFiltersArgs', 'AutomationRulesFindingFiltersArgsDict']] criteria: A set of [Security Finding Format (ASFF)](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html) finding field attributes and corresponding expected values that ASH uses to filter findings. If a rule is enabled and a finding matches the criteria specified in this parameter, ASH applies the rule action to the finding.
        :param pulumi.Input[builtins.str] description: A description of the rule.
        :param pulumi.Input[builtins.bool] is_terminal: Specifies whether a rule is the last to be applied with respect to a finding that matches the rule criteria. This is useful when a finding matches the criteria for multiple rules, and each rule has different actions. If a rule is terminal, Security Hub applies the rule action to a finding that matches the rule criteria and doesn't evaluate other rules for the finding. By default, a rule isn't terminal.
        :param pulumi.Input[builtins.str] rule_name: The name of the rule.
        :param pulumi.Input[builtins.int] rule_order: An integer ranging from 1 to 1000 that represents the order in which the rule action is applied to findings. Security Hub applies rules with lower values for this parameter first.
        :param pulumi.Input['AutomationRuleRuleStatus'] rule_status: Whether the rule is active after it is created. If this parameter is equal to ``ENABLED``, ASH applies the rule to findings and finding updates after the rule is created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: User-defined tags associated with an automation rule.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AutomationRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The ``AWS::SecurityHub::AutomationRule`` resource specifies an automation rule based on input parameters. For more information, see [Automation rules](https://docs.aws.amazon.com/securityhub/latest/userguide/automation-rules.html) in the *User Guide*.

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        rule_with_criteria_actions_tags = aws_native.securityhub.AutomationRule("ruleWithCriteriaActionsTags",
            rule_name="Example rule name",
            rule_order=5,
            description="Example rule description.",
            is_terminal=False,
            rule_status=aws_native.securityhub.AutomationRuleRuleStatus.ENABLED,
            criteria={
                "product_name": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "GuardDuty",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.PREFIX,
                        "value": "SecurityHub",
                    },
                ],
                "company_name": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "AWS",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.PREFIX,
                        "value": "Private",
                    },
                ],
                "product_arn": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "arn:aws:securityhub:us-west-2:123456789012:product/123456789012/default",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.PREFIX,
                        "value": "arn:aws:securityhub:us-west-2:123456789012:product/aws",
                    },
                ],
                "aws_account_id": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "123456789012",
                }],
                "id": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "example-finding-id",
                }],
                "generator_id": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "example-generator-id",
                }],
                "type": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "type-1",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "type-2",
                    },
                ],
                "description": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "description1",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "description2",
                    },
                ],
                "source_url": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.PREFIX,
                        "value": "https",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.PREFIX,
                        "value": "ftp",
                    },
                ],
                "title": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "title-1",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.PREFIX,
                        "value": "title-2",
                    },
                ],
                "severity_label": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "LOW",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "HIGH",
                    },
                ],
                "resource_type": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "AwsEc2Instance",
                }],
                "resource_partition": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "aws",
                }],
                "resource_id": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.PREFIX,
                    "value": "i-1234567890",
                }],
                "resource_region": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.PREFIX,
                    "value": "us-west",
                }],
                "compliance_status": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "FAILED",
                }],
                "compliance_security_control_id": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "EC2.3",
                }],
                "compliance_associated_standards_id": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "ruleset/cis-aws-foundations-benchmark/v/1.2.0",
                }],
                "verification_state": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "BENIGN_POSITIVE",
                }],
                "record_state": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "ACTIVE",
                }],
                "related_findings_product_arn": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "arn:aws:securityhub:eu-central-1::product/aws/securityhub",
                }],
                "related_findings_id": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "example-finding-id-2",
                }],
                "note_text": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "example-note-text",
                }],
                "note_updated_at": [{
                    "date_range": {
                        "unit": aws_native.securityhub.AutomationRuleDateRangeUnit.DAYS,
                        "value": 5,
                    },
                }],
                "note_updated_by": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.PREFIX,
                    "value": "sechub",
                }],
                "workflow_status": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "NEW",
                }],
                "first_observed_at": [{
                    "date_range": {
                        "unit": aws_native.securityhub.AutomationRuleDateRangeUnit.DAYS,
                        "value": 5,
                    },
                }],
                "last_observed_at": [{
                    "date_range": {
                        "unit": aws_native.securityhub.AutomationRuleDateRangeUnit.DAYS,
                        "value": 5,
                    },
                }],
                "created_at": [{
                    "date_range": {
                        "unit": aws_native.securityhub.AutomationRuleDateRangeUnit.DAYS,
                        "value": 5,
                    },
                }],
                "updated_at": [{
                    "start": "2023-04-25T17:05:54.832Z",
                    "end": "2023-05-25T17:05:54.832Z",
                }],
                "resource_tags": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleMapFilterComparison.NOT_EQUALS,
                        "key": "department",
                        "value": "security",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleMapFilterComparison.NOT_EQUALS,
                        "key": "department",
                        "value": "operations",
                    },
                ],
                "user_defined_fields": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleMapFilterComparison.EQUALS,
                        "key": "key1",
                        "value": "security",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleMapFilterComparison.EQUALS,
                        "key": "key2",
                        "value": "operations",
                    },
                ],
                "resource_details_other": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleMapFilterComparison.NOT_EQUALS,
                        "key": "area",
                        "value": "na",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleMapFilterComparison.NOT_EQUALS,
                        "key": "department",
                        "value": "sales",
                    },
                ],
                "confidence": [{
                    "gte": 50,
                    "lte": 95,
                }],
                "criticality": [{
                    "gte": 50,
                    "lte": 95,
                }],
            },
            actions=[{
                "type": aws_native.securityhub.AutomationRulesActionType.FINDING_FIELDS_UPDATE,
                "finding_fields_update": {
                    "severity": {
                        "product": 50,
                        "label": aws_native.securityhub.AutomationRuleSeverityUpdateLabel.MEDIUM,
                        "normalized": 60,
                    },
                    "types": [
                        "Software and Configuration Checks/Industry and Regulatory Standards/AWS-Foundational-Security-Best-Practices",
                        "Industry Compliance",
                    ],
                    "confidence": 98,
                    "criticality": 95,
                    "user_defined_fields": {
                        "key1": "value1",
                        "key2": "value2",
                    },
                    "related_findings": [
                        {
                            "product_arn": "arn:aws:securityhub:us-west-2:123456789012:product/123456789012/default",
                            "id": "sample-finding-id-1",
                        },
                        {
                            "product_arn": "arn:aws:securityhub:us-west-2:123456789012:product/123456789012/default",
                            "id": "sample-finding-id-2",
                        },
                    ],
                    "note": {
                        "text": "sample-note-text",
                        "updated_by": "sechub",
                    },
                    "verification_state": aws_native.securityhub.AutomationRulesFindingFieldsUpdateVerificationState.TRUE_POSITIVE,
                    "workflow": {
                        "status": aws_native.securityhub.AutomationRuleWorkflowUpdateStatus.NOTIFIED,
                    },
                },
            }],
            tags={
                "sampleTag": "sampleValue",
                "organizationUnit": "pnw",
            })

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        rule_with_criteria_actions_tags = aws_native.securityhub.AutomationRule("ruleWithCriteriaActionsTags",
            rule_name="Example rule name",
            rule_order=5,
            description="Example rule description.",
            is_terminal=False,
            rule_status=aws_native.securityhub.AutomationRuleRuleStatus.ENABLED,
            criteria={
                "product_name": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "GuardDuty",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.PREFIX,
                        "value": "SecurityHub",
                    },
                ],
                "company_name": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "AWS",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.PREFIX,
                        "value": "Private",
                    },
                ],
                "product_arn": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "arn:aws:securityhub:us-west-2:123456789012:product/123456789012/default",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.PREFIX,
                        "value": "arn:aws:securityhub:us-west-2:123456789012:product/aws",
                    },
                ],
                "aws_account_id": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "123456789012",
                }],
                "id": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "example-finding-id",
                }],
                "generator_id": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "example-generator-id",
                }],
                "type": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "type-1",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "type-2",
                    },
                ],
                "description": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "description1",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "description2",
                    },
                ],
                "source_url": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.PREFIX,
                        "value": "https",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.PREFIX,
                        "value": "ftp",
                    },
                ],
                "title": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "title-1",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.PREFIX,
                        "value": "title-2",
                    },
                ],
                "severity_label": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "LOW",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                        "value": "HIGH",
                    },
                ],
                "resource_type": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "AwsEc2Instance",
                }],
                "resource_partition": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "aws",
                }],
                "resource_id": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.PREFIX,
                    "value": "i-1234567890",
                }],
                "resource_region": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.PREFIX,
                    "value": "us-west",
                }],
                "compliance_status": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "FAILED",
                }],
                "compliance_security_control_id": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "EC2.3",
                }],
                "compliance_associated_standards_id": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "ruleset/cis-aws-foundations-benchmark/v/1.2.0",
                }],
                "verification_state": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "BENIGN_POSITIVE",
                }],
                "record_state": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "ACTIVE",
                }],
                "related_findings_product_arn": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "arn:aws:securityhub:eu-central-1::product/aws/securityhub",
                }],
                "related_findings_id": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "example-finding-id-2",
                }],
                "note_text": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "example-note-text",
                }],
                "note_updated_at": [{
                    "date_range": {
                        "unit": aws_native.securityhub.AutomationRuleDateRangeUnit.DAYS,
                        "value": 5,
                    },
                }],
                "note_updated_by": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.PREFIX,
                    "value": "sechub",
                }],
                "workflow_status": [{
                    "comparison": aws_native.securityhub.AutomationRuleStringFilterComparison.EQUALS,
                    "value": "NEW",
                }],
                "first_observed_at": [{
                    "date_range": {
                        "unit": aws_native.securityhub.AutomationRuleDateRangeUnit.DAYS,
                        "value": 5,
                    },
                }],
                "last_observed_at": [{
                    "date_range": {
                        "unit": aws_native.securityhub.AutomationRuleDateRangeUnit.DAYS,
                        "value": 5,
                    },
                }],
                "created_at": [{
                    "date_range": {
                        "unit": aws_native.securityhub.AutomationRuleDateRangeUnit.DAYS,
                        "value": 5,
                    },
                }],
                "updated_at": [{
                    "start": "2023-04-25T17:05:54.832Z",
                    "end": "2023-05-25T17:05:54.832Z",
                }],
                "resource_tags": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleMapFilterComparison.NOT_EQUALS,
                        "key": "department",
                        "value": "security",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleMapFilterComparison.NOT_EQUALS,
                        "key": "department",
                        "value": "operations",
                    },
                ],
                "user_defined_fields": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleMapFilterComparison.EQUALS,
                        "key": "key1",
                        "value": "security",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleMapFilterComparison.EQUALS,
                        "key": "key2",
                        "value": "operations",
                    },
                ],
                "resource_details_other": [
                    {
                        "comparison": aws_native.securityhub.AutomationRuleMapFilterComparison.NOT_EQUALS,
                        "key": "area",
                        "value": "na",
                    },
                    {
                        "comparison": aws_native.securityhub.AutomationRuleMapFilterComparison.NOT_EQUALS,
                        "key": "department",
                        "value": "sales",
                    },
                ],
                "confidence": [{
                    "gte": 50,
                    "lte": 95,
                }],
                "criticality": [{
                    "gte": 50,
                    "lte": 95,
                }],
            },
            actions=[{
                "type": aws_native.securityhub.AutomationRulesActionType.FINDING_FIELDS_UPDATE,
                "finding_fields_update": {
                    "severity": {
                        "product": 50,
                        "label": aws_native.securityhub.AutomationRuleSeverityUpdateLabel.MEDIUM,
                        "normalized": 60,
                    },
                    "types": [
                        "Software and Configuration Checks/Industry and Regulatory Standards/AWS-Foundational-Security-Best-Practices",
                        "Industry Compliance",
                    ],
                    "confidence": 98,
                    "criticality": 95,
                    "user_defined_fields": {
                        "key1": "value1",
                        "key2": "value2",
                    },
                    "related_findings": [
                        {
                            "product_arn": "arn:aws:securityhub:us-west-2:123456789012:product/123456789012/default",
                            "id": "sample-finding-id-1",
                        },
                        {
                            "product_arn": "arn:aws:securityhub:us-west-2:123456789012:product/123456789012/default",
                            "id": "sample-finding-id-2",
                        },
                    ],
                    "note": {
                        "text": "sample-note-text",
                        "updated_by": "sechub",
                    },
                    "verification_state": aws_native.securityhub.AutomationRulesFindingFieldsUpdateVerificationState.TRUE_POSITIVE,
                    "workflow": {
                        "status": aws_native.securityhub.AutomationRuleWorkflowUpdateStatus.NOTIFIED,
                    },
                },
            }],
            tags={
                "sampleTag": "sampleValue",
                "organizationUnit": "pnw",
            })

        ```

        :param str resource_name: The name of the resource.
        :param AutomationRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AutomationRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutomationRulesActionArgs', 'AutomationRulesActionArgsDict']]]]] = None,
                 criteria: Optional[pulumi.Input[Union['AutomationRulesFindingFiltersArgs', 'AutomationRulesFindingFiltersArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 is_terminal: Optional[pulumi.Input[builtins.bool]] = None,
                 rule_name: Optional[pulumi.Input[builtins.str]] = None,
                 rule_order: Optional[pulumi.Input[builtins.int]] = None,
                 rule_status: Optional[pulumi.Input['AutomationRuleRuleStatus']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AutomationRuleArgs.__new__(AutomationRuleArgs)

            if actions is None and not opts.urn:
                raise TypeError("Missing required property 'actions'")
            __props__.__dict__["actions"] = actions
            if criteria is None and not opts.urn:
                raise TypeError("Missing required property 'criteria'")
            __props__.__dict__["criteria"] = criteria
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["is_terminal"] = is_terminal
            __props__.__dict__["rule_name"] = rule_name
            if rule_order is None and not opts.urn:
                raise TypeError("Missing required property 'rule_order'")
            __props__.__dict__["rule_order"] = rule_order
            __props__.__dict__["rule_status"] = rule_status
            __props__.__dict__["tags"] = tags
            __props__.__dict__["created_at"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["rule_arn"] = None
            __props__.__dict__["updated_at"] = None
        super(AutomationRule, __self__).__init__(
            'aws-native:securityhub:AutomationRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'AutomationRule':
        """
        Get an existing AutomationRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = AutomationRuleArgs.__new__(AutomationRuleArgs)

        __props__.__dict__["actions"] = None
        __props__.__dict__["created_at"] = None
        __props__.__dict__["created_by"] = None
        __props__.__dict__["criteria"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["is_terminal"] = None
        __props__.__dict__["rule_arn"] = None
        __props__.__dict__["rule_name"] = None
        __props__.__dict__["rule_order"] = None
        __props__.__dict__["rule_status"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["updated_at"] = None
        return AutomationRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def actions(self) -> pulumi.Output[Sequence['outputs.AutomationRulesAction']]:
        """
        One or more actions to update finding fields if a finding matches the conditions specified in ``Criteria``.
        """
        return pulumi.get(self, "actions")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        A timestamp that indicates when the rule was created.

        Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc3339#section-5.6) . The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z` .
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[builtins.str]:
        """
        The principal that created the rule. For example, `arn:aws:sts::123456789012:assumed-role/Developer-Role/JaneDoe` .
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter
    def criteria(self) -> pulumi.Output['outputs.AutomationRulesFindingFilters']:
        """
        A set of [Security Finding Format (ASFF)](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html) finding field attributes and corresponding expected values that ASH uses to filter findings. If a rule is enabled and a finding matches the criteria specified in this parameter, ASH applies the rule action to the finding.
        """
        return pulumi.get(self, "criteria")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        A description of the rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="isTerminal")
    def is_terminal(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether a rule is the last to be applied with respect to a finding that matches the rule criteria. This is useful when a finding matches the criteria for multiple rules, and each rule has different actions. If a rule is terminal, Security Hub applies the rule action to a finding that matches the rule criteria and doesn't evaluate other rules for the finding. By default, a rule isn't terminal.
        """
        return pulumi.get(self, "is_terminal")

    @property
    @pulumi.getter(name="ruleArn")
    def rule_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the automation rule that you create. For example, `arn:aws:securityhub:us-east-1:123456789012:automation-rule/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111` .
        """
        return pulumi.get(self, "rule_arn")

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the rule.
        """
        return pulumi.get(self, "rule_name")

    @property
    @pulumi.getter(name="ruleOrder")
    def rule_order(self) -> pulumi.Output[builtins.int]:
        """
        An integer ranging from 1 to 1000 that represents the order in which the rule action is applied to findings. Security Hub applies rules with lower values for this parameter first.
        """
        return pulumi.get(self, "rule_order")

    @property
    @pulumi.getter(name="ruleStatus")
    def rule_status(self) -> pulumi.Output[Optional['AutomationRuleRuleStatus']]:
        """
        Whether the rule is active after it is created. If this parameter is equal to ``ENABLED``, ASH applies the rule to findings and finding updates after the rule is created.
        """
        return pulumi.get(self, "rule_status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        User-defined tags associated with an automation rule.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[builtins.str]:
        """
        A timestamp that indicates when the rule was most recently updated.

        Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc3339#section-5.6) . The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z` .
        """
        return pulumi.get(self, "updated_at")

