# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSecretTargetAttachmentResult',
    'AwaitableGetSecretTargetAttachmentResult',
    'get_secret_target_attachment',
    'get_secret_target_attachment_output',
]

@pulumi.output_type
class GetSecretTargetAttachmentResult:
    def __init__(__self__, id=None, target_id=None, target_type=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if target_id and not isinstance(target_id, str):
            raise TypeError("Expected argument 'target_id' to be a str")
        pulumi.set(__self__, "target_id", target_id)
        if target_type and not isinstance(target_type, str):
            raise TypeError("Expected argument 'target_type' to be a str")
        pulumi.set(__self__, "target_type", target_type)

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[builtins.str]:
        """
        The ID of the database or cluster.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> Optional[builtins.str]:
        """
        A string that defines the type of service or database associated with the secret. This value instructs Secrets Manager how to update the secret with the details of the service or database. This value must be one of the following:

        - AWS::RDS::DBInstance
        - AWS::RDS::DBCluster
        - AWS::Redshift::Cluster
        - AWS::RedshiftServerless::Namespace
        - AWS::DocDB::DBInstance
        - AWS::DocDB::DBCluster
        - AWS::DocDBElastic::Cluster
        """
        return pulumi.get(self, "target_type")


class AwaitableGetSecretTargetAttachmentResult(GetSecretTargetAttachmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecretTargetAttachmentResult(
            id=self.id,
            target_id=self.target_id,
            target_type=self.target_type)


def get_secret_target_attachment(id: Optional[builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecretTargetAttachmentResult:
    """
    Resource Type definition for AWS::SecretsManager::SecretTargetAttachment
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:secretsmanager:getSecretTargetAttachment', __args__, opts=opts, typ=GetSecretTargetAttachmentResult).value

    return AwaitableGetSecretTargetAttachmentResult(
        id=pulumi.get(__ret__, 'id'),
        target_id=pulumi.get(__ret__, 'target_id'),
        target_type=pulumi.get(__ret__, 'target_type'))
def get_secret_target_attachment_output(id: Optional[pulumi.Input[builtins.str]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecretTargetAttachmentResult]:
    """
    Resource Type definition for AWS::SecretsManager::SecretTargetAttachment
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:secretsmanager:getSecretTargetAttachment', __args__, opts=opts, typ=GetSecretTargetAttachmentResult)
    return __ret__.apply(lambda __response__: GetSecretTargetAttachmentResult(
        id=pulumi.get(__response__, 'id'),
        target_id=pulumi.get(__response__, 'target_id'),
        target_type=pulumi.get(__response__, 'target_type')))
