# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetRotationScheduleResult',
    'AwaitableGetRotationScheduleResult',
    'get_rotation_schedule',
    'get_rotation_schedule_output',
]

@pulumi.output_type
class GetRotationScheduleResult:
    def __init__(__self__, id=None, rotation_lambda_arn=None, rotation_rules=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if rotation_lambda_arn and not isinstance(rotation_lambda_arn, str):
            raise TypeError("Expected argument 'rotation_lambda_arn' to be a str")
        pulumi.set(__self__, "rotation_lambda_arn", rotation_lambda_arn)
        if rotation_rules and not isinstance(rotation_rules, dict):
            raise TypeError("Expected argument 'rotation_rules' to be a dict")
        pulumi.set(__self__, "rotation_rules", rotation_rules)

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ARN of the secret.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="rotationLambdaArn")
    def rotation_lambda_arn(self) -> Optional[builtins.str]:
        """
        The ARN of an existing Lambda rotation function. To specify a rotation function that is also defined in this template, use the Ref function.
        """
        return pulumi.get(self, "rotation_lambda_arn")

    @property
    @pulumi.getter(name="rotationRules")
    def rotation_rules(self) -> Optional['outputs.RotationScheduleRotationRules']:
        """
        A structure that defines the rotation configuration for this secret.
        """
        return pulumi.get(self, "rotation_rules")


class AwaitableGetRotationScheduleResult(GetRotationScheduleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRotationScheduleResult(
            id=self.id,
            rotation_lambda_arn=self.rotation_lambda_arn,
            rotation_rules=self.rotation_rules)


def get_rotation_schedule(id: Optional[builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRotationScheduleResult:
    """
    Resource Type definition for AWS::SecretsManager::RotationSchedule


    :param builtins.str id: The ARN of the secret.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:secretsmanager:getRotationSchedule', __args__, opts=opts, typ=GetRotationScheduleResult).value

    return AwaitableGetRotationScheduleResult(
        id=pulumi.get(__ret__, 'id'),
        rotation_lambda_arn=pulumi.get(__ret__, 'rotation_lambda_arn'),
        rotation_rules=pulumi.get(__ret__, 'rotation_rules'))
def get_rotation_schedule_output(id: Optional[pulumi.Input[builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRotationScheduleResult]:
    """
    Resource Type definition for AWS::SecretsManager::RotationSchedule


    :param builtins.str id: The ARN of the secret.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:secretsmanager:getRotationSchedule', __args__, opts=opts, typ=GetRotationScheduleResult)
    return __ret__.apply(lambda __response__: GetRotationScheduleResult(
        id=pulumi.get(__response__, 'id'),
        rotation_lambda_arn=pulumi.get(__response__, 'rotation_lambda_arn'),
        rotation_rules=pulumi.get(__response__, 'rotation_rules')))
