# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'RotationScheduleHostedRotationLambdaArgs',
    'RotationScheduleHostedRotationLambdaArgsDict',
    'RotationScheduleRotationRulesArgs',
    'RotationScheduleRotationRulesArgsDict',
    'SecretGenerateSecretStringArgs',
    'SecretGenerateSecretStringArgsDict',
    'SecretReplicaRegionArgs',
    'SecretReplicaRegionArgsDict',
]

MYPY = False

if not MYPY:
    class RotationScheduleHostedRotationLambdaArgsDict(TypedDict):
        rotation_type: pulumi.Input[builtins.str]
        """
        The type of rotation template to use
        """
        exclude_characters: NotRequired[pulumi.Input[builtins.str]]
        """
        A string of the characters that you don't want in the password.
        """
        kms_key_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The ARN of the KMS key that Secrets Manager uses to encrypt the secret. If you don't specify this value, then Secrets Manager uses the key aws/secretsmanager. If aws/secretsmanager doesn't yet exist, then Secrets Manager creates it for you automatically the first time it encrypts the secret value.
        """
        master_secret_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The ARN of the secret that contains superuser credentials, if you use the alternating users rotation strategy. CloudFormation grants the execution role for the Lambda rotation function GetSecretValue permission to the secret in this property.
        """
        master_secret_kms_key_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The ARN of the KMS key that Secrets Manager used to encrypt the superuser secret, if you use the alternating users strategy and the superuser secret is encrypted with a customer managed key. You don't need to specify this property if the superuser secret is encrypted using the key aws/secretsmanager. CloudFormation grants the execution role for the Lambda rotation function Decrypt, DescribeKey, and GenerateDataKey permission to the key in this property.
        """
        rotation_lambda_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the Lambda rotation function.
        """
        runtime: NotRequired[pulumi.Input[builtins.str]]
        """
        The python runtime associated with the Lambda function
        """
        superuser_secret_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The ARN of the secret that contains superuser credentials, if you use the alternating users rotation strategy. CloudFormation grants the execution role for the Lambda rotation function GetSecretValue permission to the secret in this property.
        """
        superuser_secret_kms_key_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The ARN of the KMS key that Secrets Manager used to encrypt the superuser secret, if you use the alternating users strategy and the superuser secret is encrypted with a customer managed key. You don't need to specify this property if the superuser secret is encrypted using the key aws/secretsmanager. CloudFormation grants the execution role for the Lambda rotation function Decrypt, DescribeKey, and GenerateDataKey permission to the key in this property.
        """
        vpc_security_group_ids: NotRequired[pulumi.Input[builtins.str]]
        """
        A comma-separated list of security group IDs applied to the target database.
        """
        vpc_subnet_ids: NotRequired[pulumi.Input[builtins.str]]
        """
        A comma separated list of VPC subnet IDs of the target database network. The Lambda rotation function is in the same subnet group.
        """
elif False:
    RotationScheduleHostedRotationLambdaArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RotationScheduleHostedRotationLambdaArgs:
    def __init__(__self__, *,
                 rotation_type: pulumi.Input[builtins.str],
                 exclude_characters: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_arn: Optional[pulumi.Input[builtins.str]] = None,
                 master_secret_arn: Optional[pulumi.Input[builtins.str]] = None,
                 master_secret_kms_key_arn: Optional[pulumi.Input[builtins.str]] = None,
                 rotation_lambda_name: Optional[pulumi.Input[builtins.str]] = None,
                 runtime: Optional[pulumi.Input[builtins.str]] = None,
                 superuser_secret_arn: Optional[pulumi.Input[builtins.str]] = None,
                 superuser_secret_kms_key_arn: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_security_group_ids: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_subnet_ids: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] rotation_type: The type of rotation template to use
        :param pulumi.Input[builtins.str] exclude_characters: A string of the characters that you don't want in the password.
        :param pulumi.Input[builtins.str] kms_key_arn: The ARN of the KMS key that Secrets Manager uses to encrypt the secret. If you don't specify this value, then Secrets Manager uses the key aws/secretsmanager. If aws/secretsmanager doesn't yet exist, then Secrets Manager creates it for you automatically the first time it encrypts the secret value.
        :param pulumi.Input[builtins.str] master_secret_arn: The ARN of the secret that contains superuser credentials, if you use the alternating users rotation strategy. CloudFormation grants the execution role for the Lambda rotation function GetSecretValue permission to the secret in this property.
        :param pulumi.Input[builtins.str] master_secret_kms_key_arn: The ARN of the KMS key that Secrets Manager used to encrypt the superuser secret, if you use the alternating users strategy and the superuser secret is encrypted with a customer managed key. You don't need to specify this property if the superuser secret is encrypted using the key aws/secretsmanager. CloudFormation grants the execution role for the Lambda rotation function Decrypt, DescribeKey, and GenerateDataKey permission to the key in this property.
        :param pulumi.Input[builtins.str] rotation_lambda_name: The name of the Lambda rotation function.
        :param pulumi.Input[builtins.str] runtime: The python runtime associated with the Lambda function
        :param pulumi.Input[builtins.str] superuser_secret_arn: The ARN of the secret that contains superuser credentials, if you use the alternating users rotation strategy. CloudFormation grants the execution role for the Lambda rotation function GetSecretValue permission to the secret in this property.
        :param pulumi.Input[builtins.str] superuser_secret_kms_key_arn: The ARN of the KMS key that Secrets Manager used to encrypt the superuser secret, if you use the alternating users strategy and the superuser secret is encrypted with a customer managed key. You don't need to specify this property if the superuser secret is encrypted using the key aws/secretsmanager. CloudFormation grants the execution role for the Lambda rotation function Decrypt, DescribeKey, and GenerateDataKey permission to the key in this property.
        :param pulumi.Input[builtins.str] vpc_security_group_ids: A comma-separated list of security group IDs applied to the target database.
        :param pulumi.Input[builtins.str] vpc_subnet_ids: A comma separated list of VPC subnet IDs of the target database network. The Lambda rotation function is in the same subnet group.
        """
        pulumi.set(__self__, "rotation_type", rotation_type)
        if exclude_characters is not None:
            pulumi.set(__self__, "exclude_characters", exclude_characters)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if master_secret_arn is not None:
            pulumi.set(__self__, "master_secret_arn", master_secret_arn)
        if master_secret_kms_key_arn is not None:
            pulumi.set(__self__, "master_secret_kms_key_arn", master_secret_kms_key_arn)
        if rotation_lambda_name is not None:
            pulumi.set(__self__, "rotation_lambda_name", rotation_lambda_name)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if superuser_secret_arn is not None:
            pulumi.set(__self__, "superuser_secret_arn", superuser_secret_arn)
        if superuser_secret_kms_key_arn is not None:
            pulumi.set(__self__, "superuser_secret_kms_key_arn", superuser_secret_kms_key_arn)
        if vpc_security_group_ids is not None:
            pulumi.set(__self__, "vpc_security_group_ids", vpc_security_group_ids)
        if vpc_subnet_ids is not None:
            pulumi.set(__self__, "vpc_subnet_ids", vpc_subnet_ids)

    @property
    @pulumi.getter(name="rotationType")
    def rotation_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of rotation template to use
        """
        return pulumi.get(self, "rotation_type")

    @rotation_type.setter
    def rotation_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "rotation_type", value)

    @property
    @pulumi.getter(name="excludeCharacters")
    def exclude_characters(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A string of the characters that you don't want in the password.
        """
        return pulumi.get(self, "exclude_characters")

    @exclude_characters.setter
    def exclude_characters(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "exclude_characters", value)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the KMS key that Secrets Manager uses to encrypt the secret. If you don't specify this value, then Secrets Manager uses the key aws/secretsmanager. If aws/secretsmanager doesn't yet exist, then Secrets Manager creates it for you automatically the first time it encrypts the secret value.
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_arn", value)

    @property
    @pulumi.getter(name="masterSecretArn")
    def master_secret_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the secret that contains superuser credentials, if you use the alternating users rotation strategy. CloudFormation grants the execution role for the Lambda rotation function GetSecretValue permission to the secret in this property.
        """
        return pulumi.get(self, "master_secret_arn")

    @master_secret_arn.setter
    def master_secret_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "master_secret_arn", value)

    @property
    @pulumi.getter(name="masterSecretKmsKeyArn")
    def master_secret_kms_key_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the KMS key that Secrets Manager used to encrypt the superuser secret, if you use the alternating users strategy and the superuser secret is encrypted with a customer managed key. You don't need to specify this property if the superuser secret is encrypted using the key aws/secretsmanager. CloudFormation grants the execution role for the Lambda rotation function Decrypt, DescribeKey, and GenerateDataKey permission to the key in this property.
        """
        return pulumi.get(self, "master_secret_kms_key_arn")

    @master_secret_kms_key_arn.setter
    def master_secret_kms_key_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "master_secret_kms_key_arn", value)

    @property
    @pulumi.getter(name="rotationLambdaName")
    def rotation_lambda_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Lambda rotation function.
        """
        return pulumi.get(self, "rotation_lambda_name")

    @rotation_lambda_name.setter
    def rotation_lambda_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rotation_lambda_name", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The python runtime associated with the Lambda function
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter(name="superuserSecretArn")
    def superuser_secret_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the secret that contains superuser credentials, if you use the alternating users rotation strategy. CloudFormation grants the execution role for the Lambda rotation function GetSecretValue permission to the secret in this property.
        """
        return pulumi.get(self, "superuser_secret_arn")

    @superuser_secret_arn.setter
    def superuser_secret_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "superuser_secret_arn", value)

    @property
    @pulumi.getter(name="superuserSecretKmsKeyArn")
    def superuser_secret_kms_key_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the KMS key that Secrets Manager used to encrypt the superuser secret, if you use the alternating users strategy and the superuser secret is encrypted with a customer managed key. You don't need to specify this property if the superuser secret is encrypted using the key aws/secretsmanager. CloudFormation grants the execution role for the Lambda rotation function Decrypt, DescribeKey, and GenerateDataKey permission to the key in this property.
        """
        return pulumi.get(self, "superuser_secret_kms_key_arn")

    @superuser_secret_kms_key_arn.setter
    def superuser_secret_kms_key_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "superuser_secret_kms_key_arn", value)

    @property
    @pulumi.getter(name="vpcSecurityGroupIds")
    def vpc_security_group_ids(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A comma-separated list of security group IDs applied to the target database.
        """
        return pulumi.get(self, "vpc_security_group_ids")

    @vpc_security_group_ids.setter
    def vpc_security_group_ids(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpc_security_group_ids", value)

    @property
    @pulumi.getter(name="vpcSubnetIds")
    def vpc_subnet_ids(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A comma separated list of VPC subnet IDs of the target database network. The Lambda rotation function is in the same subnet group.
        """
        return pulumi.get(self, "vpc_subnet_ids")

    @vpc_subnet_ids.setter
    def vpc_subnet_ids(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpc_subnet_ids", value)


if not MYPY:
    class RotationScheduleRotationRulesArgsDict(TypedDict):
        automatically_after_days: NotRequired[pulumi.Input[builtins.int]]
        """
        The number of days between automatic scheduled rotations of the secret. You can use this value to check that your secret meets your compliance guidelines for how often secrets must be rotated.
        """
        duration: NotRequired[pulumi.Input[builtins.str]]
        """
        The length of the rotation window in hours, for example 3h for a three hour window. Secrets Manager rotates your secret at any time during this window. The window must not extend into the next rotation window or the next UTC day. The window starts according to the ScheduleExpression. If you don't specify a Duration, for a ScheduleExpression in hours, the window automatically closes after one hour. For a ScheduleExpression in days, the window automatically closes at the end of the UTC day.
        """
        schedule_expression: NotRequired[pulumi.Input[builtins.str]]
        """
        A cron() or rate() expression that defines the schedule for rotating your secret. Secrets Manager rotation schedules use UTC time zone.
        """
elif False:
    RotationScheduleRotationRulesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class RotationScheduleRotationRulesArgs:
    def __init__(__self__, *,
                 automatically_after_days: Optional[pulumi.Input[builtins.int]] = None,
                 duration: Optional[pulumi.Input[builtins.str]] = None,
                 schedule_expression: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.int] automatically_after_days: The number of days between automatic scheduled rotations of the secret. You can use this value to check that your secret meets your compliance guidelines for how often secrets must be rotated.
        :param pulumi.Input[builtins.str] duration: The length of the rotation window in hours, for example 3h for a three hour window. Secrets Manager rotates your secret at any time during this window. The window must not extend into the next rotation window or the next UTC day. The window starts according to the ScheduleExpression. If you don't specify a Duration, for a ScheduleExpression in hours, the window automatically closes after one hour. For a ScheduleExpression in days, the window automatically closes at the end of the UTC day.
        :param pulumi.Input[builtins.str] schedule_expression: A cron() or rate() expression that defines the schedule for rotating your secret. Secrets Manager rotation schedules use UTC time zone.
        """
        if automatically_after_days is not None:
            pulumi.set(__self__, "automatically_after_days", automatically_after_days)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if schedule_expression is not None:
            pulumi.set(__self__, "schedule_expression", schedule_expression)

    @property
    @pulumi.getter(name="automaticallyAfterDays")
    def automatically_after_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of days between automatic scheduled rotations of the secret. You can use this value to check that your secret meets your compliance guidelines for how often secrets must be rotated.
        """
        return pulumi.get(self, "automatically_after_days")

    @automatically_after_days.setter
    def automatically_after_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "automatically_after_days", value)

    @property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The length of the rotation window in hours, for example 3h for a three hour window. Secrets Manager rotates your secret at any time during this window. The window must not extend into the next rotation window or the next UTC day. The window starts according to the ScheduleExpression. If you don't specify a Duration, for a ScheduleExpression in hours, the window automatically closes after one hour. For a ScheduleExpression in days, the window automatically closes at the end of the UTC day.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A cron() or rate() expression that defines the schedule for rotating your secret. Secrets Manager rotation schedules use UTC time zone.
        """
        return pulumi.get(self, "schedule_expression")

    @schedule_expression.setter
    def schedule_expression(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "schedule_expression", value)


if not MYPY:
    class SecretGenerateSecretStringArgsDict(TypedDict):
        """
        Generates a random password. We recommend that you specify the maximum length and include every character type that the system you are generating a password for can support.
         *Required permissions:*``secretsmanager:GetRandomPassword``. For more information, see [IAM policy actions for Secrets Manager](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssecretsmanager.html#awssecretsmanager-actions-as-permissions) and [Authentication and access control in Secrets Manager](https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html).
        """
        exclude_characters: NotRequired[pulumi.Input[builtins.str]]
        """
        A string of the characters that you don't want in the password.
        """
        exclude_lowercase: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies whether to exclude lowercase letters from the password. If you don't include this switch, the password can contain lowercase letters.
        """
        exclude_numbers: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies whether to exclude numbers from the password. If you don't include this switch, the password can contain numbers.
        """
        exclude_punctuation: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies whether to exclude the following punctuation characters from the password: ``! " # $ % & ' ( ) * + , - . / : ; < = > ? @ [ \\ ] ^ _ ` { | } ~``. If you don't include this switch, the password can contain punctuation.
        """
        exclude_uppercase: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies whether to exclude uppercase letters from the password. If you don't include this switch, the password can contain uppercase letters.
        """
        generate_string_key: NotRequired[pulumi.Input[builtins.str]]
        """
        The JSON key name for the key/value pair, where the value is the generated password. This pair is added to the JSON structure specified by the ``SecretStringTemplate`` parameter. If you specify this parameter, then you must also specify ``SecretStringTemplate``.
        """
        include_space: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies whether to include the space character. If you include this switch, the password can contain space characters.
        """
        password_length: NotRequired[pulumi.Input[builtins.int]]
        """
        The length of the password. If you don't include this parameter, the default length is 32 characters.
        """
        require_each_included_type: NotRequired[pulumi.Input[builtins.bool]]
        """
        Specifies whether to include at least one upper and lowercase letter, one number, and one punctuation. If you don't include this switch, the password contains at least one of every character type.
        """
        secret_string_template: NotRequired[pulumi.Input[builtins.str]]
        """
        A template that the generated string must match. When you make a change to this property, a new secret version is created.
        """
elif False:
    SecretGenerateSecretStringArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecretGenerateSecretStringArgs:
    def __init__(__self__, *,
                 exclude_characters: Optional[pulumi.Input[builtins.str]] = None,
                 exclude_lowercase: Optional[pulumi.Input[builtins.bool]] = None,
                 exclude_numbers: Optional[pulumi.Input[builtins.bool]] = None,
                 exclude_punctuation: Optional[pulumi.Input[builtins.bool]] = None,
                 exclude_uppercase: Optional[pulumi.Input[builtins.bool]] = None,
                 generate_string_key: Optional[pulumi.Input[builtins.str]] = None,
                 include_space: Optional[pulumi.Input[builtins.bool]] = None,
                 password_length: Optional[pulumi.Input[builtins.int]] = None,
                 require_each_included_type: Optional[pulumi.Input[builtins.bool]] = None,
                 secret_string_template: Optional[pulumi.Input[builtins.str]] = None):
        """
        Generates a random password. We recommend that you specify the maximum length and include every character type that the system you are generating a password for can support.
         *Required permissions:*``secretsmanager:GetRandomPassword``. For more information, see [IAM policy actions for Secrets Manager](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssecretsmanager.html#awssecretsmanager-actions-as-permissions) and [Authentication and access control in Secrets Manager](https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access.html).
        :param pulumi.Input[builtins.str] exclude_characters: A string of the characters that you don't want in the password.
        :param pulumi.Input[builtins.bool] exclude_lowercase: Specifies whether to exclude lowercase letters from the password. If you don't include this switch, the password can contain lowercase letters.
        :param pulumi.Input[builtins.bool] exclude_numbers: Specifies whether to exclude numbers from the password. If you don't include this switch, the password can contain numbers.
        :param pulumi.Input[builtins.bool] exclude_punctuation: Specifies whether to exclude the following punctuation characters from the password: ``! " # $ % & ' ( ) * + , - . / : ; < = > ? @ [ \\ ] ^ _ ` { | } ~``. If you don't include this switch, the password can contain punctuation.
        :param pulumi.Input[builtins.bool] exclude_uppercase: Specifies whether to exclude uppercase letters from the password. If you don't include this switch, the password can contain uppercase letters.
        :param pulumi.Input[builtins.str] generate_string_key: The JSON key name for the key/value pair, where the value is the generated password. This pair is added to the JSON structure specified by the ``SecretStringTemplate`` parameter. If you specify this parameter, then you must also specify ``SecretStringTemplate``.
        :param pulumi.Input[builtins.bool] include_space: Specifies whether to include the space character. If you include this switch, the password can contain space characters.
        :param pulumi.Input[builtins.int] password_length: The length of the password. If you don't include this parameter, the default length is 32 characters.
        :param pulumi.Input[builtins.bool] require_each_included_type: Specifies whether to include at least one upper and lowercase letter, one number, and one punctuation. If you don't include this switch, the password contains at least one of every character type.
        :param pulumi.Input[builtins.str] secret_string_template: A template that the generated string must match. When you make a change to this property, a new secret version is created.
        """
        if exclude_characters is not None:
            pulumi.set(__self__, "exclude_characters", exclude_characters)
        if exclude_lowercase is not None:
            pulumi.set(__self__, "exclude_lowercase", exclude_lowercase)
        if exclude_numbers is not None:
            pulumi.set(__self__, "exclude_numbers", exclude_numbers)
        if exclude_punctuation is not None:
            pulumi.set(__self__, "exclude_punctuation", exclude_punctuation)
        if exclude_uppercase is not None:
            pulumi.set(__self__, "exclude_uppercase", exclude_uppercase)
        if generate_string_key is not None:
            pulumi.set(__self__, "generate_string_key", generate_string_key)
        if include_space is not None:
            pulumi.set(__self__, "include_space", include_space)
        if password_length is not None:
            pulumi.set(__self__, "password_length", password_length)
        if require_each_included_type is not None:
            pulumi.set(__self__, "require_each_included_type", require_each_included_type)
        if secret_string_template is not None:
            pulumi.set(__self__, "secret_string_template", secret_string_template)

    @property
    @pulumi.getter(name="excludeCharacters")
    def exclude_characters(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A string of the characters that you don't want in the password.
        """
        return pulumi.get(self, "exclude_characters")

    @exclude_characters.setter
    def exclude_characters(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "exclude_characters", value)

    @property
    @pulumi.getter(name="excludeLowercase")
    def exclude_lowercase(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether to exclude lowercase letters from the password. If you don't include this switch, the password can contain lowercase letters.
        """
        return pulumi.get(self, "exclude_lowercase")

    @exclude_lowercase.setter
    def exclude_lowercase(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "exclude_lowercase", value)

    @property
    @pulumi.getter(name="excludeNumbers")
    def exclude_numbers(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether to exclude numbers from the password. If you don't include this switch, the password can contain numbers.
        """
        return pulumi.get(self, "exclude_numbers")

    @exclude_numbers.setter
    def exclude_numbers(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "exclude_numbers", value)

    @property
    @pulumi.getter(name="excludePunctuation")
    def exclude_punctuation(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether to exclude the following punctuation characters from the password: ``! " # $ % & ' ( ) * + , - . / : ; < = > ? @ [ \\ ] ^ _ ` { | } ~``. If you don't include this switch, the password can contain punctuation.
        """
        return pulumi.get(self, "exclude_punctuation")

    @exclude_punctuation.setter
    def exclude_punctuation(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "exclude_punctuation", value)

    @property
    @pulumi.getter(name="excludeUppercase")
    def exclude_uppercase(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether to exclude uppercase letters from the password. If you don't include this switch, the password can contain uppercase letters.
        """
        return pulumi.get(self, "exclude_uppercase")

    @exclude_uppercase.setter
    def exclude_uppercase(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "exclude_uppercase", value)

    @property
    @pulumi.getter(name="generateStringKey")
    def generate_string_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The JSON key name for the key/value pair, where the value is the generated password. This pair is added to the JSON structure specified by the ``SecretStringTemplate`` parameter. If you specify this parameter, then you must also specify ``SecretStringTemplate``.
        """
        return pulumi.get(self, "generate_string_key")

    @generate_string_key.setter
    def generate_string_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "generate_string_key", value)

    @property
    @pulumi.getter(name="includeSpace")
    def include_space(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether to include the space character. If you include this switch, the password can contain space characters.
        """
        return pulumi.get(self, "include_space")

    @include_space.setter
    def include_space(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "include_space", value)

    @property
    @pulumi.getter(name="passwordLength")
    def password_length(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The length of the password. If you don't include this parameter, the default length is 32 characters.
        """
        return pulumi.get(self, "password_length")

    @password_length.setter
    def password_length(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "password_length", value)

    @property
    @pulumi.getter(name="requireEachIncludedType")
    def require_each_included_type(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether to include at least one upper and lowercase letter, one number, and one punctuation. If you don't include this switch, the password contains at least one of every character type.
        """
        return pulumi.get(self, "require_each_included_type")

    @require_each_included_type.setter
    def require_each_included_type(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "require_each_included_type", value)

    @property
    @pulumi.getter(name="secretStringTemplate")
    def secret_string_template(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A template that the generated string must match. When you make a change to this property, a new secret version is created.
        """
        return pulumi.get(self, "secret_string_template")

    @secret_string_template.setter
    def secret_string_template(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secret_string_template", value)


if not MYPY:
    class SecretReplicaRegionArgsDict(TypedDict):
        """
        Specifies a ``Region`` and the ``KmsKeyId`` for a replica secret.
        """
        region: pulumi.Input[builtins.str]
        """
        A string that represents a ``Region``, for example "us-east-1".
        """
        kms_key_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ARN, key ID, or alias of the KMS key to encrypt the secret. If you don't include this field, Secrets Manager uses ``aws/secretsmanager``.
        """
elif False:
    SecretReplicaRegionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecretReplicaRegionArgs:
    def __init__(__self__, *,
                 region: pulumi.Input[builtins.str],
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Specifies a ``Region`` and the ``KmsKeyId`` for a replica secret.
        :param pulumi.Input[builtins.str] region: A string that represents a ``Region``, for example "us-east-1".
        :param pulumi.Input[builtins.str] kms_key_id: The ARN, key ID, or alias of the KMS key to encrypt the secret. If you don't include this field, Secrets Manager uses ``aws/secretsmanager``.
        """
        pulumi.set(__self__, "region", region)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[builtins.str]:
        """
        A string that represents a ``Region``, for example "us-east-1".
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN, key ID, or alias of the KMS key to encrypt the secret. If you don't include this field, Secrets Manager uses ``aws/secretsmanager``.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)


