# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = ['StudioLifecycleConfigArgs', 'StudioLifecycleConfig']

@pulumi.input_type
class StudioLifecycleConfigArgs:
    def __init__(__self__, *,
                 studio_lifecycle_config_app_type: pulumi.Input['StudioLifecycleConfigAppType'],
                 studio_lifecycle_config_content: pulumi.Input[builtins.str],
                 studio_lifecycle_config_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]]] = None):
        """
        The set of arguments for constructing a StudioLifecycleConfig resource.
        :param pulumi.Input['StudioLifecycleConfigAppType'] studio_lifecycle_config_app_type: The App type that the Lifecycle Configuration is attached to.
        :param pulumi.Input[builtins.str] studio_lifecycle_config_content: The content of your Amazon SageMaker Studio Lifecycle Configuration script. This content must be base64 encoded.
        :param pulumi.Input[builtins.str] studio_lifecycle_config_name: The name of the Amazon SageMaker Studio Lifecycle Configuration.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]] tags: Tags to be associated with the Lifecycle Configuration. Each tag consists of a key and an optional value. Tag keys must be unique per resource. Tags are searchable using the Search API.
        """
        pulumi.set(__self__, "studio_lifecycle_config_app_type", studio_lifecycle_config_app_type)
        pulumi.set(__self__, "studio_lifecycle_config_content", studio_lifecycle_config_content)
        if studio_lifecycle_config_name is not None:
            pulumi.set(__self__, "studio_lifecycle_config_name", studio_lifecycle_config_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="studioLifecycleConfigAppType")
    def studio_lifecycle_config_app_type(self) -> pulumi.Input['StudioLifecycleConfigAppType']:
        """
        The App type that the Lifecycle Configuration is attached to.
        """
        return pulumi.get(self, "studio_lifecycle_config_app_type")

    @studio_lifecycle_config_app_type.setter
    def studio_lifecycle_config_app_type(self, value: pulumi.Input['StudioLifecycleConfigAppType']):
        pulumi.set(self, "studio_lifecycle_config_app_type", value)

    @property
    @pulumi.getter(name="studioLifecycleConfigContent")
    def studio_lifecycle_config_content(self) -> pulumi.Input[builtins.str]:
        """
        The content of your Amazon SageMaker Studio Lifecycle Configuration script. This content must be base64 encoded.
        """
        return pulumi.get(self, "studio_lifecycle_config_content")

    @studio_lifecycle_config_content.setter
    def studio_lifecycle_config_content(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "studio_lifecycle_config_content", value)

    @property
    @pulumi.getter(name="studioLifecycleConfigName")
    def studio_lifecycle_config_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Amazon SageMaker Studio Lifecycle Configuration.
        """
        return pulumi.get(self, "studio_lifecycle_config_name")

    @studio_lifecycle_config_name.setter
    def studio_lifecycle_config_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "studio_lifecycle_config_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]]]:
        """
        Tags to be associated with the Lifecycle Configuration. Each tag consists of a key and an optional value. Tag keys must be unique per resource. Tags are searchable using the Search API.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.CreateOnlyTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:sagemaker:StudioLifecycleConfig")
class StudioLifecycleConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 studio_lifecycle_config_app_type: Optional[pulumi.Input['StudioLifecycleConfigAppType']] = None,
                 studio_lifecycle_config_content: Optional[pulumi.Input[builtins.str]] = None,
                 studio_lifecycle_config_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.CreateOnlyTagArgs', '_root_inputs.CreateOnlyTagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::SageMaker::StudioLifecycleConfig

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input['StudioLifecycleConfigAppType'] studio_lifecycle_config_app_type: The App type that the Lifecycle Configuration is attached to.
        :param pulumi.Input[builtins.str] studio_lifecycle_config_content: The content of your Amazon SageMaker Studio Lifecycle Configuration script. This content must be base64 encoded.
        :param pulumi.Input[builtins.str] studio_lifecycle_config_name: The name of the Amazon SageMaker Studio Lifecycle Configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.CreateOnlyTagArgs', '_root_inputs.CreateOnlyTagArgsDict']]]] tags: Tags to be associated with the Lifecycle Configuration. Each tag consists of a key and an optional value. Tag keys must be unique per resource. Tags are searchable using the Search API.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StudioLifecycleConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::SageMaker::StudioLifecycleConfig

        :param str resource_name: The name of the resource.
        :param StudioLifecycleConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StudioLifecycleConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 studio_lifecycle_config_app_type: Optional[pulumi.Input['StudioLifecycleConfigAppType']] = None,
                 studio_lifecycle_config_content: Optional[pulumi.Input[builtins.str]] = None,
                 studio_lifecycle_config_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.CreateOnlyTagArgs', '_root_inputs.CreateOnlyTagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StudioLifecycleConfigArgs.__new__(StudioLifecycleConfigArgs)

            if studio_lifecycle_config_app_type is None and not opts.urn:
                raise TypeError("Missing required property 'studio_lifecycle_config_app_type'")
            __props__.__dict__["studio_lifecycle_config_app_type"] = studio_lifecycle_config_app_type
            if studio_lifecycle_config_content is None and not opts.urn:
                raise TypeError("Missing required property 'studio_lifecycle_config_content'")
            __props__.__dict__["studio_lifecycle_config_content"] = studio_lifecycle_config_content
            __props__.__dict__["studio_lifecycle_config_name"] = studio_lifecycle_config_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["studio_lifecycle_config_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["studioLifecycleConfigAppType", "studioLifecycleConfigContent", "studioLifecycleConfigName", "tags[*]"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(StudioLifecycleConfig, __self__).__init__(
            'aws-native:sagemaker:StudioLifecycleConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'StudioLifecycleConfig':
        """
        Get an existing StudioLifecycleConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = StudioLifecycleConfigArgs.__new__(StudioLifecycleConfigArgs)

        __props__.__dict__["studio_lifecycle_config_app_type"] = None
        __props__.__dict__["studio_lifecycle_config_arn"] = None
        __props__.__dict__["studio_lifecycle_config_content"] = None
        __props__.__dict__["studio_lifecycle_config_name"] = None
        __props__.__dict__["tags"] = None
        return StudioLifecycleConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="studioLifecycleConfigAppType")
    def studio_lifecycle_config_app_type(self) -> pulumi.Output['StudioLifecycleConfigAppType']:
        """
        The App type that the Lifecycle Configuration is attached to.
        """
        return pulumi.get(self, "studio_lifecycle_config_app_type")

    @property
    @pulumi.getter(name="studioLifecycleConfigArn")
    def studio_lifecycle_config_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the Lifecycle Configuration.
        """
        return pulumi.get(self, "studio_lifecycle_config_arn")

    @property
    @pulumi.getter(name="studioLifecycleConfigContent")
    def studio_lifecycle_config_content(self) -> pulumi.Output[builtins.str]:
        """
        The content of your Amazon SageMaker Studio Lifecycle Configuration script. This content must be base64 encoded.
        """
        return pulumi.get(self, "studio_lifecycle_config_content")

    @property
    @pulumi.getter(name="studioLifecycleConfigName")
    def studio_lifecycle_config_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Amazon SageMaker Studio Lifecycle Configuration.
        """
        return pulumi.get(self, "studio_lifecycle_config_name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.CreateOnlyTag']]]:
        """
        Tags to be associated with the Lifecycle Configuration. Each tag consists of a key and an optional value. Tag keys must be unique per resource. Tags are searchable using the Search API.
        """
        return pulumi.get(self, "tags")

