# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['PartnerAppArgs', 'PartnerApp']

@pulumi.input_type
class PartnerAppArgs:
    def __init__(__self__, *,
                 auth_type: pulumi.Input['PartnerAppAuthType'],
                 execution_role_arn: pulumi.Input[builtins.str],
                 tier: pulumi.Input[builtins.str],
                 type: pulumi.Input['PartnerAppType'],
                 application_config: Optional[pulumi.Input['PartnerAppConfigArgs']] = None,
                 client_token: Optional[pulumi.Input[builtins.str]] = None,
                 enable_iam_session_based_identity: Optional[pulumi.Input[builtins.bool]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_config: Optional[pulumi.Input['PartnerAppMaintenanceConfigArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a PartnerApp resource.
        :param pulumi.Input['PartnerAppAuthType'] auth_type: The Auth type of PartnerApp.
        :param pulumi.Input[builtins.str] execution_role_arn: The execution role for the user.
        :param pulumi.Input[builtins.str] tier: The tier of the PartnerApp.
        :param pulumi.Input['PartnerAppType'] type: The type of PartnerApp.
        :param pulumi.Input['PartnerAppConfigArgs'] application_config: A collection of settings that specify the maintenance schedule for the PartnerApp.
        :param pulumi.Input[builtins.str] client_token: The client token for the PartnerApp.
        :param pulumi.Input[builtins.bool] enable_iam_session_based_identity: Enables IAM Session based Identity for PartnerApp.
        :param pulumi.Input[builtins.str] kms_key_id: The AWS KMS customer managed key used to encrypt the data associated with the PartnerApp.
        :param pulumi.Input['PartnerAppMaintenanceConfigArgs'] maintenance_config: A collection of settings that specify the maintenance schedule for the PartnerApp.
        :param pulumi.Input[builtins.str] name: A name for the PartnerApp.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: A list of tags to apply to the PartnerApp.
        """
        pulumi.set(__self__, "auth_type", auth_type)
        pulumi.set(__self__, "execution_role_arn", execution_role_arn)
        pulumi.set(__self__, "tier", tier)
        pulumi.set(__self__, "type", type)
        if application_config is not None:
            pulumi.set(__self__, "application_config", application_config)
        if client_token is not None:
            pulumi.set(__self__, "client_token", client_token)
        if enable_iam_session_based_identity is not None:
            pulumi.set(__self__, "enable_iam_session_based_identity", enable_iam_session_based_identity)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if maintenance_config is not None:
            pulumi.set(__self__, "maintenance_config", maintenance_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Input['PartnerAppAuthType']:
        """
        The Auth type of PartnerApp.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: pulumi.Input['PartnerAppAuthType']):
        pulumi.set(self, "auth_type", value)

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> pulumi.Input[builtins.str]:
        """
        The execution role for the user.
        """
        return pulumi.get(self, "execution_role_arn")

    @execution_role_arn.setter
    def execution_role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "execution_role_arn", value)

    @property
    @pulumi.getter
    def tier(self) -> pulumi.Input[builtins.str]:
        """
        The tier of the PartnerApp.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "tier", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['PartnerAppType']:
        """
        The type of PartnerApp.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['PartnerAppType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="applicationConfig")
    def application_config(self) -> Optional[pulumi.Input['PartnerAppConfigArgs']]:
        """
        A collection of settings that specify the maintenance schedule for the PartnerApp.
        """
        return pulumi.get(self, "application_config")

    @application_config.setter
    def application_config(self, value: Optional[pulumi.Input['PartnerAppConfigArgs']]):
        pulumi.set(self, "application_config", value)

    @property
    @pulumi.getter(name="clientToken")
    def client_token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The client token for the PartnerApp.
        """
        return pulumi.get(self, "client_token")

    @client_token.setter
    def client_token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_token", value)

    @property
    @pulumi.getter(name="enableIamSessionBasedIdentity")
    def enable_iam_session_based_identity(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enables IAM Session based Identity for PartnerApp.
        """
        return pulumi.get(self, "enable_iam_session_based_identity")

    @enable_iam_session_based_identity.setter
    def enable_iam_session_based_identity(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_iam_session_based_identity", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS KMS customer managed key used to encrypt the data associated with the PartnerApp.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="maintenanceConfig")
    def maintenance_config(self) -> Optional[pulumi.Input['PartnerAppMaintenanceConfigArgs']]:
        """
        A collection of settings that specify the maintenance schedule for the PartnerApp.
        """
        return pulumi.get(self, "maintenance_config")

    @maintenance_config.setter
    def maintenance_config(self, value: Optional[pulumi.Input['PartnerAppMaintenanceConfigArgs']]):
        pulumi.set(self, "maintenance_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A name for the PartnerApp.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        A list of tags to apply to the PartnerApp.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:sagemaker:PartnerApp")
class PartnerApp(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_config: Optional[pulumi.Input[Union['PartnerAppConfigArgs', 'PartnerAppConfigArgsDict']]] = None,
                 auth_type: Optional[pulumi.Input['PartnerAppAuthType']] = None,
                 client_token: Optional[pulumi.Input[builtins.str]] = None,
                 enable_iam_session_based_identity: Optional[pulumi.Input[builtins.bool]] = None,
                 execution_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_config: Optional[pulumi.Input[Union['PartnerAppMaintenanceConfigArgs', 'PartnerAppMaintenanceConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 tier: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input['PartnerAppType']] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::SageMaker::PartnerApp

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['PartnerAppConfigArgs', 'PartnerAppConfigArgsDict']] application_config: A collection of settings that specify the maintenance schedule for the PartnerApp.
        :param pulumi.Input['PartnerAppAuthType'] auth_type: The Auth type of PartnerApp.
        :param pulumi.Input[builtins.str] client_token: The client token for the PartnerApp.
        :param pulumi.Input[builtins.bool] enable_iam_session_based_identity: Enables IAM Session based Identity for PartnerApp.
        :param pulumi.Input[builtins.str] execution_role_arn: The execution role for the user.
        :param pulumi.Input[builtins.str] kms_key_id: The AWS KMS customer managed key used to encrypt the data associated with the PartnerApp.
        :param pulumi.Input[Union['PartnerAppMaintenanceConfigArgs', 'PartnerAppMaintenanceConfigArgsDict']] maintenance_config: A collection of settings that specify the maintenance schedule for the PartnerApp.
        :param pulumi.Input[builtins.str] name: A name for the PartnerApp.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: A list of tags to apply to the PartnerApp.
        :param pulumi.Input[builtins.str] tier: The tier of the PartnerApp.
        :param pulumi.Input['PartnerAppType'] type: The type of PartnerApp.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PartnerAppArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::SageMaker::PartnerApp

        :param str resource_name: The name of the resource.
        :param PartnerAppArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PartnerAppArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_config: Optional[pulumi.Input[Union['PartnerAppConfigArgs', 'PartnerAppConfigArgsDict']]] = None,
                 auth_type: Optional[pulumi.Input['PartnerAppAuthType']] = None,
                 client_token: Optional[pulumi.Input[builtins.str]] = None,
                 enable_iam_session_based_identity: Optional[pulumi.Input[builtins.bool]] = None,
                 execution_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 maintenance_config: Optional[pulumi.Input[Union['PartnerAppMaintenanceConfigArgs', 'PartnerAppMaintenanceConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 tier: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input['PartnerAppType']] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PartnerAppArgs.__new__(PartnerAppArgs)

            __props__.__dict__["application_config"] = application_config
            if auth_type is None and not opts.urn:
                raise TypeError("Missing required property 'auth_type'")
            __props__.__dict__["auth_type"] = auth_type
            __props__.__dict__["client_token"] = client_token
            __props__.__dict__["enable_iam_session_based_identity"] = enable_iam_session_based_identity
            if execution_role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'execution_role_arn'")
            __props__.__dict__["execution_role_arn"] = execution_role_arn
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["maintenance_config"] = maintenance_config
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            if tier is None and not opts.urn:
                raise TypeError("Missing required property 'tier'")
            __props__.__dict__["tier"] = tier
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["arn"] = None
            __props__.__dict__["base_url"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["authType", "executionRoleArn", "kmsKeyId", "name", "type"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(PartnerApp, __self__).__init__(
            'aws-native:sagemaker:PartnerApp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'PartnerApp':
        """
        Get an existing PartnerApp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = PartnerAppArgs.__new__(PartnerAppArgs)

        __props__.__dict__["application_config"] = None
        __props__.__dict__["arn"] = None
        __props__.__dict__["auth_type"] = None
        __props__.__dict__["base_url"] = None
        __props__.__dict__["client_token"] = None
        __props__.__dict__["enable_iam_session_based_identity"] = None
        __props__.__dict__["execution_role_arn"] = None
        __props__.__dict__["kms_key_id"] = None
        __props__.__dict__["maintenance_config"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["tier"] = None
        __props__.__dict__["type"] = None
        return PartnerApp(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationConfig")
    def application_config(self) -> pulumi.Output[Optional['outputs.PartnerAppConfig']]:
        """
        A collection of settings that specify the maintenance schedule for the PartnerApp.
        """
        return pulumi.get(self, "application_config")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the created PartnerApp.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Output['PartnerAppAuthType']:
        """
        The Auth type of PartnerApp.
        """
        return pulumi.get(self, "auth_type")

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> pulumi.Output[builtins.str]:
        """
        The AppServerUrl based on app and account-info.
        """
        return pulumi.get(self, "base_url")

    @property
    @pulumi.getter(name="clientToken")
    def client_token(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The client token for the PartnerApp.
        """
        return pulumi.get(self, "client_token")

    @property
    @pulumi.getter(name="enableIamSessionBasedIdentity")
    def enable_iam_session_based_identity(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enables IAM Session based Identity for PartnerApp.
        """
        return pulumi.get(self, "enable_iam_session_based_identity")

    @property
    @pulumi.getter(name="executionRoleArn")
    def execution_role_arn(self) -> pulumi.Output[builtins.str]:
        """
        The execution role for the user.
        """
        return pulumi.get(self, "execution_role_arn")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The AWS KMS customer managed key used to encrypt the data associated with the PartnerApp.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="maintenanceConfig")
    def maintenance_config(self) -> pulumi.Output[Optional['outputs.PartnerAppMaintenanceConfig']]:
        """
        A collection of settings that specify the maintenance schedule for the PartnerApp.
        """
        return pulumi.get(self, "maintenance_config")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        A name for the PartnerApp.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        A list of tags to apply to the PartnerApp.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def tier(self) -> pulumi.Output[builtins.str]:
        """
        The tier of the PartnerApp.
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output['PartnerAppType']:
        """
        The type of PartnerApp.
        """
        return pulumi.get(self, "type")

