# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['InferenceExperimentArgs', 'InferenceExperiment']

@pulumi.input_type
class InferenceExperimentArgs:
    def __init__(__self__, *,
                 endpoint_name: pulumi.Input[builtins.str],
                 model_variants: pulumi.Input[Sequence[pulumi.Input['InferenceExperimentModelVariantConfigArgs']]],
                 role_arn: pulumi.Input[builtins.str],
                 type: pulumi.Input['InferenceExperimentType'],
                 data_storage_config: Optional[pulumi.Input['InferenceExperimentDataStorageConfigArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 desired_state: Optional[pulumi.Input['InferenceExperimentDesiredState']] = None,
                 kms_key: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 schedule: Optional[pulumi.Input['InferenceExperimentScheduleArgs']] = None,
                 shadow_mode_config: Optional[pulumi.Input['InferenceExperimentShadowModeConfigArgs']] = None,
                 status_reason: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a InferenceExperiment resource.
        :param pulumi.Input[builtins.str] endpoint_name: The name of the endpoint.
        :param pulumi.Input[Sequence[pulumi.Input['InferenceExperimentModelVariantConfigArgs']]] model_variants: An array of ModelVariantConfig objects. Each ModelVariantConfig object in the array describes the infrastructure configuration for the corresponding variant.
        :param pulumi.Input[builtins.str] role_arn: The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to access model artifacts and container images, and manage Amazon SageMaker Inference endpoints for model deployment.
        :param pulumi.Input['InferenceExperimentType'] type: The type of the inference experiment that you want to run.
        :param pulumi.Input['InferenceExperimentDataStorageConfigArgs'] data_storage_config: The Amazon S3 location and configuration for storing inference request and response data.
        :param pulumi.Input[builtins.str] description: The description of the inference experiment.
        :param pulumi.Input['InferenceExperimentDesiredState'] desired_state: The desired state of the experiment after starting or stopping operation.
        :param pulumi.Input[builtins.str] kms_key: The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint.
        :param pulumi.Input[builtins.str] name: The name for the inference experiment.
        :param pulumi.Input['InferenceExperimentScheduleArgs'] schedule: The duration for which the inference experiment ran or will run.
               
               The maximum duration that you can set for an inference experiment is 30 days.
        :param pulumi.Input['InferenceExperimentShadowModeConfigArgs'] shadow_mode_config: The configuration of `ShadowMode` inference experiment type, which shows the production variant that takes all the inference requests, and the shadow variant to which Amazon SageMaker replicates a percentage of the inference requests. For the shadow variant it also shows the percentage of requests that Amazon SageMaker replicates.
        :param pulumi.Input[builtins.str] status_reason: The error message or client-specified reason from the StopInferenceExperiment API, that explains the status of the inference experiment.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        """
        pulumi.set(__self__, "endpoint_name", endpoint_name)
        pulumi.set(__self__, "model_variants", model_variants)
        pulumi.set(__self__, "role_arn", role_arn)
        pulumi.set(__self__, "type", type)
        if data_storage_config is not None:
            pulumi.set(__self__, "data_storage_config", data_storage_config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if desired_state is not None:
            pulumi.set(__self__, "desired_state", desired_state)
        if kms_key is not None:
            pulumi.set(__self__, "kms_key", kms_key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if shadow_mode_config is not None:
            pulumi.set(__self__, "shadow_mode_config", shadow_mode_config)
        if status_reason is not None:
            pulumi.set(__self__, "status_reason", status_reason)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the endpoint.
        """
        return pulumi.get(self, "endpoint_name")

    @endpoint_name.setter
    def endpoint_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "endpoint_name", value)

    @property
    @pulumi.getter(name="modelVariants")
    def model_variants(self) -> pulumi.Input[Sequence[pulumi.Input['InferenceExperimentModelVariantConfigArgs']]]:
        """
        An array of ModelVariantConfig objects. Each ModelVariantConfig object in the array describes the infrastructure configuration for the corresponding variant.
        """
        return pulumi.get(self, "model_variants")

    @model_variants.setter
    def model_variants(self, value: pulumi.Input[Sequence[pulumi.Input['InferenceExperimentModelVariantConfigArgs']]]):
        pulumi.set(self, "model_variants", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to access model artifacts and container images, and manage Amazon SageMaker Inference endpoints for model deployment.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['InferenceExperimentType']:
        """
        The type of the inference experiment that you want to run.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['InferenceExperimentType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="dataStorageConfig")
    def data_storage_config(self) -> Optional[pulumi.Input['InferenceExperimentDataStorageConfigArgs']]:
        """
        The Amazon S3 location and configuration for storing inference request and response data.
        """
        return pulumi.get(self, "data_storage_config")

    @data_storage_config.setter
    def data_storage_config(self, value: Optional[pulumi.Input['InferenceExperimentDataStorageConfigArgs']]):
        pulumi.set(self, "data_storage_config", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the inference experiment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> Optional[pulumi.Input['InferenceExperimentDesiredState']]:
        """
        The desired state of the experiment after starting or stopping operation.
        """
        return pulumi.get(self, "desired_state")

    @desired_state.setter
    def desired_state(self, value: Optional[pulumi.Input['InferenceExperimentDesiredState']]):
        pulumi.set(self, "desired_state", value)

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint.
        """
        return pulumi.get(self, "kms_key")

    @kms_key.setter
    def kms_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name for the inference experiment.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['InferenceExperimentScheduleArgs']]:
        """
        The duration for which the inference experiment ran or will run.

        The maximum duration that you can set for an inference experiment is 30 days.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['InferenceExperimentScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="shadowModeConfig")
    def shadow_mode_config(self) -> Optional[pulumi.Input['InferenceExperimentShadowModeConfigArgs']]:
        """
        The configuration of `ShadowMode` inference experiment type, which shows the production variant that takes all the inference requests, and the shadow variant to which Amazon SageMaker replicates a percentage of the inference requests. For the shadow variant it also shows the percentage of requests that Amazon SageMaker replicates.
        """
        return pulumi.get(self, "shadow_mode_config")

    @shadow_mode_config.setter
    def shadow_mode_config(self, value: Optional[pulumi.Input['InferenceExperimentShadowModeConfigArgs']]):
        pulumi.set(self, "shadow_mode_config", value)

    @property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The error message or client-specified reason from the StopInferenceExperiment API, that explains the status of the inference experiment.
        """
        return pulumi.get(self, "status_reason")

    @status_reason.setter
    def status_reason(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status_reason", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:sagemaker:InferenceExperiment")
class InferenceExperiment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_storage_config: Optional[pulumi.Input[Union['InferenceExperimentDataStorageConfigArgs', 'InferenceExperimentDataStorageConfigArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 desired_state: Optional[pulumi.Input['InferenceExperimentDesiredState']] = None,
                 endpoint_name: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key: Optional[pulumi.Input[builtins.str]] = None,
                 model_variants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InferenceExperimentModelVariantConfigArgs', 'InferenceExperimentModelVariantConfigArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 schedule: Optional[pulumi.Input[Union['InferenceExperimentScheduleArgs', 'InferenceExperimentScheduleArgsDict']]] = None,
                 shadow_mode_config: Optional[pulumi.Input[Union['InferenceExperimentShadowModeConfigArgs', 'InferenceExperimentShadowModeConfigArgsDict']]] = None,
                 status_reason: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 type: Optional[pulumi.Input['InferenceExperimentType']] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::SageMaker::InferenceExperiment

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['InferenceExperimentDataStorageConfigArgs', 'InferenceExperimentDataStorageConfigArgsDict']] data_storage_config: The Amazon S3 location and configuration for storing inference request and response data.
        :param pulumi.Input[builtins.str] description: The description of the inference experiment.
        :param pulumi.Input['InferenceExperimentDesiredState'] desired_state: The desired state of the experiment after starting or stopping operation.
        :param pulumi.Input[builtins.str] endpoint_name: The name of the endpoint.
        :param pulumi.Input[builtins.str] kms_key: The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InferenceExperimentModelVariantConfigArgs', 'InferenceExperimentModelVariantConfigArgsDict']]]] model_variants: An array of ModelVariantConfig objects. Each ModelVariantConfig object in the array describes the infrastructure configuration for the corresponding variant.
        :param pulumi.Input[builtins.str] name: The name for the inference experiment.
        :param pulumi.Input[builtins.str] role_arn: The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to access model artifacts and container images, and manage Amazon SageMaker Inference endpoints for model deployment.
        :param pulumi.Input[Union['InferenceExperimentScheduleArgs', 'InferenceExperimentScheduleArgsDict']] schedule: The duration for which the inference experiment ran or will run.
               
               The maximum duration that you can set for an inference experiment is 30 days.
        :param pulumi.Input[Union['InferenceExperimentShadowModeConfigArgs', 'InferenceExperimentShadowModeConfigArgsDict']] shadow_mode_config: The configuration of `ShadowMode` inference experiment type, which shows the production variant that takes all the inference requests, and the shadow variant to which Amazon SageMaker replicates a percentage of the inference requests. For the shadow variant it also shows the percentage of requests that Amazon SageMaker replicates.
        :param pulumi.Input[builtins.str] status_reason: The error message or client-specified reason from the StopInferenceExperiment API, that explains the status of the inference experiment.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
        :param pulumi.Input['InferenceExperimentType'] type: The type of the inference experiment that you want to run.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InferenceExperimentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::SageMaker::InferenceExperiment

        :param str resource_name: The name of the resource.
        :param InferenceExperimentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InferenceExperimentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_storage_config: Optional[pulumi.Input[Union['InferenceExperimentDataStorageConfigArgs', 'InferenceExperimentDataStorageConfigArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 desired_state: Optional[pulumi.Input['InferenceExperimentDesiredState']] = None,
                 endpoint_name: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key: Optional[pulumi.Input[builtins.str]] = None,
                 model_variants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InferenceExperimentModelVariantConfigArgs', 'InferenceExperimentModelVariantConfigArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 schedule: Optional[pulumi.Input[Union['InferenceExperimentScheduleArgs', 'InferenceExperimentScheduleArgsDict']]] = None,
                 shadow_mode_config: Optional[pulumi.Input[Union['InferenceExperimentShadowModeConfigArgs', 'InferenceExperimentShadowModeConfigArgsDict']]] = None,
                 status_reason: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 type: Optional[pulumi.Input['InferenceExperimentType']] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InferenceExperimentArgs.__new__(InferenceExperimentArgs)

            __props__.__dict__["data_storage_config"] = data_storage_config
            __props__.__dict__["description"] = description
            __props__.__dict__["desired_state"] = desired_state
            if endpoint_name is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint_name'")
            __props__.__dict__["endpoint_name"] = endpoint_name
            __props__.__dict__["kms_key"] = kms_key
            if model_variants is None and not opts.urn:
                raise TypeError("Missing required property 'model_variants'")
            __props__.__dict__["model_variants"] = model_variants
            __props__.__dict__["name"] = name
            if role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'role_arn'")
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["schedule"] = schedule
            __props__.__dict__["shadow_mode_config"] = shadow_mode_config
            __props__.__dict__["status_reason"] = status_reason
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["arn"] = None
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["endpoint_metadata"] = None
            __props__.__dict__["last_modified_time"] = None
            __props__.__dict__["status"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["endpointName", "kmsKey", "name", "roleArn", "type"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(InferenceExperiment, __self__).__init__(
            'aws-native:sagemaker:InferenceExperiment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'InferenceExperiment':
        """
        Get an existing InferenceExperiment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = InferenceExperimentArgs.__new__(InferenceExperimentArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["creation_time"] = None
        __props__.__dict__["data_storage_config"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["desired_state"] = None
        __props__.__dict__["endpoint_metadata"] = None
        __props__.__dict__["endpoint_name"] = None
        __props__.__dict__["kms_key"] = None
        __props__.__dict__["last_modified_time"] = None
        __props__.__dict__["model_variants"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["role_arn"] = None
        __props__.__dict__["schedule"] = None
        __props__.__dict__["shadow_mode_config"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["status_reason"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        return InferenceExperiment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the inference experiment.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp at which you created the inference experiment.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="dataStorageConfig")
    def data_storage_config(self) -> pulumi.Output[Optional['outputs.InferenceExperimentDataStorageConfig']]:
        """
        The Amazon S3 location and configuration for storing inference request and response data.
        """
        return pulumi.get(self, "data_storage_config")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the inference experiment.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> pulumi.Output[Optional['InferenceExperimentDesiredState']]:
        """
        The desired state of the experiment after starting or stopping operation.
        """
        return pulumi.get(self, "desired_state")

    @property
    @pulumi.getter(name="endpointMetadata")
    def endpoint_metadata(self) -> pulumi.Output['outputs.InferenceExperimentEndpointMetadata']:
        return pulumi.get(self, "endpoint_metadata")

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the endpoint.
        """
        return pulumi.get(self, "endpoint_name")

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance that hosts the endpoint.
        """
        return pulumi.get(self, "kms_key")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> pulumi.Output[builtins.str]:
        """
        The timestamp at which you last modified the inference experiment.
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter(name="modelVariants")
    def model_variants(self) -> pulumi.Output[Sequence['outputs.InferenceExperimentModelVariantConfig']]:
        """
        An array of ModelVariantConfig objects. Each ModelVariantConfig object in the array describes the infrastructure configuration for the corresponding variant.
        """
        return pulumi.get(self, "model_variants")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name for the inference experiment.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can assume to access model artifacts and container images, and manage Amazon SageMaker Inference endpoints for model deployment.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Output[Optional['outputs.InferenceExperimentSchedule']]:
        """
        The duration for which the inference experiment ran or will run.

        The maximum duration that you can set for an inference experiment is 30 days.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="shadowModeConfig")
    def shadow_mode_config(self) -> pulumi.Output[Optional['outputs.InferenceExperimentShadowModeConfig']]:
        """
        The configuration of `ShadowMode` inference experiment type, which shows the production variant that takes all the inference requests, and the shadow variant to which Amazon SageMaker replicates a percentage of the inference requests. For the shadow variant it also shows the percentage of requests that Amazon SageMaker replicates.
        """
        return pulumi.get(self, "shadow_mode_config")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output['InferenceExperimentStatus']:
        """
        The status of the inference experiment.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusReason")
    def status_reason(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The error message or client-specified reason from the StopInferenceExperiment API, that explains the status of the inference experiment.
        """
        return pulumi.get(self, "status_reason")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output['InferenceExperimentType']:
        """
        The type of the inference experiment that you want to run.
        """
        return pulumi.get(self, "type")

