# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['InferenceComponentArgs', 'InferenceComponent']

@pulumi.input_type
class InferenceComponentArgs:
    def __init__(__self__, *,
                 endpoint_name: pulumi.Input[builtins.str],
                 specification: pulumi.Input['InferenceComponentSpecificationArgs'],
                 deployment_config: Optional[pulumi.Input['InferenceComponentDeploymentConfigArgs']] = None,
                 endpoint_arn: Optional[pulumi.Input[builtins.str]] = None,
                 inference_component_name: Optional[pulumi.Input[builtins.str]] = None,
                 runtime_config: Optional[pulumi.Input['InferenceComponentRuntimeConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 variant_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a InferenceComponent resource.
        :param pulumi.Input[builtins.str] endpoint_name: The name of the endpoint that hosts the inference component.
        :param pulumi.Input['InferenceComponentDeploymentConfigArgs'] deployment_config: The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.
        :param pulumi.Input[builtins.str] endpoint_arn: The Amazon Resource Name (ARN) of the endpoint that hosts the inference component.
        :param pulumi.Input[builtins.str] inference_component_name: The name of the inference component.
        :param pulumi.Input[builtins.str] variant_name: The name of the production variant that hosts the inference component.
        """
        pulumi.set(__self__, "endpoint_name", endpoint_name)
        pulumi.set(__self__, "specification", specification)
        if deployment_config is not None:
            pulumi.set(__self__, "deployment_config", deployment_config)
        if endpoint_arn is not None:
            pulumi.set(__self__, "endpoint_arn", endpoint_arn)
        if inference_component_name is not None:
            pulumi.set(__self__, "inference_component_name", inference_component_name)
        if runtime_config is not None:
            pulumi.set(__self__, "runtime_config", runtime_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if variant_name is not None:
            pulumi.set(__self__, "variant_name", variant_name)

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the endpoint that hosts the inference component.
        """
        return pulumi.get(self, "endpoint_name")

    @endpoint_name.setter
    def endpoint_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "endpoint_name", value)

    @property
    @pulumi.getter
    def specification(self) -> pulumi.Input['InferenceComponentSpecificationArgs']:
        return pulumi.get(self, "specification")

    @specification.setter
    def specification(self, value: pulumi.Input['InferenceComponentSpecificationArgs']):
        pulumi.set(self, "specification", value)

    @property
    @pulumi.getter(name="deploymentConfig")
    def deployment_config(self) -> Optional[pulumi.Input['InferenceComponentDeploymentConfigArgs']]:
        """
        The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.
        """
        return pulumi.get(self, "deployment_config")

    @deployment_config.setter
    def deployment_config(self, value: Optional[pulumi.Input['InferenceComponentDeploymentConfigArgs']]):
        pulumi.set(self, "deployment_config", value)

    @property
    @pulumi.getter(name="endpointArn")
    def endpoint_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the endpoint that hosts the inference component.
        """
        return pulumi.get(self, "endpoint_arn")

    @endpoint_arn.setter
    def endpoint_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint_arn", value)

    @property
    @pulumi.getter(name="inferenceComponentName")
    def inference_component_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the inference component.
        """
        return pulumi.get(self, "inference_component_name")

    @inference_component_name.setter
    def inference_component_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "inference_component_name", value)

    @property
    @pulumi.getter(name="runtimeConfig")
    def runtime_config(self) -> Optional[pulumi.Input['InferenceComponentRuntimeConfigArgs']]:
        return pulumi.get(self, "runtime_config")

    @runtime_config.setter
    def runtime_config(self, value: Optional[pulumi.Input['InferenceComponentRuntimeConfigArgs']]):
        pulumi.set(self, "runtime_config", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="variantName")
    def variant_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the production variant that hosts the inference component.
        """
        return pulumi.get(self, "variant_name")

    @variant_name.setter
    def variant_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "variant_name", value)


@pulumi.type_token("aws-native:sagemaker:InferenceComponent")
class InferenceComponent(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deployment_config: Optional[pulumi.Input[Union['InferenceComponentDeploymentConfigArgs', 'InferenceComponentDeploymentConfigArgsDict']]] = None,
                 endpoint_arn: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_name: Optional[pulumi.Input[builtins.str]] = None,
                 inference_component_name: Optional[pulumi.Input[builtins.str]] = None,
                 runtime_config: Optional[pulumi.Input[Union['InferenceComponentRuntimeConfigArgs', 'InferenceComponentRuntimeConfigArgsDict']]] = None,
                 specification: Optional[pulumi.Input[Union['InferenceComponentSpecificationArgs', 'InferenceComponentSpecificationArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 variant_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::SageMaker::InferenceComponent

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['InferenceComponentDeploymentConfigArgs', 'InferenceComponentDeploymentConfigArgsDict']] deployment_config: The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.
        :param pulumi.Input[builtins.str] endpoint_arn: The Amazon Resource Name (ARN) of the endpoint that hosts the inference component.
        :param pulumi.Input[builtins.str] endpoint_name: The name of the endpoint that hosts the inference component.
        :param pulumi.Input[builtins.str] inference_component_name: The name of the inference component.
        :param pulumi.Input[builtins.str] variant_name: The name of the production variant that hosts the inference component.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InferenceComponentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::SageMaker::InferenceComponent

        :param str resource_name: The name of the resource.
        :param InferenceComponentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InferenceComponentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deployment_config: Optional[pulumi.Input[Union['InferenceComponentDeploymentConfigArgs', 'InferenceComponentDeploymentConfigArgsDict']]] = None,
                 endpoint_arn: Optional[pulumi.Input[builtins.str]] = None,
                 endpoint_name: Optional[pulumi.Input[builtins.str]] = None,
                 inference_component_name: Optional[pulumi.Input[builtins.str]] = None,
                 runtime_config: Optional[pulumi.Input[Union['InferenceComponentRuntimeConfigArgs', 'InferenceComponentRuntimeConfigArgsDict']]] = None,
                 specification: Optional[pulumi.Input[Union['InferenceComponentSpecificationArgs', 'InferenceComponentSpecificationArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 variant_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InferenceComponentArgs.__new__(InferenceComponentArgs)

            __props__.__dict__["deployment_config"] = deployment_config
            __props__.__dict__["endpoint_arn"] = endpoint_arn
            if endpoint_name is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint_name'")
            __props__.__dict__["endpoint_name"] = endpoint_name
            __props__.__dict__["inference_component_name"] = inference_component_name
            __props__.__dict__["runtime_config"] = runtime_config
            if specification is None and not opts.urn:
                raise TypeError("Missing required property 'specification'")
            __props__.__dict__["specification"] = specification
            __props__.__dict__["tags"] = tags
            __props__.__dict__["variant_name"] = variant_name
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["failure_reason"] = None
            __props__.__dict__["inference_component_arn"] = None
            __props__.__dict__["inference_component_status"] = None
            __props__.__dict__["last_modified_time"] = None
        super(InferenceComponent, __self__).__init__(
            'aws-native:sagemaker:InferenceComponent',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'InferenceComponent':
        """
        Get an existing InferenceComponent resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = InferenceComponentArgs.__new__(InferenceComponentArgs)

        __props__.__dict__["creation_time"] = None
        __props__.__dict__["deployment_config"] = None
        __props__.__dict__["endpoint_arn"] = None
        __props__.__dict__["endpoint_name"] = None
        __props__.__dict__["failure_reason"] = None
        __props__.__dict__["inference_component_arn"] = None
        __props__.__dict__["inference_component_name"] = None
        __props__.__dict__["inference_component_status"] = None
        __props__.__dict__["last_modified_time"] = None
        __props__.__dict__["runtime_config"] = None
        __props__.__dict__["specification"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["variant_name"] = None
        return InferenceComponent(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[builtins.str]:
        """
        The time when the inference component was created.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="deploymentConfig")
    def deployment_config(self) -> pulumi.Output[Optional['outputs.InferenceComponentDeploymentConfig']]:
        """
        The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.
        """
        return pulumi.get(self, "deployment_config")

    @property
    @pulumi.getter(name="endpointArn")
    def endpoint_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the endpoint that hosts the inference component.
        """
        return pulumi.get(self, "endpoint_arn")

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the endpoint that hosts the inference component.
        """
        return pulumi.get(self, "endpoint_name")

    @property
    @pulumi.getter(name="failureReason")
    def failure_reason(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "failure_reason")

    @property
    @pulumi.getter(name="inferenceComponentArn")
    def inference_component_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the inference component.
        """
        return pulumi.get(self, "inference_component_arn")

    @property
    @pulumi.getter(name="inferenceComponentName")
    def inference_component_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the inference component.
        """
        return pulumi.get(self, "inference_component_name")

    @property
    @pulumi.getter(name="inferenceComponentStatus")
    def inference_component_status(self) -> pulumi.Output['InferenceComponentStatus']:
        """
        The status of the inference component.
        """
        return pulumi.get(self, "inference_component_status")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> pulumi.Output[builtins.str]:
        """
        The time when the inference component was last updated.
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter(name="runtimeConfig")
    def runtime_config(self) -> pulumi.Output[Optional['outputs.InferenceComponentRuntimeConfig']]:
        return pulumi.get(self, "runtime_config")

    @property
    @pulumi.getter
    def specification(self) -> pulumi.Output['outputs.InferenceComponentSpecification']:
        return pulumi.get(self, "specification")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="variantName")
    def variant_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the production variant that hosts the inference component.
        """
        return pulumi.get(self, "variant_name")

