# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs

__all__ = ['ImageArgs', 'Image']

@pulumi.input_type
class ImageArgs:
    def __init__(__self__, *,
                 image_role_arn: pulumi.Input[builtins.str],
                 image_description: Optional[pulumi.Input[builtins.str]] = None,
                 image_display_name: Optional[pulumi.Input[builtins.str]] = None,
                 image_name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Image resource.
        :param pulumi.Input[builtins.str] image_role_arn: The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf.
               
               *Length Constraints* : Minimum length of 20. Maximum length of 2048.
               
               *Pattern* : `^arn:aws[a-z\\-]*:iam::\\d{12}:role/?[a-zA-Z_0-9+=,.@\\-_/]+$`
        :param pulumi.Input[builtins.str] image_description: The description of the image.
        :param pulumi.Input[builtins.str] image_display_name: The display name of the image.
               
               *Length Constraints* : Minimum length of 1. Maximum length of 128.
               
               *Pattern* : `^\\S(.*\\S)?$`
        :param pulumi.Input[builtins.str] image_name: The name of the Image. Must be unique by region in your account.
               
               *Length Constraints* : Minimum length of 1. Maximum length of 63.
               
               *Pattern* : `^[a-zA-Z0-9]([-.]?[a-zA-Z0-9]){0,62}$`
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: An array of key-value pairs to apply to this resource.
        """
        pulumi.set(__self__, "image_role_arn", image_role_arn)
        if image_description is not None:
            pulumi.set(__self__, "image_description", image_description)
        if image_display_name is not None:
            pulumi.set(__self__, "image_display_name", image_display_name)
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="imageRoleArn")
    def image_role_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf.

        *Length Constraints* : Minimum length of 20. Maximum length of 2048.

        *Pattern* : `^arn:aws[a-z\\-]*:iam::\\d{12}:role/?[a-zA-Z_0-9+=,.@\\-_/]+$`
        """
        return pulumi.get(self, "image_role_arn")

    @image_role_arn.setter
    def image_role_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "image_role_arn", value)

    @property
    @pulumi.getter(name="imageDescription")
    def image_description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the image.
        """
        return pulumi.get(self, "image_description")

    @image_description.setter
    def image_description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_description", value)

    @property
    @pulumi.getter(name="imageDisplayName")
    def image_display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The display name of the image.

        *Length Constraints* : Minimum length of 1. Maximum length of 128.

        *Pattern* : `^\\S(.*\\S)?$`
        """
        return pulumi.get(self, "image_display_name")

    @image_display_name.setter
    def image_display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_display_name", value)

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Image. Must be unique by region in your account.

        *Length Constraints* : Minimum length of 1. Maximum length of 63.

        *Pattern* : `^[a-zA-Z0-9]([-.]?[a-zA-Z0-9]){0,62}$`
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:sagemaker:Image")
class Image(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 image_description: Optional[pulumi.Input[builtins.str]] = None,
                 image_display_name: Optional[pulumi.Input[builtins.str]] = None,
                 image_name: Optional[pulumi.Input[builtins.str]] = None,
                 image_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::SageMaker::Image

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] image_description: The description of the image.
        :param pulumi.Input[builtins.str] image_display_name: The display name of the image.
               
               *Length Constraints* : Minimum length of 1. Maximum length of 128.
               
               *Pattern* : `^\\S(.*\\S)?$`
        :param pulumi.Input[builtins.str] image_name: The name of the Image. Must be unique by region in your account.
               
               *Length Constraints* : Minimum length of 1. Maximum length of 63.
               
               *Pattern* : `^[a-zA-Z0-9]([-.]?[a-zA-Z0-9]){0,62}$`
        :param pulumi.Input[builtins.str] image_role_arn: The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf.
               
               *Length Constraints* : Minimum length of 20. Maximum length of 2048.
               
               *Pattern* : `^arn:aws[a-z\\-]*:iam::\\d{12}:role/?[a-zA-Z_0-9+=,.@\\-_/]+$`
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: An array of key-value pairs to apply to this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ImageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::SageMaker::Image

        :param str resource_name: The name of the resource.
        :param ImageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ImageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 image_description: Optional[pulumi.Input[builtins.str]] = None,
                 image_display_name: Optional[pulumi.Input[builtins.str]] = None,
                 image_name: Optional[pulumi.Input[builtins.str]] = None,
                 image_role_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ImageArgs.__new__(ImageArgs)

            __props__.__dict__["image_description"] = image_description
            __props__.__dict__["image_display_name"] = image_display_name
            __props__.__dict__["image_name"] = image_name
            if image_role_arn is None and not opts.urn:
                raise TypeError("Missing required property 'image_role_arn'")
            __props__.__dict__["image_role_arn"] = image_role_arn
            __props__.__dict__["tags"] = tags
            __props__.__dict__["image_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["imageName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Image, __self__).__init__(
            'aws-native:sagemaker:Image',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Image':
        """
        Get an existing Image resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ImageArgs.__new__(ImageArgs)

        __props__.__dict__["image_arn"] = None
        __props__.__dict__["image_description"] = None
        __props__.__dict__["image_display_name"] = None
        __props__.__dict__["image_name"] = None
        __props__.__dict__["image_role_arn"] = None
        __props__.__dict__["tags"] = None
        return Image(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="imageArn")
    def image_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the image.

        *Type* : String

        *Length Constraints* : Maximum length of 256.

        *Pattern* : `^arn:aws(-[\\w]+)*:sagemaker:.+:[0-9]{12}:image/[a-z0-9]([-.]?[a-z0-9])*$`
        """
        return pulumi.get(self, "image_arn")

    @property
    @pulumi.getter(name="imageDescription")
    def image_description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the image.
        """
        return pulumi.get(self, "image_description")

    @property
    @pulumi.getter(name="imageDisplayName")
    def image_display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The display name of the image.

        *Length Constraints* : Minimum length of 1. Maximum length of 128.

        *Pattern* : `^\\S(.*\\S)?$`
        """
        return pulumi.get(self, "image_display_name")

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Image. Must be unique by region in your account.

        *Length Constraints* : Minimum length of 1. Maximum length of 63.

        *Pattern* : `^[a-zA-Z0-9]([-.]?[a-zA-Z0-9]){0,62}$`
        """
        return pulumi.get(self, "image_name")

    @property
    @pulumi.getter(name="imageRoleArn")
    def image_role_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf.

        *Length Constraints* : Minimum length of 20. Maximum length of 2048.

        *Pattern* : `^arn:aws[a-z\\-]*:iam::\\d{12}:role/?[a-zA-Z_0-9+=,.@\\-_/]+$`
        """
        return pulumi.get(self, "image_role_arn")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

