# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs

__all__ = [
    'GetPartnerAppResult',
    'AwaitableGetPartnerAppResult',
    'get_partner_app',
    'get_partner_app_output',
]

@pulumi.output_type
class GetPartnerAppResult:
    def __init__(__self__, application_config=None, arn=None, base_url=None, enable_iam_session_based_identity=None, maintenance_config=None, tags=None, tier=None):
        if application_config and not isinstance(application_config, dict):
            raise TypeError("Expected argument 'application_config' to be a dict")
        pulumi.set(__self__, "application_config", application_config)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if base_url and not isinstance(base_url, str):
            raise TypeError("Expected argument 'base_url' to be a str")
        pulumi.set(__self__, "base_url", base_url)
        if enable_iam_session_based_identity and not isinstance(enable_iam_session_based_identity, bool):
            raise TypeError("Expected argument 'enable_iam_session_based_identity' to be a bool")
        pulumi.set(__self__, "enable_iam_session_based_identity", enable_iam_session_based_identity)
        if maintenance_config and not isinstance(maintenance_config, dict):
            raise TypeError("Expected argument 'maintenance_config' to be a dict")
        pulumi.set(__self__, "maintenance_config", maintenance_config)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if tier and not isinstance(tier, str):
            raise TypeError("Expected argument 'tier' to be a str")
        pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter(name="applicationConfig")
    def application_config(self) -> Optional['outputs.PartnerAppConfig']:
        """
        A collection of settings that specify the maintenance schedule for the PartnerApp.
        """
        return pulumi.get(self, "application_config")

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the created PartnerApp.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> Optional[builtins.str]:
        """
        The AppServerUrl based on app and account-info.
        """
        return pulumi.get(self, "base_url")

    @property
    @pulumi.getter(name="enableIamSessionBasedIdentity")
    def enable_iam_session_based_identity(self) -> Optional[builtins.bool]:
        """
        Enables IAM Session based Identity for PartnerApp.
        """
        return pulumi.get(self, "enable_iam_session_based_identity")

    @property
    @pulumi.getter(name="maintenanceConfig")
    def maintenance_config(self) -> Optional['outputs.PartnerAppMaintenanceConfig']:
        """
        A collection of settings that specify the maintenance schedule for the PartnerApp.
        """
        return pulumi.get(self, "maintenance_config")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        A list of tags to apply to the PartnerApp.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def tier(self) -> Optional[builtins.str]:
        """
        The tier of the PartnerApp.
        """
        return pulumi.get(self, "tier")


class AwaitableGetPartnerAppResult(GetPartnerAppResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPartnerAppResult(
            application_config=self.application_config,
            arn=self.arn,
            base_url=self.base_url,
            enable_iam_session_based_identity=self.enable_iam_session_based_identity,
            maintenance_config=self.maintenance_config,
            tags=self.tags,
            tier=self.tier)


def get_partner_app(arn: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPartnerAppResult:
    """
    Resource Type definition for AWS::SageMaker::PartnerApp


    :param builtins.str arn: The Amazon Resource Name (ARN) of the created PartnerApp.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:sagemaker:getPartnerApp', __args__, opts=opts, typ=GetPartnerAppResult).value

    return AwaitableGetPartnerAppResult(
        application_config=pulumi.get(__ret__, 'application_config'),
        arn=pulumi.get(__ret__, 'arn'),
        base_url=pulumi.get(__ret__, 'base_url'),
        enable_iam_session_based_identity=pulumi.get(__ret__, 'enable_iam_session_based_identity'),
        maintenance_config=pulumi.get(__ret__, 'maintenance_config'),
        tags=pulumi.get(__ret__, 'tags'),
        tier=pulumi.get(__ret__, 'tier'))
def get_partner_app_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPartnerAppResult]:
    """
    Resource Type definition for AWS::SageMaker::PartnerApp


    :param builtins.str arn: The Amazon Resource Name (ARN) of the created PartnerApp.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:sagemaker:getPartnerApp', __args__, opts=opts, typ=GetPartnerAppResult)
    return __ret__.apply(lambda __response__: GetPartnerAppResult(
        application_config=pulumi.get(__response__, 'application_config'),
        arn=pulumi.get(__response__, 'arn'),
        base_url=pulumi.get(__response__, 'base_url'),
        enable_iam_session_based_identity=pulumi.get(__response__, 'enable_iam_session_based_identity'),
        maintenance_config=pulumi.get(__response__, 'maintenance_config'),
        tags=pulumi.get(__response__, 'tags'),
        tier=pulumi.get(__response__, 'tier')))
