# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetModelPackageResult',
    'AwaitableGetModelPackageResult',
    'get_model_package',
    'get_model_package_output',
]

@pulumi.output_type
class GetModelPackageResult:
    def __init__(__self__, additional_inference_specifications=None, approval_description=None, certify_for_marketplace=None, creation_time=None, customer_metadata_properties=None, last_modified_time=None, model_approval_status=None, model_card=None, model_package_arn=None, model_package_name=None, model_package_status=None, model_package_status_details=None, model_package_version=None, skip_model_validation=None, source_uri=None, tags=None):
        if additional_inference_specifications and not isinstance(additional_inference_specifications, list):
            raise TypeError("Expected argument 'additional_inference_specifications' to be a list")
        pulumi.set(__self__, "additional_inference_specifications", additional_inference_specifications)
        if approval_description and not isinstance(approval_description, str):
            raise TypeError("Expected argument 'approval_description' to be a str")
        pulumi.set(__self__, "approval_description", approval_description)
        if certify_for_marketplace and not isinstance(certify_for_marketplace, bool):
            raise TypeError("Expected argument 'certify_for_marketplace' to be a bool")
        pulumi.set(__self__, "certify_for_marketplace", certify_for_marketplace)
        if creation_time and not isinstance(creation_time, str):
            raise TypeError("Expected argument 'creation_time' to be a str")
        pulumi.set(__self__, "creation_time", creation_time)
        if customer_metadata_properties and not isinstance(customer_metadata_properties, dict):
            raise TypeError("Expected argument 'customer_metadata_properties' to be a dict")
        pulumi.set(__self__, "customer_metadata_properties", customer_metadata_properties)
        if last_modified_time and not isinstance(last_modified_time, str):
            raise TypeError("Expected argument 'last_modified_time' to be a str")
        pulumi.set(__self__, "last_modified_time", last_modified_time)
        if model_approval_status and not isinstance(model_approval_status, str):
            raise TypeError("Expected argument 'model_approval_status' to be a str")
        pulumi.set(__self__, "model_approval_status", model_approval_status)
        if model_card and not isinstance(model_card, dict):
            raise TypeError("Expected argument 'model_card' to be a dict")
        pulumi.set(__self__, "model_card", model_card)
        if model_package_arn and not isinstance(model_package_arn, str):
            raise TypeError("Expected argument 'model_package_arn' to be a str")
        pulumi.set(__self__, "model_package_arn", model_package_arn)
        if model_package_name and not isinstance(model_package_name, str):
            raise TypeError("Expected argument 'model_package_name' to be a str")
        pulumi.set(__self__, "model_package_name", model_package_name)
        if model_package_status and not isinstance(model_package_status, str):
            raise TypeError("Expected argument 'model_package_status' to be a str")
        pulumi.set(__self__, "model_package_status", model_package_status)
        if model_package_status_details and not isinstance(model_package_status_details, dict):
            raise TypeError("Expected argument 'model_package_status_details' to be a dict")
        pulumi.set(__self__, "model_package_status_details", model_package_status_details)
        if model_package_version and not isinstance(model_package_version, int):
            raise TypeError("Expected argument 'model_package_version' to be a int")
        pulumi.set(__self__, "model_package_version", model_package_version)
        if skip_model_validation and not isinstance(skip_model_validation, str):
            raise TypeError("Expected argument 'skip_model_validation' to be a str")
        pulumi.set(__self__, "skip_model_validation", skip_model_validation)
        if source_uri and not isinstance(source_uri, str):
            raise TypeError("Expected argument 'source_uri' to be a str")
        pulumi.set(__self__, "source_uri", source_uri)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="additionalInferenceSpecifications")
    def additional_inference_specifications(self) -> Optional[Sequence['outputs.ModelPackageAdditionalInferenceSpecificationDefinition']]:
        """
        An array of additional Inference Specification objects.
        """
        return pulumi.get(self, "additional_inference_specifications")

    @property
    @pulumi.getter(name="approvalDescription")
    def approval_description(self) -> Optional[builtins.str]:
        """
        A description provided when the model approval is set.
        """
        return pulumi.get(self, "approval_description")

    @property
    @pulumi.getter(name="certifyForMarketplace")
    def certify_for_marketplace(self) -> Optional[builtins.bool]:
        """
        Whether the model package is to be certified to be listed on AWS Marketplace. For information about listing model packages on AWS Marketplace, see [List Your Algorithm or Model Package on AWS Marketplace](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-mkt-list.html) .
        """
        return pulumi.get(self, "certify_for_marketplace")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[builtins.str]:
        """
        The time that the model package was created.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="customerMetadataProperties")
    def customer_metadata_properties(self) -> Optional['outputs.ModelPackageCustomerMetadataProperties']:
        """
        The metadata properties for the model package.
        """
        return pulumi.get(self, "customer_metadata_properties")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> Optional[builtins.str]:
        """
        The last time the model package was modified.
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter(name="modelApprovalStatus")
    def model_approval_status(self) -> Optional['ModelPackageModelApprovalStatus']:
        """
        The approval status of the model. This can be one of the following values.

        - `APPROVED` - The model is approved
        - `REJECTED` - The model is rejected.
        - `PENDING_MANUAL_APPROVAL` - The model is waiting for manual approval.
        """
        return pulumi.get(self, "model_approval_status")

    @property
    @pulumi.getter(name="modelCard")
    def model_card(self) -> Optional['outputs.ModelPackageModelCard']:
        """
        An Amazon SageMaker Model Card.
        """
        return pulumi.get(self, "model_card")

    @property
    @pulumi.getter(name="modelPackageArn")
    def model_package_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the model package.
        """
        return pulumi.get(self, "model_package_arn")

    @property
    @pulumi.getter(name="modelPackageName")
    def model_package_name(self) -> Optional[builtins.str]:
        """
        The name of the model package. The name can be as follows:

        - For a versioned model, the name is automatically generated by SageMaker Model Registry and follows the format ' `ModelPackageGroupName/ModelPackageVersion` '.
        - For an unversioned model, you must provide the name.
        """
        return pulumi.get(self, "model_package_name")

    @property
    @pulumi.getter(name="modelPackageStatus")
    def model_package_status(self) -> Optional['ModelPackageStatus']:
        """
        The status of the model package. This can be one of the following values.

        - `PENDING` - The model package creation is pending.
        - `IN_PROGRESS` - The model package is in the process of being created.
        - `COMPLETED` - The model package was successfully created.
        - `FAILED` - The model package creation failed.
        - `DELETING` - The model package is in the process of being deleted.
        """
        return pulumi.get(self, "model_package_status")

    @property
    @pulumi.getter(name="modelPackageStatusDetails")
    def model_package_status_details(self) -> Optional['outputs.ModelPackageStatusDetails']:
        """
        Specifies the validation and image scan statuses of the model package.
        """
        return pulumi.get(self, "model_package_status_details")

    @property
    @pulumi.getter(name="modelPackageVersion")
    def model_package_version(self) -> Optional[builtins.int]:
        """
        The version number of a versioned model.
        """
        return pulumi.get(self, "model_package_version")

    @property
    @pulumi.getter(name="skipModelValidation")
    def skip_model_validation(self) -> Optional['ModelPackageSkipModelValidation']:
        """
        Indicates if you want to skip model validation.
        """
        return pulumi.get(self, "skip_model_validation")

    @property
    @pulumi.getter(name="sourceUri")
    def source_uri(self) -> Optional[builtins.str]:
        """
        The URI of the source for the model package.
        """
        return pulumi.get(self, "source_uri")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetModelPackageResult(GetModelPackageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetModelPackageResult(
            additional_inference_specifications=self.additional_inference_specifications,
            approval_description=self.approval_description,
            certify_for_marketplace=self.certify_for_marketplace,
            creation_time=self.creation_time,
            customer_metadata_properties=self.customer_metadata_properties,
            last_modified_time=self.last_modified_time,
            model_approval_status=self.model_approval_status,
            model_card=self.model_card,
            model_package_arn=self.model_package_arn,
            model_package_name=self.model_package_name,
            model_package_status=self.model_package_status,
            model_package_status_details=self.model_package_status_details,
            model_package_version=self.model_package_version,
            skip_model_validation=self.skip_model_validation,
            source_uri=self.source_uri,
            tags=self.tags)


def get_model_package(model_package_arn: Optional[builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetModelPackageResult:
    """
    Resource Type definition for AWS::SageMaker::ModelPackage


    :param builtins.str model_package_arn: The Amazon Resource Name (ARN) of the model package.
    """
    __args__ = dict()
    __args__['modelPackageArn'] = model_package_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:sagemaker:getModelPackage', __args__, opts=opts, typ=GetModelPackageResult).value

    return AwaitableGetModelPackageResult(
        additional_inference_specifications=pulumi.get(__ret__, 'additional_inference_specifications'),
        approval_description=pulumi.get(__ret__, 'approval_description'),
        certify_for_marketplace=pulumi.get(__ret__, 'certify_for_marketplace'),
        creation_time=pulumi.get(__ret__, 'creation_time'),
        customer_metadata_properties=pulumi.get(__ret__, 'customer_metadata_properties'),
        last_modified_time=pulumi.get(__ret__, 'last_modified_time'),
        model_approval_status=pulumi.get(__ret__, 'model_approval_status'),
        model_card=pulumi.get(__ret__, 'model_card'),
        model_package_arn=pulumi.get(__ret__, 'model_package_arn'),
        model_package_name=pulumi.get(__ret__, 'model_package_name'),
        model_package_status=pulumi.get(__ret__, 'model_package_status'),
        model_package_status_details=pulumi.get(__ret__, 'model_package_status_details'),
        model_package_version=pulumi.get(__ret__, 'model_package_version'),
        skip_model_validation=pulumi.get(__ret__, 'skip_model_validation'),
        source_uri=pulumi.get(__ret__, 'source_uri'),
        tags=pulumi.get(__ret__, 'tags'))
def get_model_package_output(model_package_arn: Optional[pulumi.Input[builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetModelPackageResult]:
    """
    Resource Type definition for AWS::SageMaker::ModelPackage


    :param builtins.str model_package_arn: The Amazon Resource Name (ARN) of the model package.
    """
    __args__ = dict()
    __args__['modelPackageArn'] = model_package_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:sagemaker:getModelPackage', __args__, opts=opts, typ=GetModelPackageResult)
    return __ret__.apply(lambda __response__: GetModelPackageResult(
        additional_inference_specifications=pulumi.get(__response__, 'additional_inference_specifications'),
        approval_description=pulumi.get(__response__, 'approval_description'),
        certify_for_marketplace=pulumi.get(__response__, 'certify_for_marketplace'),
        creation_time=pulumi.get(__response__, 'creation_time'),
        customer_metadata_properties=pulumi.get(__response__, 'customer_metadata_properties'),
        last_modified_time=pulumi.get(__response__, 'last_modified_time'),
        model_approval_status=pulumi.get(__response__, 'model_approval_status'),
        model_card=pulumi.get(__response__, 'model_card'),
        model_package_arn=pulumi.get(__response__, 'model_package_arn'),
        model_package_name=pulumi.get(__response__, 'model_package_name'),
        model_package_status=pulumi.get(__response__, 'model_package_status'),
        model_package_status_details=pulumi.get(__response__, 'model_package_status_details'),
        model_package_version=pulumi.get(__response__, 'model_package_version'),
        skip_model_validation=pulumi.get(__response__, 'skip_model_validation'),
        source_uri=pulumi.get(__response__, 'source_uri'),
        tags=pulumi.get(__response__, 'tags')))
