# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs

__all__ = [
    'GetEndpointResult',
    'AwaitableGetEndpointResult',
    'get_endpoint',
    'get_endpoint_output',
]

@pulumi.output_type
class GetEndpointResult:
    def __init__(__self__, deployment_config=None, endpoint_arn=None, endpoint_config_name=None, tags=None):
        if deployment_config and not isinstance(deployment_config, dict):
            raise TypeError("Expected argument 'deployment_config' to be a dict")
        pulumi.set(__self__, "deployment_config", deployment_config)
        if endpoint_arn and not isinstance(endpoint_arn, str):
            raise TypeError("Expected argument 'endpoint_arn' to be a str")
        pulumi.set(__self__, "endpoint_arn", endpoint_arn)
        if endpoint_config_name and not isinstance(endpoint_config_name, str):
            raise TypeError("Expected argument 'endpoint_config_name' to be a str")
        pulumi.set(__self__, "endpoint_config_name", endpoint_config_name)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="deploymentConfig")
    def deployment_config(self) -> Optional['outputs.EndpointDeploymentConfig']:
        """
        Specifies deployment configuration for updating the SageMaker endpoint. Includes rollback and update policies.
        """
        return pulumi.get(self, "deployment_config")

    @property
    @pulumi.getter(name="endpointArn")
    def endpoint_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the endpoint.
        """
        return pulumi.get(self, "endpoint_arn")

    @property
    @pulumi.getter(name="endpointConfigName")
    def endpoint_config_name(self) -> Optional[builtins.str]:
        """
        The name of the endpoint configuration for the SageMaker endpoint. This is a required property.
        """
        return pulumi.get(self, "endpoint_config_name")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetEndpointResult(GetEndpointResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEndpointResult(
            deployment_config=self.deployment_config,
            endpoint_arn=self.endpoint_arn,
            endpoint_config_name=self.endpoint_config_name,
            tags=self.tags)


def get_endpoint(endpoint_arn: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEndpointResult:
    """
    Resource Type definition for AWS::SageMaker::Endpoint


    :param builtins.str endpoint_arn: The Amazon Resource Name (ARN) of the endpoint.
    """
    __args__ = dict()
    __args__['endpointArn'] = endpoint_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:sagemaker:getEndpoint', __args__, opts=opts, typ=GetEndpointResult).value

    return AwaitableGetEndpointResult(
        deployment_config=pulumi.get(__ret__, 'deployment_config'),
        endpoint_arn=pulumi.get(__ret__, 'endpoint_arn'),
        endpoint_config_name=pulumi.get(__ret__, 'endpoint_config_name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_endpoint_output(endpoint_arn: Optional[pulumi.Input[builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEndpointResult]:
    """
    Resource Type definition for AWS::SageMaker::Endpoint


    :param builtins.str endpoint_arn: The Amazon Resource Name (ARN) of the endpoint.
    """
    __args__ = dict()
    __args__['endpointArn'] = endpoint_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:sagemaker:getEndpoint', __args__, opts=opts, typ=GetEndpointResult)
    return __ret__.apply(lambda __response__: GetEndpointResult(
        deployment_config=pulumi.get(__response__, 'deployment_config'),
        endpoint_arn=pulumi.get(__response__, 'endpoint_arn'),
        endpoint_config_name=pulumi.get(__response__, 'endpoint_config_name'),
        tags=pulumi.get(__response__, 'tags')))
