# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAppImageConfigResult',
    'AwaitableGetAppImageConfigResult',
    'get_app_image_config',
    'get_app_image_config_output',
]

@pulumi.output_type
class GetAppImageConfigResult:
    def __init__(__self__, app_image_config_arn=None, code_editor_app_image_config=None, jupyter_lab_app_image_config=None, kernel_gateway_image_config=None):
        if app_image_config_arn and not isinstance(app_image_config_arn, str):
            raise TypeError("Expected argument 'app_image_config_arn' to be a str")
        pulumi.set(__self__, "app_image_config_arn", app_image_config_arn)
        if code_editor_app_image_config and not isinstance(code_editor_app_image_config, dict):
            raise TypeError("Expected argument 'code_editor_app_image_config' to be a dict")
        pulumi.set(__self__, "code_editor_app_image_config", code_editor_app_image_config)
        if jupyter_lab_app_image_config and not isinstance(jupyter_lab_app_image_config, dict):
            raise TypeError("Expected argument 'jupyter_lab_app_image_config' to be a dict")
        pulumi.set(__self__, "jupyter_lab_app_image_config", jupyter_lab_app_image_config)
        if kernel_gateway_image_config and not isinstance(kernel_gateway_image_config, dict):
            raise TypeError("Expected argument 'kernel_gateway_image_config' to be a dict")
        pulumi.set(__self__, "kernel_gateway_image_config", kernel_gateway_image_config)

    @property
    @pulumi.getter(name="appImageConfigArn")
    def app_image_config_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the AppImageConfig.
        """
        return pulumi.get(self, "app_image_config_arn")

    @property
    @pulumi.getter(name="codeEditorAppImageConfig")
    def code_editor_app_image_config(self) -> Optional['outputs.AppImageConfigCodeEditorAppImageConfig']:
        """
        The CodeEditorAppImageConfig.
        """
        return pulumi.get(self, "code_editor_app_image_config")

    @property
    @pulumi.getter(name="jupyterLabAppImageConfig")
    def jupyter_lab_app_image_config(self) -> Optional['outputs.AppImageConfigJupyterLabAppImageConfig']:
        """
        The JupyterLabAppImageConfig.
        """
        return pulumi.get(self, "jupyter_lab_app_image_config")

    @property
    @pulumi.getter(name="kernelGatewayImageConfig")
    def kernel_gateway_image_config(self) -> Optional['outputs.AppImageConfigKernelGatewayImageConfig']:
        """
        The KernelGatewayImageConfig.
        """
        return pulumi.get(self, "kernel_gateway_image_config")


class AwaitableGetAppImageConfigResult(GetAppImageConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAppImageConfigResult(
            app_image_config_arn=self.app_image_config_arn,
            code_editor_app_image_config=self.code_editor_app_image_config,
            jupyter_lab_app_image_config=self.jupyter_lab_app_image_config,
            kernel_gateway_image_config=self.kernel_gateway_image_config)


def get_app_image_config(app_image_config_name: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAppImageConfigResult:
    """
    Resource Type definition for AWS::SageMaker::AppImageConfig


    :param builtins.str app_image_config_name: The Name of the AppImageConfig.
    """
    __args__ = dict()
    __args__['appImageConfigName'] = app_image_config_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:sagemaker:getAppImageConfig', __args__, opts=opts, typ=GetAppImageConfigResult).value

    return AwaitableGetAppImageConfigResult(
        app_image_config_arn=pulumi.get(__ret__, 'app_image_config_arn'),
        code_editor_app_image_config=pulumi.get(__ret__, 'code_editor_app_image_config'),
        jupyter_lab_app_image_config=pulumi.get(__ret__, 'jupyter_lab_app_image_config'),
        kernel_gateway_image_config=pulumi.get(__ret__, 'kernel_gateway_image_config'))
def get_app_image_config_output(app_image_config_name: Optional[pulumi.Input[builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAppImageConfigResult]:
    """
    Resource Type definition for AWS::SageMaker::AppImageConfig


    :param builtins.str app_image_config_name: The Name of the AppImageConfig.
    """
    __args__ = dict()
    __args__['appImageConfigName'] = app_image_config_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:sagemaker:getAppImageConfig', __args__, opts=opts, typ=GetAppImageConfigResult)
    return __ret__.apply(lambda __response__: GetAppImageConfigResult(
        app_image_config_arn=pulumi.get(__response__, 'app_image_config_arn'),
        code_editor_app_image_config=pulumi.get(__response__, 'code_editor_app_image_config'),
        jupyter_lab_app_image_config=pulumi.get(__response__, 'jupyter_lab_app_image_config'),
        kernel_gateway_image_config=pulumi.get(__response__, 'kernel_gateway_image_config')))
