# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'GetAppResult',
    'AwaitableGetAppResult',
    'get_app',
    'get_app_output',
]

@pulumi.output_type
class GetAppResult:
    def __init__(__self__, app_arn=None, built_in_lifecycle_config_arn=None, recovery_mode=None):
        if app_arn and not isinstance(app_arn, str):
            raise TypeError("Expected argument 'app_arn' to be a str")
        pulumi.set(__self__, "app_arn", app_arn)
        if built_in_lifecycle_config_arn and not isinstance(built_in_lifecycle_config_arn, str):
            raise TypeError("Expected argument 'built_in_lifecycle_config_arn' to be a str")
        pulumi.set(__self__, "built_in_lifecycle_config_arn", built_in_lifecycle_config_arn)
        if recovery_mode and not isinstance(recovery_mode, bool):
            raise TypeError("Expected argument 'recovery_mode' to be a bool")
        pulumi.set(__self__, "recovery_mode", recovery_mode)

    @property
    @pulumi.getter(name="appArn")
    def app_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the app.
        """
        return pulumi.get(self, "app_arn")

    @property
    @pulumi.getter(name="builtInLifecycleConfigArn")
    def built_in_lifecycle_config_arn(self) -> Optional[builtins.str]:
        """
        The lifecycle configuration that runs before the default lifecycle configuration.
        """
        return pulumi.get(self, "built_in_lifecycle_config_arn")

    @property
    @pulumi.getter(name="recoveryMode")
    def recovery_mode(self) -> Optional[builtins.bool]:
        """
        Indicates whether the application is launched in recovery mode.
        """
        return pulumi.get(self, "recovery_mode")


class AwaitableGetAppResult(GetAppResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAppResult(
            app_arn=self.app_arn,
            built_in_lifecycle_config_arn=self.built_in_lifecycle_config_arn,
            recovery_mode=self.recovery_mode)


def get_app(app_name: Optional[builtins.str] = None,
            app_type: Optional['AppType'] = None,
            domain_id: Optional[builtins.str] = None,
            user_profile_name: Optional[builtins.str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAppResult:
    """
    Resource Type definition for AWS::SageMaker::App


    :param builtins.str app_name: The name of the app.
    :param 'AppType' app_type: The type of app.
    :param builtins.str domain_id: The domain ID.
    :param builtins.str user_profile_name: The user profile name.
    """
    __args__ = dict()
    __args__['appName'] = app_name
    __args__['appType'] = app_type
    __args__['domainId'] = domain_id
    __args__['userProfileName'] = user_profile_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:sagemaker:getApp', __args__, opts=opts, typ=GetAppResult).value

    return AwaitableGetAppResult(
        app_arn=pulumi.get(__ret__, 'app_arn'),
        built_in_lifecycle_config_arn=pulumi.get(__ret__, 'built_in_lifecycle_config_arn'),
        recovery_mode=pulumi.get(__ret__, 'recovery_mode'))
def get_app_output(app_name: Optional[pulumi.Input[builtins.str]] = None,
                   app_type: Optional[pulumi.Input['AppType']] = None,
                   domain_id: Optional[pulumi.Input[builtins.str]] = None,
                   user_profile_name: Optional[pulumi.Input[builtins.str]] = None,
                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAppResult]:
    """
    Resource Type definition for AWS::SageMaker::App


    :param builtins.str app_name: The name of the app.
    :param 'AppType' app_type: The type of app.
    :param builtins.str domain_id: The domain ID.
    :param builtins.str user_profile_name: The user profile name.
    """
    __args__ = dict()
    __args__['appName'] = app_name
    __args__['appType'] = app_type
    __args__['domainId'] = domain_id
    __args__['userProfileName'] = user_profile_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:sagemaker:getApp', __args__, opts=opts, typ=GetAppResult)
    return __ret__.apply(lambda __response__: GetAppResult(
        app_arn=pulumi.get(__response__, 'app_arn'),
        built_in_lifecycle_config_arn=pulumi.get(__response__, 'built_in_lifecycle_config_arn'),
        recovery_mode=pulumi.get(__response__, 'recovery_mode')))
