# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TableBucketPolicyArgs', 'TableBucketPolicy']

@pulumi.input_type
class TableBucketPolicyArgs:
    def __init__(__self__, *,
                 resource_policy: pulumi.Input['TableBucketPolicyResourcePolicyArgs'],
                 table_bucket_arn: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a TableBucketPolicy resource.
        :param pulumi.Input['TableBucketPolicyResourcePolicyArgs'] resource_policy: The bucket policy JSON for the table bucket.
        :param pulumi.Input[builtins.str] table_bucket_arn: The Amazon Resource Name (ARN) of the table bucket.
        """
        pulumi.set(__self__, "resource_policy", resource_policy)
        pulumi.set(__self__, "table_bucket_arn", table_bucket_arn)

    @property
    @pulumi.getter(name="resourcePolicy")
    def resource_policy(self) -> pulumi.Input['TableBucketPolicyResourcePolicyArgs']:
        """
        The bucket policy JSON for the table bucket.
        """
        return pulumi.get(self, "resource_policy")

    @resource_policy.setter
    def resource_policy(self, value: pulumi.Input['TableBucketPolicyResourcePolicyArgs']):
        pulumi.set(self, "resource_policy", value)

    @property
    @pulumi.getter(name="tableBucketArn")
    def table_bucket_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the table bucket.
        """
        return pulumi.get(self, "table_bucket_arn")

    @table_bucket_arn.setter
    def table_bucket_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "table_bucket_arn", value)


@pulumi.type_token("aws-native:s3tables:TableBucketPolicy")
class TableBucketPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 resource_policy: Optional[pulumi.Input[Union['TableBucketPolicyResourcePolicyArgs', 'TableBucketPolicyResourcePolicyArgsDict']]] = None,
                 table_bucket_arn: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Applies an IAM resource policy to a table bucket.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['TableBucketPolicyResourcePolicyArgs', 'TableBucketPolicyResourcePolicyArgsDict']] resource_policy: The bucket policy JSON for the table bucket.
        :param pulumi.Input[builtins.str] table_bucket_arn: The Amazon Resource Name (ARN) of the table bucket.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TableBucketPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Applies an IAM resource policy to a table bucket.

        :param str resource_name: The name of the resource.
        :param TableBucketPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TableBucketPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 resource_policy: Optional[pulumi.Input[Union['TableBucketPolicyResourcePolicyArgs', 'TableBucketPolicyResourcePolicyArgsDict']]] = None,
                 table_bucket_arn: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TableBucketPolicyArgs.__new__(TableBucketPolicyArgs)

            if resource_policy is None and not opts.urn:
                raise TypeError("Missing required property 'resource_policy'")
            __props__.__dict__["resource_policy"] = resource_policy
            if table_bucket_arn is None and not opts.urn:
                raise TypeError("Missing required property 'table_bucket_arn'")
            __props__.__dict__["table_bucket_arn"] = table_bucket_arn
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["tableBucketArn"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(TableBucketPolicy, __self__).__init__(
            'aws-native:s3tables:TableBucketPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'TableBucketPolicy':
        """
        Get an existing TableBucketPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = TableBucketPolicyArgs.__new__(TableBucketPolicyArgs)

        __props__.__dict__["resource_policy"] = None
        __props__.__dict__["table_bucket_arn"] = None
        return TableBucketPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="resourcePolicy")
    def resource_policy(self) -> pulumi.Output['outputs.TableBucketPolicyResourcePolicy']:
        """
        The bucket policy JSON for the table bucket.
        """
        return pulumi.get(self, "resource_policy")

    @property
    @pulumi.getter(name="tableBucketArn")
    def table_bucket_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the table bucket.
        """
        return pulumi.get(self, "table_bucket_arn")

