# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['TableBucketArgs', 'TableBucket']

@pulumi.input_type
class TableBucketArgs:
    def __init__(__self__, *,
                 encryption_configuration: Optional[pulumi.Input['TableBucketEncryptionConfigurationArgs']] = None,
                 table_bucket_name: Optional[pulumi.Input[builtins.str]] = None,
                 unreferenced_file_removal: Optional[pulumi.Input['TableBucketUnreferencedFileRemovalArgs']] = None):
        """
        The set of arguments for constructing a TableBucket resource.
        :param pulumi.Input['TableBucketEncryptionConfigurationArgs'] encryption_configuration: Configuration specifying how data should be encrypted. This structure defines the encryption algorithm and optional KMS key to be used for server-side encryption.
        :param pulumi.Input[builtins.str] table_bucket_name: The name for the table bucket.
        :param pulumi.Input['TableBucketUnreferencedFileRemovalArgs'] unreferenced_file_removal: The unreferenced file removal settings for your table bucket. Unreferenced file removal identifies and deletes all objects that are not referenced by any table snapshots. For more information, see the [*Amazon S3 User Guide*](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-table-buckets-maintenance.html) .
        """
        if encryption_configuration is not None:
            pulumi.set(__self__, "encryption_configuration", encryption_configuration)
        if table_bucket_name is not None:
            pulumi.set(__self__, "table_bucket_name", table_bucket_name)
        if unreferenced_file_removal is not None:
            pulumi.set(__self__, "unreferenced_file_removal", unreferenced_file_removal)

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> Optional[pulumi.Input['TableBucketEncryptionConfigurationArgs']]:
        """
        Configuration specifying how data should be encrypted. This structure defines the encryption algorithm and optional KMS key to be used for server-side encryption.
        """
        return pulumi.get(self, "encryption_configuration")

    @encryption_configuration.setter
    def encryption_configuration(self, value: Optional[pulumi.Input['TableBucketEncryptionConfigurationArgs']]):
        pulumi.set(self, "encryption_configuration", value)

    @property
    @pulumi.getter(name="tableBucketName")
    def table_bucket_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name for the table bucket.
        """
        return pulumi.get(self, "table_bucket_name")

    @table_bucket_name.setter
    def table_bucket_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "table_bucket_name", value)

    @property
    @pulumi.getter(name="unreferencedFileRemoval")
    def unreferenced_file_removal(self) -> Optional[pulumi.Input['TableBucketUnreferencedFileRemovalArgs']]:
        """
        The unreferenced file removal settings for your table bucket. Unreferenced file removal identifies and deletes all objects that are not referenced by any table snapshots. For more information, see the [*Amazon S3 User Guide*](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-table-buckets-maintenance.html) .
        """
        return pulumi.get(self, "unreferenced_file_removal")

    @unreferenced_file_removal.setter
    def unreferenced_file_removal(self, value: Optional[pulumi.Input['TableBucketUnreferencedFileRemovalArgs']]):
        pulumi.set(self, "unreferenced_file_removal", value)


@pulumi.type_token("aws-native:s3tables:TableBucket")
class TableBucket(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 encryption_configuration: Optional[pulumi.Input[Union['TableBucketEncryptionConfigurationArgs', 'TableBucketEncryptionConfigurationArgsDict']]] = None,
                 table_bucket_name: Optional[pulumi.Input[builtins.str]] = None,
                 unreferenced_file_removal: Optional[pulumi.Input[Union['TableBucketUnreferencedFileRemovalArgs', 'TableBucketUnreferencedFileRemovalArgsDict']]] = None,
                 __props__=None):
        """
        Creates an Amazon S3 Tables table bucket in the same AWS Region where you create the AWS CloudFormation stack.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['TableBucketEncryptionConfigurationArgs', 'TableBucketEncryptionConfigurationArgsDict']] encryption_configuration: Configuration specifying how data should be encrypted. This structure defines the encryption algorithm and optional KMS key to be used for server-side encryption.
        :param pulumi.Input[builtins.str] table_bucket_name: The name for the table bucket.
        :param pulumi.Input[Union['TableBucketUnreferencedFileRemovalArgs', 'TableBucketUnreferencedFileRemovalArgsDict']] unreferenced_file_removal: The unreferenced file removal settings for your table bucket. Unreferenced file removal identifies and deletes all objects that are not referenced by any table snapshots. For more information, see the [*Amazon S3 User Guide*](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-table-buckets-maintenance.html) .
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[TableBucketArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an Amazon S3 Tables table bucket in the same AWS Region where you create the AWS CloudFormation stack.

        :param str resource_name: The name of the resource.
        :param TableBucketArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TableBucketArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 encryption_configuration: Optional[pulumi.Input[Union['TableBucketEncryptionConfigurationArgs', 'TableBucketEncryptionConfigurationArgsDict']]] = None,
                 table_bucket_name: Optional[pulumi.Input[builtins.str]] = None,
                 unreferenced_file_removal: Optional[pulumi.Input[Union['TableBucketUnreferencedFileRemovalArgs', 'TableBucketUnreferencedFileRemovalArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TableBucketArgs.__new__(TableBucketArgs)

            __props__.__dict__["encryption_configuration"] = encryption_configuration
            __props__.__dict__["table_bucket_name"] = table_bucket_name
            __props__.__dict__["unreferenced_file_removal"] = unreferenced_file_removal
            __props__.__dict__["table_bucket_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["tableBucketName"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(TableBucket, __self__).__init__(
            'aws-native:s3tables:TableBucket',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'TableBucket':
        """
        Get an existing TableBucket resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = TableBucketArgs.__new__(TableBucketArgs)

        __props__.__dict__["encryption_configuration"] = None
        __props__.__dict__["table_bucket_arn"] = None
        __props__.__dict__["table_bucket_name"] = None
        __props__.__dict__["unreferenced_file_removal"] = None
        return TableBucket(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> pulumi.Output[Optional['outputs.TableBucketEncryptionConfiguration']]:
        """
        Configuration specifying how data should be encrypted. This structure defines the encryption algorithm and optional KMS key to be used for server-side encryption.
        """
        return pulumi.get(self, "encryption_configuration")

    @property
    @pulumi.getter(name="tableBucketArn")
    def table_bucket_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the table bucket.
        """
        return pulumi.get(self, "table_bucket_arn")

    @property
    @pulumi.getter(name="tableBucketName")
    def table_bucket_name(self) -> pulumi.Output[builtins.str]:
        """
        The name for the table bucket.
        """
        return pulumi.get(self, "table_bucket_name")

    @property
    @pulumi.getter(name="unreferencedFileRemoval")
    def unreferenced_file_removal(self) -> pulumi.Output[Optional['outputs.TableBucketUnreferencedFileRemoval']]:
        """
        The unreferenced file removal settings for your table bucket. Unreferenced file removal identifies and deletes all objects that are not referenced by any table snapshots. For more information, see the [*Amazon S3 User Guide*](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-table-buckets-maintenance.html) .
        """
        return pulumi.get(self, "unreferenced_file_removal")

