# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'TableBucketEncryptionConfiguration',
    'TableBucketPolicyResourcePolicy',
    'TableBucketUnreferencedFileRemoval',
]

@pulumi.output_type
class TableBucketEncryptionConfiguration(dict):
    """
    Specifies encryption settings for the table bucket
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyArn":
            suggest = "kms_key_arn"
        elif key == "sseAlgorithm":
            suggest = "sse_algorithm"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableBucketEncryptionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableBucketEncryptionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableBucketEncryptionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_arn: Optional[builtins.str] = None,
                 sse_algorithm: Optional['TableBucketEncryptionConfigurationSseAlgorithm'] = None):
        """
        Specifies encryption settings for the table bucket
        :param builtins.str kms_key_arn: ARN of the KMS key to use for encryption
        :param 'TableBucketEncryptionConfigurationSseAlgorithm' sse_algorithm: Server-side encryption algorithm
        """
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if sse_algorithm is not None:
            pulumi.set(__self__, "sse_algorithm", sse_algorithm)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[builtins.str]:
        """
        ARN of the KMS key to use for encryption
        """
        return pulumi.get(self, "kms_key_arn")

    @property
    @pulumi.getter(name="sseAlgorithm")
    def sse_algorithm(self) -> Optional['TableBucketEncryptionConfigurationSseAlgorithm']:
        """
        Server-side encryption algorithm
        """
        return pulumi.get(self, "sse_algorithm")


@pulumi.output_type
class TableBucketPolicyResourcePolicy(dict):
    """
    A policy document containing permissions to add to the specified table bucket. In IAM, you must provide policy documents in JSON format. However, in CloudFormation you can provide the policy in JSON or YAML format because CloudFormation converts YAML to JSON before submitting it to IAM.
    """
    def __init__(__self__):
        """
        A policy document containing permissions to add to the specified table bucket. In IAM, you must provide policy documents in JSON format. However, in CloudFormation you can provide the policy in JSON or YAML format because CloudFormation converts YAML to JSON before submitting it to IAM.
        """
        pass


@pulumi.output_type
class TableBucketUnreferencedFileRemoval(dict):
    """
    Settings governing the Unreferenced File Removal maintenance action. Unreferenced file removal identifies and deletes all objects that are not referenced by any table snapshots.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "noncurrentDays":
            suggest = "noncurrent_days"
        elif key == "unreferencedDays":
            suggest = "unreferenced_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableBucketUnreferencedFileRemoval. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableBucketUnreferencedFileRemoval.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableBucketUnreferencedFileRemoval.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 noncurrent_days: Optional[builtins.int] = None,
                 status: Optional['TableBucketUnreferencedFileRemovalStatus'] = None,
                 unreferenced_days: Optional[builtins.int] = None):
        """
        Settings governing the Unreferenced File Removal maintenance action. Unreferenced file removal identifies and deletes all objects that are not referenced by any table snapshots.
        :param builtins.int noncurrent_days: S3 permanently deletes noncurrent objects after the number of days specified by the NoncurrentDays property.
        :param 'TableBucketUnreferencedFileRemovalStatus' status: Indicates whether the Unreferenced File Removal maintenance action is enabled.
        :param builtins.int unreferenced_days: For any object not referenced by your table and older than the UnreferencedDays property, S3 creates a delete marker and marks the object version as noncurrent.
        """
        if noncurrent_days is not None:
            pulumi.set(__self__, "noncurrent_days", noncurrent_days)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if unreferenced_days is not None:
            pulumi.set(__self__, "unreferenced_days", unreferenced_days)

    @property
    @pulumi.getter(name="noncurrentDays")
    def noncurrent_days(self) -> Optional[builtins.int]:
        """
        S3 permanently deletes noncurrent objects after the number of days specified by the NoncurrentDays property.
        """
        return pulumi.get(self, "noncurrent_days")

    @property
    @pulumi.getter
    def status(self) -> Optional['TableBucketUnreferencedFileRemovalStatus']:
        """
        Indicates whether the Unreferenced File Removal maintenance action is enabled.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="unreferencedDays")
    def unreferenced_days(self) -> Optional[builtins.int]:
        """
        For any object not referenced by your table and older than the UnreferencedDays property, S3 creates a delete marker and marks the object version as noncurrent.
        """
        return pulumi.get(self, "unreferenced_days")


