# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetTableBucketResult',
    'AwaitableGetTableBucketResult',
    'get_table_bucket',
    'get_table_bucket_output',
]

@pulumi.output_type
class GetTableBucketResult:
    def __init__(__self__, encryption_configuration=None, table_bucket_arn=None, unreferenced_file_removal=None):
        if encryption_configuration and not isinstance(encryption_configuration, dict):
            raise TypeError("Expected argument 'encryption_configuration' to be a dict")
        pulumi.set(__self__, "encryption_configuration", encryption_configuration)
        if table_bucket_arn and not isinstance(table_bucket_arn, str):
            raise TypeError("Expected argument 'table_bucket_arn' to be a str")
        pulumi.set(__self__, "table_bucket_arn", table_bucket_arn)
        if unreferenced_file_removal and not isinstance(unreferenced_file_removal, dict):
            raise TypeError("Expected argument 'unreferenced_file_removal' to be a dict")
        pulumi.set(__self__, "unreferenced_file_removal", unreferenced_file_removal)

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> Optional['outputs.TableBucketEncryptionConfiguration']:
        """
        Configuration specifying how data should be encrypted. This structure defines the encryption algorithm and optional KMS key to be used for server-side encryption.
        """
        return pulumi.get(self, "encryption_configuration")

    @property
    @pulumi.getter(name="tableBucketArn")
    def table_bucket_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the table bucket.
        """
        return pulumi.get(self, "table_bucket_arn")

    @property
    @pulumi.getter(name="unreferencedFileRemoval")
    def unreferenced_file_removal(self) -> Optional['outputs.TableBucketUnreferencedFileRemoval']:
        """
        The unreferenced file removal settings for your table bucket. Unreferenced file removal identifies and deletes all objects that are not referenced by any table snapshots. For more information, see the [*Amazon S3 User Guide*](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-table-buckets-maintenance.html) .
        """
        return pulumi.get(self, "unreferenced_file_removal")


class AwaitableGetTableBucketResult(GetTableBucketResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTableBucketResult(
            encryption_configuration=self.encryption_configuration,
            table_bucket_arn=self.table_bucket_arn,
            unreferenced_file_removal=self.unreferenced_file_removal)


def get_table_bucket(table_bucket_arn: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTableBucketResult:
    """
    Creates an Amazon S3 Tables table bucket in the same AWS Region where you create the AWS CloudFormation stack.


    :param builtins.str table_bucket_arn: The Amazon Resource Name (ARN) of the table bucket.
    """
    __args__ = dict()
    __args__['tableBucketArn'] = table_bucket_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:s3tables:getTableBucket', __args__, opts=opts, typ=GetTableBucketResult).value

    return AwaitableGetTableBucketResult(
        encryption_configuration=pulumi.get(__ret__, 'encryption_configuration'),
        table_bucket_arn=pulumi.get(__ret__, 'table_bucket_arn'),
        unreferenced_file_removal=pulumi.get(__ret__, 'unreferenced_file_removal'))
def get_table_bucket_output(table_bucket_arn: Optional[pulumi.Input[builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTableBucketResult]:
    """
    Creates an Amazon S3 Tables table bucket in the same AWS Region where you create the AWS CloudFormation stack.


    :param builtins.str table_bucket_arn: The Amazon Resource Name (ARN) of the table bucket.
    """
    __args__ = dict()
    __args__['tableBucketArn'] = table_bucket_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:s3tables:getTableBucket', __args__, opts=opts, typ=GetTableBucketResult)
    return __ret__.apply(lambda __response__: GetTableBucketResult(
        encryption_configuration=pulumi.get(__response__, 'encryption_configuration'),
        table_bucket_arn=pulumi.get(__response__, 'table_bucket_arn'),
        unreferenced_file_removal=pulumi.get(__response__, 'unreferenced_file_removal')))
