# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'TableBucketEncryptionConfigurationArgs',
    'TableBucketEncryptionConfigurationArgsDict',
    'TableBucketPolicyResourcePolicyArgs',
    'TableBucketPolicyResourcePolicyArgsDict',
    'TableBucketUnreferencedFileRemovalArgs',
    'TableBucketUnreferencedFileRemovalArgsDict',
]

MYPY = False

if not MYPY:
    class TableBucketEncryptionConfigurationArgsDict(TypedDict):
        """
        Specifies encryption settings for the table bucket
        """
        kms_key_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        ARN of the KMS key to use for encryption
        """
        sse_algorithm: NotRequired[pulumi.Input['TableBucketEncryptionConfigurationSseAlgorithm']]
        """
        Server-side encryption algorithm
        """
elif False:
    TableBucketEncryptionConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TableBucketEncryptionConfigurationArgs:
    def __init__(__self__, *,
                 kms_key_arn: Optional[pulumi.Input[builtins.str]] = None,
                 sse_algorithm: Optional[pulumi.Input['TableBucketEncryptionConfigurationSseAlgorithm']] = None):
        """
        Specifies encryption settings for the table bucket
        :param pulumi.Input[builtins.str] kms_key_arn: ARN of the KMS key to use for encryption
        :param pulumi.Input['TableBucketEncryptionConfigurationSseAlgorithm'] sse_algorithm: Server-side encryption algorithm
        """
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)
        if sse_algorithm is not None:
            pulumi.set(__self__, "sse_algorithm", sse_algorithm)

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN of the KMS key to use for encryption
        """
        return pulumi.get(self, "kms_key_arn")

    @kms_key_arn.setter
    def kms_key_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_arn", value)

    @property
    @pulumi.getter(name="sseAlgorithm")
    def sse_algorithm(self) -> Optional[pulumi.Input['TableBucketEncryptionConfigurationSseAlgorithm']]:
        """
        Server-side encryption algorithm
        """
        return pulumi.get(self, "sse_algorithm")

    @sse_algorithm.setter
    def sse_algorithm(self, value: Optional[pulumi.Input['TableBucketEncryptionConfigurationSseAlgorithm']]):
        pulumi.set(self, "sse_algorithm", value)


if not MYPY:
    class TableBucketPolicyResourcePolicyArgsDict(TypedDict):
        """
        A policy document containing permissions to add to the specified table bucket. In IAM, you must provide policy documents in JSON format. However, in CloudFormation you can provide the policy in JSON or YAML format because CloudFormation converts YAML to JSON before submitting it to IAM.
        """
        pass
elif False:
    TableBucketPolicyResourcePolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TableBucketPolicyResourcePolicyArgs:
    def __init__(__self__):
        """
        A policy document containing permissions to add to the specified table bucket. In IAM, you must provide policy documents in JSON format. However, in CloudFormation you can provide the policy in JSON or YAML format because CloudFormation converts YAML to JSON before submitting it to IAM.
        """
        pass


if not MYPY:
    class TableBucketUnreferencedFileRemovalArgsDict(TypedDict):
        """
        Settings governing the Unreferenced File Removal maintenance action. Unreferenced file removal identifies and deletes all objects that are not referenced by any table snapshots.
        """
        noncurrent_days: NotRequired[pulumi.Input[builtins.int]]
        """
        S3 permanently deletes noncurrent objects after the number of days specified by the NoncurrentDays property.
        """
        status: NotRequired[pulumi.Input['TableBucketUnreferencedFileRemovalStatus']]
        """
        Indicates whether the Unreferenced File Removal maintenance action is enabled.
        """
        unreferenced_days: NotRequired[pulumi.Input[builtins.int]]
        """
        For any object not referenced by your table and older than the UnreferencedDays property, S3 creates a delete marker and marks the object version as noncurrent.
        """
elif False:
    TableBucketUnreferencedFileRemovalArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TableBucketUnreferencedFileRemovalArgs:
    def __init__(__self__, *,
                 noncurrent_days: Optional[pulumi.Input[builtins.int]] = None,
                 status: Optional[pulumi.Input['TableBucketUnreferencedFileRemovalStatus']] = None,
                 unreferenced_days: Optional[pulumi.Input[builtins.int]] = None):
        """
        Settings governing the Unreferenced File Removal maintenance action. Unreferenced file removal identifies and deletes all objects that are not referenced by any table snapshots.
        :param pulumi.Input[builtins.int] noncurrent_days: S3 permanently deletes noncurrent objects after the number of days specified by the NoncurrentDays property.
        :param pulumi.Input['TableBucketUnreferencedFileRemovalStatus'] status: Indicates whether the Unreferenced File Removal maintenance action is enabled.
        :param pulumi.Input[builtins.int] unreferenced_days: For any object not referenced by your table and older than the UnreferencedDays property, S3 creates a delete marker and marks the object version as noncurrent.
        """
        if noncurrent_days is not None:
            pulumi.set(__self__, "noncurrent_days", noncurrent_days)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if unreferenced_days is not None:
            pulumi.set(__self__, "unreferenced_days", unreferenced_days)

    @property
    @pulumi.getter(name="noncurrentDays")
    def noncurrent_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        S3 permanently deletes noncurrent objects after the number of days specified by the NoncurrentDays property.
        """
        return pulumi.get(self, "noncurrent_days")

    @noncurrent_days.setter
    def noncurrent_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "noncurrent_days", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input['TableBucketUnreferencedFileRemovalStatus']]:
        """
        Indicates whether the Unreferenced File Removal maintenance action is enabled.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input['TableBucketUnreferencedFileRemovalStatus']]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="unreferencedDays")
    def unreferenced_days(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        For any object not referenced by your table and older than the UnreferencedDays property, S3 creates a delete marker and marks the object version as noncurrent.
        """
        return pulumi.get(self, "unreferenced_days")

    @unreferenced_days.setter
    def unreferenced_days(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "unreferenced_days", value)


